-- C:\mish_cvs\misH_skripte\bm_gas3010.pkb
--
-- Generated for Oracle 10g on Tue Oct 14  11:29:33 2025 by Server Generator 6.5.96.5.6
 

PROMPT Creating Package Body 'BM_GAS3010'
CREATE OR REPLACE PACKAGE BODY BM_GAS3010 IS
datum_m DATE;
obrada_u_toku_m BOOLEAN := FALSE;
zaliha_tab_m zaliha_tab_t;
obrada_gas_m VARCHAR2(1);

PROCEDURE OBRADA_ULAZA;
PROCEDURE ULAZ_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 );
PROCEDURE ULAZ_NAMIRNICE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,KOLICINA_NAM_P NUMBER
 ,ZAD_NAB_CIJENA_P NUMBER
 );
PROCEDURE ULAZ_AMBALAZE
 (MT_ID_P NUMBER
 ,DOB_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 );
PROCEDURE OBRADA_PRIJELAZA
 (VRSTA_MJESTA_TROSKA_P NUMBER
 );
PROCEDURE PRIJELAZ_SIROVINE
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 );
PROCEDURE PRIJELAZ_NAMIRNICE_PRIMAOC
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,NAM_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,CIJENA_KVAZI_NAM_P NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 );
PROCEDURE PRIJELAZ_NAMIRNICE_DAVAOC
 (MT_ID_DAJE_P NUMBER
 ,NAM_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 );
PROCEDURE PRIJELAZ_PROIZVODA
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 );
PROCEDURE PRIJELAZ_AMBALAZE
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 );
PROCEDURE IZRACUN_PRO_NC_NAMIRNICE;
PROCEDURE OBRADA_IZLAZA;
PROCEDURE IZLAZ_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OPERA_RC_ID_P NUMBER := NULL
 );
PROCEDURE IZLAZ_PROIZVODA
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 ,OPERA_RC_ID_P IN NUMBER := NULL
 );
PROCEDURE IZLAZ_SIROVINE
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OPERA_RC_ID_P IN NUMBER := NULL
 );
PROCEDURE OBRADA_PROIZVODNJE;
PROCEDURE OBRADA_OTPISA;
PROCEDURE OTPIS_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 );
PROCEDURE OTPIS_PROIZVODA
 (MT_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 );
PROCEDURE OTPIS_AMBALAZE
 (MT_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 );
PROCEDURE OBRADA_ZAMJENA;
PROCEDURE OTPIS_NAMIRNICE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_NAM_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 );
PROCEDURE ZAMJENA_NAM_SA_PRO
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_SUPSTITUT_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 );
PROCEDURE ZAMJENA_PRO_SA_NAM
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 );
PROCEDURE ZAMJENA_NAM_SA_NAM
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 );
PROCEDURE AZUR_SUPSTITUT
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,PRO_ID_SUPSTITUT_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOL_STORNO_IZLAZ_SUP_P NUMBER
 ,KOL_IZLAZ_SUP_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 );
PROCEDURE IZRACUN_ZALIHA_NAMIRNICA;
PROCEDURE IZRACUN_ZALIHA_AMBALAZE;
PROCEDURE ZALIHA_AMBALAZE_DOB
 (DOB_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 );
PROCEDURE ZALIHA_AMBALAZE_MT
 (MT_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 );
FUNCTION PROS_NC_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAM_ID_P NUMBER
 )
 RETURN NUMBER;
PROCEDURE PROVJERI_PRESKOK_DOK
 (DAT_ZADNJEG_DO_P DATE
 ,POCETNI_DAT_DO_P DATE
 );
PROCEDURE INSERT_ZALIHA;
FUNCTION POSTOJI_NEGATIVNA_ZALIHA
 RETURN BOOLEAN;
FUNCTION NEGATIVNA_ZALIHA
 RETURN VARCHAR2;
PROCEDURE OBRADA_ZAPISNIKA;
PROCEDURE POSALJI_PRIJELAZNICU
 (ID_PRI_DAVATELJ_P IN NUMBER
 );
PROCEDURE IZRACUN_PRO_NC_NAMIRNICE_HNB;
PROCEDURE IZRACUN_PRO_NC_PROIZVODA_HNB;
PROCEDURE PRIJEPIS_U_ASORTIMAN_HNB;
FUNCTION PROS_NC_NAMIRNICE_HNB
 (NAM_ID_P NUMBER
 )
 RETURN NUMBER;
PROCEDURE POSALJI_VR_OTPREMNICE_IR_HF_VA;
PROCEDURE POSALJI_VR_OTPREMNICU
 (ID_P NUMBER
 );
FUNCTION OPERA_RC_M
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 )
 RETURN NUMBER;
FUNCTION OPERA_RC_K
 (KASA_ID_P NUMBER
 ,NAC_ID_P NUMBER
 )
 RETURN NUMBER;


PROCEDURE START_VISE_DO
 (DATUM_POC_P IN DATE
 ,DATUM_ZAV_P IN DATE
 ,NEGATIVNA_ZALIHA_P OUT VARCHAR2
 ,AZURIRATI_PC_PROIZVODA_HNB_P IN VARCHAR2
 )
 IS
   datum_L DATE;
   datum_obracuna_L DATE;
   brojac_l NUMBER;
   datum_pdo_L DATE;
   postoji_trnkase_log_l BOOLEAN;
BEGIN
   /* lock in exclusive mode */
   gas_zaj.zakljucaj_obracun;

   /* zbog AUR replikacijskih okidaa sirovina, namirnica i proizvoda */
   obrada_u_toku_M := TRUE;

   /* datum obrauna mora biti vei od datuma prethodnog obrauna */
   datum_L := dat_zadnjeg_do;

   IF datum_l IS NOT NULL AND datum_L >= datum_poc_P THEN
      gas_zaj.vrati_poruku (-20042);
   END IF;

   /* ne smiju biti preskoeni dokumenti koji nisu proli dnevni obraun */
   provjeri_preskok_dok (datum_L, datum_poc_P);
      
   /* ako je bila izmjena dokumenata na SYSDATE (vage, minibar...) ne doputa se obraun dalje bez ponitavanja
      alje se NULL za datum do kojeg se kontrolira jer se unutar procedure ita datum zadnjeg dnevnog DO.
   */   
   datum_pdo_L := gas_zaj.mijenjani_dokumenti (NULL); 
   
   IF datum_pdo_L IS NOT NULL THEN
      gas_zaj.vrati_poruku (-20431, TO_CHAR(datum_pdo_L,'DD.MM.YYYY'));
   END IF;   
                                       
    SELECT obrada_gas
      INTO obrada_gas_m
      FROM nst_gas_obrada;                                    
                                       
   datum_obracuna_L := datum_poc_P;
   WHILE datum_obracuna_L <= datum_zav_P LOOP

      /* kontrola slijednosti internog rednog broja rauna s kase IRN 3917 */
      pra_gas_log.kontrola_trnkase_rbr(datum_obracuna_L,datum_obracuna_L); 
       /* kontrola slijednosti fiskalnog rednog broja rauna s kase IRN 4111 */
      pra_gas_log.kontrola_trnkase_rbr_fisk(datum_obracuna_L,datum_obracuna_L);
      
      postoji_trnkase_log_l :=  pra_gas_log.postoji_trnkase_log (datum_obracuna_l);
      IF postoji_trnkase_log_l THEN
        gas_zaj.vrati_poruku (-20523, TO_CHAR(datum_obracuna_l,'DD.MM.YYYY'));
      END IF;

      /* lock in exclusive mode - PRVI PUT JE VE ZAKLJUANO */
      gas_zaj.zakljucaj_obracun;

      /* mora biti obraena prethodna inventura artikala i ambalae */
      provjera_datum_inventure (datum_obracuna_L);
      datum_M := TRUNC (datum_obracuna_L); -- TRUNC vjerojatno ne treba   
      
      /* dokument promjene cijene se radi na zalihu od prethodnog dana */
      IF obrada_gas_m = 'D' THEN
         pra_nst_gas.pro_cijene (datum_obracuna_L );
      END IF;
      
      obrada_prijelaza (-1);
      obrada_ulaza;
      obrada_prijelaza (0);
      obrada_proizvodnje;
      
      IF datum_obracuna_L = datum_zav_P THEN
        zaj_obr.izracun_zad_nc_proizvoda ('D');
      ELSE
        zaj_obr.izracun_zad_nc_proizvoda ('N');
      END IF;

      IF UPPER (pra_zmp_zaj.tekuci_cvor) = 'HNBGASTRO' THEN -- specijalno za HNB
         izracun_pro_nc_namirnice_HNB;
         izracun_pro_nc_proizvoda_HNB;

         IF azurirati_PC_proizvoda_HNB_p = 'D' THEN
            prijepis_u_asortiman_HNB;
         END IF;
      ELSE
         izracun_pro_nc_namirnice;
      END IF;

      obrada_izlaza;
      obrada_otpisa;
      obrada_zamjena;
      izracun_zaliha_namirnica;
      izracun_zaliha_ambalaze;

      /*
      Ako je parametarski zabranjena negativna zaliha tada se radi ROLLBACK
      i pamti se samo negativna zaliha u tablicu p_zaliha.
      */
      IF postoji_negativna_zaliha THEN
         insert_zaliha;
         ROLLBACK;

         DELETE p_zaliha;
         INSERT INTO p_zaliha (zaliha) VALUES (zaliha_tab_m);
         COMMIT;
         EXIT; -- IZLAZ IZ PETLJE
      END IF;

      /* Slanje oznaenih prijelaznica na drugi vor */
      FOR pri IN (
         SELECT ROWID, id
           FROM t_prijelaz
          WHERE datum = datum_m
            AND ozn_replikacije = 'D')
      LOOP
         UPDATE t_prijelaz
            SET ozn_replikacije = 'N'
          WHERE ROWID = pri.ROWID;

         posalji_prijelaznicu (pri.id);
      END LOOP;

      IF obrada_gas_m = 'D' THEN
         pra_nst_gas.obrada_datum (datum_M );
         obrada_zapisnika;

         IF  TO_CHAR(TO_DATE(datum_M), 'DDMM') =  '3112' THEN    
             pra_nst_gas.pocetno_stanje (datum_m + 1);
         END IF;      
      END IF;

      IF UPPER (pra_zmp_zaj.tekuci_cvor) IN ('RIRACP', 'RICKUHINJA') THEN
         posalji_VR_otpremnice_IR_HF_VA;
      END IF;

      INSERT INTO l_obracun (datum, oznaka) VALUES (datum_m, '00');
       
      COMMIT;
      datum_obracuna_l := datum_obracuna_l + 1;
   END LOOP;

   negativna_zaliha_p := negativna_zaliha;
   obrada_u_toku_m := FALSE;
END START_VISE_DO;
PROCEDURE OBRADA_ULAZA
 IS

   nam_id_l NUMBER;
   odnos_jm_b_l NUMBER;
   odnos_jm_n_l NUMBER;
BEGIN   
    
   FOR ulaz IN (
     SELECT ul.id, mt_id, dob_id
        FROM t_ulazdok ul, m_mt mt 
       WHERE datum = datum_M
         AND ul.mt_id = mt.id
       ORDER BY id)
   LOOP
      FOR ulazart IN (
         SELECT ROWID, sir_id, nam_id,
                kolicina, rabat, nab_cijena
           FROM t_ulazdok_art
          WHERE ulaz_id = ulaz.id)
      LOOP
         IF ulazart.sir_id IS NOT NULL THEN
            SELECT odnos_jm_b, odnos_jm_n
              INTO odnos_jm_b_l, odnos_jm_n_l
              FROM m_sirovine
             WHERE id = ulazart.sir_id;

            UPDATE t_ulazdok_art
               SET odnos_jm_b = odnos_jm_b_l,
                   odnos_jm_n = odnos_jm_n_l
             WHERE ROWID = ulazart.ROWID;

            ulaz_sirovine (
               ulaz.mt_id,
               ulazart.sir_id,
               ulazart.kolicina,
               ROUND(ulazart.nab_cijena * (1 - ulazart.rabat / 100),2),
               odnos_jm_b_l,
               odnos_jm_n_l);
         ELSE
            ulaz_namirnice (
               ulaz.mt_id,
               NULL, -- sir_id
               ulazart.nam_id,
               ulazart.kolicina,
               ROUND(ulazart.nab_cijena * (1 - ulazart.rabat / 100),2));
         END IF;
      END LOOP;

      FOR ulazamb IN (
         SELECT amb_id, kolicina
           FROM t_ulazdok_amb
          WHERE ulaz_id = ulaz.id)
      LOOP
         ulaz_ambalaze (
            ulaz.mt_id,
            ulaz.dob_id,
            ulazamb.amb_id,
            ulazamb.kolicina);
      END LOOP;
   END LOOP;
END;
PROCEDURE ULAZ_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 )
 IS

   kalo_obrade_L           NUMBER;
   kalo_odmrzavanja_L      NUMBER;
   korigirana_cijena_sir_L NUMBER;
   korigirana_kol_sir_L    NUMBER;
   korigirana_kol_nam_L    NUMBER;
   korigirana_cijena_nam_L NUMBER;
   ekvivalent_L            NUMBER;
   cijena_L                NUMBER;
   pom_br_rastava_L        NUMBER;
   sir_sifra_l             m_sirovine.sifra%TYPE;
BEGIN
   IF kolicina_P > 0 AND nab_cijena_p > 0  THEN
      cijena_L :=
         zaj_obr.cijena_odnos (
            nab_cijena_P,
            odnos_jm_b_P,
            odnos_jm_n_P);

      UPDATE m_sirovine
         SET zad_nab_cijena = cijena_L,
             dat_azur_nc    = datum_M
       WHERE id = sir_id_P;
   END IF;

   SELECT kalo_obrade, kalo_odmrzavanja, sifra INTO
          kalo_obrade_L, kalo_odmrzavanja_L, sir_sifra_l
     FROM m_sirovine
    WHERE id = sir_id_P;

   IF zaj_obr.ima_sir_bez_rastava(sir_id_p) = -1 THEN
      gas_zaj.vrati_poruku (-20219, sir_sifra_l);
   END IF;

   korigirana_kol_sir_L :=
      zaj_obr.korigirana_kol_sirovine (
         kolicina_P,
         odnos_jm_b_P,
         odnos_jm_n_P,
         kalo_odmrzavanja_L,
         kalo_obrade_L);

   korigirana_cijena_sir_L :=
      zaj_obr.korigirana_cijena_sirovine (
         nab_cijena_P,
         odnos_jm_b_P,
         odnos_jm_n_P,
         kalo_odmrzavanja_L,
         kalo_obrade_L);

   pom_br_rastava_L := zaj_obr.pom_broj_rastava (sir_id_P);

   FOR ras IN (
      SELECT nam_id, udio_namirnice
        FROM m_rastav
       WHERE sir_id = sir_id_P)
   LOOP
      SELECT ekvivalent INTO ekvivalent_L
        FROM m_namirnice
	WHERE id = ras.nam_id;

      korigirana_kol_nam_L :=
         zaj_obr.korigirana_kol_namirnice (
            korigirana_kol_sir_L,
            ras.udio_namirnice);

      korigirana_cijena_nam_L :=
         zaj_obr.korigirana_cijena_namirnice (
            korigirana_cijena_sir_L,
            ekvivalent_L,
            pom_br_rastava_L);

      ulaz_namirnice (
         mt_id_P,
         sir_id_P,
         ras.nam_id,
         korigirana_kol_nam_L,
         korigirana_cijena_nam_L);
   END LOOP;
END;
PROCEDURE ULAZ_NAMIRNICE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,KOLICINA_NAM_P NUMBER
 ,ZAD_NAB_CIJENA_P NUMBER
 )
 IS

   brojac_L NUMBER;
   izn_ulaz_L NUMBER;
BEGIN
 
   IF kolicina_nam_P > 0 AND zad_nab_cijena_P > 0 THEN
      UPDATE m_namirnice
         SET zad_nab_cijena = zad_nab_cijena_P,
             dat_azur_nc = datum_M
       WHERE id = nam_id_P;
   END IF;

   izn_ulaz_L := kolicina_nam_P * zad_nab_cijena_P;

   SELECT COUNT (1) INTO brojac_L
      FROM i_dnev_ui_det
     WHERE mt_id  = mt_id_P
       AND nam_id = nam_id_P
       AND datum  = datum_M
       AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
       AND pro_id IS NULL
       AND nam_id_supstitut IS NULL
       AND pro_id_supstitut IS NULL;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, sir_id_P, NULL,
         NULL, NULL, kolicina_nam_P, 0,
         0, 0, 0,
         0, 0,
         0, 0, izn_ulaz_L, 0,
         0, 0, zad_nab_cijena_P);
   ELSE
      UPDATE i_dnev_ui_det
         SET zad_nab_cijena = zad_nab_cijena_P,
             kol_ulaz = kol_ulaz + kolicina_nam_P,
             izn_ulaz = izn_ulaz + izn_ulaz_L
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
         AND pro_id IS NULL
         AND nam_id_supstitut IS NULL
         AND pro_id_supstitut IS NULL;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, kolicina_nam_P, 0,
         0, 0, 0,
         0, 0,
         0, 0, izn_ulaz_L, 0,
         0, 0, zad_nab_cijena_P);
   ELSE
      UPDATE i_dnev_ui
         SET zad_nab_cijena = zad_nab_cijena_P,
             kol_ulaz = kol_ulaz + kolicina_nam_P,
             izn_ulaz = izn_ulaz + izn_ulaz_L
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;
   END IF;
END;
PROCEDURE ULAZ_AMBALAZE
 (MT_ID_P NUMBER
 ,DOB_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 )
 IS

   rowid_l ROWID;
BEGIN
   /*
   Jedino u ovoj proceduri se mogu kreirati/aurirati dva retka tablice i_dnev_ui_amb.
   Redak koji ima NULL u dob_id slui za promatranje po MT.
   On se aurira i u ostalim procedurama, te u obraunu inventure ambalae.
   Redak koji ima NOT NULL u dob_id slui za promatranje po dobavljau.
   On se aurira samo u ovoj proceduri, i to tako da mu se aurira i polje "zaliha",
   (koje predstavlja zaduenje prema dobavljau), za razliku od polja "zaliha"
   u recima po mjestima troka, koje se aurira u proceduri "izracun_zaliha_ambalaze".
   */

   /* Auriranje retka koji ima NULL u dob_id */
   rowid_l := NULL;
   BEGIN
      SELECT ROWID INTO rowid_l -- koristimo ROWID da u UPDATE ne moramo ponoviti uvjet
        FROM i_dnev_ui_amb
       WHERE mt_id  = mt_id_p
         AND amb_id = amb_id_p
         AND datum  = datum_m
         AND dob_id IS NULL;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   IF rowid_l IS NULL THEN
      INSERT INTO i_dnev_ui_amb (
         mt_id, amb_id, datum, dob_id,
         kol_ulaz, kol_int_ulaz, kol_int_izlaz, kol_izlaz,
         kol_dnev_otpis, kol_inv_razlika, zaliha)
         VALUES (
         mt_id_p, amb_id_p, datum_m, NULL,
         kolicina_p, 0, 0, 0,
         0, 0, 0); -- zaliha se aurira kasnije
   ELSE
      UPDATE i_dnev_ui_amb
         SET kol_ulaz = kol_ulaz + kolicina_p -- zaliha se aurira kasnije
       WHERE ROWID = rowid_l;
   END IF;

   IF dob_id_p IS NULL THEN
      RETURN; -- dob_id_P je NULL kod po.stanja, pa se ne aurira slog za dobavljaa
   END IF;

   /* Auriranje retka koji ima NOT NULL u dob_id */
   rowid_l := NULL;
   BEGIN
      SELECT ROWID INTO rowid_l -- koristimo ROWID da u UPDATE ne moramo ponoviti uvjet
        FROM i_dnev_ui_amb
       WHERE mt_id  = mt_id_p
         AND amb_id = amb_id_p
         AND datum  = datum_m
         AND dob_id = dob_id_p;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   IF rowid_l IS NULL THEN
      INSERT INTO i_dnev_ui_amb (
         mt_id, amb_id, datum, dob_id,
         kol_ulaz, kol_int_ulaz, kol_int_izlaz, kol_izlaz,
         kol_dnev_otpis, kol_inv_razlika, zaliha)
         VALUES (
         mt_id_p, amb_id_p, datum_m, dob_id_p,
         kolicina_p, 0, 0, 0,
         0, 0, kolicina_p); -- zaliha se aurira odmah
   ELSE
      UPDATE i_dnev_ui_amb
         SET kol_ulaz = kol_ulaz + kolicina_p,
             zaliha   = zaliha + kolicina_p -- zaliha se aurira odmah
       WHERE ROWID = rowid_l;
   END IF;
END;
PROCEDURE OBRADA_PRIJELAZA
 (VRSTA_MJESTA_TROSKA_P NUMBER
 )
 IS

   pros_nab_cijena_l NUMBER;
   odnos_jm_b_l      NUMBER;
   odnos_jm_n_l      NUMBER;
   nam_id_l          NUMBER;
   brojac_l          NUMBER;
BEGIN
   FOR pri IN (
      SELECT id, mt_id_daje, mt_id_prima, ozn_int_prihoda, ROWID
        FROM t_prijelaz
       WHERE datum = datum_M
         AND mt_id_daje <> mt_id_prima -- MT je istovremeno primatelj i davatelj samo kod proizvodnje
         AND zaj_obr.vanjsko_mjesto_troska (mt_id_daje) = vrsta_mjesta_troska_P)
   LOOP

      FOR priart IN (
         SELECT ROWID, sir_id, pro_id, nam_id, nam_pro_id,
                kolicina, DECODE (planska_cijena, 0, nab_cijena, planska_cijena) nab_cijena,
                planska_cijena
           FROM t_prijelaz_art
          WHERE pri_id = pri.id
            AND kolicina <> 0)
      LOOP
         IF priart.sir_id IS NOT NULL THEN
            SELECT odnos_jm_b, odnos_jm_n
              INTO odnos_jm_b_l, odnos_jm_n_l
              FROM m_sirovine
             WHERE id = priart.sir_id;

            UPDATE t_prijelaz_art
               SET odnos_jm_b = odnos_jm_b_l,
                   odnos_jm_n = odnos_jm_n_l
             WHERE ROWID = priart.ROWID;

            prijelaz_sirovine (
               mt_id_daje_p      => pri.mt_id_daje,
               mt_id_prima_p     => pri.mt_id_prima,
               sir_id_p          => priart.sir_id,
               kolicina_p        => priart.kolicina,
               nab_cijena_p      => priart.nab_cijena,
               odnos_jm_b_p      => odnos_jm_b_l,
               odnos_jm_n_p      => odnos_jm_n_l,
               pros_nab_cijena_p => pros_nab_cijena_l, -- procedura vraa cijenu (OUT parametar) 
               ozn_int_prihoda_p => pri.ozn_int_prihoda); 
 
               
         ELSIF priart.pro_id IS NOT NULL THEN
            /*
            Prijelaz proizvoda izmeu vanjskih MT obavezno ima kvazi-namirnicu.
            jer se iz cijene proizvoda ne mogu izraunati cijene namirnica. */
            
            
            IF zaj_obr.vanjsko_mjesto_troska (pri.mt_id_daje) = -1 -- MT davatelj je vanjski
               AND
               zaj_obr.vanjsko_mjesto_troska (pri.mt_id_prima) = 0 -- MT primatelj je unutarnji
            THEN
               /*
                Proizvod u ovom sluaju mora (u stavci) imati kvazi namirnicu.
                Provjerava se za svaki sluaj, iako se provjera radi kod unosa stavke prijelaznice.
                No, moda je u meuvremenu promijenjena struktura OJ, pa je unutarnje MT postalo vanjsko.
                */
                IF priart.nam_pro_id IS NULL THEN
                    gas_zaj.vrati_poruku (-20209);
                END IF;

                /* Razduuje se / zaduuje kvazi-namirnica */

                prijelaz_namirnice_davaoc (
                   mt_id_daje_p      => pri.mt_id_daje,
                   nam_id_p          => priart.nam_pro_id, -- razduuje se kvazi-namirnica
                   sir_id_p          => NULL,
                   pro_id_p          => NULL,
                   kolicina_p        => priart.kolicina,
                   nab_cijena_p      => priart.nab_cijena,
                   pros_nab_cijena_p => pros_nab_cijena_l); -- procedura vraa cijenu (OUT parametar)

                prijelaz_namirnice_primaoc (
                   mt_id_daje_p       => pri.mt_id_daje,
                   mt_id_prima_p      => pri.mt_id_prima,
                   nam_id_p           => priart.nam_pro_id, -- zaduuje se kvazi-namirnica
                   sir_id_p           => NULL,
                   pro_id_p           => NULL,
                   nam_pro_id_p       => NULL,  -- samo kod proizvoda moe biti NOT NULL
                   kolicina_p         => priart.kolicina,
                   nab_cijena_p       => priart.nab_cijena,
                   cijena_kvazi_nam_p => NULL, -- samo kod proizvoda moe biti NOT NULL  
                   ozn_int_prihoda_p  => pri.ozn_int_prihoda);    
                  
            ELSE
                prijelaz_proizvoda (
                   mt_id_daje_p       => pri.mt_id_daje,
                   mt_id_prima_p      => pri.mt_id_prima,
                   pro_id_p           => priart.pro_id,
                   nam_pro_id_p       => priart.nam_pro_id,  -- NOT NULL samo ako zaduuje kvazi-namirnicu
                   kolicina_p         => priart.kolicina,
                   nab_cijena_p       => priart.nab_cijena,
                   cijena_proizvoda_p => pros_nab_cijena_l, -- procedura vraa cijenu (OUT parametar) 
                   ozn_int_prihoda_p  => pri.ozn_int_prihoda); 
            END IF;
             
         ELSE
            prijelaz_namirnice_davaoc (
               mt_id_daje_p      => pri.mt_id_daje,
               nam_id_p          => priart.nam_id,
               sir_id_p          => NULL,
               pro_id_p          => NULL,
               kolicina_p        => priart.kolicina,
               nab_cijena_p      => priart.nab_cijena,
               pros_nab_cijena_p => pros_nab_cijena_l); -- procedura vraa cijenu (OUT parametar)

            prijelaz_namirnice_primaoc (
               mt_id_daje_p       => pri.mt_id_daje,
               mt_id_prima_p      => pri.mt_id_prima,
               nam_id_p           => priart.nam_id,
               sir_id_p           => NULL,
               pro_id_p           => NULL,
               nam_pro_id_p       => NULL,  -- samo kod proizvoda moe biti NOT NULL
               kolicina_p         => priart.kolicina,
               nab_cijena_p       => priart.nab_cijena,
               cijena_kvazi_nam_p => NULL, -- samo kod proizvoda moe biti NOT NULL  
               ozn_int_prihoda_p  => pri.ozn_int_prihoda);
         END IF;

         IF zaj_obr.vanjsko_mjesto_troska (pri.mt_id_daje) = 0  THEN
            /* Ako su se mijenjale pros.cijene, oznaava se da prijelaznicu treba poslati vanjskom primatelju */
            IF priart.planska_cijena = 0
               AND ROUND (priart.nab_cijena, 2) <> ROUND (pros_nab_cijena_l, 2) -- ROUND je da se izbjegne "zaarani krug" 
               AND prijelaznica_za_slanje (pri.id) = -1
            THEN
               UPDATE t_prijelaz
                  SET ozn_replikacije = 'D'
                WHERE ROWID = pri.ROWID;
            END IF;

            UPDATE t_prijelaz_art
               SET nab_cijena = pros_nab_cijena_l
             WHERE pri_id = pri.id
               AND NVL (nam_id, 0) = NVL (priart.nam_id, 0)
               AND NVL (sir_id, 0) = NVL (priart.sir_id, 0)
               AND NVL (pro_id, 0) = NVL (priart.pro_id, 0);

            /*
            BEGIN TRGOVINA
            Ako je napravljena obrada trgovake robe i ponavlja se dnevni obraun,
            mijenjaju se i prosjene cijene u GAS, te se aurira pnc u tnst_prijelaz_gas.
            */
            FOR nstpri IN (
               SELECT id
                 FROM tnst_prijelaz
                WHERE gasulaz_id = pri.id)
            LOOP
               IF priart.nam_id IS NOT NULL THEN
                  nam_id_l := priart.nam_id;
               ELSIF priart.pro_id IS NOT NULL THEN
                  SELECT nam_id INTO nam_id_l
                    FROM m_sastav
                   WHERE pro_id = priart.pro_id;
               ELSE
                  SELECT nam_id INTO nam_id_l
                    FROM m_rastav
                   WHERE sir_id = priart.sir_id;
               END IF;

               UPDATE tnst_prijelaz_gas
                  SET nab_cijena = pros_nab_cijena_l
                WHERE nstprij_id = nstpri.id
                  AND nam_id  = nam_id_l;
            END LOOP;
            /* END TRGOVINA */

         END IF;
      END LOOP;

      FOR priamb IN (
         SELECT amb_id, kolicina
           FROM t_prijelaz_amb
          WHERE pri_id = pri.id)
      LOOP
         prijelaz_ambalaze (
            mt_id_daje_p  => pri.mt_id_daje,
            mt_id_prima_p => pri.mt_id_prima,
            amb_id_p      => priamb.amb_id,
            kolicina_p    => priamb.kolicina);
      END LOOP;
   END LOOP;
END;
PROCEDURE PRIJELAZ_SIROVINE
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 )
 IS

   cijena_L                NUMBER;
   kalo_obrade_L           NUMBER;
   kalo_odmrzavanja_L      NUMBER;
   korigirana_kol_sir_L    NUMBER;
   korigirana_kol_nam_L    NUMBER;
   korigirana_cijena_sir_L NUMBER;
   korigirana_cijena_nam_L NUMBER;
   ekvivalent_L            NUMBER;
   pom_br_rastava_L        NUMBER;
   pros_nab_cijena_L       NUMBER;
   cijena_sirovine_L       NUMBER := 0;
   sir_sifra_l             m_sirovine.sifra%TYPE;
BEGIN
   IF zaj_obr.vanjsko_mjesto_troska (mt_id_daje_p) = -1  THEN
      cijena_l := zaj_obr.cijena_odnos (nab_cijena_p, odnos_jm_b_p, odnos_jm_n_p);

      IF kolicina_p > 0 AND nab_cijena_p > 0 THEN
         UPDATE m_sirovine
            SET zad_nab_cijena = cijena_l,
                dat_azur_nc    = datum_m
          WHERE id = sir_id_p;
      END IF;
   END IF;

   SELECT kalo_obrade, kalo_odmrzavanja, sifra
     INTO kalo_obrade_l, kalo_odmrzavanja_l, sir_sifra_l
     FROM m_sirovine
    WHERE id = sir_id_p;

   IF zaj_obr.ima_sir_bez_rastava(sir_id_p) = -1 THEN
	 gas_zaj.vrati_poruku	(-20219, sir_sifra_l);
   END IF;

   korigirana_kol_sir_l :=
      zaj_obr.korigirana_kol_sirovine (
         kolicina_p,
         odnos_jm_b_p,
         odnos_jm_n_p,
         kalo_odmrzavanja_l,
         kalo_obrade_l);

   korigirana_cijena_sir_l :=
      zaj_obr.korigirana_cijena_sirovine (
         nab_cijena_p,
         odnos_jm_b_p,
         odnos_jm_n_p,
         kalo_odmrzavanja_l,
         kalo_obrade_l);

   pom_br_rastava_l := zaj_obr.pom_broj_rastava (sir_id_p);

   FOR ras IN (
      SELECT  nam_id, udio_namirnice
        FROM m_rastav
       WHERE sir_id = sir_id_p)
   LOOP
      SELECT ekvivalent INTO ekvivalent_l
        FROM m_namirnice
       WHERE id = ras.nam_id;

      korigirana_kol_nam_l :=
         zaj_obr.korigirana_kol_namirnice (
            korigirana_kol_sir_l,
            ras.udio_namirnice);

      korigirana_cijena_nam_l :=
         zaj_obr.korigirana_cijena_namirnice (
            korigirana_cijena_sir_l,
            ekvivalent_l,
            pom_br_rastava_l);

      prijelaz_namirnice_davaoc (
         mt_id_daje_p      => mt_id_daje_p,
         nam_id_p          => ras.nam_id,
         sir_id_p          => sir_id_p,
         pro_id_p          => NULL,
         kolicina_p        => korigirana_kol_nam_l,
         nab_cijena_p      => korigirana_cijena_nam_l,
         pros_nab_cijena_p => pros_nab_cijena_l); -- procedura vraa cijenu (OUT parametar)

      prijelaz_namirnice_primaoc (
         mt_id_daje_p       => mt_id_daje_p,
         mt_id_prima_p      => mt_id_prima_p,
         nam_id_p           => ras.nam_id,
         sir_id_p           => sir_id_p,
         pro_id_p           => NULL,
         nam_pro_id_p       => NULL,  -- samo kod proizvoda moe biti NOT NULL
         kolicina_p         => korigirana_kol_nam_l,
         nab_cijena_p       => korigirana_cijena_nam_l,
         cijena_kvazi_nam_p => NULL,  -- samo kod proizvoda moe biti NOT NULL
         ozn_int_prihoda_p  => ozn_int_prihoda_p);
         
      cijena_sirovine_l := cijena_sirovine_l + ABS (korigirana_kol_nam_l) * pros_nab_cijena_l;
   END LOOP;
 
   pros_nab_cijena_p := cijena_sirovine_l / ABS (kolicina_p);
END;
PROCEDURE PRIJELAZ_NAMIRNICE_PRIMAOC
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,NAM_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,CIJENA_KVAZI_NAM_P NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 )
 IS

   brojac_L          NUMBER;
   izn_int_L         NUMBER;
   pros_nab_cijena_L NUMBER;
   zad_nab_cijena_L  NUMBER;
   datum_L           DATE;
   ozn_int_prihoda_l m_mt.ozn_int_prihoda%TYPE;
   mt_vrsta_l m_mt.vrsta%TYPE;
BEGIN  
   
   /* Mjesto troka PRIMATELJ vrste 'Administracija' slui za direktno razduivanje (ulaz je istodobno troak)
      Ovakva prijelaznice se ne repliciraju primatelju.
      Knjienja idu iz tablica T_PRIJELAZ i T_PRIJELAZ_ART 
   */             
   SELECT vrsta 
     INTO mt_vrsta_l
     FROM m_mt 
    WHERE id = mt_id_prima_p;
     
   IF mt_vrsta_l = 'T' THEN
      RETURN;
   END IF;             
   --
                
   IF zaj_obr.vanjsko_mjesto_troska (mt_id_daje_p) = -1  OR ozn_int_prihoda_P = 'D' THEN
      pros_nab_cijena_l := nab_cijena_p;
      IF kolicina_p > 0 AND nam_pro_id_p IS NULL AND pros_nab_cijena_l > 0 THEN
         UPDATE m_namirnice
            SET zad_nab_cijena = pros_nab_cijena_l,
                dat_azur_nc  = datum_m
          WHERE id = nam_id_p;
      END IF;
   ELSE
      /*
      Ako je rije o prijelazu sirovine, prijelazu namirnice ili prijelazu proizvoda
      u varijanti da primaoc zaprima proizvod kao proizvod (a ne kao kvazi-namirnicu),
      trai se prosjena cijena namirnice kod davaoca,
      jer se procedura PRIJELAZ_NAMIRNICE_DAVAOC uvijek poziva prije ove procedure,
      pa je cijena namirnice kod davaoca (za taj dan) ve izraunata.

      Ako je rije o prijelazu proizvoda u varijanti da primaoc zaprima proizvod kao kvazi-namirnicu
      (nam_pro_id_p IS NOT NULL) tada se (kroz parametar cijena_kvazi_nam_p) uzima cijena proizvoda
      koja je izraunata u proceduri PRIJELAZ_PROIZVODA.
      */
      IF nam_pro_id_p IS NULL THEN
         SELECT pros_nab_cijena INTO pros_nab_cijena_l
           FROM i_dnev_ui
          WHERE mt_id  = mt_id_daje_p
            AND nam_id = nam_id_p
            AND datum  = datum_m;
      ELSE
         pros_nab_cijena_l := cijena_kvazi_nam_p;
      END IF;
   END IF;

   SELECT zad_nab_cijena
     INTO zad_nab_cijena_l
     FROM m_namirnice
    WHERE id = nam_id_p;

   IF nam_pro_id_p IS NULL THEN
      izn_int_l := kolicina_p * pros_nab_cijena_l;
   ELSE
      IF ozn_int_prihoda_P = 'D' THEN
        izn_int_l := kolicina_p * pros_nab_cijena_l;
	ELSE
	  izn_int_l := cijena_kvazi_nam_p;
	END IF;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_det
    WHERE mt_id  = mt_id_prima_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
      AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
      AND nam_id_supstitut IS NULL
      AND pro_id_supstitut IS NULL;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_prima_P, nam_id_P, datum_M, sir_id_P, pro_id_P,
         NULL, NULL, 0, 0,
         kolicina_P, 0, 0,
         0, 0,
         0, 0, 0, izn_int_L,
         0, pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_det
         SET zad_nab_cijena  = zad_nab_cijena_L,
             kol_int_ulaz = kol_int_ulaz + kolicina_P,
             izn_int_ulaz = izn_int_ulaz + izn_int_L
       WHERE mt_id  = mt_id_prima_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
         AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
         AND nam_id_supstitut IS NULL
         AND pro_id_supstitut IS NULL;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_prima_P
      AND nam_id = nam_id_P
      AND datum  = datum_M;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_prima_P, nam_id_P, datum_M, 0, 0,
         kolicina_P, 0, 0,
         0, 0,
         0, 0, 0, izn_int_L,
         0, 0, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui
         SET kol_int_ulaz = kol_int_ulaz + kolicina_P,
             izn_int_ulaz = izn_int_ulaz + izn_int_L
       WHERE mt_id  = mt_id_prima_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;
   END IF;
END;
PROCEDURE PRIJELAZ_NAMIRNICE_DAVAOC
 (MT_ID_DAJE_P NUMBER
 ,NAM_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 )
 IS

   brojac_L          NUMBER;
   izn_int_L         NUMBER;
   pros_nab_cijena_L NUMBER;
   zad_nab_cijena_L  NUMBER;
   iznos_L           NUMBER;
   kolicina_L        NUMBER;
   izn_ulaz_L        NUMBER;
   izn_int_ulaz_L    NUMBER;
   izn_int_izlaz_L   NUMBER;
   kol_ulaz_L        NUMBER;
   kol_int_ulaz_L    NUMBER;
   kol_int_izlaz_L   NUMBER;
   datum_L           DATE;
   cvor_centar_l     smet_cvorovi.sifra%TYPE;
BEGIN
 

   /* 1. Ako je MT vanjsko, uzima cijenu iz prijelaznice */
   IF zaj_obr.vanjsko_mjesto_troska (mt_id_daje_p) = -1  THEN
      pros_nab_cijena_l := nab_cijena_p;

      GOTO postavi_pros_nab_cijenu;
   END IF;


   /* 2.1 Ako MT nije vanjsko, prvo trai prethodnu pros.nab.cijenu kod MT davaoca */
   SELECT MAX (datum) INTO datum_l
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_daje_p
      AND nam_id = nam_id_p
      AND datum  < datum_m;

   IF datum_l IS NOT NULL THEN
      SELECT pros_nab_cijena INTO pros_nab_cijena_l
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_daje_p
         AND nam_id = nam_id_p
         AND datum  = datum_l;

      GOTO postavi_pros_nab_cijenu;
   END IF;


   /* 2.2 Ako ne nae prethodnu, rauna trenutanu pros.nab.cijenu davaoca */
   SELECT COUNT (1) INTO brojac_l
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_daje_p
      AND nam_id = nam_id_p
      AND datum  = datum_m;

   IF brojac_l <> 0 THEN
      SELECT izn_ulaz, izn_int_ulaz, izn_int_izlaz,
             kol_ulaz, kol_int_ulaz, kol_int_izlaz
        INTO izn_ulaz_l, izn_int_ulaz_l, izn_int_izlaz_l,
             kol_ulaz_l, kol_int_ulaz_l, kol_int_izlaz_l
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_daje_p
         AND nam_id = nam_id_p
         AND datum  = datum_m;

      /*
      Kod izrauna prosjene cijene nekad se uzimao i INTERNI IZLAZ, a sada samo INTERNI ULAZ,
      zato jer je ponekad dolazilo do udnih (npr. vrlo velikih) prosjenih cijena,
      kada je koliina u nazivniku bila vrlo malena.

      iznos_l    := izn_ulaz_l + izn_int_ulaz_l - izn_int_izlaz_l;
      kolicina_l := kol_ulaz_l + kol_int_ulaz_l - kol_int_izlaz_l;
      */
      iznos_l    := izn_ulaz_l + izn_int_ulaz_l;
      kolicina_l := kol_ulaz_l + kol_int_ulaz_l;

      IF iznos_l > 0 AND kolicina_l > 0 THEN
         pros_nab_cijena_l := iznos_l / kolicina_l;

         GOTO postavi_pros_nab_cijenu;
      END IF;
   END IF;


   /* 2.3 Ako ne moe izraunati niti trenutanu pros.nab.cijenu, stavlja nulu */
   pros_nab_cijena_l := 0;


   <<postavi_pros_nab_cijenu>> pros_nab_cijena_p := pros_nab_cijena_l;

   SELECT zad_nab_cijena
     INTO zad_nab_cijena_l
     FROM m_namirnice
    WHERE id = nam_id_p;

   izn_int_l := kolicina_p * pros_nab_cijena_p;

   SELECT COUNT (1) INTO brojac_l
     FROM i_dnev_ui_det
    WHERE mt_id  = mt_id_daje_p
      AND nam_id = nam_id_p
      AND datum  = datum_m
      AND NVL (sir_id, 0) = NVL (sir_id_p, 0)
      AND NVL (pro_id, 0) = NVL (pro_id_p, 0)
      AND nam_id_supstitut IS NULL
      AND pro_id_supstitut IS NULL;

   IF brojac_l = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_daje_p, nam_id_p, datum_m, sir_id_p, pro_id_p,
         NULL, NULL, 0, 0,
         0, kolicina_p, 0,
         0, 0,
         0, 0, 0, 0,
         izn_int_l, 0, zad_nab_cijena_l);
   ELSE
      UPDATE i_dnev_ui_det
         SET zad_nab_cijena = zad_nab_cijena_l,
             kol_int_izlaz  = kol_int_izlaz + kolicina_p,
             izn_int_izlaz  = izn_int_izlaz + izn_int_l
       WHERE mt_id  = mt_id_daje_p
         AND nam_id = nam_id_p
         AND datum  = datum_m
         AND NVL (sir_id, 0) = NVL (sir_id_p, 0)
         AND NVL (pro_id, 0) = NVL (pro_id_p, 0)
         AND nam_id_supstitut IS NULL
         AND pro_id_supstitut IS NULL;
   END IF;

   SELECT COUNT (1) INTO brojac_l
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_daje_p
      AND nam_id = nam_id_p
      AND datum  = datum_m;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_daje_p, nam_id_p, datum_m, 0, 0,
         0, kolicina_p, 0,
         0, 0,
         0, 0, 0, 0,
         izn_int_l, pros_nab_cijena_l, zad_nab_cijena_l);
   ELSE
      UPDATE i_dnev_ui
         SET zad_nab_cijena  = zad_nab_cijena_l,
             pros_nab_cijena = pros_nab_cijena_l,
             kol_int_izlaz   = kol_int_izlaz + kolicina_p,
             izn_int_izlaz = izn_int_izlaz + izn_int_l
       WHERE mt_id  = mt_id_daje_p
         AND nam_id = nam_id_p
         AND datum  = datum_m;
   END IF;
END;
PROCEDURE PRIJELAZ_PROIZVODA
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,NAB_CIJENA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 ,OZN_INT_PRIHODA_P IN M_MT.OZN_INT_PRIHODA%TYPE
 )
 IS

   kolicina_normativ_L NUMBER;
   kol_recepture_L     NUMBER;
   razina_L            NUMBER;
   brojac_L            NUMBER;
   pros_nab_cijena_L   NUMBER;
   cijena_proizvoda_L  NUMBER := 0;
   zad_nab_cijena_L    NUMBER;
   vrijednost_l        m_mt.sifra%TYPE;
   mt_sifra_l          m_mt.sifra%TYPE;
   ozn_int_prihoda_l   m_mt.ozn_int_prihoda%TYPE;
   vrsta_l             m_mt.vrsta%TYPE;
BEGIN
   SELECT kol_recepture, zad_nab_cijena
     INTO kol_recepture_l, zad_nab_cijena_l
     FROM m_proizvodi
    WHERE id = pro_id_p;

   FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_p)
   LOOP
      kolicina_normativ_l :=
         zaj_obr.kolicina_normativ (
            kolicina_p,
            sas.normativ,
            kol_recepture_l);

      IF sas.nam_id IS NOT NULL THEN
         prijelaz_namirnice_davaoc (
            mt_id_daje_p      => mt_id_daje_p,
            nam_id_p          => sas.nam_id,
            sir_id_p          => NULL,
            pro_id_p          => pro_id_p,
            kolicina_p        => kolicina_normativ_l,
            nab_cijena_p      => NULL, -- parametar NIJE vaan za ovaj sluaj, jer vanjsko MT ne moe davati proizvod
            pros_nab_cijena_p => pros_nab_cijena_l); -- procedura vraa cijenu (OUT parametar)

         cijena_proizvoda_l := cijena_proizvoda_l + pros_nab_cijena_l * ABS (kolicina_normativ_l);

         /* Primaoc se zaduuje za svaku namirnicu iz sastava */
         IF nam_pro_id_p IS NULL THEN
            prijelaz_namirnice_primaoc (
               mt_id_daje_p       => mt_id_daje_p,
               mt_id_prima_p      => mt_id_prima_p,
               nam_id_p           => sas.nam_id,
               sir_id_p           => NULL,
               pro_id_p           => pro_id_p,
               nam_pro_id_p       => NULL, -- nije kvazi-namirnica
               kolicina_p         => kolicina_normativ_l,
               nab_cijena_p       => NULL,  -- parametar NIJE vaan za ovaj sluaj, rauna se u pozvanoj proceduri
               cijena_kvazi_nam_p => NULL, -- nije kvazi-namirnica 
               ozn_int_prihoda_p  => ozn_int_prihoda_p);
	        END IF;
      ELSE
         SELECT COUNT (1) INTO brojac_l
           FROM p_planpot
          WHERE mt_id = mt_id_daje_p
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_l = 0 THEN
            SELECT razina INTO razina_l
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
               mt_id, nac_id, nam_id, pro_id,
               kolicina, razina_proizvoda)
               VALUES (
               mt_id_daje_p, NULL, NULL, sas.pro_id_poluproizvod,
               kolicina_normativ_l, razina_l);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_l
             WHERE mt_id = mt_id_daje_p
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nac_id, nam_id,
             kolicina, razina_proizvoda
        FROM p_planpot)
   LOOP
      prijelaz_namirnice_davaoc (
         mt_id_daje_p      => mt_id_daje_p,
         nam_id_p          => pom.nam_id,
         sir_id_p          => NULL,
         pro_id_p          => pro_id_p,
         kolicina_p        => pom.kolicina,
         nab_cijena_p      => NULL, -- parametar NIJE vaan za ovaj sluaj, jer vanjsko MT ne moe davati proizvod
         pros_nab_cijena_p => pros_nab_cijena_l); -- procedura vraa cijenu (OUT parametar)

      cijena_proizvoda_l := cijena_proizvoda_l + pros_nab_cijena_l * ABS (pom.kolicina);

      /* Primaoc se zaduuje za svaku namirnicu iz sastava */
      IF nam_pro_id_p IS NULL THEN
         prijelaz_namirnice_primaoc (
            mt_id_daje_p       => mt_id_daje_p,
            mt_id_prima_p      => mt_id_prima_p,
            nam_id_p           => pom.nam_id,
            sir_id_p           => NULL,
            pro_id_p           => pro_id_p,
            nam_pro_id_p       => NULL, -- nije kvazi-namirnica
            kolicina_p         => pom.kolicina,
            nab_cijena_p       => NULL,  -- parametar NIJE vaan za ovaj sluaj, rauna se u pozvanoj proceduri
            cijena_kvazi_nam_p => NULL, -- nije kvazi-namirnica    
            ozn_int_prihoda_p => ozn_int_prihoda_p);
      END IF;
   END LOOP;

   cijena_proizvoda_p := cijena_proizvoda_l / ABS (kolicina_p);
   DELETE p_planpot;

   /* Primaoc se zaduuje za samo jednu namirnicu koja "zamjenjuje" proizvod */
   IF nam_pro_id_p IS NOT NULL THEN
      
      IF ozn_int_prihoda_P = 'D' AND  zaj_obr.vanjsko_mjesto_troska (mt_id_daje_p) = -1	THEN
         UPDATE m_namirnice
            SET zad_nab_cijena = nab_cijena_p,
                dat_azur_nc = datum_m
          WHERE id = nam_pro_id_p;
      ELSE
         UPDATE m_namirnice
            SET zad_nab_cijena = cijena_proizvoda_p,
                dat_azur_nc = datum_m
          WHERE id = nam_pro_id_p;
      END IF;

      SELECT vrsta
        INTO vrsta_l
        FROM m_mt
       WHERE id = mt_id_daje_p;

 
       prijelaz_namirnice_primaoc (
          mt_id_daje_p       => mt_id_daje_p,
          mt_id_prima_p      => mt_id_prima_p,
          nam_id_p           => nam_pro_id_p, -- u pozvanoj proceduri radi se sa kvazi-namirnicom
          sir_id_p           => NULL,
          pro_id_p           => pro_id_p,
          nam_pro_id_p       => nam_pro_id_p,
          kolicina_p         => kolicina_p,
          nab_cijena_p       => nab_cijena_p, -- parametar NIJE vaan za ovaj sluaj osim za MT sa planskim cijenama, rauna se u pozvanoj proceduri
          cijena_kvazi_nam_p => cijena_proizvoda_l,
          ozn_int_prihoda_p  => ozn_int_prihoda_p);
      
   END IF;
END;
PROCEDURE PRIJELAZ_AMBALAZE
 (MT_ID_DAJE_P NUMBER
 ,MT_ID_PRIMA_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 )
 IS

   rowid_l ROWID;
BEGIN
   /* Auriranje za MT davaoca */
   rowid_l := NULL;
   BEGIN
      SELECT ROWID INTO rowid_l -- koristimo ROWID da u UPDATE ne moramo ponoviti uvjet
        FROM i_dnev_ui_amb
       WHERE mt_id  = mt_id_daje_p
         AND amb_id = amb_id_p
         AND datum  = datum_m
         AND dob_id IS NULL;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   IF rowid_l IS NULL THEN
      INSERT INTO i_dnev_ui_amb (
         mt_id, amb_id, datum, dob_id,
         kol_ulaz, kol_int_ulaz, kol_int_izlaz, kol_izlaz,
         kol_dnev_otpis, kol_inv_razlika, zaliha)
         VALUES (
         mt_id_daje_p, amb_id_p, datum_m, NULL,
         0, 0, kolicina_p, 0,
         0, 0, 0);
   ELSE
      UPDATE i_dnev_ui_amb
         SET kol_int_izlaz = kol_int_izlaz + kolicina_p
       WHERE ROWID = rowid_l;
   END IF;

   /* Auriranje za MT primaoca */
   rowid_l := NULL;
   BEGIN
      SELECT ROWID INTO rowid_l -- koristimo ROWID da u UPDATE ne moramo ponoviti uvjet
        FROM i_dnev_ui_amb
       WHERE mt_id  = mt_id_prima_p
         AND amb_id = amb_id_p
         AND datum  = datum_m
         AND dob_id IS NULL;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   IF rowid_l IS NULL THEN
      INSERT INTO i_dnev_ui_amb (
         mt_id, amb_id, datum, dob_id,
         kol_ulaz, kol_int_ulaz, kol_int_izlaz, kol_izlaz,
         kol_dnev_otpis, kol_inv_razlika, zaliha)
         VALUES (
         mt_id_prima_p, amb_id_p, datum_m, NULL,
         0, kolicina_p, 0, 0,
         0, 0, 0);
   ELSE
      UPDATE i_dnev_ui_amb
         SET kol_int_ulaz = kol_int_ulaz + kolicina_p
       WHERE ROWID = rowid_l;
   END IF;
END;
PROCEDURE IZRACUN_PRO_NC_NAMIRNICE
 IS

   zaliha_L               NUMBER;
   pros_nab_cijena_L      NUMBER;
   pros_nab_cijena_nova_L NUMBER;
   zad_nab_cijena_L       NUMBER;
   iznos_L                NUMBER;
   iznos_ukupno_L         NUMBER;
   kolicina_L             NUMBER;
   kolicina_ukupno_L      NUMBER;
   datum_L                DATE;
   cvor_centar_l          smet_cvorovi.sifra%TYPE;
   min_kolicina_l CONSTANT NUMBER := 1 / 1000;
BEGIN
   FOR dui IN (
      SELECT mt_id, nam_id, zaliha, pros_nab_cijena, izn_ulaz,
             izn_int_ulaz, izn_int_izlaz, kol_ulaz, kol_int_ulaz,
             kol_int_izlaz
        FROM i_dnev_ui
       WHERE datum  = datum_M)
   LOOP
      SELECT MAX (datum) INTO datum_L
        FROM i_dnev_ui
       WHERE mt_id  = dui.mt_id
         AND nam_id = dui.nam_id
         AND datum  < datum_M;
      IF datum_L IS NOT NULL THEN
         SELECT zaliha, pros_nab_cijena
           INTO zaliha_L, pros_nab_cijena_L
           FROM i_dnev_ui
          WHERE mt_id  = dui.mt_id
            AND nam_id = dui.nam_id
            AND datum  = datum_L;
      ELSE
         zaliha_L := 0;
         pros_nab_cijena_L := 0;
      END IF;

      /*
      Kod izrauna prosjene cijene nekad se uzimao i INTERNI IZLAZ, a sada samo INTERNI ULAZ,
      zato jer je ponekad dolazilo do udnih (npr. vrlo velikih) prosjenih cijena,
      kada je koliina u nazivniku bila vrlo malena.

      iznos_L    := dui.izn_ulaz + dui.izn_int_ulaz - dui.izn_int_izlaz;
      kolicina_L := dui.kol_ulaz + dui.kol_int_ulaz - dui.kol_int_izlaz;
      */
      iznos_L    := dui.izn_ulaz + dui.izn_int_ulaz;
      kolicina_L := dui.kol_ulaz + dui.kol_int_ulaz;

      iznos_ukupno_L := zaliha_L * pros_nab_cijena_L + iznos_L;
      kolicina_ukupno_L := zaliha_L + kolicina_L;


      IF zaliha_l >= min_kolicina_l AND iznos_ukupno_l > 0 AND kolicina_ukupno_l >= min_kolicina_l THEN
         pros_nab_cijena_nova_L := iznos_ukupno_l / kolicina_ukupno_l;
      ELSIF iznos_l > 0 AND kolicina_l >= min_kolicina_l THEN
         pros_nab_cijena_nova_l := iznos_l / kolicina_l;
      ELSE
         pros_nab_cijena_nova_l := pros_nab_cijena_l;
      END IF;

      /*
      Auriranje ZNC u i_dnev_ui koje se provodi u prethodnim
      procedurama je ostavljeno, iako nema efekta, jer se "pregazi" sa ovime
      */
      SELECT zad_nab_cijena INTO zad_nab_cijena_L
        FROM m_namirnice
       WHERE id = dui.nam_id;
      UPDATE i_dnev_ui
         SET pros_nab_cijena = pros_nab_cijena_nova_L,
             zad_nab_cijena  = zad_nab_cijena_L
       WHERE mt_id  = dui.mt_id
         AND nam_id = dui.nam_id
         AND datum  = datum_M;
   END LOOP;
END;
PROCEDURE OBRADA_IZLAZA
 IS
   pros_nab_cijena_l  NUMBER := 0;
   zad_nab_cijena_l   NUMBER;
   br_gostiju_izlaz_l NUMBER;
   priznanje_l NUMBER ;
   izl_id_l           NUMBER;
   gpor_id_l          NUMBER;
   gknji_id_L         NUMBER;
   pro_nam_id_L       NUMBER;
   sifra_l            m_proizvodi.sifra%TYPE;
   opera_rc_id_l      NUMBER; -- OPERA!
   kase_id_l          NUMBER; -- OPERA!
BEGIN
   /*
   Za stavke ra?una (sa kase) koje se odnose na nestandardan proizvod,
   provjerava se da li postoji zapis i u "ru?nom" izlazu
   (za isto MT, na?in potro?nje i datum).

   Tako?er, a?uriraju se porezne stope i priznanje u dokumentu
   izlaza nestandardnog proizvoda na temelju stavaka sa kase.
   */
   FOR rn IN (
      SELECT id, nac_id, popust
        FROM t_rnkase
       WHERE datum = datum_m)
   LOOP
      FOR rnpro IN (
         SELECT sifgr_id, mt_id, gpor_id, pdv, ppot, cijena
           FROM t_rnkase_pro
          WHERE rn_id = rn.id
            AND sifgr_id IS NOT NULL) -- nestandardni proizvodi
      LOOP
         /*
         Ako ima vi?e stavaka sa kase za isto MT, datum, na?in potro?nje i proizvod,
         a?uriranje u dokumentu izlaza napravit ?e se vi?e puta.
         To je nepotrebno, ali ne smeta, jer sve te stavke sa kase
         moraju imati iste porezne stope i priznanje.
         */
         UPDATE t_izlaz
            SET pdv       = rnpro.pdv,
                ppot      = rnpro.ppot 
          WHERE mt_id    = rnpro.mt_id
            AND datum    = datum_m
            AND nac_id   = rn.nac_id
            AND sifgr_id = rnpro.sifgr_id;

         IF SQL%NOTFOUND THEN -- ako ne postoji odgovaraju?i dokument izlaza
            DECLARE
               mt_sifra_l     m_mt.sifra%TYPE;
               nacpot_sifra_l m_nacpot.sifra%TYPE;
               sifgr_sifra_l  m_sif_grupa.sif_proizvoda_kasa%TYPE;
            BEGIN
               SELECT sif_proizvoda_kasa INTO sifgr_sifra_l
                 FROM m_sif_grupa
                WHERE id = rnpro.sifgr_id;

               SELECT sifra INTO mt_sifra_l
                 FROM m_mt
                WHERE id = rnpro.mt_id;

               SELECT sifra INTO nacpot_sifra_l
                 FROM m_nacpot
                WHERE id = rn.nac_id;

               gas_zaj.vrati_poruku
                  (-20055, sifgr_sifra_l, mt_sifra_l, nacpot_sifra_l, datum_m);
            END;
         END IF;
      END LOOP; -- stavke ra?una
   END LOOP; -- zaglavlja ra?una


   /* Koli?ine "ru?nog" izlaza nestandardnih proizvoda pune se koli?inama sa kase */
   FOR izl IN (
      SELECT id, mt_id, sifgr_id, nac_id, br_gostiju_plan
        FROM t_izlaz
       WHERE datum = datum_m
         AND sifgr_id IS NOT NULL) -- izlaz nestandardnih proizvoda
   LOOP
      /*
      Sumiraju se koli?ine svih stavaka ra?una koje se odnose na isti
      dan, na?in potro?nje, MT i nestandardan proizvod. Na kasi se mogu mijenjati PC
      pa se rauna prosjena prodajna cijena 
      */
      SELECT NVL (SUM (rnpro.kolicina), 0), 
             DECODE(SUM(rnpro.kolicina),0, SUM(rnpro.iznos),SUM(rnpro.iznos) / SUM(rnpro.kolicina))
        INTO br_gostiju_izlaz_l,
             priznanje_l  
        FROM t_rnkase rn,
             t_rnkase_pro rnpro
       WHERE rn.datum       = datum_m
         AND rn.nac_id      = izl.nac_id
         AND rnpro.rn_id    = rn.id
         AND rnpro.sifgr_id = izl.sifgr_id
         AND rnpro.mt_id    = izl.mt_id;

      UPDATE t_izlaz
         SET br_gostiju_izlaz = br_gostiju_izlaz_l,
             priznanje        = NVL(priznanje_l,0)
       WHERE id = izl.id;

      UPDATE t_izlaz_art
         SET kol_izlaz =  (kol_plan - kol_povrat) * br_gostiju_izlaz_l / izl.br_gostiju_plan
       WHERE izl_id = izl.id;
   END LOOP;


   /* Obrada "ru?nog" izlaza */
   FOR izl IN (
      SELECT id, mt_id, nac_id, sifgr_id
        FROM t_izlaz
       WHERE datum = datum_m)
   LOOP
      -- OPERA!
      opera_rc_id_l := NULL;

      IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' THEN -- vodi se Opera     
         IF izl.sifgr_id IS NULL OR SUBSTR(UPPER (pra_zmp_zaj.tekuci_cvor),1,3) =  'ALH' THEN   -- pansionski izlazi 
            opera_rc_id_l := opera_rc_m (izl.mt_id,izl.nac_id);
         ELSE -- nestandardni proizvod       
              /*
              Uzima se MIN (kase_id), jer (teoretski) nestandardni proizvod moe biti prodan na vie kasa.
              Mogue je da ne bude niti jedna kasa, jer za runi izlaz ne mora postojati izlaz sa kase
              (u prethodnom kodu se tada koliine runog izlaza jednostavno stave na nulu).
              */
              SELECT NVL (MIN (rn.kase_id), -1)
                INTO kase_id_L
                FROM t_rnkase rn,
                     t_rnkase_pro rnpro
               WHERE rn.datum       = datum_m
                 AND rn.nac_id      = izl.nac_id
                 AND rnpro.rn_id    = rn.id
                 AND rnpro.sifgr_id = izl.sifgr_id
                 AND rnpro.mt_id    = izl.mt_id;

              /*
              Ako nae izlaz sa kase, trait e RC.
              Inae nee poslije raditi nita, jer e opera_rc_id_l biti NULL.
             */
             IF kase_id_L <> -1 THEN
                opera_rc_id_l := opera_rc_k (kase_id_l, izl.nac_id);  
             END IF;           
         END IF;
      END IF;

      FOR izlart IN (
         SELECT ROWID, nam_id, pro_id, sir_id, kol_izlaz
           FROM t_izlaz_art
          WHERE izl_id = izl.id
            AND kol_izlaz <> 0)
      LOOP
         IF izl.sifgr_id IS NOT NULL THEN
            SELECT DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1034'), 'da', gknji_id, NULL)  INTO gknji_id_L
              FROM m_sif_grupa
             WHERE id = izl.sifgr_id;
         ELSE
             gknji_id_L := NULL;
         END IF;
         IF izlart.pro_id IS NOT NULL THEN
            izlaz_proizvoda (
               izl.mt_id,
               izl.nac_id,
               izlart.pro_id,
               gknji_id_L,
               izlart.kol_izlaz,
               pros_nab_cijena_l,
               opera_rc_id_l); -- OPERA!

            SELECT zad_nab_cijena
              INTO zad_nab_cijena_l
              FROM m_proizvodi
             WHERE id = izlart.pro_id;
         ELSIF izlart.sir_id IS NOT NULL THEN 
             izlaz_sirovine ( 
               izl.mt_id, 
               izl.nac_id, 
               izlart.sir_id, 
               NULL, --gknji_id, 
               izlart.kol_izlaz, 
               pros_nab_cijena_l,
               opera_rc_id_l); -- OPERA!
         ELSE
            izlaz_namirnice (
               izl.mt_id,
               izl.nac_id,
               izlart.nam_id,
               NULL, -- pro_id 
               NULL, -- sir_id
               gknji_id_L,
               izlart.kol_izlaz,
               pros_nab_cijena_l,
               opera_rc_id_l); -- OPERA!

            SELECT zad_nab_cijena
              INTO zad_nab_cijena_l
              FROM m_namirnice
             WHERE id = izlart.nam_id;
         END IF;

         /*
         Punjenje ZNC ?e ponovo raditi i BUR_T_IZLAZ_ART
         sa paketom PRA_IZLAZ_ART.NAPUNI_POLJA
         */
         UPDATE t_izlaz_art
            SET pros_nab_cijena = pros_nab_cijena_l,
                zad_nab_cijena = zad_nab_cijena_l
          WHERE ROWID = izlart.ROWID;
      END LOOP; -- stavke "ru?nog" izlaza
   END LOOP; -- zaglavlja "ru?nog" izlaza


   /*
   Obrada izlaza sa kase.
   Izlaz nestandardnih proizvoda se ne radi, jer je ve? napravljen kroz "ru?ni" izlaz.
   A?uriraju se zadnja i prosje?na NC u stavkama ra?una.
   */
   FOR rn IN (
      SELECT id, nac_id, kase_id -- OPERA!
        FROM t_rnkase
       WHERE datum = datum_m)
   LOOP
      -- OPERA!
      opera_rc_id_l := NULL;

      IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' AND SUBSTR(UPPER (pra_zmp_zaj.tekuci_cvor),1,3) <> 'ALH' THEN -- vodi se Opera
           opera_rc_id_l := opera_rc_k (rn.kase_id, rn.nac_id); 
      END IF;

      FOR rnpro IN (
         SELECT ROWID, pro_id, sifgr_id, mt_id, kolicina
           FROM t_rnkase_pro
          WHERE rn_id = rn.id)
      LOOP
         IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1'  AND SUBSTR(UPPER (pra_zmp_zaj.tekuci_cvor),1,3) = 'ALH' THEN  
            opera_rc_id_l := opera_rc_m ( rnpro.mt_id,rn.nac_id); 
         END IF;   
         
         IF rnpro.pro_id IS NOT NULL THEN -- standardni proizvod
            izlaz_proizvoda (
               rnpro.mt_id,
               rn.nac_id,
               rnpro.pro_id,
               NULL, -- gknji_id_P
               rnpro.kolicina,
               pros_nab_cijena_l,
               opera_rc_id_l); -- OPERA!

             SELECT zad_nab_cijena
               INTO zad_nab_cijena_l
               FROM m_proizvodi
              WHERE id = rnpro.pro_id;

              /*
              Ako je u stavci standardan proizvod, ostavlja se porezna grupa
              koja je iz proizvoda prepisana kod prijepisa prometa.
             */
             gpor_id_l := NULL;
          ELSIF rnpro.sifgr_id IS NOT NULL THEN -- nestandardni proizvod
              SELECT id, br_gostiju_izlaz, gpor_id
                INTO izl_id_L, br_gostiju_izlaz_l, gpor_id_l
                FROM t_izlaz
               WHERE mt_id     = rnpro.mt_id
                 AND datum     = datum_m
                 AND nac_id    = rn.nac_id
                 AND sifgr_id  = rnpro.sifgr_id;

              IF br_gostiju_izlaz_l = 0 THEN
                 zad_nab_cijena_l := 0;
                 pros_nab_cijena_l := 0;
              ELSE
                SELECT SUM (kol_izlaz * zad_nab_cijena) / br_gostiju_izlaz_l,
                       SUM (kol_izlaz * pros_nab_cijena) / br_gostiju_izlaz_l
                  INTO zad_nab_cijena_l,
                       pros_nab_cijena_l
                  FROM t_izlaz_art
                 WHERE izl_id = izl_id_l;
              END IF;  
          END IF;

         /*
         A?urira se id porezne grupe na temelju dokumenta izlaza.
         To se radi (barem za sada) jer sekvencijalna datoteka prometa
         nema poreznu grupu, pa se kod prijepisa porezna grupa
         u stavke standardnih proizvoda stavlja iz proizvoda,
         a u stavke nestandardnih proizvoda (privremeno - do obra?una)
         iz nestandardnih proizvoda.
         */
         UPDATE t_rnkase_pro
            SET pros_nab_cijena = NVL (pros_nab_cijena_l, 0),
                zad_nab_cijena  = NVL (zad_nab_cijena_l, 0),
                gpor_id         = NVL (gpor_id_l, gpor_id) -- ako je NULL, ne mijenja
          WHERE ROWID = rnpro.ROWID;
      END LOOP; -- stavke ra?una
   END LOOP; -- zaglavlja ra?una


   /* otpremnice */
   FOR izldok IN (
      SELECT id, gmpkom_id, mt_id, nac_id, ozn_vdokumenta
        FROM tgas_izlazdok
       WHERE datum = datum_m)
   LOOP
      FOR izldokart IN (
         SELECT ROWID, pro_id, kolicina, gknji_id
           FROM tgas_izlazdok_art
          WHERE gasizldok_id = izldok.id)
      LOOP
        -- ako je otpremnica mjesto troka se razduuje za namirnice iz sastava proizvoda
        IF izldok.ozn_vdokumenta =  'O' THEN
            izlaz_proizvoda (
               izldok.mt_id,
               izldok.nac_id,
               izldokart.pro_id,
               izldokart.gknji_id,
               izldokart.kolicina,
               pros_nab_cijena_l,
               NULL); -- OPERA!
        -- ako je povrat mjesto troka se zaduuje za kvazi_namirnicu ako postoji, nema  kontrole
        ELSIF izldok.ozn_vdokumenta  = 'P'  THEN
            SELECT pro_nam_id, sifra  INTO pro_nam_id_l, sifra_l
              FROM m_proizvodi
             WHERE id = izldokart.pro_id;

            IF pro_nam_id_l IS NULL THEN
               izlaz_proizvoda (
                  izldok.mt_id,
                  izldok.nac_id,
                  izldokart.pro_id,
                  izldokart.gknji_id,
                  izldokart.kolicina,
                  pros_nab_cijena_l,
                  NULL); -- OPERA!
            ELSE
               izlaz_namirnice  (
                  izldok.mt_id,
                  izldok.nac_id,
                  pro_nam_id_l,
                  NULL, -- pro_id 
                  NULL, -- sir_id
                  izldokart.gknji_id,
                  izldokart.kolicina,
                  pros_nab_cijena_l,
                  NULL); -- OPERA!
           END IF;
        END IF;

        UPDATE tgas_izlazdok_art
           SET nab_cijena = pros_nab_cijena_l
         WHERE ROWID = izldokart.ROWID;
      END LOOP;

      FOR izldokamb IN (
         -- mnoi sa -1 jer se radi o razduenju ambalae, a koristi se procedura ulaz
         SELECT amb_id, kolicina * -1  kolicina
           FROM tgas_izlazdok_amb
          WHERE gasizldok_id = izldok.id)
      LOOP
         ulaz_ambalaze (
            izldok.mt_id,
            izldok.gmpkom_id,
            izldokamb.amb_id,
            izldokamb.kolicina);
      END LOOP;
   END LOOP; 
   
   
   /* Primka kao direktni troak */
   FOR ulaz IN (
      SELECT ul.id, mt_id, dob_id
        FROM t_ulazdok ul, m_mt mt
       WHERE datum = datum_M
         AND ul.mt_id = mt.id
         AND mt.vrsta <> 'U'  -- ne moe za trgovaku robi
         AND ul.ozn_vdokumenta <> 'P'   -- ne moe za poetno stanje
       ORDER BY id)
   LOOP
      FOR ulazart IN (
         SELECT ROWID, sir_id, nam_id,
                kolicina, rabat, nab_cijena, nac_id
           FROM t_ulazdok_art
          WHERE ulaz_id = ulaz.id
            AND ozn_troska = -1
            AND nac_id IS NOT NULL)
      LOOP
         IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1'  THEN
            opera_rc_id_l := opera_rc_m ( ulaz.mt_id, ulazart.nac_id);
         END IF;         
         
         IF ulazart.sir_id IS NOT NULL THEN
              izlaz_sirovine (
               ulaz.mt_id,
               ulazart.nac_id,
               ulazart.sir_id,
               NULL, --gknji_id moe biti NULL ita se iz namirnice,
               ulazart.kolicina,
               pros_nab_cijena_l, -- nije bitno
               opera_rc_id_l); -- OPERA!
         ELSE
           izlaz_namirnice  (
                  ulaz.mt_id,
                  ulazart.nac_id,
                  ulazart.nam_id,  
                  NULL, -- pro_id
                  NULL, -- sir_id
                  NULL, -- gknji_id,
                  ulazart.kolicina,
                  pros_nab_cijena_l, -- nije bitno
                  opera_rc_id_l); -- OPERA!
         END IF;
      END LOOP;
    END LOOP;
END;
PROCEDURE IZLAZ_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OPERA_RC_ID_P NUMBER := NULL
 )
 IS

   brojac_L          NUMBER;
   pros_nab_cijena_L NUMBER;
   zad_nab_cijena_L  NUMBER;
   gknji_id_L        NUMBER;
BEGIN
   SELECT zad_nab_cijena
     INTO zad_nab_cijena_L
     FROM m_namirnice
    WHERE id = nam_id_P;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_det
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
      AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
      AND nam_id_supstitut IS NULL
      AND pro_id_supstitut IS NULL;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, sir_id_P, pro_id_P,
         NULL, NULL, 0, kolicina_P,
         0, 0, 0,
         0, 0,
         0, 0, 0, 0,
         0, 0, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_det
         SET kol_izlaz = kol_izlaz + kolicina_P,
             zad_nab_cijena = zad_nab_cijena_L
       WHERE mt_id  = mt_id_P
	     AND nam_id = nam_id_P
         AND datum  = datum_M
         AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
         AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
         AND nam_id_supstitut IS NULL
         AND pro_id_supstitut IS NULL;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M;

   IF brojac_L = 0 THEN
      /* Trai se prosjena cijena za najvei prethodni datum */
      IF UPPER (pra_zmp_zaj.tekuci_cvor) = 'HNBGASTRO' THEN -- specijalno za HNB
         pros_nab_cijena_L := pros_nc_namirnice_hnb ( nam_id_P);
      ELSE
         pros_nab_cijena_L := pros_nc_namirnice (mt_id_P, nam_id_P);
      END IF;

      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, 0, kolicina_P,
         0, 0, 0,
         0, 0,
         0, 0, 0, 0,
         0, pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui
         SET kol_izlaz = kol_izlaz + kolicina_P
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;

      /* Trai se prosjena cijena za tekui datum */
      SELECT pros_nab_cijena
        INTO pros_nab_cijena_L
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;
   END IF;

   /* Knjigovodstvena grupa se dobiva iz proizvoda ako je razduenje u namirnici onda se uzima iz namirnice */
   IF gknji_id_P IS NULL THEN
	SELECT gknji_id INTO gknji_id_L
	  FROM m_namirnice
       WHERE id = nam_id_P;
   ELSE
	gknji_id_L := gknji_id_P;
   END IF;

   /* Ovisno o parametru GAS 1009 za unutarnja mjesta troka se provjeravaju pravila knjizenja (mgas_pravila_knjizenja) */
   IF zaj_obr.vanjsko_mjesto_troska (mt_id_p) = 0 THEN
      pra_usali_knjizenja.provjeri_knjizenje (mt_id_p, nac_id_p, gknji_id_l);
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_nac
    WHERE mt_id  = mt_id_P
      AND nac_id = nac_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND gknji_id = gknji_id_L;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_nac (
         mt_id, nac_id, nam_id, datum, gknji_id,  kol_izlaz,
         kol_storno_izlaz_sup, kol_izlaz_sup,
         pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nac_id_P, nam_id_P, datum_M, gknji_id_L, kolicina_P,
         0, 0,
         pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_nac
         SET kol_izlaz = kol_izlaz + kolicina_P
       WHERE mt_id  = mt_id_P
         AND nac_id = nac_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND gknji_id = gknji_id_L;
   END IF;

   -- OPERA!
   /* Ako se vodi Opera, radi se storno razduenja izvornog MT, pa se razduuje RC */

   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' -- vodi se Opera
      AND opera_rc_id_P IS NOT NULL -- provjeravaju se oba uvjeta, iako bi bio dovoljan jedan od njih
   THEN
      SELECT COUNT (1) INTO brojac_L
        FROM i_dnev_ui_nac_opera
       WHERE mt_id = mt_id_P
         AND opera_rc_id = opera_rc_id_P
         AND nac_id = nac_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND gknji_id = gknji_id_L;

      IF brojac_L = 0 THEN
         INSERT INTO i_dnev_ui_nac_opera (
            mt_id, opera_rc_id, nac_id, nam_id, datum, gknji_id, kol_izlaz,
            kol_storno_izlaz_sup, kol_izlaz_sup,
            pros_nab_cijena, zad_nab_cijena)
            VALUES (
            mt_id_P, opera_rc_id_P, nac_id_P, nam_id_P, datum_M, gknji_id_L, kolicina_P,
            0, 0,
            pros_nab_cijena_L, zad_nab_cijena_L);
      ELSE
         UPDATE i_dnev_ui_nac_opera
            SET kol_izlaz = kol_izlaz + kolicina_P
          WHERE mt_id = mt_id_P
            AND opera_rc_id = opera_rc_id_P
            AND nac_id = nac_id_P
            AND nam_id = nam_id_P
            AND datum  = datum_M
            AND gknji_id = gknji_id_L;
      END IF;
   END IF;

   pros_nab_cijena_P := pros_nab_cijena_L;
END;
PROCEDURE IZLAZ_PROIZVODA
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 ,OPERA_RC_ID_P IN NUMBER := NULL
 )
 IS

   brojac_L            NUMBER;
   kolicina_normativ_L NUMBER;
   razina_L            NUMBER;
   kol_recepture_L     NUMBER;
   pros_nab_cijena_L   NUMBER;
   cijena_proizvoda_L  NUMBER := 0;
   gknji_id_L          NUMBER;
BEGIN
   /* Ako se radi o izlazu nestandardnog proizvoda tada se knjigovodstvena grupa uzima iz nestandardnog proizvoda, gknji_id_P  
     'GAS','1034' . Nasljeivanje knjigovodstvene grupe iz proizvoda: da ili ne */
   SELECT kol_recepture,
          DECODE(pra_zmp_zaj.zmppar_vrijednost ('GAS','1034'), 'da',DECODE (gknji_id_P, NULL, gknji_id, gknji_id_P), NULL)    
     INTO kol_recepture_L, 
          gknji_id_L 
     FROM m_proizvodi
    WHERE id = pro_id_P;

   FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_P)
   LOOP
      kolicina_normativ_L :=
         zaj_obr.kolicina_normativ (
            kolicina_P,
            sas.normativ,
            kol_recepture_L);

      IF sas.nam_id IS NOT NULL THEN
         izlaz_namirnice (
            mt_id_P,
            nac_id_P,
            sas.nam_id,
            pro_id_P, 
            NULL, --sir_id_P
            gknji_id_L,
            kolicina_normativ_L,
            pros_nab_cijena_L,
            opera_rc_id_P); -- OPERA!

         cijena_proizvoda_L := cijena_proizvoda_L + pros_nab_cijena_L * kolicina_normativ_L;
      ELSE
         SELECT COUNT (1) INTO brojac_L
           FROM p_planpot
          WHERE mt_id = mt_id_P
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_L = 0 THEN
            SELECT razina INTO razina_L
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
               mt_id, nac_id, nam_id, pro_id,
               kolicina, razina_proizvoda)
               VALUES (
               mt_id_P, NULL, NULL, sas.pro_id_poluproizvod,
               kolicina_normativ_L, razina_L);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_L
             WHERE mt_id = mt_id_P
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nam_id, pro_id,
             kolicina, razina_proizvoda
        FROM p_planpot)
   LOOP
      izlaz_namirnice (
         pom.mt_id,
         nac_id_P,
         pom.nam_id,
         pro_id_P, 
         NULL, --sir_id_p
         gknji_id_L,
         pom.kolicina,
         pros_nab_cijena_L,
         opera_rc_id_P); -- OPERA!

      cijena_proizvoda_L := cijena_proizvoda_L + pom.kolicina * pros_nab_cijena_L;
   END LOOP;

   cijena_proizvoda_P := cijena_proizvoda_L / kolicina_P;

   DELETE p_planpot;
END;
PROCEDURE IZLAZ_SIROVINE
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,OPERA_RC_ID_P IN NUMBER := NULL
 )
 IS
kalo_obrade_L              NUMBER;
kalo_odmrzavanja_L   NUMBER;
korigirana_kol_sir_L   NUMBER;
korigirana_kol_nam_L NUMBER;
korigirana_cijena_sir_L NUMBER;
ekvivalent_L                   NUMBER;
pom_br_rastava_L       NUMBER;
odnos_jm_b_l               NUMBER;
odnos_jm_n_l               NUMBER;
pros_nab_cijena_L       NUMBER;
cijena_sirovine_L         NUMBER := 0;
sir_sifra_l             m_sirovine.sifra%TYPE;
BEGIN
   SELECT kalo_obrade, kalo_odmrzavanja, sifra, odnos_jm_b, odnos_jm_n
     INTO kalo_obrade_l, kalo_odmrzavanja_l, sir_sifra_l, odnos_jm_b_l, odnos_jm_n_l
     FROM m_sirovine
    WHERE id = sir_id_p;

   IF zaj_obr.ima_sir_bez_rastava(sir_id_p) = -1 THEN
     gas_zaj.vrati_poruku    (-20219, sir_sifra_l);
   END IF;

   korigirana_kol_sir_l :=
      zaj_obr.korigirana_kol_sirovine (
         kolicina_p,
         odnos_jm_b_l,
         odnos_jm_n_l,
         kalo_odmrzavanja_l,
         kalo_obrade_l);


   pom_br_rastava_l := zaj_obr.pom_broj_rastava (sir_id_p);

   FOR ras IN (
      SELECT  nam_id, udio_namirnice
        FROM m_rastav
       WHERE sir_id = sir_id_p)
   LOOP
      SELECT ekvivalent INTO ekvivalent_l
        FROM m_namirnice
       WHERE id = ras.nam_id;

      korigirana_kol_nam_l :=
         zaj_obr.korigirana_kol_namirnice (
            korigirana_kol_sir_l,
            ras.udio_namirnice);
            
      izlaz_namirnice (
         mt_id_p,
         nac_id_p,
         ras.nam_id,
         NULL, -- pro_id
         sir_id_P, 
         NULL,   -- gknji_id_L,
         korigirana_kol_nam_l,
         pros_nab_cijena_l,
         opera_rc_id_P); -- OPERA!
   
      cijena_sirovine_l := cijena_sirovine_l + ABS (korigirana_kol_nam_l) * pros_nab_cijena_l;    
   END LOOP;

   pros_nab_cijena_p := cijena_sirovine_l / ABS (kolicina_p);
END;
PROCEDURE OBRADA_PROIZVODNJE
 IS

   pros_nab_cijena_l NUMBER;
BEGIN
   /* MT se razduuje za namirnice iz sastava proizvoda i zaduuje za kvazi-namirnicu proizvoda */
   FOR pri IN (
      SELECT id, mt_id_daje, mt_id_prima
        FROM t_prijelaz
       WHERE datum = datum_m
         AND mt_id_daje = mt_id_prima) -- MT je primatelj i davatelj
   LOOP
      FOR priart IN (
         SELECT ROWID, pro_id, nam_pro_id,
                kolicina, nab_cijena
           FROM t_prijelaz_art
          WHERE pri_id = pri.id
            AND kolicina <> 0)
      LOOP
         IF priart.pro_id IS NULL OR priart.nam_pro_id IS NULL THEN
            -- Kod obrade proizvodnje u stavkama smije biti samo proizvod koji ima kvazi-namirnicu.
            gas_zaj.vrati_poruku (-20224);
         END IF;

         prijelaz_proizvoda (
            mt_id_daje_p       => pri.mt_id_daje,
            mt_id_prima_p      => pri.mt_id_prima,
            pro_id_p           => priart.pro_id,
            nam_pro_id_p       => priart.nam_pro_id,  -- mora biti NOT NULL, zaduuje kvazi-namirnicu
            kolicina_p         => priart.kolicina,
            nab_cijena_p       => priart.nab_cijena,
            cijena_proizvoda_p => pros_nab_cijena_l,  -- procedura vraa cijenu (OUT parametar) 
            ozn_int_prihoda_p  => 'N');

         UPDATE t_prijelaz_art
            SET nab_cijena = pros_nab_cijena_l
          WHERE ROWID = priart.ROWID;
      END LOOP;
   END LOOP;
END;
PROCEDURE OBRADA_OTPISA
 IS

   pros_nab_cijena_l NUMBER;
   odnos_jm_b_l      NUMBER;
   odnos_jm_n_l      NUMBER;
   pdv_l NUMBER;
   gpor_id_l M_GPOREZ.ID%TYPE;
BEGIN
   FOR otp IN (
      SELECT id, mt_id, nac_id, ozn_otpis 
        FROM t_otpis
       WHERE datum = datum_M)
   LOOP
      FOR otpart IN (
         SELECT ROWID, sir_id, nam_id, pro_id, kolicina, gpor_id
           FROM t_otpis_art
          WHERE otp_id = otp.id)
      LOOP
         IF otpart.sir_id IS NOT NULL THEN
            SELECT odnos_jm_b, odnos_jm_n
              INTO odnos_jm_b_l, odnos_jm_n_l
              FROM m_sirovine
             WHERE id = otpart.sir_id;

            UPDATE t_otpis_art
               SET odnos_jm_b = odnos_jm_b_l,
                   odnos_jm_n = odnos_jm_n_l
             WHERE ROWID = otpart.ROWID;

            otpis_sirovine (
               otp.mt_id,
               otpart.sir_id,
               otpart.kolicina,
               odnos_jm_b_l,
               odnos_jm_n_l,
               pros_nab_cijena_l);
         ELSIF otpart.pro_id IS NOT NULL THEN
            otpis_proizvoda (
               otp.mt_id,
               otpart.pro_id,
               otpart.kolicina,
               pros_nab_cijena_l);
         ELSE
            otpis_namirnice (
               otp.mt_id,
               NULL, -- sir_id
               otpart.nam_id,
               NULL, -- pro_id
               otpart.kolicina,
               pros_nab_cijena_l);
         END IF;                                                
        
         /* Samo za porezno nepriznat otpis puni se ponovo porezna grupa i pdv iz matinih podatka 
            i rauna iznos pdv-a, a za porezno priznat otpis postavlja se na NULL 
         */
            
         IF otp.ozn_otpis = 'N' THEN          
           IF otpart.nam_id IS NOT NULL THEN
              SELECT gpor_id INTO gpor_id_l
                FROM m_namirnice 
               WHERE id = otpart.nam_id;          
           ELSIF otpart.pro_id IS NOT NULL THEN    
              SELECT gpor_id INTO gpor_id_l
                FROM m_proizvodi 
               WHERE id = otpart.pro_id;
           ELSE 
              SELECT MIN(gpor_id) INTO gpor_id_l
                FROM m_rastav ras,
                     m_namirnice nam 
               WHERE ras.sir_id = otpart.sir_id
                 AND ras.nam_id = nam.id;            
            END IF;       
        
           SELECT vpispp.stopa INTO pdv_l
             FROM mgas_gpor_raz gporraz,
                  s_vpisporukap vpispp
            WHERE gporraz.gpor_id = gpor_id_l
              AND datum_M BETWEEN gporraz.dat_valjan AND NVL (gporraz.dat_ponisten, datum_M)
              AND gporraz.vpispp_id = vpispp.id;         
         ELSE   
            gpor_id_l := NULL;
            pdv_l := 0;          
         END IF;        
         
        UPDATE t_otpis_art
           SET pros_nab_cijena = pros_nab_cijena_l,
               iznos_poreza = DECODE(pdv_l, 0, 0, (kolicina * pros_nab_cijena_l) * pdv_l/100.00),
               gpor_id = gpor_id_l,
               pdv = pdv_l
         WHERE otp_id = otp.id
           AND NVL (nam_id, 0) = NVL (otpart.nam_id, 0)
           AND NVL (sir_id, 0) = NVL (otpart.sir_id, 0)
           AND NVL (pro_id, 0) = NVL (otpart.pro_id, 0);
      END LOOP;
   END LOOP;  
   
   FOR otpamb IN (
      SELECT id, mt_id
        FROM t_otpisamb
       WHERE datum  = datum_M)
   LOOP
      FOR otpambamb IN (
         SELECT amb_id, kolicina
           FROM t_otpisamb_amb
          WHERE otpamb_id = otpamb.id)
      LOOP
         otpis_ambalaze (
            otpamb.mt_id,
            otpambamb.amb_id,
            otpambamb.kolicina);
      END LOOP;
   END LOOP;
END;
PROCEDURE OTPIS_SIROVINE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,ODNOS_JM_B_P NUMBER
 ,ODNOS_JM_N_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 )
 IS

   korigirana_kol_sir_L NUMBER;
   korigirana_kol_nam_L NUMBER;
   kalo_obrade_L        NUMBER;
   kalo_odmrzavanja_L   NUMBER;
   pros_nab_cijena_L    NUMBER;
   cijena_sirovine_L    NUMBER := 0;
   sir_sifra_l          m_sirovine.sifra%TYPE;
BEGIN
   SELECT kalo_obrade, kalo_odmrzavanja, sifra
     INTO kalo_obrade_L, kalo_odmrzavanja_L, sir_sifra_l
     FROM m_sirovine
    WHERE id = sir_id_P;

   IF zaj_obr.ima_sir_bez_rastava(sir_id_p) = -1 THEN
	 gas_zaj.vrati_poruku	(-20219, sir_sifra_l);
   END IF;

   korigirana_kol_sir_L :=
      zaj_obr.korigirana_kol_sirovine (
         kolicina_P,
         odnos_jm_b_P,
         odnos_jm_n_P,
         kalo_odmrzavanja_L,
         kalo_obrade_L);
   FOR ras IN (
      SELECT nam_id, udio_namirnice
        FROM m_rastav
       WHERE sir_id = sir_id_P)
   LOOP
      korigirana_kol_nam_L :=
         zaj_obr.korigirana_kol_namirnice (
            korigirana_kol_sir_L,
            ras.udio_namirnice);
      otpis_namirnice (
         mt_id_P,
         sir_id_P,
         ras.nam_id,
         NULL, -- pro_id
         korigirana_kol_nam_L,
         pros_nab_cijena_l);

      cijena_sirovine_L :=
         cijena_sirovine_L
       + korigirana_kol_nam_L
       * pros_nab_cijena_L;
   END LOOP;
   pros_nab_cijena_P := cijena_sirovine_L / kolicina_P;
END;
PROCEDURE OTPIS_PROIZVODA
 (MT_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,CIJENA_PROIZVODA_P OUT NUMBER
 )
 IS

   brojac_L            NUMBER;
   kolicina_normativ_L NUMBER;
   razina_L            NUMBER;
   kol_recepture_L     NUMBER;
   pros_nab_cijena_L   NUMBER;
   cijena_proizvoda_L  NUMBER := 0;
BEGIN
   SELECT kol_recepture INTO kol_recepture_L
     FROM m_proizvodi
    WHERE id = pro_id_P;

   FOR sas IN (
      SELECT pro_id, nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_P)
   LOOP
      kolicina_normativ_L :=
         zaj_obr.kolicina_normativ (
            kolicina_P,
            sas.normativ,
            kol_recepture_L);

      IF sas.nam_id IS NOT NULL THEN
         otpis_namirnice (
            mt_id_P,
            NULL, -- sir_id
            sas.nam_id,
            pro_id_P,
            kolicina_normativ_L,
            pros_nab_cijena_L);

         cijena_proizvoda_L :=
             cijena_proizvoda_L
           + pros_nab_cijena_L
           * kolicina_normativ_L;
      ELSE
         SELECT COUNT (1) INTO brojac_L
           FROM p_planpot
          WHERE mt_id = mt_id_P
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_L = 0 THEN
            SELECT razina INTO razina_L
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
                mt_id, nac_id, nam_id, pro_id,
                kolicina, razina_proizvoda)
                VALUES (
                mt_id_p, NULL, NULL, sas.pro_id_poluproizvod,
                kolicina_normativ_L, razina_L);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_L
             WHERE mt_id = mt_id_P
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nam_id, pro_id,
             kolicina, razina_proizvoda
        FROM p_planpot)
   LOOP
      otpis_namirnice (
         pom.mt_id,
         NULL, -- sir_id
         pom.nam_id,
         pom.pro_id,
         pom.kolicina,
         pros_nab_cijena_L);

         cijena_proizvoda_L :=
             cijena_proizvoda_L
           + pom.kolicina
           * pros_nab_cijena_L;
   END LOOP;

   cijena_proizvoda_P := cijena_proizvoda_L / kolicina_P;
   DELETE p_planpot;
END;
PROCEDURE OTPIS_AMBALAZE
 (MT_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 )
 IS

   rowid_l ROWID;
BEGIN
   rowid_l := NULL;
   BEGIN
      SELECT ROWID INTO rowid_l -- koristimo ROWID da u UPDATE ne moramo ponoviti uvjet
        FROM i_dnev_ui_amb
       WHERE mt_id  = mt_id_p
         AND amb_id = amb_id_p
         AND datum  = datum_m
         AND dob_id IS NULL;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         NULL;
   END;

   IF rowid_l IS NULL THEN
      INSERT INTO i_dnev_ui_amb (
         mt_id, amb_id, datum, dob_id,
         kol_ulaz, kol_int_ulaz, kol_int_izlaz, kol_izlaz,
         kol_dnev_otpis, kol_inv_razlika, zaliha)
         VALUES (
         mt_id_p, amb_id_p, datum_m, NULL,
         0, 0, 0, 0,
         kolicina_p, 0, 0);
   ELSE
      UPDATE i_dnev_ui_amb
         SET kol_dnev_otpis = kol_dnev_otpis + kolicina_p
       WHERE ROWID = rowid_l;
   END IF;
END;
PROCEDURE OBRADA_ZAMJENA
 IS

   pros_nab_cijena_l     NUMBER;
   pros_nab_cijena_sup_l NUMBER;
BEGIN
   FOR zam IN (
      SELECT id, mt_id, nac_id
        FROM t_zamjena
       WHERE datum = datum_M)
   LOOP
      FOR zamart IN (
         SELECT ROWID, nam_id, pro_id, nam_id_supstitut, pro_id_supstitut,
                kolicina, kol_supstituta
           FROM t_zamjena_art
          WHERE zam_id = zam.id)
      LOOP
         IF zamart.nam_id IS NOT NULL THEN
            IF zamart.nam_id_supstitut IS NOT NULL THEN
               zamjena_nam_sa_nam (
                  zam.mt_id,
                  zam.nac_id,
                  zamart.nam_id,
                  zamart.nam_id_supstitut,
                  NULL, -- gknji_id
                  zamart.kolicina,
                  zamart.kol_supstituta,
                  pros_nab_cijena_l,
                  pros_nab_cijena_sup_l);
            ELSE
               zamjena_nam_sa_pro (
                  zam.mt_id,
                  zam.nac_id,
                  zamart.nam_id,
                  zamart.pro_id_supstitut,
                  zamart.kolicina,
                  zamart.kol_supstituta,
                  pros_nab_cijena_l,
                  pros_nab_cijena_sup_l);
            END IF;
         ELSE
            zamjena_pro_sa_nam (
               zam.mt_id,
               zam.nac_id,
               zamart.pro_id,
               zamart.nam_id_supstitut,
               zamart.kolicina,
               zamart.kol_supstituta,
               pros_nab_cijena_l,
               pros_nab_cijena_sup_l);
         END IF;

         UPDATE t_zamjena_art
            SET pros_nab_cijena           = pros_nab_cijena_l,
                pros_nab_cijena_supstitut = pros_nab_cijena_sup_l
          WHERE ROWID = zamart.ROWID;
      END LOOP;
   END LOOP;
END;
PROCEDURE OTPIS_NAMIRNICE
 (MT_ID_P NUMBER
 ,SIR_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,KOLICINA_NAM_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 )
 IS

   brojac_L          NUMBER;
   pros_nab_cijena_L NUMBER;
   zad_nab_cijena_L  NUMBER;
BEGIN
   SELECT zad_nab_cijena
     INTO zad_nab_cijena_L
     FROM m_namirnice
    WHERE id = nam_id_P;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_det
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
      AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
      AND nam_id_supstitut IS NULL
      AND pro_id_supstitut IS NULL;

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, sir_id_P, pro_id_P,
         NULL, NULL, 0, 0,
         0, 0, 0,
         0, kolicina_nam_P,
         0, 0, 0, 0,
         0, 0, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_det
         SET kol_dnev_otpis = kol_dnev_otpis + kolicina_nam_P
       WHERE mt_id  = mt_id_P
 	   AND nam_id = nam_id_P
         AND datum  = datum_M
         AND NVL (sir_id, 0) = NVL (sir_id_P, 0)
         AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
         AND nam_id_supstitut IS NULL
         AND pro_id_supstitut IS NULL;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M;

   IF brojac_L = 0 THEN
      /* Trai se prosjena cijena za najvei prethodni datum */
      IF UPPER (pra_zmp_zaj.tekuci_cvor) = 'HNBGASTRO' THEN -- specijalno za HNB
         pros_nab_cijena_L := pros_nc_namirnice_hnb (nam_id_P);
      ELSE
         pros_nab_cijena_L := pros_nc_namirnice (mt_id_P, nam_id_P);
      END IF;

      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
         kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
         kol_izlaz_sup, kol_dnev_otpis,
         kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
         izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nam_id_P, datum_M, 0, 0,
         0, 0, 0,
         0, kolicina_nam_P,
         0, 0, 0, 0,
         0, pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui
         SET kol_dnev_otpis = kol_dnev_otpis + kolicina_nam_P
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;

      /* Trai se prosjena cijena za tekui datum */
      SELECT pros_nab_cijena
        INTO pros_nab_cijena_L
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;
   END IF;

   pros_nab_cijena_P := pros_nab_cijena_L;
END;
PROCEDURE ZAMJENA_NAM_SA_PRO
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_SUPSTITUT_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 )
 IS

   brojac_L            NUMBER;
   kolicina_normativ_L NUMBER;
   razina_L            NUMBER;
   kol_recepture_L     NUMBER;
   pros_nab_cijena_L   NUMBER;
   cijena_proizvoda_L  NUMBER := 0;
   gknji_id_L          NUMBER;
BEGIN
   /* Auriranje izlaza supstituirane namirnice */
   azur_supstitut (
      mt_id_P,
      nac_id_P,
      nam_id_P,
      NULL, -- pro_id
      NULL, -- nam_id_supstitut
      pro_id_supstitut_P,
      NULL, -- gknji_id
      kolicina_P,
      0, -- koliina namirnice supstituta
      pros_nab_cijena_L);

   /* vraa cijenu supstituirane namirnice */
   pros_nab_cijena_P := pros_nab_cijena_L;

   SELECT kol_recepture, gknji_id
     INTO kol_recepture_L, gknji_id_L
     FROM m_proizvodi
    WHERE id = pro_id_supstitut_P;

   FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_supstitut_P)
   LOOP
      kolicina_normativ_L :=
         zaj_obr.kolicina_normativ (
            kol_supstituta_P,
            sas.normativ,
            kol_recepture_L);

      IF sas.nam_id IS NOT NULL THEN
         /* Auriranje izlaza namirnice supstituta */
         azur_supstitut (
            mt_id_P,
            nac_id_P,
            sas.nam_id,
            NULL, -- pro_id
            nam_id_P,
            pro_id_supstitut_P,
            gknji_id_L,
            0, -- koliina supstituirane namirnice
            kolicina_normativ_L,
            pros_nab_cijena_L);

         cijena_proizvoda_L := cijena_proizvoda_L + kolicina_normativ_L * pros_nab_cijena_L;
      ELSE
         SELECT COUNT (1) INTO brojac_L
           FROM p_planpot
          WHERE mt_id = mt_id_P
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_L = 0 THEN
            SELECT razina INTO razina_L
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
               mt_id, nac_id, nam_id, pro_id,
               kolicina, razina_proizvoda)
               VALUES (
               mt_id_p, NULL, NULL, sas.pro_id_poluproizvod,
               kolicina_normativ_L, razina_L);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_L
             WHERE mt_id = mt_id_P
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nac_id, nam_id, pro_id,
             kolicina, razina_proizvoda
        FROM p_planpot)
   LOOP
      /* Auriranje izlaza namirnice supstituta */
      azur_supstitut (
         pom.mt_id,
         nac_id_P,
         pom.nam_id,
         NULL, -- pro_id
         nam_id_P,
         pro_id_supstitut_P,
         gknji_id_L,
         0, -- koliina supstituirane namirnice
         pom.kolicina,
         pros_nab_cijena_L);

      cijena_proizvoda_L := cijena_proizvoda_L + pom.kolicina * pros_nab_cijena_L;
   END LOOP;

   /* vraa cijenu proizvoda supstituta */
   pros_nab_cijena_sup_P := cijena_proizvoda_L / kol_supstituta_P;

   DELETE p_planpot;
END;
PROCEDURE ZAMJENA_PRO_SA_NAM
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 )
 IS

   brojac_L            NUMBER;
   kolicina_normativ_L NUMBER;
   razina_L            NUMBER;
   kol_recepture_L     NUMBER;
   pros_nab_cijena_L   NUMBER;
   cijena_proizvoda_L  NUMBER := 0;
   gknji_id_L          NUMBER;
BEGIN
   SELECT kol_recepture, gknji_id
     INTO kol_recepture_L, gknji_id_L
     FROM m_proizvodi
    WHERE id = pro_id_P;

   FOR sas IN (
      SELECT nam_id, pro_id_poluproizvod, normativ
        FROM m_sastav
       WHERE pro_id = pro_id_P)
   LOOP
      kolicina_normativ_L :=
         zaj_obr.kolicina_normativ (
            kolicina_P,
            sas.normativ,
            kol_recepture_L);

      IF sas.nam_id IS NOT NULL THEN
         /* Auriranje izlaza supstituirane namirnice */
         azur_supstitut (
            mt_id_P,
            nac_id_P,
            sas.nam_id,
            pro_id_P,
            nam_id_supstitut_P,
            NULL, -- pro_id_supstitut
            gknji_id_L,
            kolicina_normativ_L,
            0, -- koliina namirnice supstituta
            pros_nab_cijena_L);

         cijena_proizvoda_L := cijena_proizvoda_L + kolicina_normativ_L * pros_nab_cijena_L;
      ELSE
         SELECT COUNT (1) INTO brojac_L
           FROM p_planpot
          WHERE mt_id = mt_id_P
            AND nac_id IS NULL
            AND nam_id IS NULL
            AND pro_id = sas.pro_id_poluproizvod;

         IF brojac_L = 0 THEN
            SELECT razina INTO razina_L
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;

            INSERT INTO p_planpot (
               mt_id, nac_id, nam_id, pro_id,
               kolicina, razina_proizvoda)
               VALUES (
               mt_id_p, NULL, NULL, sas.pro_id_poluproizvod,
               kolicina_normativ_L, razina_L);
         ELSE
            UPDATE p_planpot
               SET kolicina = kolicina + kolicina_normativ_L
             WHERE mt_id = mt_id_P
               AND nac_id IS NULL
               AND nam_id IS NULL
               AND pro_id = sas.pro_id_poluproizvod;
         END IF;
      END IF;
   END LOOP;

   zaj_obr.rastavljanje_proizvoda;

   FOR pom IN (
      SELECT mt_id, nac_id, nam_id, pro_id,
             kolicina, razina_proizvoda
        FROM p_planpot)
   LOOP
      /* Auriranje izlaza supstituirane namirnice */
      azur_supstitut (
         pom.mt_id,
         nac_id_P,
         pom.nam_id,
         pro_id_P,
         nam_id_supstitut_P,
         NULL, -- pro_id_supstitut
         gknji_id_L,
         pom.kolicina,
         0, -- koliina namirnice supstituta
         pros_nab_cijena_L);

      cijena_proizvoda_L := cijena_proizvoda_L + pom.kolicina * pros_nab_cijena_L;
   END LOOP;

   /* vraa cijenu supstituiranog proizvoda */
   pros_nab_cijena_P := cijena_proizvoda_L / kolicina_P;

   DELETE p_planpot;

   /* Auriranje izlaza namirnice supstituta */
   azur_supstitut (
      mt_id_P,
      nac_id_P,
      nam_id_supstitut_P,
      pro_id_P,
      nam_id_supstitut_P,
      NULL, -- pro_id_supstitut
      NULL, -- gknji_id
      0, -- koliina supstituirane namirnice
      kol_supstituta_p,
      pros_nab_cijena_L);

   /* vraa cijenu namirnice supstituta */
   pros_nab_cijena_sup_P := pros_nab_cijena_L;
END;
PROCEDURE ZAMJENA_NAM_SA_NAM
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOLICINA_P NUMBER
 ,KOL_SUPSTITUTA_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 ,PROS_NAB_CIJENA_SUP_P OUT NUMBER
 )
 IS

    pros_nab_cijena_l NUMBER;
BEGIN
   /* Auriranje izlaza supstituirane namirnice */
   azur_supstitut (
      mt_id_P,
      nac_id_P,
      nam_id_P,
      NULL, -- pro_id
      nam_id_supstitut_P,
      NULL, -- pro_id_supstitut
      NULL, -- gknji_id
      kolicina_P,
      0, -- koliina namirnice supstituta
      pros_nab_cijena_L);

   pros_nab_cijena_P := pros_nab_cijena_L;


   /* Auriranje izlaza namirnice supstituta */
   azur_supstitut (
      mt_id_P,
      nac_id_P,
      nam_id_supstitut_P,
      NULL, -- pro_id
      nam_id_P,
      NULL, -- pro_id_supstitut
      NULL, -- gknji_id
      0, -- koliina supstituirane namirnice
      kol_supstituta_P,
      pros_nab_cijena_L);

   pros_nab_cijena_sup_P := pros_nab_cijena_L;
END;
PROCEDURE AZUR_SUPSTITUT
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 ,NAM_ID_P NUMBER
 ,PRO_ID_P NUMBER
 ,NAM_ID_SUPSTITUT_P NUMBER
 ,PRO_ID_SUPSTITUT_P NUMBER
 ,GKNJI_ID_P NUMBER
 ,KOL_STORNO_IZLAZ_SUP_P NUMBER
 ,KOL_IZLAZ_SUP_P NUMBER
 ,PROS_NAB_CIJENA_P OUT NUMBER
 )
 IS
   brojac_L          NUMBER;
   pros_nab_cijena_L NUMBER;
   zad_nab_cijena_L  NUMBER;
   gknji_id_L        NUMBER;
   opera_rc_id_l     NUMBER; -- OPERA!
BEGIN
   SELECT zad_nab_cijena
     INTO zad_nab_cijena_L
     FROM m_namirnice
    WHERE id = nam_id_P;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_det
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND sir_id IS NULL
      AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
      AND NVL (nam_id_supstitut, 0) = NVL(nam_id_supstitut_P, 0)
      AND NVL (pro_id_supstitut, 0) = NVL(pro_id_supstitut_P, 0);

   IF brojac_L = 0 THEN
      INSERT INTO i_dnev_ui_det (
         mt_id, nam_id, datum, sir_id, pro_id,
         nam_id_supstitut, pro_id_supstitut,
         kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz,
         kol_storno_izlaz_sup, kol_izlaz_sup,
         kol_dnev_otpis, kol_inv_razlika, zaliha,
         izn_ulaz, izn_int_ulaz, izn_int_izlaz,
         pros_nab_cijena, zad_nab_cijena)
        VALUES (
         mt_id_P, nam_id_P, datum_M, NULL, pro_id_P,
         nam_id_supstitut_P, pro_id_supstitut_P,
         0, 0, 0, 0,
         kol_storno_izlaz_sup_P, kol_izlaz_sup_P,
         0, 0, 0,
         0, 0, 0,
         0, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_det
         SET kol_storno_izlaz_sup = kol_storno_izlaz_sup + kol_storno_izlaz_sup_P,
             kol_izlaz_sup = kol_izlaz_sup + kol_izlaz_sup_P,
             zad_nab_cijena = zad_nab_cijena_L
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND sir_id IS NULL
         AND NVL (pro_id, 0) = NVL (pro_id_P, 0)
         AND NVL (nam_id_supstitut, 0) = NVL (nam_id_supstitut_P, 0)
         AND NVL (pro_id_supstitut, 0) = NVL (pro_id_supstitut_P, 0);
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui
    WHERE mt_id  = mt_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M;

   IF brojac_L = 0 THEN
      /* Trai se prosjena cijena za najvei prethodni datum */
      IF UPPER (pra_zmp_zaj.tekuci_cvor) = 'HNBGASTRO' THEN -- specijalno za HNB
         pros_nab_cijena_L := pros_nc_namirnice_hnb (nam_id_P);
      ELSE
         pros_nab_cijena_L := pros_nc_namirnice (mt_id_P, nam_id_P);
      END IF;

      INSERT INTO i_dnev_ui (
         mt_id, nam_id, datum,
         kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz,
         kol_storno_izlaz_sup, kol_izlaz_sup,
         kol_dnev_otpis, kol_inv_razlika, zaliha,
         izn_ulaz, izn_int_ulaz, izn_int_izlaz,
         pros_nab_cijena, zad_nab_cijena)
        VALUES (
         mt_id_P, nam_id_P, datum_M,
         0, 0, 0, 0,
         kol_storno_izlaz_sup_P, kol_izlaz_sup_P,
         0, 0, 0,
         0, 0, 0,
         pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui
         SET kol_storno_izlaz_sup = kol_storno_izlaz_sup + kol_storno_izlaz_sup_P,
             kol_izlaz_sup = kol_izlaz_sup + kol_izlaz_sup_P
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;

      /* Trai se prosjena cijena za tekui datum */
      SELECT pros_nab_cijena
        INTO pros_nab_cijena_L
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M;
   END IF;

   /* Knjigovodstvena grupa se dobiva iz proizvoda ako je razduenje u namirnici onda se uzima iz namirnice */
   IF gknji_id_P IS NULL THEN
	SELECT gknji_id INTO gknji_id_L
	  FROM m_namirnice
       WHERE id = nam_id_P;
   ELSE
	gknji_id_L := gknji_id_P;
   END IF;

   SELECT COUNT (1) INTO brojac_L
     FROM i_dnev_ui_nac
    WHERE mt_id  = mt_id_P
      AND nac_id = nac_id_P
      AND nam_id = nam_id_P
      AND datum  = datum_M
      AND gknji_id = gknji_id_L;

   IF brojac_L = 0 THEN
         INSERT INTO i_dnev_ui_nac (
         mt_id, nac_id, nam_id, datum, gknji_id,  kol_izlaz,
         kol_storno_izlaz_sup, kol_izlaz_sup,
         pros_nab_cijena, zad_nab_cijena)
         VALUES (
         mt_id_P, nac_id_P, nam_id_P, datum_M, gknji_id_L, 0,
         kol_storno_izlaz_sup_P, kol_izlaz_sup_P,
         pros_nab_cijena_L, zad_nab_cijena_L);
   ELSE
      UPDATE i_dnev_ui_nac
         SET kol_storno_izlaz_sup = kol_storno_izlaz_sup + kol_storno_izlaz_sup_P,
             kol_izlaz_sup = kol_izlaz_sup + kol_izlaz_sup_P
       WHERE mt_id  = mt_id_P
         AND nac_id = nac_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND gknji_id = gknji_id_L;
   END IF;

   -- OPERA!
   /* Ako se vodi Opera, radi se storno razduenja izvornog MT, pa se razduuje RC */

   opera_rc_id_l := NULL;

   IF pra_zmp_zaj.zmppar_vrijednost ('GAS', '1004') = '1' THEN -- vodi se Opera
      DECLARE
         sifra_mt_l  m_mt.sifra%TYPE;
         sifra_np_l  m_nacpot.sifra%TYPE;
      BEGIN
         SELECT sifra INTO sifra_mt_l
           FROM m_mt
          WHERE id = mt_id_P;

         SELECT sifra INTO sifra_np_l
           FROM m_nacpot
          WHERE id = nac_id_P;

         SELECT oj_id INTO opera_rc_id_l
           FROM m_mt_np
          WHERE mt_id  = mt_id_P
            AND nac_id = nac_id_P;

         IF opera_rc_id_l IS NULL THEN
            RAISE_APPLICATION_ERROR (-20001,
               'Nije unesen RC za kombinaciju MT: ' || sifra_mt_l || ' i naina potronje: ' || sifra_np_l);
         END IF;
      EXCEPTION
         WHEN NO_DATA_FOUND THEN
            RAISE_APPLICATION_ERROR (-20001,
               'Nije unesena veza MT: ' || sifra_mt_l || ' i naina potronje: ' || sifra_np_l);
      END;

      SELECT COUNT (1) INTO brojac_L
        FROM i_dnev_ui_nac_opera
       WHERE mt_id = mt_id_P
         AND opera_rc_id = opera_rc_id_l
         AND nac_id = nac_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_M
         AND gknji_id = gknji_id_L;

      IF brojac_L = 0 THEN
         INSERT INTO i_dnev_ui_nac_opera (
            mt_id, opera_rc_id, nac_id, nam_id, datum, gknji_id, kol_izlaz,
            kol_storno_izlaz_sup, kol_izlaz_sup,
            pros_nab_cijena, zad_nab_cijena)
            VALUES (
            mt_id_P, opera_rc_id_l, nac_id_P, nam_id_P, datum_M, gknji_id_L, 0,
            kol_storno_izlaz_sup_P, kol_izlaz_sup_P,
            pros_nab_cijena_L, zad_nab_cijena_L);
      ELSE
         UPDATE i_dnev_ui_nac_opera
            SET kol_storno_izlaz_sup = kol_storno_izlaz_sup + kol_storno_izlaz_sup_P,
                kol_izlaz_sup = kol_izlaz_sup + kol_izlaz_sup_P
          WHERE mt_id = mt_id_P
            AND opera_rc_id = opera_rc_id_l
            AND nac_id = nac_id_P
            AND nam_id = nam_id_P
            AND datum  = datum_M
            AND gknji_id = gknji_id_L;
      END IF;
   END IF;

   pros_nab_cijena_P := pros_nab_cijena_L;
END;
PROCEDURE IZRACUN_ZALIHA_NAMIRNICA
 IS

   kolicina_L NUMBER;
   zaliha_L   NUMBER;
   brojac_L   NUMBER;
BEGIN
   FOR dui IN (
      SELECT ROWID, mt_id, nam_id, kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz,
             kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis,
             pros_nab_cijena, zad_nab_cijena
        FROM i_dnev_ui
       WHERE datum  = datum_M)
   LOOP
      /*
      0 kao konstanta u parametru koristi se da ne bismo imali
      dvije procedure - jedna sa poetnim stanjem (obraun inventure),
      a druga bez poetnog stanja (dnevni_obraun)
      */
      kolicina_L :=
         zaj_obr.zaliha_namirnica (
            0,
            dui.kol_ulaz,
            dui.kol_izlaz,
            dui.kol_int_ulaz,
            dui.kol_int_izlaz,
            dui.kol_storno_izlaz_sup,
            dui.kol_izlaz_sup,
            dui.kol_dnev_otpis);

      SELECT COUNT (1) INTO brojac_L
        FROM i_zaliha
       WHERE mt_id  = dui.mt_id
         AND nam_id = dui.nam_id;

      IF brojac_L = 0 THEN
         INSERT INTO i_zaliha (
            mt_id, nam_id, zaliha,
            zad_nab_cijena, pros_nab_cijena)
            VALUES (
            dui.mt_id, dui.nam_id, kolicina_L,
            dui.zad_nab_cijena, dui.pros_nab_cijena);
      ELSE
         UPDATE i_zaliha
            SET zaliha = zaliha + kolicina_L,
                zad_nab_cijena  = dui.zad_nab_cijena,
                pros_nab_cijena = dui.pros_nab_cijena
          WHERE mt_id  = dui.mt_id
            AND nam_id = dui.nam_id;
      END IF;

      SELECT zaliha
        INTO zaliha_L
        FROM i_zaliha
       WHERE mt_id  = dui.mt_id
         AND nam_id = dui.nam_id;
      /* auriranje zaliha u dnevnom ulazu/izlazu namirnica */
      UPDATE i_dnev_ui
         SET zaliha = zaliha_L
       WHERE ROWID = dui.ROWID;
   END LOOP;

   /* auriranje zaliha u dnevnom ulazu/izlazu namirnica */
   /* ovo je druga varijanta - prethodna je uglavnom bra */
   /*
   UPDATE i_dnev_ui dui
      SET zaliha = (SELECT zaliha
                      FROM i_zaliha
                     WHERE mt_id  = dui.mt_id
                       AND nam_id = dui.nam_id)
    WHERE datum = datum_M;
   */

   /* auriranje zaliha na razini instalacije u namirnicama */
   zaj_obr.izracun_zaliha_instalacije;
END;
PROCEDURE IZRACUN_ZALIHA_AMBALAZE
 IS

   kolicina_L NUMBER;
BEGIN
   FOR duiamb IN (
      SELECT ROWID, dob_id, mt_id, amb_id, kol_ulaz, kol_izlaz,
             kol_int_ulaz, kol_int_izlaz, kol_dnev_otpis
        FROM i_dnev_ui_amb
       WHERE datum = datum_m)
   LOOP
      IF duiamb.dob_id IS NULL THEN -- obrada redaka za MT
         /*
         0 kao konstanta u parametru koristi se da ne bismo imali dvije procedure,
         tj.jednu sa poetnim stanjem (obraun inventure),
         a drugu bez poetnog stanja (dnevni_obraun)
         */
         kolicina_L :=
            zaj_obr.zaliha_ambalaze_mt (
               0,
               duiamb.kol_ulaz,
               duiamb.kol_int_ulaz,
               duiamb.kol_int_izlaz,
               duiamb.kol_izlaz,
               duiamb.kol_dnev_otpis);

         zaliha_ambalaze_mt (
            duiamb.mt_id,
            duiamb.amb_id,
            kolicina_l);

         /* Auriranje zaliha po MT u i_dnev_ui_amb */
         SELECT zaliha
           INTO kolicina_l
           FROM i_zaliha_mt
          WHERE mt_id  = duiamb.mt_id
            AND amb_id = duiamb.amb_id;

         UPDATE i_dnev_ui_amb
            SET zaliha = kolicina_l
          WHERE ROWID = duiamb.ROWID;
      ELSE -- obrada redaka za dobavljaa
         kolicina_l :=
            zaj_obr.zaliha_ambalaze_dob (
               duiamb.kol_ulaz,
               duiamb.kol_izlaz);

         zaliha_ambalaze_dob (
            duiamb.dob_id,
            duiamb.amb_id,
            kolicina_l);

         /* Aur.zaliha po dobavljau u i_dnev_ui_amb napravljeno je u obrada_ulaza */
      END IF;
   END LOOP;
END;
PROCEDURE ZALIHA_AMBALAZE_DOB
 (DOB_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 )
 IS

   brojac_L NUMBER;
BEGIN
   SELECT COUNT (1) INTO brojac_l
     FROM i_zaliha_dob
    WHERE dob_id = dob_id_p
      AND amb_id = amb_id_p;

   IF brojac_L = 0 THEN
      INSERT INTO i_zaliha_dob (
         dob_id, amb_id, zaliha)
         VALUES (
         dob_id_p, amb_id_p, kolicina_p);
   ELSE
      UPDATE i_zaliha_dob
         SET zaliha =  zaliha + kolicina_p
       WHERE dob_id = dob_id_p
         AND amb_id = amb_id_p;
   END IF;
END;
PROCEDURE ZALIHA_AMBALAZE_MT
 (MT_ID_P NUMBER
 ,AMB_ID_P NUMBER
 ,KOLICINA_P NUMBER
 )
 IS

   brojac_L NUMBER;
BEGIN
   SELECT COUNT (1) INTO brojac_l
     FROM i_zaliha_mt
    WHERE mt_id  = mt_id_p
      AND amb_id = amb_id_p;

   IF brojac_L = 0 THEN
      INSERT INTO i_zaliha_mt (
         mt_id, amb_id, zaliha)
         VALUES (
         mt_id_p, amb_id_p, kolicina_p);
   ELSE
      UPDATE i_zaliha_mt
         SET zaliha =  zaliha + kolicina_p
       WHERE mt_id  = mt_id_p
         AND amb_id = amb_id_p;
   END IF;
END;
FUNCTION PROS_NC_NAMIRNICE
 (MT_ID_P NUMBER
 ,NAM_ID_P NUMBER
 )
 RETURN NUMBER
 IS

   datum_L           DATE;
   pros_nab_cijena_L NUMBER;
BEGIN
  SELECT MAX (datum) INTO datum_L
    FROM i_dnev_ui
   WHERE mt_id  = mt_id_P
     AND nam_id = nam_id_P
     AND datum  < datum_M;
   IF datum_L IS NOT NULL THEN
      SELECT pros_nab_cijena
        INTO pros_nab_cijena_L
        FROM i_dnev_ui
       WHERE mt_id  = mt_id_P
         AND nam_id = nam_id_P
         AND datum  = datum_L;
   ELSE
      pros_nab_cijena_L := 0;
   END IF;
   RETURN pros_nab_cijena_L;
END;
PROCEDURE PROVJERI_PRESKOK_DOK
 (DAT_ZADNJEG_DO_P DATE
 ,POCETNI_DAT_DO_P DATE
 )
 IS

   brojac_l         NUMBER;
   dat_zadnjeg_do_l DATE;
BEGIN
   IF dat_zadnjeg_do_p IS NOT NULL THEN
      dat_zadnjeg_do_l := dat_zadnjeg_do_p;
   ELSE
      dat_zadnjeg_do_l := TO_DATE ('01.01.1900', 'DD.MM.RRRR');
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_ulazdok
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0222')); -- Ulaz artikala i ambalae
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_prijelaz
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0224')); -- Prijelaz artikala i ambalae
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_izlaz
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0242')); -- Izlaz artikala
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_rnkase
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0235')); -- Rauni sa kasa
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_otpis
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0225')); -- Otpis artikala
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_otpisamb
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0228')); -- Otpis ambalae
   END IF;

   SELECT COUNT (*) INTO brojac_l
     FROM t_zamjena
    WHERE datum > dat_zadnjeg_do_l
      AND datum < pocetni_dat_do_p;

   IF brojac_l <> 0 THEN
      gas_zaj.vrati_poruku (-20083, pra_zmp_zaj.poruka ('GAS', 'GAS0233')); -- Zamjena artikala
   END IF;
END;
PROCEDURE INSERT_ZALIHA
 IS

   vrijednost_l szmp_parametri.vrijednost%TYPE;
/*
Ako je parametrom GAS '1001' zabranjena negativna zaliha,
u tablicu p_zaliha se pamti nekomitirana negativana zaliha.
*/
BEGIN
   vrijednost_l := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1001');

   SELECT CAST (MULTISET (SELECT mt_id, nam_id, zaliha
                            FROM i_zaliha, m_mt mt
                           WHERE zaliha < 0
                             AND mt.id = mt_id
                             AND zaj_obr.vanjsko_mjesto_troska (mt_id) = 0 -- unutarnje MT
                             AND INSTR (vrijednost_l, mt.vrsta) > 0 -- vrsta MT je u popisu
                         )
                AS zaliha_tab_t
               )
     INTO zaliha_tab_m
     FROM DUAL;
END;
FUNCTION POSTOJI_NEGATIVNA_ZALIHA
 RETURN BOOLEAN
 IS

   vrijednost_l szmp_parametri.vrijednost%TYPE;
   postoji_l    BOOLEAN := FALSE;
   brojac_l     NUMBER;
   naredba_L    VARCHAR2(32000);
BEGIN
   vrijednost_L := pra_zmp_zaj.zmppar_vrijednost ('GAS', '1001');

   IF vrijednost_l <> 'nebitno' THEN
      SELECT SUM (INSTR (vrijednost_l, mt.vrsta))
        INTO brojac_l
        FROM i_zaliha dui, m_mt mt
       WHERE dui.mt_id = mt.id
         AND dui.zaliha < 0
         AND zaj_obr.vanjsko_mjesto_troska (mt.id) = 0;

      IF brojac_l > 0 THEN
         postoji_l := TRUE;
      END IF;
   END IF;

   RETURN postoji_l;
END;
FUNCTION NEGATIVNA_ZALIHA
 RETURN VARCHAR2
 IS

   negativna_zaliha_l VARCHAR (400);
BEGIN
   FOR neg IN
      (SELECT DISTINCT (mt.sifra) sifra
         FROM i_zaliha zal,
              m_mt mt
        WHERE zal.zaliha < 0
          AND zal.mt_id = mt.id
          AND zaj_obr.vanjsko_mjesto_troska (mt.id) = 0)
   LOOP
      negativna_zaliha_l := negativna_zaliha_l || ' ' || neg.sifra || ',';
   END LOOP;
   negativna_zaliha_l := SUBSTR (negativna_zaliha_l, 1, 180);
   RETURN negativna_zaliha_l;
END;
PROCEDURE OBRADA_ZAPISNIKA
 IS

   brojac_l          NUMBER;
   pros_nab_cijena_L m_namirnice.zad_nab_cijena%TYPE := 0;
   zad_nab_cijena_L  m_namirnice.zad_nab_cijena%TYPE  := 0;
   zaliha_l          m_namirnice.zaliha%TYPE := 0;
   ukupno_zaliha_l   m_namirnice.zaliha%TYPE :=0;
   datum_L           DATE;
BEGIN
   /*
   Prema pravilima trgovakog poslovanja nije dozvoljena negativna zaliha.
   U toku dnevne obrade se prethodno poziva NST procedura koja automatski radi (i) zapisnike o privremenom zaduenju.
   Ovdje se ti zapisnici itaju i auriraju polja "zaliha" i "kol_dnev_otpis" u tablicima "i_dnev_ui" i "i_dnev_ui_det",
   a u tablici "i_zaliha" samo polje "zaliha".
   */
   FOR zap IN (
     SELECT zap.id zap_id, zap.mt_id
       FROM t_zapisnik zap,
            m_mt mt
      WHERE zap.mt_id = mt.id
        AND datum = datum_M
        AND mt.vrsta = 'U'
        AND zaj_obr.vanjsko_mjesto_troska (mt.id) = 0)
   LOOP
      FOR zapart IN (
        SELECT nam_id, kolicina
          FROM t_zapisnik_art
         WHERE zap_id = zap.zap_id)
      LOOP
         SELECT COUNT (*) INTO brojac_l
           FROM i_dnev_ui
          WHERE nam_id = zapart.nam_id
            AND mt_id = zap.mt_id
            AND datum = datum_m;

         IF brojac_l = 0 THEN
            SELECT MAX (datum) INTO datum_l
              FROM i_dnev_ui
             WHERE datum  < datum_m
               AND nam_id = zapart.nam_id
               AND mt_id  = zap.mt_id;

            IF datum_l IS NOT NULL THEN
               SELECT pros_nab_cijena, zad_nab_cijena, zaliha
                 INTO pros_nab_cijena_l, zad_nab_cijena_l, zaliha_l
                 FROM i_dnev_ui
                WHERE nam_id = zapart.nam_id
                  AND mt_id  = zap.mt_id
                  AND datum  = datum_l;

                ukupno_zaliha_l := zaliha_l + zapart.kolicina;
            ELSE
                ukupno_zaliha_l := zapart.kolicina;
            END IF;

            INSERT INTO i_dnev_ui (
               mt_id, nam_id, datum, kol_ulaz, kol_izlaz,
               kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup,
               kol_izlaz_sup, kol_dnev_otpis,
               kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
               izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
              VALUES (
               zap.mt_id, zapart.nam_id, datum_m, 0, 0,
               0, 0, 0,
               0, - zapart.kolicina,
               0, ukupno_zaliha_L, 0, 0,
               0, pros_nab_cijena_l, zad_nab_cijena_l);
         ELSE
            UPDATE i_dnev_ui
               SET zaliha = zaliha + zapart.kolicina,
                   kol_dnev_otpis = kol_dnev_otpis - zapart.kolicina
             WHERE mt_id  = zap.mt_id
               AND nam_id = zapart.nam_id
               AND datum  = datum_M;
         END IF;

         SELECT COUNT (*) INTO brojac_l
           FROM i_dnev_ui_det
          WHERE nam_id = zapart.nam_id
            AND mt_id  = zap.mt_id
            AND datum  = datum_m;

         IF brojac_L = 0 THEN
            INSERT INTO i_dnev_ui_det (
               mt_id, nam_id, datum, sir_id, pro_id, nam_id_supstitut, pro_id_supstitut,
               kol_ulaz, kol_izlaz,kol_int_ulaz,
               kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis,
               kol_inv_razlika, zaliha, izn_ulaz, izn_int_ulaz,
               izn_int_izlaz, pros_nab_cijena, zad_nab_cijena)
              VALUES (
               zap.mt_id, zapart.nam_id, datum_m, NULL, NULL, NULL, NULL,
               0, 0, 0,
               0, 0, 0, - zapart.kolicina,
               0, ukupno_zaliha_l, 0, 0,
               0, pros_nab_cijena_l, zad_nab_cijena_l);
         ELSE
            UPDATE i_dnev_ui_det
               SET zaliha = zaliha + zapart.kolicina,
                   kol_dnev_otpis = kol_dnev_otpis - zapart.kolicina
             WHERE mt_id  = zap.mt_id
               AND nam_id = zapart.nam_id
               AND datum  = datum_M;
         END IF;

         SELECT COUNT (1) INTO brojac_l
           FROM i_zaliha
          WHERE mt_id  = zap.mt_id
            AND nam_id = zapart.nam_id;

         IF brojac_l = 0 THEN
            INSERT INTO i_zaliha (
               mt_id, nam_id, zaliha,
               zad_nab_cijena, pros_nab_cijena)
              VALUES (
               zap.mt_id, zapart.nam_id, ukupno_zaliha_l,
               zad_nab_cijena_l, pros_nab_cijena_l);
         ELSE
            SELECT zaliha INTO zaliha_l
              FROM i_dnev_ui
             WHERE nam_id = zapart.nam_id
               AND mt_id = zap.mt_id
               AND datum = datum_m;

            UPDATE i_zaliha
               SET zaliha = zaliha_l,
                   zad_nab_cijena  = zad_nab_cijena_l,
                   pros_nab_cijena = pros_nab_cijena_l
             WHERE mt_id  = zap.mt_id
               AND nam_id = zapart.nam_id;
         END IF;

         zaliha_l := 0;
         ukupno_zaliha_l := 0;
      END LOOP;
   END LOOP;
END;
PROCEDURE POSALJI_PRIJELAZNICU
 (ID_PRI_DAVATELJ_P IN NUMBER
 )
 IS

   godina_l        t_prijelaz.godina%TYPE;
   mt_id_daje_l    NUMBER;
   rbr_daje_l      t_prijelaz.rbr_daje%TYPE;
   mt_id_prima_l   NUMBER;
   centar_l        smet_cvorovi.sifra%TYPE;
   naredba_l       VARCHAR2 (32000);
   id_pri_centar_l NUMBER (32);
BEGIN
   IF prijelaznica_za_slanje (id_pri_davatelj_p) = 0 THEN
      RETURN;
   END IF;

   SELECT godina,   mt_id_daje,   rbr_daje,   mt_id_prima
     INTO godina_l, mt_id_daje_l, rbr_daje_l, mt_id_prima_l
     FROM t_prijelaz
    WHERE id = id_pri_davatelj_p;

   centar_l := pra_zmp_zaj.zmppar_vrijednost ('ZMP', '0018');

   BEGIN
      SAVEPOINT prije_slanja_na_cvor;

      /*
      Ako prijelaznica (sa istim UK davatelja) ve postoji na centru, aurira se.
      Ako ne postoji, generira joj se ID na temelju sekvence sa centra i odmah se stavlja oznaka valjanosti V.
      */
      naredba_l :=
      'BEGIN
          SELECT id INTO :id_pri_centar
            FROM t_prijelaz@' || centar_l  || '
           WHERE godina     = :godina
             AND mt_id_daje = :mt_id_daje
             AND rbr_daje   = :rbr_daje;

          UPDATE t_prijelaz@' || centar_l || '
             SET (datum, opis, opis80, nac_id) =
                 (SELECT datum, opis, opis80, nac_id
                    FROM t_prijelaz
                   WHERE id = :id_pri_davatelj)
           WHERE id = :id_pri_centar;
       EXCEPTION
          WHEN NO_DATA_FOUND THEN
             :id_pri_centar := gas_zaj.sekvenca@' || centar_l || '(NULL);

             INSERT INTO t_prijelaz@' || centar_l || '
                      (id,             godina, mt_id_daje, rbr_daje, mt_id_prima, rbr_prima,
                       datum, nac_id, opis, opis80, ozn_valjanosti, ozn_replikacije, nar_id, ozn_int_prihoda)
                SELECT :id_pri_centar, godina, mt_id_daje, rbr_daje, mt_id_prima, rbr_prima,
                       datum, nac_id, opis, opis80, ''V'', ''N'', NULL, ozn_int_prihoda
                  FROM t_prijelaz
                 WHERE id = :id_pri_davatelj;
       END;';

      EXECUTE IMMEDIATE naredba_l
         USING IN OUT id_pri_centar_l, IN godina_l, IN mt_id_daje_l, IN rbr_daje_l, IN id_pri_davatelj_p;

      /*
      Auriranje stavaka (stavke se prvo briu, pa unose, to treba kod UPDATE).
      Na kraju, ako prijelaznica nije ve u log-u, pokuava se odmah slati primatelju.
      */
      naredba_l :=
      '
      DECLARE
         brojac_l INTEGER;
         rowid_l  ROWID;
      BEGIN
         DELETE t_prijelaz_art@' || centar_l || '
          WHERE pri_id = :id_pri_centar;

         /* Insert sirovina, namirnica i (iako ih ne bi smjelo biti) proizvoda koji nemaju kvazi-namirnicu */
         INSERT INTO t_prijelaz_art@' || centar_l || '
                  (pri_id, sir_id, nam_id, pro_id, nam_pro_id,
                   odnos_jm_b, odnos_jm_n,
                   kolicina, kolicina_plan,
                   nab_cijena, planska_cijena)
            SELECT :id_pri_centar, sir_id, nam_id, pro_id, nam_pro_id,
                   odnos_jm_b, odnos_jm_n,
                   kolicina, kolicina_plan,
                   nab_cijena, planska_cijena
              FROM t_prijelaz_art
             WHERE pri_id = :id_pri_davatelj
               AND (sir_id IS NOT NULL
                    OR
                    nam_id IS NOT NULL
                    OR
                    pro_id IS NOT NULL AND nam_pro_id IS NULL
                   );

         /*
         Insert proizvoda koji imaju kvazi-namirnicu.
         Kvazi-namirnica se zamjenjuje (eventualnim) supstitutom, a koliina/cijena se mnoi/dijeli sa omjer_zamjene.
         */
         INSERT INTO t_prijelaz_art@' || centar_l || '
                  (pri_id, sir_id, nam_id, pro_id,
                   nam_pro_id,
                   odnos_jm_b, odnos_jm_n,
                   kolicina,
                   kolicina_plan,
                   nab_cijena,
                   planska_cijena
                  )
            SELECT :id_pri_centar pri_id, sir_id, nam_id, pro_id,
                   (SELECT NVL (id_supstitut, id)
                      FROM m_namirnice
                     WHERE id = x.nam_pro_id
                   ) nam_pro_id,
                   odnos_jm_b, odnos_jm_n,
                   (SELECT x.kolicina * omjer_zamjene
                      FROM m_namirnice
                     WHERE id = x.nam_pro_id
                   ) kolicina,
                   (SELECT x.kolicina_plan * omjer_zamjene
                      FROM m_namirnice
                     WHERE id = x.nam_pro_id
                   ) kolicina_plan,
                   (SELECT DECODE (x.planska_cijena, 0,
                                   x.nab_cijena / omjer_zamjene,
                                   x.planska_cijena / omjer_zamjene
                                  )
                      FROM m_namirnice
                     WHERE id = x.nam_pro_id
                   ) nab_cijena,
                   (SELECT x.planska_cijena / omjer_zamjene
                      FROM m_namirnice
                     WHERE id = x.nam_pro_id
                   ) planska_cijena
              FROM t_prijelaz_art x
             WHERE pri_id = :id_pri_davatelj
               AND pro_id IS NOT NULL AND nam_pro_id IS NOT NULL;

         DELETE t_prijelaz_amb@' || centar_l || '
          WHERE pri_id = :id_pri_centar;

         INSERT INTO t_prijelaz_amb@' || centar_l || '
                  (pri_id,         amb_id, kolicina)
            SELECT :id_pri_centar, amb_id, kolicina
              FROM t_prijelaz_amb
             WHERE pri_id = :id_pri_davatelj;

         SELECT COUNT (*) INTO brojac_l
           FROM possus_l_dokumenti@' || centar_l  || '
          WHERE id = :id_pri_centar
            AND vrsta = ''P'';

         IF brojac_l = 0 THEN
            SELECT ROWID INTO rowid_l
              FROM t_prijelaz@' || centar_l || '
             WHERE id = :id_pri_centar;

            possus_gas.brisi_tab@'  || centar_l || ';
            possus_gas.napuni_tab@' || centar_l || '(rowid_l);
            possus_gas.repliciraj_prijelaznice@' || centar_l || ';
         END IF;
      END;
      ';

      EXECUTE IMMEDIATE naredba_l USING id_pri_centar_l, id_pri_davatelj_p;
   EXCEPTION
      WHEN OTHERS THEN
         ROLLBACK TO prije_slanja_na_cvor;
         RAISE;
      /*
      Nakon ORA-02055 treba dati ROLLBACK, inae daljnje naredbe javljaju ORA-02067.
      Nije dobro:

      WHEN OTHERS THEN
         IF SQLCODE = -2055 THEN
            ROLLBACK TO prije_slanja_na_cvor;
         END IF;
         RAISE;

      zato to se u sluaju greke ORA-02055 i (npr.) ORA-01400 u SQLCODE nalazi ORA-01400,
      pa se ROLLBACK ne bi napravio (i onda daljnje naredbe javljaju ORA-02067).
      */
   END;
END;
PROCEDURE IZRACUN_PRO_NC_NAMIRNICE_HNB
 IS

   zaliha_l                NUMBER;
   pros_nab_cijena_l       NUMBER;
   pros_nab_cijena_nova_l  NUMBER;
   zad_nab_cijena_l        NUMBER;
   iznos_l                 NUMBER;
   iznos_ukupno_l          NUMBER;
   kolicina_l              NUMBER;
   kolicina_ukupno_l       NUMBER;
   datum_l                 DATE;
   min_kolicina_l CONSTANT NUMBER := 1 / 1000;
   brojac_l                INTEGER;
BEGIN
   /* Pamti se prethodni datum - uvijek postoje sve namirnice, za sva MT koja su jednom imala promet te namirnice */
   SELECT MAX (datum) INTO datum_l
     FROM i_dnev_ui
    WHERE datum < datum_m;

   /* Izraun nove prosjene cijene na temelju redaka svih MT. */
   FOR dui IN (
      SELECT nam_id,
             SUM (izn_ulaz) izn_ulaz,
             SUM (izn_int_ulaz) izn_int_ulaz,
             SUM (kol_ulaz) kol_ulaz,
             SUM (kol_int_ulaz) kol_int_ulaz
        FROM i_dnev_ui
       WHERE datum  = datum_m
         AND mt_id IN (SELECT id FROM m_mt WHERE vrsta <> 'M') -- skladita se ne smiju uzeti u izraun
       GROUP BY nam_id)
   LOOP
      SELECT NVL (SUM (zaliha), 0), NVL (MAX (pros_nab_cijena), 0) -- max nije vaan, sve bi prosjene cijene trebale biti iste
        INTO zaliha_l, pros_nab_cijena_l
        FROM i_dnev_ui
       WHERE zaliha > 0
         AND nam_id = dui.nam_id
         AND datum  = datum_l
         AND mt_id IN (SELECT id FROM m_mt WHERE vrsta <> 'M');

      iznos_l    := dui.izn_ulaz + dui.izn_int_ulaz;
      kolicina_l := dui.kol_ulaz + dui.kol_int_ulaz;

      iznos_ukupno_l    := zaliha_l * pros_nab_cijena_l + iznos_l;
      kolicina_ukupno_l := zaliha_l + kolicina_l;

      IF zaliha_l >= min_kolicina_l AND iznos_ukupno_l > 0 AND kolicina_ukupno_l >= min_kolicina_l THEN
         pros_nab_cijena_nova_l := iznos_ukupno_l / kolicina_ukupno_l;
      ELSIF iznos_l > 0 AND kolicina_l >= min_kolicina_l THEN
         pros_nab_cijena_nova_l := iznos_l / kolicina_l;
      ELSE
         pros_nab_cijena_nova_l := pros_nab_cijena_l;
      END IF;

      /* Auriranje ZNC u tablici I_DNEV_UI u prethodnim procedurama je ostavljeno, iako nema efekta, jer se "pregazi" ovime */
      SELECT zad_nab_cijena INTO zad_nab_cijena_l
        FROM m_namirnice
       WHERE id = dui.nam_id;

      UPDATE i_dnev_ui
         SET pros_nab_cijena = pros_nab_cijena_nova_l,
             zad_nab_cijena  = zad_nab_cijena_l
       WHERE nam_id = dui.nam_id
         AND datum  = datum_m
         AND mt_id IN (SELECT id FROM m_mt WHERE vrsta <> 'M');
   END LOOP;

   /*
   Kreiranje redaka u I_DNEV_UI za tekui datum, ako redak ve ne postoji zbog ulaza/izlaza na tekui datum.
   Prepisuju se redovi od prethodnog datuma, sa koliinama i iznosima postavljenim na 0,
   a stavlja se nova prosjena cijena i zadnja nabavna cijena.
   */
   FOR dui IN (
      SELECT *
        FROM i_dnev_ui
       WHERE datum  = datum_l -- gledamo prethodni datum
         AND mt_id IN (SELECT id FROM m_mt WHERE vrsta <> 'M'))
   LOOP
      /* Da li odgovarajui redak postoji na tekui datum */
      SELECT COUNT (*) INTO brojac_l
        FROM i_dnev_ui
       WHERE mt_id  = dui.mt_id
         AND nam_id = dui.nam_id
         AND datum  = datum_m;

      /* Ako ne postoji, kreira se sa novom prosjenom cijenom i zadnjom nabavnom cijenom */
      IF brojac_l = 0 THEN
         SELECT MAX (pros_nab_cijena), MAX (zad_nab_cijena) -- max nije vaan, sve bi cijene trebale biti iste
           INTO pros_nab_cijena_l, zad_nab_cijena_l
           FROM i_dnev_ui
          WHERE nam_id = dui.nam_id
            AND datum  = datum_m
            AND mt_id IN (SELECT id FROM m_mt WHERE vrsta <> 'M');

         INSERT INTO i_dnev_ui (
            mt_id, nam_id, datum,
            kol_ulaz, kol_izlaz, kol_int_ulaz, kol_int_izlaz, kol_storno_izlaz_sup, kol_izlaz_sup, kol_dnev_otpis, kol_inv_razlika,
            izn_ulaz, izn_int_ulaz, izn_int_izlaz,
            zaliha, pros_nab_cijena, zad_nab_cijena)
            VALUES (
            dui.mt_id, dui.nam_id, datum_m,
            0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0,
            dui.zaliha, NVL (pros_nab_cijena_l, dui.pros_nab_cijena), NVL (zad_nab_cijena_l, dui.zad_nab_cijena));
      END IF;
   END LOOP;
END;
PROCEDURE IZRACUN_PRO_NC_PROIZVODA_HNB
 IS
   pros_nc_proizvoda_l NUMBER;
   pros_nc_l           NUMBER;
   marza_l             NUMBER;
   pdv_l               NUMBER;
   ppot_l              NUMBER;
   pc_l                NUMBER;
BEGIN
   FOR pro IN (
      SELECT id, kol_recepture, gkalk_id, gpor_id
        FROM m_proizvodi
       ORDER BY razina ASC)
   LOOP
      pros_nc_proizvoda_l := 0;

      FOR sas IN (
         SELECT nam_id, pro_id_poluproizvod, normativ
           FROM m_sastav
          WHERE pro_id = pro.id)
      LOOP
         IF sas.nam_id IS NOT NULL THEN
            SELECT NVL (MAX (pros_nab_cijena), 0) -- MAX nije vaan, sve cijene namirnice za jedan datum su iste
              INTO pros_nc_l
              FROM i_dnev_ui
             WHERE datum = datum_m
               AND nam_id = sas.nam_id;
         ELSE
            SELECT pros_nab_cijena
              INTO pros_nc_l
              FROM m_proizvodi
             WHERE id = sas.pro_id_poluproizvod;
         END IF;

         pros_nc_proizvoda_l := pros_nc_proizvoda_l + pros_nc_l * sas.normativ;
      END LOOP;

      /* mora se podijeliti sa kol_recepture */
      pros_nc_proizvoda_l := pros_nc_proizvoda_l / pro.kol_recepture;

      /* Ako proizvod nema kalkulativnu grupu, mara je 0 */
      IF pro.gkalk_id IS NULL THEN
         marza_l := 0;
      ELSE
         SELECT marza1 INTO marza_l
           FROM m_gkalk
          WHERE id = pro.gkalk_id;
      END IF;

      /* Ako proizvod nema poreznu grupu, PC se postavlja na 0 */
      IF pro.gpor_id IS NULL THEN
         pc_l := 0;
      ELSE
         gas_zaj.porezi (pro.gpor_id, datum_m, pdv_l, ppot_l);
         pc_l := zaj_obr.pc_proizvoda (
                    nabavna_cijena_p => pros_nc_proizvoda_l,
                    marza_p          => marza_l,
                    pdv_p            => pdv_l,
                    ppot_p           => ppot_l);
      END IF;

      /* Zaokruivanje PC1 na drugu decimalu, osim ako bi cijena ispala 0, tada se stavlja 1 cent */
      UPDATE m_proizvodi
         SET pros_nab_cijena = pros_nc_proizvoda_l,
             pc1 = DECODE (ROUND (pc_l, 2), 0, 1 / 100, ROUND (pc_l, 2))
       WHERE id = pro.id;
   END LOOP;
END;
PROCEDURE PRIJEPIS_U_ASORTIMAN_HNB
 IS
BEGIN
   -- CK na M_ASO_KASE ne dozvoljava da PC bude 0, ali PC1 u M_PROIZVODI nije 0)
   UPDATE m_aso_kase aso
      SET pc = (SELECT pc1
                  FROM m_proizvodi
                 WHERE id = aso.pro_id
               );
END;
FUNCTION PROVJERA_PRIJEPISA_SA_KASA
 (ID_P NUMBER
 ,DATUM_P DATE
 )
 RETURN BOOLEAN
 IS

  BROJAC_L NUMBER;
BEGIN
   SELECT COUNT (1) INTO brojac_l
     FROM t_rnkase
    WHERE datum   = datum_P
      AND kase_id = id_P;
   IF brojac_L = 0 THEN
      RETURN FALSE;
   ELSE
      RETURN TRUE;
   END IF;
END PROVJERA_PRIJEPISA_SA_KASA;
FUNCTION OBRADA_U_TOKU
 RETURN BOOLEAN
 IS
BEGIN
   RETURN obrada_u_toku_M;
END;
PROCEDURE PROVJERA_DATUM_INVENTURE
 (DATUM_P DATE
 )
 IS

   datum_inventura_L DATE;
   datum_invamb_L    DATE;
   nebitno_L         l_obracun.oznaka%TYPE;
BEGIN
   /* provjera da li je obraena inventura artikala */
   BEGIN
      SELECT MAX (datum) INTO datum_inventura_L
        FROM t_inventura
       WHERE datum < datum_P;
      IF datum_inventura_L IS NOT NULL THEN
         SELECT oznaka INTO nebitno_L
           FROM l_obracun
          WHERE datum = datum_inventura_L
            AND oznaka = '40';
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         gas_zaj.vrati_poruku (-20044);
   END;
   /* provjera da li je obraena inventura ambalae */
   BEGIN
      SELECT MAX (datum) INTO datum_invamb_L
         FROM t_invamb
         WHERE datum < datum_P;
      IF datum_invamb_L IS NOT NULL THEN
         SELECT oznaka INTO nebitno_L
           FROM l_obracun
          WHERE datum  = datum_invamb_L
            AND oznaka = '60';
      END IF;
   EXCEPTION
      WHEN NO_DATA_FOUND THEN
         gas_zaj.vrati_poruku (-20045);
   END;
END;
FUNCTION DAT_ZADNJEG_DO
 RETURN DATE
 IS

   dat_zadnjeg_do_L DATE;
BEGIN
   SELECT MAX (datum) INTO dat_zadnjeg_do_L
     FROM l_obracun
    WHERE oznaka = '00';
   RETURN dat_zadnjeg_do_L;
END;
FUNCTION PRIJELAZNICA_ZA_SLANJE
 (ID_PRI_DAVATELJ_P IN NUMBER
 )
 RETURN NUMBER
 IS

   mt_id_daje_l  NUMBER;
   mt_id_prima_l NUMBER;
   vrsta_l       m_mt.vrsta%TYPE;
   oj_vlasnik_l  NUMBER;
BEGIN
   /* Prijelaznica se alje na drugi vor samo sa ne-centra */
   IF pra_zmp_zaj.centar <> 0 THEN
      RETURN 0;
   END IF;

   SELECT mt_id_daje,   mt_id_prima
     INTO mt_id_daje_l, mt_id_prima_l
     FROM t_prijelaz
    WHERE id = id_pri_davatelj_p;

   /* Ako je davatelj vrste Magazin ili primatelj vrste Magazin ili Administracija, ne alje se. */
   SELECT vrsta INTO vrsta_l
     FROM m_mt
    WHERE id = mt_id_daje_l;

   IF vrsta_l = 'M' THEN
      RETURN 0;
   END IF;

   SELECT vrsta INTO vrsta_l
     FROM m_mt
    WHERE id = mt_id_prima_l;

   IF vrsta_l IN ('M', 'T') THEN
      RETURN 0;
   END IF;
 
   /*
   alje se samo ako je davatelj unutarnje MT i primatelj vanjsko MT.
   Ukljuuju se i MT vrste T, pa se zato ne koristi funkcija zaj_obr.vanjsko_mjesto_troska.
   */
   SELECT oj_id INTO oj_vlasnik_l
     FROM sgas_vlasnik;

   IF oj_vlasnik_l IS NULL THEN
      RETURN 0;
   END IF;

   /* Ako je davatelj vanjski, ne alje se. */
   IF pra_zmp.oj_pripada_oj (mt_id_daje_l, oj_vlasnik_l) = 0 THEN
      RETURN 0;
   END IF;

   /* Ako je primatelj unutarnji, ne alje se. */
   IF pra_zmp.oj_pripada_oj (mt_id_prima_l, oj_vlasnik_l) = -1 THEN
      RETURN 0;
   END IF;

   RETURN -1;
END;
FUNCTION PROS_NC_NAMIRNICE_HNB
 (NAM_ID_P NUMBER
 )
 RETURN NUMBER
 IS

   datum_L           DATE;
   pros_nab_cijena_L NUMBER;
BEGIN
  SELECT MAX (datum) INTO datum_L
    FROM i_dnev_ui
   WHERE nam_id = nam_id_P
     AND datum  < datum_M;
   IF datum_L IS NOT NULL THEN
      SELECT MAX(pros_nab_cijena)
        INTO pros_nab_cijena_L
        FROM i_dnev_ui
       WHERE nam_id = nam_id_P
         AND datum  = datum_L;
   ELSE
      pros_nab_cijena_L := 0;
   END IF;
   RETURN pros_nab_cijena_L;
END;
PROCEDURE POSALJI_VR_OTPREMNICE_IR_HF_VA
 IS
   ne_VR_sifra_l    m_mt.sifra%TYPE;
   ne_VR_id_l       NUMBER (32);
   centar_l         smet_cvorovi.sifra%TYPE;
   gmpkom_id_l      tgas_izlazdok.gmpkom_id%TYPE;
   naredba_l        VARCHAR2 (32000);
   sifra_l          m_proizvodi.sifra%TYPE;
   naziv_l          m_proizvodi.naziv%TYPE;
   pro_nam_id_l     m_proizvodi.pro_nam_id%TYPE;
   sifra_nam_l      m_namirnice.sifra%TYPE;
BEGIN
   /*
   Ako se pokree na shemi RIRACP (CK Vine) ili RICKUHINJA (CK President), otpremnice za komitente IMPERIAL RIVIERA, HELIOS FAROS ili tri Austrijska hotela
   kreiraju primke za odgovarajue MT (koje pie na poetku NAPOMENE otpremnice) i imaju dobavljaa VALAMAR RIVIERA.

   Za Austrijske hotele, koji nisu u replikaciji, stavke primke se kreiraju na temelju ifre kvazi-namirnice (runo se sikroniziraju), a ne id-a kvazi-namirnice.
   */

   /* Provjera otpremnica */
   FOR zagotpr IN (
      SELECT id, rbr, napomena, gmpkom_id
        FROM tgas_izlazdok
       WHERE datum = datum_m
         AND gmpkom_id IN (3680732, 98285292, 210945683) -- komitent je IR, HF, Austrija
         AND NVL (opis, 'opis') != 'OTPREMNICA POSLANA NA PODCENTAR')
   LOOP
      ne_VR_sifra_l := SUBSTR (zagotpr.napomena, 1, 6);
      gmpkom_id_l   := zagotpr.gmpkom_id;

      /*
      ifra MT (za IR, HF, Austrija) trebala bi biti upisana na poetku napomene.
      Ima 4 znaka (IR, HF, Austrija), 5 znakova (IR) ili 6 znakova (IR za Makarsku).
      Ako su esti ili peti znak prazni, eliminiramo ga.
      */

      IF SUBSTR (ne_VR_sifra_l, 6, 1) = ' ' THEN
         ne_VR_sifra_l := SUBSTR (ne_VR_sifra_l, 1, 5);
      END IF;

      IF SUBSTR (ne_VR_sifra_l, 5, 1) = ' ' THEN
         ne_VR_sifra_l := SUBSTR (ne_VR_sifra_l, 1, 4);
      END IF;

      IF    gmpkom_id_l = 3680732 THEN
         centar_l := 'ircentar';
      ELSIF gmpkom_id_l = 98285292 THEN
         centar_l := 'hfcentar';
      ELSIF gmpkom_id_l = 210945683 THEN
         centar_l := 'vacentar';
      END IF;

      BEGIN
         naredba_l := 'SELECT id FROM m_mt@' || centar_l || ' WHERE sifra = :ne_VR_sifra_l';
         EXECUTE IMMEDIATE naredba_l INTO ne_VR_id_l USING ne_VR_sifra_l;
      EXCEPTION
         WHEN NO_DATA_FOUND THEN
            RAISE_APPLICATION_ERROR (-20000, 'Otpremnica ' || zagotpr.rbr || ' za IR, HF, VR Austrija nema na poetku napomene dobru ifru MT!');
      END;

      /*
      Provjeravaju se stavke otpremnica:
      - imaju li proizvodi kvazi-namirnicu
      - postoje li u Austriji jednake ifre kvazi-namirnica.
      */
      FOR staotpr IN (
         SELECT pro_id
           FROM tgas_izlazdok_art
          WHERE gasizldok_id = zagotpr.id)
      LOOP
         SELECT sifra, naziv, pro_nam_id
           INTO sifra_l, naziv_l, pro_nam_id_l
           FROM m_proizvodi
          WHERE id = staotpr.pro_id;

         IF pro_nam_id_l IS NULL THEN
            RAISE_APPLICATION_ERROR (-20000,
               'Otpremnica ' || zagotpr.rbr || ' za IR, HF, VR Austrija sadri proizvod ' || sifra_l || ' ' || naziv_l || ' koji nema kvazi-namirnicu!');
         END IF;

         IF gmpkom_id_l = 210945683 THEN -- komitent je iz Austrije
            BEGIN
               naredba_l :=
               'SELECT sifra
                  FROM m_namirnice@' || centar_l || '
                 WHERE sifra = (SELECT sifra FROM m_namirnice WHERE id = :pro_nam_id)
               ';
               EXECUTE IMMEDIATE naredba_l INTO sifra_nam_l USING pro_nam_id_l;
            EXCEPTION
               WHEN NO_DATA_FOUND THEN
                  RAISE_APPLICATION_ERROR (-20000,
                     'Otpremnica ' || zagotpr.rbr || ' sadri proizvod ' || sifra_l || ' ' || naziv_l || ' ija ifra kvazi-namirnice ne postoji u VR Austrija!');
            END;
         END IF;
      END LOOP;
   END LOOP;

   /* Slanje otpremnica - WHERE uvjet je jednak kao kod gornje provjere otpremnica */
   FOR zagotpr IN (
      SELECT id
        FROM tgas_izlazdok
       WHERE datum = datum_m
         AND gmpkom_id IN (3680732, 98285292, 210945683) -- komitent je IR, HF, Austrija
         AND NVL (opis, 'opis') != 'OTPREMNICA POSLANA NA PODCENTAR')
   LOOP
      posalji_VR_otpremnicu (zagotpr.id);

      UPDATE tgas_izlazdok
         SET opis = 'OTPREMNICA POSLANA NA PODCENTAR' -- storno otpremnica vie nee imati minus na poetku, pa se nee opet obraditi
       WHERE id = zagotpr.id;
   END LOOP;
END;
PROCEDURE POSALJI_VR_OTPREMNICU
 (ID_P NUMBER
 )
 IS
   VR_gmpkom_id_l   NUMBER (32) := 332292; -- komitent 211279 VALAMAR RIVIERA D.D.
   ne_VR_sifra_l    m_mt.sifra%TYPE;
   ne_VR_id_l       NUMBER (32);
   centar_l         smet_cvorovi.sifra%TYPE;
   godina_l         tgas_izlazdok.godina%TYPE;
   rbr_otpr_l       tgas_izlazdok.rbr%TYPE;
   gmpkom_id_l      tgas_izlazdok.gmpkom_id%TYPE;
   mt_id_l          tgas_izlazdok.mt_id%TYPE;
   mt_sifra_l       m_mt.sifra%TYPE;
   nac_id_l         tgas_izlazdok.nac_id%TYPE;
   opis_primke_l    t_ulazdok.opis%TYPE;
   naredba_l        VARCHAR2 (32000);
   id_pri_centar_l  NUMBER (32);
   ozn_vdokumenta_l t_ulazdok.ozn_vdokumenta%TYPE;
BEGIN
   /*
   Na otpremnicama se smije nalaziti samo proizvod s kvazi namirnicom.
   Za razduenje sirovina i namirnica moe se koristi tehnoloki oblik: proizvod s kvazi namirnicom i samo jednom namirnicom u sastavu.
   */

   SELECT SUBSTR (napomena, 1, 6), godina,   rbr,        gmpkom_id,   mt_id,   nac_id,   DECODE (status, 'N','D','U')
     INTO ne_VR_sifra_l,           godina_l, rbr_otpr_l, gmpkom_id_l, mt_id_l, nac_id_l, ozn_vdokumenta_l
     FROM tgas_izlazdok
    WHERE id = id_p;

   SELECT sifra
     INTO mt_sifra_l
     FROM m_mt
    WHERE id = mt_id_l;

   -- ifra MT davatelja dodaje se kao prefiks na rbr otpremnice
   rbr_otpr_l := mt_sifra_l || '-' || rbr_otpr_l;

   SELECT 'Nain potronje: ' || sifra
     INTO opis_primke_l
     FROM m_nacpot
    WHERE id = nac_id_l;  

   /* Sljedee tri IF naredbe su jednake kao u proceduri POSALJI_VR_OTPREMNICE_IR_HF_VA */

   IF SUBSTR (ne_VR_sifra_l, 6, 1) = ' ' THEN
      ne_VR_sifra_l := SUBSTR (ne_VR_sifra_l, 1, 5);
   END IF;

   IF SUBSTR (ne_VR_sifra_l, 5, 1) = ' ' THEN
      ne_VR_sifra_l := SUBSTR (ne_VR_sifra_l, 1, 4);
   END IF;

   IF    gmpkom_id_l = 3680732 THEN
      centar_l := 'ircentar';
   ELSIF gmpkom_id_l = 98285292 THEN
      centar_l := 'hfcentar';
   ELSIF gmpkom_id_l = 210945683 THEN
      centar_l := 'vacentar';
      ozn_vdokumenta_l := 'I'; -- interna primka
   END IF;

   BEGIN
      /* Ve je provjereno u proceduri POSALJI_VR_OTPREMNICE_IR_HF_VA */
      naredba_l := 'SELECT id FROM m_mt@' || centar_l || ' WHERE sifra = :ne_VR_sifra_l';
      EXECUTE IMMEDIATE naredba_l INTO ne_VR_id_l USING ne_VR_sifra_l;
   END;
   
   BEGIN
      SAVEPOINT prije_slanja_na_cvor;

      /*
      Ako primka ne postoji na centru, generira joj se ID na temelju sekvence sa centra i odmah se stavlja oznaka valjanosti V.
      Napomene:
      - petorka (godina + mt_id + dob_id + broj + ozn_vdokumenta) NIJE UK u t_ulazdok, ali vjerojatnost da bude duplo je zanemariva
      - rbr iz otpremnice se kopira u broj u primci
      */

      naredba_l :=
      'BEGIN
          SELECT id INTO :id_pri_centar
            FROM t_ulazdok@' || centar_l || '
           WHERE godina = :godina_l
             AND mt_id  = :IR_HF_mt_id_l
             AND dob_id = :VR_gmpkom_id_l
             AND broj   = :rbr_otpr_l
             AND ozn_vdokumenta = :ozn_vdokumenta_l;
       EXCEPTION
          WHEN NO_DATA_FOUND THEN
             :id_pri_centar := gas_zaj.sekvenca@' || centar_l || '(NULL);

             INSERT INTO t_ulazdok@' || centar_l || '
                      (id,
                       mt_id,
                       dob_id,
                       opis,
                       broj,
                       rbr, godina, datum, ozn_vdokumenta,
                       opis80, ozn_prijepisa, ozn_valjanosti, izn_korekcije)
                SELECT :id_pri_centar,
                       :IR_HF_mt_id_l,
                       :VR_gmpkom_id_l,
                       :opis_primke_l,
                       :rbr_otpr_l,
                       NULL, godina, datum, :ozn_vdokumenta_l,
                       NULL, ''N'', ''V'', 0
                  FROM tgas_izlazdok
                 WHERE id = :id_p;
       END;
      ';

      EXECUTE IMMEDIATE naredba_l
        USING IN OUT id_pri_centar_l, godina_l, ne_VR_id_l, VR_gmpkom_id_l, rbr_otpr_l, ozn_vdokumenta_l, opis_primke_l, id_p;

      IF gmpkom_id_l IN (3680732, 98285292) THEN -- komitent (kupac) je IR ili HF
        /*
        Auriranje stavaka (stavke se prvo briu, pa unose, to treba kod UPDATE).
        Na kraju, ako primka nije ve u log-u, pokuava se odmah slati primatelju.
        */
        naredba_l :=
        'DECLARE
           brojac_l INTEGER;
           rowid_l  ROWID;
         BEGIN
           DELETE t_ulazdok_art@' || centar_l || '
            WHERE ulaz_id = :id_pri_centar;

           INSERT INTO t_ulazdok_art@' || centar_l || '
                    (ulaz_id, sir_id,
                     nam_id,
                     odnos_jm_b, odnos_jm_n, kolicina, rabat, nab_cijena
                    )
             SELECT :id_pri_centar ulaz_id, NULL,
                    (SELECT pro_nam_id FROM m_proizvodi WHERE id = x.pro_id) nam_id,
                    1, 1, kolicina, rabat, prod_cijena
               FROM tgas_izlazdok_art x
              WHERE gasizldok_id = :id_p;

           SELECT COUNT (*) INTO brojac_l
             FROM possus_l_dokumenti@' || centar_l  || '
            WHERE id = :id_pri_centar
              AND vrsta = ''U'';

           IF brojac_l = 0 THEN
             SELECT ROWID INTO rowid_l
               FROM t_ulazdok@' || centar_l || '
              WHERE id = :id_pri_centar;

             possus_gas.brisi_tab@'  || centar_l || ';
             possus_gas.napuni_tab@' || centar_l || '(rowid_l);
             possus_gas.repliciraj_primke@' || centar_l || ';
           END IF;
         END;
        ';
      ELSE -- Valamar Austrija centar
        /*
        Auriranje stavaka direktno na objektu.
        Stavke se kreiraju na temelju ifre kvazi-namirnice, a ne id-a kvazi-namirnice, jer se matini podaci ne repliciraju iz Valamara.
        */
        naredba_l :=
        'DECLARE
           brojac_l INTEGER;
           rowid_l  ROWID;
         BEGIN
           DELETE t_ulazdok_art@' || centar_l || '
            WHERE ulaz_id = :id_pri_centar;

           INSERT INTO t_ulazdok_art@' || centar_l || '
                    (ulaz_id, sir_id,
                     nam_id,
                     odnos_jm_b, odnos_jm_n, kolicina, rabat, nab_cijena
                    )
             SELECT :id_pri_centar ulaz_id, NULL,
                    (SELECT id
                       FROM m_namirnice@' || centar_l || '
                      WHERE sifra =
                            (SELECT sifra
                               FROM m_namirnice
                              WHERE id = (SELECT pro_nam_id FROM m_proizvodi WHERE id = x.pro_id)
                            )
                    ) nam_id,
                    1, 1, kolicina, rabat, prod_cijena
               FROM tgas_izlazdok_art x
              WHERE gasizldok_id = :id_p;

           SELECT COUNT (*) INTO brojac_l
             FROM possus_l_dokumenti@' || centar_l  || '
            WHERE id = :id_pri_centar
              AND vrsta = ''U'';

           IF brojac_l = 0 THEN
             SELECT ROWID INTO rowid_l
               FROM t_ulazdok@' || centar_l || '
              WHERE id = :id_pri_centar;

             possus_gas.brisi_tab@'  || centar_l || ';
             possus_gas.napuni_tab@' || centar_l || '(rowid_l);
             possus_gas.repliciraj_primke@' || centar_l || ';
           END IF;
         END;
        ';
      END IF;

      EXECUTE IMMEDIATE naredba_l USING id_pri_centar_l, id_p;
   EXCEPTION
      WHEN OTHERS THEN
         ROLLBACK TO prije_slanja_na_cvor;
         RAISE;
      /*
      Nakon ORA-02055 treba dati ROLLBACK, inae daljnje naredbe javljaju ORA-02067.
      Nije dobro:

      WHEN OTHERS THEN
         IF SQLCODE = -2055 THEN
            ROLLBACK TO prije_slanja_na_cvor;
         END IF;
         RAISE;

      zato to se u sluaju greke ORA-02055 i (npr.) ORA-01400 u SQLCODE nalazi ORA-01400,
      pa se ROLLBACK ne bi napravio (i onda daljnje naredbe javljaju ORA-02067).
      */
   END;
END;
FUNCTION OPERA_RC_M
 (MT_ID_P NUMBER
 ,NAC_ID_P NUMBER
 )
 RETURN NUMBER
 IS

  opera_rc_id_l      NUMBER; -- OPERA!
  sifra_mt_l  m_mt.sifra%TYPE;
  sifra_np_l  m_nacpot.sifra%TYPE;
BEGIN    
  /* Varijata sa Simfony kasama i Operom */ 
  SELECT sifra INTO sifra_mt_l
    FROM m_mt
   WHERE id = mt_id_p;

  SELECT sifra INTO sifra_np_l
    FROM m_nacpot
   WHERE id = nac_id_p;

  SELECT oj_id INTO opera_rc_id_l
    FROM m_mt_np
   WHERE mt_id  = mt_id_p
     AND nac_id = nac_id_p;

  IF opera_rc_id_l IS NULL THEN
     RAISE_APPLICATION_ERROR (-20001,
      'Nije unesen RC za kombinaciju MT: ' || sifra_mt_l || ' i naina potronje: ' || sifra_np_l);
  ELSE
      RETURN opera_rc_id_l;
  END IF;

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      RAISE_APPLICATION_ERROR (-20001,
        'Nije upisana veza MT: ' || sifra_mt_l || ' i naina potronje: ' || sifra_np_l);
END;
FUNCTION OPERA_RC_K
 (KASA_ID_P NUMBER
 ,NAC_ID_P NUMBER
 )
 RETURN NUMBER
 IS

  opera_rc_id_l      NUMBER; -- OPERA!
  sifra_kase_l  m_kase.sifra%TYPE;
  sifra_np_l  m_nacpot.sifra%TYPE;
BEGIN 
  /* Varijanta sa POS kasama i sustavom Opera */    
  SELECT sifra INTO sifra_kase_l
    FROM mgmp_kase
   WHERE id = kasa_id_p;

  SELECT sifra INTO sifra_np_l
    FROM m_nacpot
   WHERE id = nac_id_p;

  SELECT oj_id INTO opera_rc_id_l
    FROM m_kasa_np
   WHERE kase_id = kasa_id_p
     AND nac_id  = nac_id_p;

  IF opera_rc_id_l IS NULL THEN
     RAISE_APPLICATION_ERROR (-20001,
       'Nije unesen RC za kombinaciju kase: ' || sifra_kase_l || ' i naina potronje: ' || sifra_np_l);
  ELSE 
     RETURN (opera_rc_id_l);
  END IF;

  EXCEPTION
  WHEN NO_DATA_FOUND THEN
     RAISE_APPLICATION_ERROR (-20001,
       'Nije unesena veza kase: ' || sifra_kase_l || ' i naina potronje: ' || sifra_np_l);
 END;

END BM_GAS3010;
/
SHOW ERROR

