/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.JarSignature;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.BlackList;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.TrustedLibraries;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarAsBLOBVerifier
extends JarVerifier {
    private JarSignature js = null;

    public static JarVerifier create(URL uRL, String string, File file, File file2) {
        JarAsBLOBVerifier jarAsBLOBVerifier = new JarAsBLOBVerifier(uRL, string, file, file2);
        if (jarAsBLOBVerifier.detectedSignature()) {
            return jarAsBLOBVerifier;
        }
        return null;
    }

    JarAsBLOBVerifier(URL uRL, String string, File file, File file2) {
        super(uRL, string, file, file2);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.jarFile));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            if (zipEntry != null && "META-INF/".equals(zipEntry.getName())) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null && zipEntry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry != null && JarSignature.BLOB_SIGNATURE.equals(zipEntry.getName())) {
                byte[] byArray = JarAsBLOBVerifier.getBytes(zipInputStream);
                this.js = JarSignature.load(byArray);
            }
        }
        catch (Exception exception) {
            if (Config.getDeployDebug() || Config.getPluginDebug()) {
                Trace.ignored(exception);
            }
            this.js = null;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
        }
    }

    private boolean detectedSignature() {
        return this.js != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(DownloadDelegate downloadDelegate) throws IOException, JARSigningException {
        JarFile jarFile = new JarFile(this.jarFile);
        try {
            int n;
            Object object;
            Object object2;
            int n2 = jarFile.size();
            int n3 = 0;
            this.manifest = jarFile.getManifest();
            Enumeration<JarEntry> enumeration = jarFile.entries();
            if (downloadDelegate != null) {
                downloadDelegate.validating(this.jarLocation, 0, n2);
            }
            if (BlackList.getInstance().checkJarFile(jarFile)) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 5);
            }
            if (TrustedLibraries.checkJarFile(jarFile)) {
                object2 = this.manifest.getMainAttributes();
                object2.putValue("Trusted-Library", Boolean.TRUE.toString());
            }
            while (enumeration.hasMoreElements()) {
                ++n3;
                object2 = null;
                object = null;
                object = enumeration.nextElement();
                object2 = ((ZipEntry)object).getName();
                if (JarSignature.BLOB_SIGNATURE.equals(object2) || JarUtil.isDirectory((ZipEntry)object)) continue;
                this.authenticateJarEntry(jarFile, (JarEntry)object);
            }
            if (!this.js.isValid()) {
                throw new JARSigningException(this.jarLocation, this.jarVersion, 2);
            }
            this.hasOnlySignedEntries = true;
            this.hasSingleCodeSource = true;
            this.hasMissingSignedEntries = false;
            object2 = this.js.getCodeSigners();
            object = new CodeSource(this.jarLocation, (CodeSigner[])object2);
            Certificate[] certificateArray = ((CodeSource)object).getCertificates();
            this.singleSignerIndicesCert = new int[certificateArray.length];
            for (n = 0; n < certificateArray.length; ++n) {
                this.signerCerts.add(certificateArray[n]);
                this.singleSignerIndicesCert[n] = n;
            }
            this.codeSourceCertCache.put(this.singleSignerIndicesCert, object);
            if (Config.isJavaVersionAtLeast15()) {
                this.singleSignerIndicesCS = new int[((CodeSigner[])object2).length];
                for (n = 0; n < ((CodeSigner[])object2).length; ++n) {
                    this.signersCS.add(object2[n]);
                    this.singleSignerIndicesCS[n] = n;
                }
                this.codeSourceCache.put(this.singleSignerIndicesCS, object);
            }
            this.signerMap.put(null, this.singleSignerIndicesCS);
            this.signerMapCert.put(null, this.singleSignerIndicesCert);
        }
        finally {
            jarFile.close();
        }
    }

    protected void authenticateJarEntry(JarFile jarFile, JarEntry jarEntry) throws IOException, JARSigningException {
        String string = jarEntry.getName();
        boolean bl = this.nativePath != null && string.indexOf("/") == -1 && string.indexOf("\\") == -1;
        try {
            InputStream inputStream = this.js.updateWithZipEntry(string, jarFile.getInputStream(jarEntry));
            JarAsBLOBVerifier.readAndMaybeSaveStreamTo(inputStream, bl, string, this.nativePath);
        }
        catch (SignatureException signatureException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, signatureException);
        }
        catch (SecurityException securityException) {
            throw new JARSigningException(this.jarLocation, this.jarVersion, 2, securityException);
        }
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

