/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;

public class CompositeName
implements Name {
    private transient NameImpl impl;
    private static final long serialVersionUID = 1667768148915813118L;

    protected CompositeName(Enumeration<String> enumeration) {
        this.impl = new NameImpl(null, enumeration);
    }

    public CompositeName(String string) throws InvalidNameException {
        this.impl = new NameImpl(null, string);
    }

    public CompositeName() {
        this.impl = new NameImpl(null);
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CompositeName && this.impl.equals(((CompositeName)object).impl);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof CompositeName)) {
            throw new ClassCastException("Not a CompositeName");
        }
        return this.impl.compareTo(((CompositeName)object).impl);
    }

    @Override
    public Object clone() {
        return new CompositeName(this.getAll());
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return this.impl.getAll();
    }

    @Override
    public String get(int n) {
        return this.impl.get(n);
    }

    @Override
    public Name getPrefix(int n) {
        Enumeration enumeration = this.impl.getPrefix(n);
        return new CompositeName(enumeration);
    }

    @Override
    public Name getSuffix(int n) {
        Enumeration enumeration = this.impl.getSuffix(n);
        return new CompositeName(enumeration);
    }

    @Override
    public boolean startsWith(Name name) {
        if (name instanceof CompositeName) {
            return this.impl.startsWith(name.size(), name.getAll());
        }
        return false;
    }

    @Override
    public boolean endsWith(Name name) {
        if (name instanceof CompositeName) {
            return this.impl.endsWith(name.size(), name.getAll());
        }
        return false;
    }

    @Override
    public Name addAll(Name name) throws InvalidNameException {
        if (name instanceof CompositeName) {
            this.impl.addAll(name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a composite name: " + name.toString());
    }

    @Override
    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof CompositeName) {
            this.impl.addAll(n, name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a composite name: " + name.toString());
    }

    @Override
    public Name add(String string) throws InvalidNameException {
        this.impl.add(string);
        return this;
    }

    @Override
    public Name add(int n, String string) throws InvalidNameException {
        this.impl.add(n, string);
        return this;
    }

    @Override
    public Object remove(int n) throws InvalidNameException {
        return this.impl.remove(n);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.size());
        Enumeration<String> enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.impl = new NameImpl(null);
        int n = objectInputStream.readInt();
        try {
            while (--n >= 0) {
                this.add((String)objectInputStream.readObject());
            }
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name");
        }
    }
}

