/*
 * Decompiled with CFR 0.152.
 */
package hr.istratech.proxy.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import hr.istratech.proxy.config.ClientCert;
import hr.istratech.proxy.config.Logging;
import hr.istratech.proxy.config.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Configuration {
    private List<Server> servers = new ArrayList<Server>();
    private Logging logging = new Logging();

    public static Configuration load() {
        return Configuration.load("proxy.conf");
    }

    public static Configuration load(String fileName) {
        Config hCfg = ConfigFactory.parseFile(new File(fileName));
        Configuration conf = new Configuration();
        if (hCfg.hasPath("logging.history")) {
            conf.logging.setHistory(hCfg.getInt("logging.history"));
        }
        if (hCfg.hasPath("logging.level")) {
            conf.logging.setLevel(hCfg.getString("logging.level"));
        }
        if (hCfg.hasPath("servers")) {
            for (Config config : hCfg.getConfigList("servers")) {
                Server server = new Server();
                conf.servers.add(server);
                if (config.hasPath("port")) {
                    server.setPort(config.getInt("port"));
                }
                if (config.hasPath("url")) {
                    server.setUrl(config.getString("url"));
                }
                if (config.hasPath("path")) {
                    server.setPath(config.getString("path"));
                }
                if (config.hasPath("timeout")) {
                    server.setTimeout(config.getInt("timeout"));
                } else {
                    server.setTimeout(600000);
                }
                if (config.hasPath("idleTimeout")) {
                    server.setIdleTimeout(config.getInt("idleTimeout"));
                } else {
                    server.setIdleTimeout(30000);
                }
                if (config.hasPath("sslProtocol")) {
                    server.setSslProtocol(config.getString("sslProtocol"));
                }
                if (config.hasPath("headers")) {
                    Config headersCfg = config.getConfig("headers");
                    for (Map.Entry<String, ConfigValue> header : config.getConfig("headers").entrySet()) {
                        ConfigValue value = header.getValue();
                        server.getHeaders().put(header.getKey(), header.getValue().render(ConfigRenderOptions.defaults().setJson(false)));
                    }
                }
                if (config.hasPath("logging")) {
                    Logging logging = new Logging();
                    server.setLogging(logging);
                    if (config.hasPath("logging.history")) {
                        logging.setHistory(config.getInt("logging.history"));
                    }
                    if (config.hasPath("logging.level")) {
                        logging.setLevel(config.getString("logging.level"));
                    }
                }
                if (!config.hasPath("client-cert")) continue;
                ClientCert clientCert = new ClientCert();
                server.setClientCert(clientCert);
                if (config.hasPath("client-cert.file")) {
                    clientCert.setFile(config.getString("client-cert.file"));
                }
                if (!config.hasPath("client-cert.password")) continue;
                clientCert.setPassword(config.getString("client-cert.password"));
            }
        }
        return conf;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }
}

