/*
 * Decompiled with CFR 0.152.
 */
package hr.istratech.proxy;

import hr.istratech.proxy.TrustAllExtendTrustManager;
import hr.istratech.proxy.config.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLProxyServlet
extends ProxyServlet.Transparent {
    private String _clientCertFile;
    private String _clientCertPassword;
    private String _proxyTo;
    private String _prefix;
    private String _timeout = new String("60000");
    private String _idleTimeout = new String("30000");
    private Map<String, String> headers = new HashMap<String, String>();
    String strContext = "/";

    @Override
    public void init(ServletConfig config) throws ServletException {
        this._clientCertFile = config.getInitParameter("clientCertFile");
        this._clientCertPassword = config.getInitParameter("clientCertPassword");
        this._timeout = config.getInitParameter("timeout");
        this._idleTimeout = config.getInitParameter("idleTimeout");
        super.init(config);
        for (String param : Collections.list(config.getInitParameterNames())) {
            if (!param.startsWith("#HEADER#")) continue;
            this.headers.put(param.substring(8).toLowerCase(), config.getInitParameter(param));
        }
        this.strContext = config.getInitParameter("contextPath");
        this._proxyTo = config.getInitParameter("proxyTo");
        if (this._proxyTo == null) {
            throw new UnavailableException("Init parameter 'proxyTo' is required.");
        }
        String prefix = config.getInitParameter("prefix");
        if (prefix != null) {
            if (!prefix.startsWith("/")) {
                throw new UnavailableException("Init parameter 'prefix' must start with a '/'.");
            }
            this._prefix = prefix;
        }
        String contextPath = config.getServletContext().getContextPath();
        this._prefix = this._prefix == null ? contextPath : contextPath + this._prefix;
        PrintStream serverLogStream = null;
        StdErrLog logger = (StdErrLog)this._log;
        try {
            serverLogStream = new PrintStream(new RolloverFileOutputStream("request-" + config.getInitParameter("servletPort") + "-yyyy_mm_dd.log", true, Integer.parseInt(config.getInitParameter("traceHistory"))));
            logger.setStdErrStream(serverLogStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.setLevel(Logging.getLogLevel(this.getServletConfig().getInitParameter("traceLevel")));
        this._log.info("Proxy on \"{}:{}\" for \"{}\" has been started", config.getInitParameter("servletPort"), this.strContext, config.getInitParameter("proxyTo"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpClient newHttpClient() {
        SslContextFactory sslFactory = new SslContextFactory();
        sslFactory.setTrustAll(true);
        try {
            KeyStore keyStore = null;
            if (null != this._clientCertFile) {
                keyStore = KeyStore.getInstance("PKCS12");
                try (FileInputStream instream = new FileInputStream(new File(this._clientCertFile));){
                    if (null != this._clientCertPassword) {
                        keyStore.load(instream, this._clientCertPassword.toCharArray());
                    } else {
                        keyStore.load(instream, null);
                    }
                }
            }
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            if (null != keyStore) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (null != this._clientCertPassword) {
                    keyManagerFactory.init(keyStore, this._clientCertPassword.toCharArray());
                } else {
                    keyManagerFactory.init(keyStore, null);
                }
                sslContext.init(keyManagerFactory.getKeyManagers(), TrustAllExtendTrustManager.TRUST_ALL_EXTEND_TRUST_MANAGERS, null);
            } else {
                sslContext.init(null, TrustAllExtendTrustManager.TRUST_ALL_EXTEND_TRUST_MANAGERS, null);
            }
            sslFactory.setSslContext(sslContext);
        }
        catch (NoSuchAlgorithmException e) {
            this._log.warn("Found invalid context, use default", "", e);
        }
        catch (KeyManagementException e) {
            this._log.warn("Fail to init customized ssl context", "", e);
        }
        catch (CertificateException e) {
            this._log.warn("Fail to load client certificate", "", e);
        }
        catch (KeyStoreException e) {
            this._log.warn("Fail to load client certificate", "", e);
        }
        catch (IOException e) {
            this._log.warn("Fail to load client certificate", "", e);
        }
        catch (UnrecoverableKeyException e) {
            this._log.warn("Fail to load client certificate", "", e);
            e.printStackTrace();
        }
        HttpClient client = new HttpClient(sslFactory);
        client.setRemoveIdleDestinations(true);
        this.getServletContext().setAttribute("idleTimeout", this._idleTimeout);
        this.getServletContext().setAttribute("timeout", this._timeout);
        return client;
    }

    @Override
    protected void copyRequestHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.copyRequestHeaders(clientRequest, proxyRequest);
        Enumeration<String> headerNames = clientRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            if (this.isOn(headerName.toLowerCase())) continue;
            this._log.debug(headerName + " header removed", new Object[0]);
            proxyRequest.getHeaders().remove(headerName);
        }
    }

    private String RemoveSecureFromCookies(String cookieHeader) {
        return cookieHeader;
    }

    @Override
    protected String filterServerResponseHeader(HttpServletRequest clientRequest, Response serverResponse, String headerName, String headerValue) {
        if (headerName.equalsIgnoreCase("location")) {
            URI targetUri = serverResponse.getRequest().getURI();
            String toReplace = targetUri.getScheme() + "://" + targetUri.getAuthority();
            if (null != this.strContext && this.strContext.endsWith("/")) {
                this.strContext = this.strContext.substring(0, this.strContext.length() - 1);
            }
            if (headerValue.startsWith(toReplace)) {
                headerValue = null != this.strContext ? clientRequest.getScheme() + "://" + clientRequest.getHeader("host") + this.strContext + headerValue.substring(toReplace.length()) : clientRequest.getScheme() + "://" + clientRequest.getHeader("host") + headerValue.substring(toReplace.length());
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Rewrote location header to {}", headerValue);
                }
                return headerValue;
            }
            if (headerValue.startsWith("/") && null != this.strContext && !headerValue.startsWith(this.strContext + "/")) {
                headerValue = this.strContext + headerValue;
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Rewrote location header to {}", headerValue);
                }
                return headerValue;
            }
        } else if ((headerName.equalsIgnoreCase("Set-Cookie") || headerName.equalsIgnoreCase("Set-Cookie2")) && this._proxyTo.toLowerCase().startsWith("https")) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Deleted secure attribute from cookie {}", headerName);
            }
            headerValue = headerValue.replaceAll("; *(?i)secure", "");
        }
        return super.filterServerResponseHeader(clientRequest, serverResponse, headerName, headerValue);
    }

    @Override
    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        if (this.isOn(HttpHeader.VIA.toString().toLowerCase())) {
            this.addViaHeader(proxyRequest);
        } else if (this._log.isDebugEnabled()) {
            this._log.debug("Via header switched off", new Object[0]);
        }
        if (this.isOn(HttpHeader.X_FORWARDED_FOR.toString().toLowerCase())) {
            proxyRequest.header(HttpHeader.X_FORWARDED_FOR, clientRequest.getRemoteAddr());
        } else {
            this._log.debug(HttpHeader.X_FORWARDED_FOR.toString() + " header switched off", new Object[0]);
        }
        if (this.isOn(HttpHeader.X_FORWARDED_PROTO.toString().toLowerCase())) {
            proxyRequest.header(HttpHeader.X_FORWARDED_PROTO, clientRequest.getScheme());
        } else {
            this._log.debug(HttpHeader.X_FORWARDED_PROTO.toString() + " header switched off", new Object[0]);
        }
        if (this.isOn(HttpHeader.X_FORWARDED_HOST.toString().toLowerCase())) {
            proxyRequest.header(HttpHeader.X_FORWARDED_HOST, clientRequest.getHeader(HttpHeader.HOST.asString()));
        } else {
            this._log.debug(HttpHeader.X_FORWARDED_HOST.toString() + " header switched off", new Object[0]);
        }
        if (this.isOn(HttpHeader.X_FORWARDED_SERVER.toString().toLowerCase())) {
            proxyRequest.header(HttpHeader.X_FORWARDED_SERVER, clientRequest.getLocalName());
        } else {
            this._log.debug(HttpHeader.X_FORWARDED_SERVER.toString() + " header switched off", new Object[0]);
        }
    }

    @Override
    protected String rewriteTarget(HttpServletRequest request) {
        URI rewrittenURI;
        String query;
        String rest;
        String path = request.getRequestURI();
        if (!path.startsWith(this._prefix)) {
            return null;
        }
        StringBuilder uri = new StringBuilder(this._proxyTo);
        if (this._proxyTo.endsWith("/")) {
            uri.setLength(uri.length() - 1);
        }
        if (!(rest = path.substring(this._prefix.length())).isEmpty()) {
            if (!rest.startsWith("/")) {
                uri.append("/");
            }
            uri.append(rest);
        }
        if ((query = request.getQueryString()) != null) {
            String separator = "://";
            if (uri.indexOf("/", uri.indexOf(separator) + separator.length()) < 0) {
                uri.append("/");
            }
            uri.append("?").append(query);
        }
        if (!this.validateDestination((rewrittenURI = URI.create(uri.toString()).normalize()).getHost(), rewrittenURI.getPort())) {
            return null;
        }
        return rewrittenURI.toString();
    }

    private boolean isOn(String name) {
        String value = this.headers.get(name);
        return null == value || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true");
    }

    @Override
    protected URI rewriteURI(HttpServletRequest request) {
        return URI.create(this.rewriteTarget(request));
    }
}

