/*
 * Decompiled with CFR 0.152.
 */
package hr.istratech.proxy;

import hr.istratech.proxy.SSLProxyServlet;
import hr.istratech.proxy.config.Configuration;
import hr.istratech.proxy.config.Logging;
import hr.istratech.proxy.config.Server;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.eclipse.jetty.proxy.ConnectHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;

public class Proxy {
    private org.eclipse.jetty.server.Server httpServer = null;
    private List<org.eclipse.jetty.server.Server> servers = new ArrayList<org.eclipse.jetty.server.Server>();
    private Configuration configuration;
    private final String version = "1.3.2";
    private static Proxy proxy = new Proxy();
    public static String DEFAULT_CONF_FNAME = "proxy.conf";
    private boolean running = true;

    public String getVersion() {
        return "1.3.2";
    }

    public static void windowsService(String[] args) {
        String cmd = "start";
        if (args.length > 0) {
            cmd = args[0];
        }
        if ("start".equals(cmd)) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.S ");
                String strDate = formatter.format(new Date());
                System.out.println(strDate + " Pokretanje I3Fiskal servisa");
                proxy.loadAndStart(DEFAULT_CONF_FNAME);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            proxy.stopProxy();
        }
    }

    private void setRunning(boolean running) {
        this.running = running;
    }

    private boolean getRunning() {
        return this.running;
    }

    private boolean connectorExist(org.eclipse.jetty.server.Server server, int port) {
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof ServerConnector) || ((ServerConnector)connector).getPort() != port) continue;
            return true;
        }
        return false;
    }

    private boolean startProxy() throws ServletException {
        PrintStream serverLogStream = null;
        StdErrLog logger = new StdErrLog();
        try {
            serverLogStream = new PrintStream(new RolloverFileOutputStream("proxy-yyyy_mm_dd.log", true, this.configuration.getLogging().getHistory()));
            logger.setStdErrStream(serverLogStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log.setLog(logger);
        logger.setLevel(Logging.getLogLevel(this.configuration.getLogging().getLevel()));
        org.eclipse.jetty.server.Server httpServer = new org.eclipse.jetty.server.Server();
        httpServer.addBean(Log.getLog());
        HandlerCollection collection = new HandlerCollection();
        System.out.println("Starting: ");
        for (Server serverConfig : this.configuration.getServers()) {
            String srcContextPath = serverConfig.getPath();
            if (srcContextPath.endsWith("/*")) {
                srcContextPath = srcContextPath.substring(0, srcContextPath.length() - 2);
            } else if (srcContextPath.length() > 1 && srcContextPath.endsWith("/")) {
                srcContextPath = srcContextPath.substring(0, srcContextPath.length() - 1);
            }
            if (!this.connectorExist(httpServer, serverConfig.getPort())) {
                ServerConnector proxyConnector = new ServerConnector(httpServer);
                proxyConnector.setReuseAddress(true);
                proxyConnector.setPort(serverConfig.getPort());
                proxyConnector.setName("Proxy" + serverConfig.getPort().toString());
                httpServer.addConnector(proxyConnector);
            } else {
                boolean bDuplicateContext = false;
                for (Handler handler : collection.getHandlers()) {
                    if (!(handler instanceof ServletContextHandler)) continue;
                    String contextPath = ((ServletContextHandler)handler).getContextPath();
                    if (!((ServletContextHandler)handler).getContextPath().equalsIgnoreCase(srcContextPath)) continue;
                    System.out.println("!!! Duplicate context path. proxy on \":" + serverConfig.getPort() + srcContextPath + "\" for \"" + serverConfig.getUrl() + "\" won't be started !!!");
                    Log.getLog().warn("Duplicate context path \"{}\" on port {}, proxy for \"{}\" won't be started", contextPath, serverConfig.getPort(), serverConfig.getUrl());
                    bDuplicateContext = true;
                    break;
                }
                if (bDuplicateContext) continue;
            }
            System.out.println("proxy on \":" + serverConfig.getPort() + srcContextPath + "\" for \"" + serverConfig.getUrl() + "\"");
            ConnectHandler proxy = new ConnectHandler();
            ServletHolder proxyServlet = new ServletHolder(SSLProxyServlet.class);
            ServletContextHandler context = new ServletContextHandler(proxy, serverConfig.getPath(), 1);
            context.setContextPath(srcContextPath);
            context.addServlet(proxyServlet, "/*");
            context.setVirtualHosts(new String[]{"@Proxy" + serverConfig.getPort().toString()});
            collection.addHandler(context);
            for (Map.Entry<String, String> header : serverConfig.getHeaders().entrySet()) {
                if (header.getKey().equalsIgnoreCase("host")) {
                    String strHost = header.getValue();
                    if (null == strHost) {
                        strHost = "false";
                    }
                    if (strHost.equalsIgnoreCase("preserve") || strHost.equalsIgnoreCase("on") || strHost.equalsIgnoreCase("true")) {
                        proxyServlet.setInitParameter("preserveHost", "true");
                        continue;
                    }
                    if (strHost.equalsIgnoreCase("change")) {
                        if (serverConfig.getPort() == 80 || serverConfig.getPort() == 443) {
                            proxyServlet.setInitParameter("hostHeader", Proxy.getLocalHost());
                            continue;
                        }
                        proxyServlet.setInitParameter("hostHeader", Proxy.getLocalHost() + ":" + serverConfig.getPort().toString());
                        continue;
                    }
                    proxyServlet.setInitParameter("preserveHost", "false");
                    continue;
                }
                proxyServlet.setInitParameter("#HEADER#" + header.getKey(), header.getValue());
            }
            proxyServlet.setInitParameter("contextPath", srcContextPath);
            proxyServlet.setInitParameter("servletPort", serverConfig.getPort().toString());
            proxyServlet.setInitParameter("traceLevel", serverConfig.getLogging().getLevel());
            proxyServlet.setInitParameter("traceHistory", serverConfig.getLogging().getHistory().toString());
            proxyServlet.setInitParameter("proxyTo", serverConfig.getUrl());
            proxyServlet.setInitParameter("timeout", serverConfig.getTimeout().toString());
            proxyServlet.setInitParameter("idleTimeout", serverConfig.getIdleTimeout().toString());
            if (null != serverConfig.getClientCert().getFile()) {
                proxyServlet.setInitParameter("clientCertFile", serverConfig.getClientCert().getFile());
            }
            if (null == serverConfig.getClientCert().getPassword()) continue;
            proxyServlet.setInitParameter("clientCertPassword", serverConfig.getClientCert().getPassword());
        }
        try {
            httpServer.setHandler(collection);
            httpServer.start();
            System.out.println("Proxy service has been started");
        }
        catch (Exception e) {
            System.out.println("Error at starting server, error:" + e.getMessage());
            Log.getLog().warn("Error at starting server", e);
            return false;
        }
        return true;
    }

    private void loadAndStart(String confFileName) throws IOException, ServletException {
        System.out.println("Istratech(c) Proxy " + this.getVersion());
        BufferedReader stdin = null;
        if (!Proxy.class.getResource("Proxy.class").getProtocol().equalsIgnoreCase("jar")) {
            stdin = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Enter \"quit\" to stop...");
        }
        this.loadConfig(confFileName);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Proxy.this.stopProxy();
            }
        });
        if (!this.startProxy()) {
            return;
        }
        this.setRunning(true);
        while (this.getRunning()) {
            try {
                Thread.sleep(100L);
                if (null == stdin || !stdin.ready() || stdin.readLine().compareToIgnoreCase("quit") != 0) continue;
                break;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.stopProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopProxy() {
        System.out.println("Shutting down...");
        try {
            if (null != this.httpServer) {
                this.httpServer.stop();
            }
            System.out.println("Proxy server has been stopped");
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.getLog().warn("Error at stopping server", e);
        }
        this.setRunning(false);
        Proxy proxy = this;
        synchronized (proxy) {
            this.notify();
        }
    }

    private void loadConfig(String fileName) throws IOException {
        this.configuration = Configuration.load(fileName);
    }

    public static String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    public static void main(String[] args) throws Exception {
        String headerValue = ".appId=1234;Path/; Secure; test ";
        headerValue = headerValue.replaceAll("; *(?i)secure", "");
        System.out.println(headerValue);
        headerValue = ".appId=1234;Path/;secure; test ";
        headerValue = headerValue.replaceAll("; *(?i)secure", "");
        System.out.println(headerValue);
        if (args.length > 0) {
            proxy.loadAndStart(args[0]);
        } else {
            proxy.loadAndStart(DEFAULT_CONF_FNAME);
        }
    }
}

