/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.DeployLock;
import com.sun.deploy.util.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.OCSP;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static CertStore browserUntrustedStore = null;
    private static List jurisdictionList = null;
    private static boolean isBrowserRootStoreLoaded = false;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static boolean ocspEECheck = false;
    private static HashSet deniedURL = null;
    private static DeployLock deployLock = null;
    public static final long PERMISSION_GRANTED_FOR_SESSION = 1L;
    public static final long PERMISSION_DENIED = 0L;
    private static final String SUN_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc";
    private static final String ORACLE_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Oracle Corporation";
    private static final String[] PRE_TRUSTED_NAMESPACES = new String[]{"OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc", "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Oracle Corporation"};
    private static final List preTrustList = Arrays.asList(PRE_TRUSTED_NAMESPACES);

    public static void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        boolean bl = false;
        try {
            bl = deployLock.lock();
            deniedStore = new DeniedCertStore();
            deniedURL.clear();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static HashSet getDeniedURL() {
        boolean bl = false;
        try {
            bl = deployLock.lock();
            HashSet hashSet = deniedURL;
            return hashSet;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static void reset() {
        boolean bl = false;
        try {
            bl = deployLock.lock();
            rootStore = RootCertStore.getCertStore();
            permanentStore = DeploySigningCertStore.getCertStore();
            sessionStore = new SessionCertStore();
            deniedStore = new DeniedCertStore();
            deniedURL = new HashSet();
            jurisdictionList = null;
            if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                Service service = ServiceManager.getService();
                browserRootStore = service.getBrowserSigningRootCertStore();
                browserTrustedStore = service.getBrowserTrustedCertStore();
                browserUntrustedStore = service.getBrowserUntrustedCertStore();
                isBrowserRootStoreLoaded = false;
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string;
                        crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                        if (crlCheck && (string = Config.getProperty("deployment.security.validation.crl.url")) != null && string.length() > 0) {
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                            URL uRL = new URL(string);
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setDoInput(true);
                            uRLConnection.setUseCaches(false);
                            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                            crl509 = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                            dataInputStream.close();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
                        if (ocspCheck) {
                            ocspSigner = Config.getProperty("deployment.security.validation.ocsp.signer");
                            ocspURL = Config.getProperty("deployment.security.validation.ocsp.url");
                            if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                                ocspValidConfig = true;
                            }
                        }
                        ocspEECheck = Config.getBooleanProperty("deployment.security.validation.ocsp.publisher");
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static long isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        AppInfo appInfo = new AppInfo();
        appInfo.setFrom(codeSource.getLocation());
        return TrustDecider.isAllPermissionGranted(codeSource, appInfo);
    }

    public static long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, appInfo, false);
    }

    public static synchronized long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, boolean bl) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        block102: {
            boolean bl2 = crlCheck;
            boolean bl3 = ocspCheck;
            boolean bl4 = ocspEECheck;
            boolean bl5 = false;
            try {
                bl5 = deployLock.lock();
                Certificate[] certificateArray = codeSource.getCertificates();
                URL uRL = codeSource.getLocation();
                if (certificateArray == null) {
                    long l = 0L;
                    return l;
                }
                DeployManifestChecker.verify(codeSource.getLocation(), true, appInfo);
                int n = 0;
                String string = null;
                rootStore.load();
                permanentStore.load();
                sessionStore.load();
                deniedStore.load();
                if (browserRootStore != null && !isBrowserRootStoreLoaded) {
                    browserRootStore.load();
                    isBrowserRootStoreLoaded = true;
                }
                if (browserTrustedStore != null) {
                    browserTrustedStore.load();
                }
                if (browserUntrustedStore != null) {
                    browserUntrustedStore.load();
                }
                List list = TrustDecider.breakDownMultiSignerChains(certificateArray);
                n = list.size();
                boolean bl6 = true;
                try {
                    Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
                    if (clazz == null) {
                        bl6 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
                    bl6 = false;
                }
                if (Config.isJavaVersionAtLeast16() && bl6) {
                    Object object;
                    Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
                    boolean bl7 = false;
                    boolean bl8 = false;
                    long l = 0L;
                    long l2 = 0L;
                    int n2 = 0;
                    int n3 = 0;
                    LinkedHashSet<X509Certificate> linkedHashSet = new LinkedHashSet<X509Certificate>();
                    linkedHashSet.addAll(rootStore.getCertificates());
                    if (browserRootStore != null) {
                        linkedHashSet.addAll(browserRootStore.getCertificates());
                    }
                    HashMap<X500Principal, X509Certificate> hashMap = new HashMap<X500Principal, X509Certificate>();
                    Iterator iterator = linkedHashSet.iterator();
                    while (iterator.hasNext()) {
                        object = (X509Certificate)iterator.next();
                        hashMap.put(((X509Certificate)object).getSubjectX500Principal(), (X509Certificate)object);
                    }
                    iterator = list.iterator();
                    n = 0;
                    while (iterator.hasNext()) {
                        Object object2;
                        Object object3;
                        boolean bl9;
                        Object object4;
                        Cloneable cloneable;
                        Date date;
                        X509Certificate x509Certificate;
                        int n4;
                        Certificate[] certificateArray2;
                        block101: {
                            X500Principal x500Principal;
                            object = (List)iterator.next();
                            certificateArray2 = object.toArray(new X509Certificate[0]);
                            CertificateExpiredException certificateExpiredException = null;
                            CertificateNotYetValidException certificateNotYetValidException = null;
                            l2 = Long.MAX_VALUE;
                            for (n4 = 0; n4 < certificateArray2.length; ++n4) {
                                block100: {
                                    long l3 = certificateArray2[n4].getNotAfter().getTime();
                                    if (l3 < l2) {
                                        l2 = l3;
                                    }
                                    try {
                                        certificateArray2[n4].checkValidity();
                                    }
                                    catch (CertificateExpiredException certificateExpiredException2) {
                                        if (certificateExpiredException == null) {
                                            certificateExpiredException = certificateExpiredException2;
                                            n2 = -1;
                                            n3 = -1;
                                            bl8 = true;
                                        }
                                    }
                                    catch (CertificateNotYetValidException certificateNotYetValidException2) {
                                        if (certificateNotYetValidException != null) break block100;
                                        certificateNotYetValidException = certificateNotYetValidException2;
                                        n2 = 1;
                                        n3 = 1;
                                        bl8 = true;
                                    }
                                }
                                if (browserUntrustedStore == null || !browserUntrustedStore.contains(certificateArray2[n4])) continue;
                                string = ResourceManager.getMessage("security.dialog.unverified.signed.publisher");
                                Trace.msgSecurityPrintln(string);
                                throw new CertificateException(string);
                            }
                            n4 = certificateArray2.length;
                            x509Certificate = certificateArray2[n4 - 1];
                            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                            if (((Object)x500Principal2).equals(x500Principal = x509Certificate.getSubjectX500Principal()) && !linkedHashSet.contains(x509Certificate)) {
                                if (!TrustDecider.isReplacedCA(hashMap, x509Certificate)) {
                                    if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                                        string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                                        throw new CertificateException(string);
                                    }
                                    bl7 = true;
                                }
                                linkedHashSet.add(x509Certificate);
                            }
                            date = null;
                            try {
                                CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                                Timestamp timestamp = codeSignerArray[n].getTimestamp();
                                if (timestamp != null) {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                                    date = timestamp.getTimestamp();
                                    CertPath certPath = timestamp.getSignerCertPath();
                                    if (bl8) {
                                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                                        cloneable = certificateArray2[0].getNotAfter();
                                        object4 = certificateArray2[0].getNotBefore();
                                        if (date.before((Date)cloneable) && date.after((Date)object4)) {
                                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                                            boolean bl10 = TrustDecider.checkTSAPath(certPath, linkedHashSet);
                                            if (bl10) {
                                                bl8 = false;
                                                n2 = 0;
                                            } else {
                                                date = null;
                                            }
                                        } else {
                                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                                        }
                                    } else {
                                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                                    }
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                                }
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
                            }
                            bl9 = false;
                            if (jurisdictionList != null) {
                                Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.found");
                                if (!bl7 && n2 == 0) {
                                    Trace.msgSecurityPrintln("trustdecider.check.trustextension.on");
                                    bl9 = TrustDecider.checkTrustedExtension(certificateArray2[0]);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.trustextension.off");
                                }
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.notfound");
                            }
                            if (!(bl7 || n3 != 0 || appInfo.getType() != 3 || bl || bl9 || permanentStore.contains(certificateArray2[0]))) {
                                bl4 = true;
                                Trace.msgSecurityPrintln("trustdecider.check.extensioninstall.on");
                            }
                            boolean bl11 = false;
                            boolean bl12 = false;
                            cloneable = null;
                            try {
                                int n5;
                                object4 = Validator.getInstance("PKIX", "plugin code signing", linkedHashSet);
                                object3 = (PKIXValidator)object4;
                                cloneable = ((PKIXValidator)object3).getParameters();
                                ((PKIXParameters)cloneable).addCertPathChecker(new DeployCertPathChecker((PKIXValidator)object3));
                                if (bl2) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
                                    if (crl509 != null) {
                                        bl11 = true;
                                    } else {
                                        for (n5 = 0; n5 < certificateArray2.length; ++n5) {
                                            if (!CertUtils.getCertCRLExtension(certificateArray2[n5])) continue;
                                            bl11 = true;
                                        }
                                    }
                                    cloneable = TrustDecider.doCRLValidation((PKIXParameters)cloneable, bl11);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
                                }
                                if (bl3) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
                                    if (ocspValidConfig) {
                                        bl12 = true;
                                    } else {
                                        for (n5 = 0; n5 < certificateArray2.length; ++n5) {
                                            if (!CertUtils.getCertAIAExtension(certificateArray2[n5])) continue;
                                            bl12 = true;
                                        }
                                    }
                                    TrustDecider.doOCSPValidation((PKIXParameters)cloneable, linkedHashSet, (X509Certificate[])certificateArray2, bl12, bl2);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
                                }
                                object2 = new X509Certificate[n4];
                                for (int i = 0; i < n4; ++i) {
                                    object2[i] = new X509CertificateWrapper(certificateArray2[i]);
                                }
                                ((Validator)object4).validate((X509Certificate[])object2);
                                if (bl2 && bl11 || bl3 && bl12) {
                                    Trace.msgSecurityPrintln("trustdecider.check.revocation.succeed");
                                }
                            }
                            catch (CertificateException certificateException) {
                                if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                                    throw new CertificateException(string);
                                }
                                if (certificateException instanceof ValidatorException) {
                                    object3 = (ValidatorException)certificateException;
                                    if (ValidatorException.T_NO_TRUST_ANCHOR.equals(((ValidatorException)object3).getErrorType())) {
                                        bl7 = true;
                                        break block101;
                                    }
                                    object2 = "Certificate has been revoked";
                                    if (bl2 && bl11 || bl3 && bl12) {
                                        String string2 = ((Throwable)object3).getMessage();
                                        if (string2.contains((CharSequence)object2)) {
                                            Trace.msgSecurityPrintln("trustdecider.check.validation.revoked");
                                        } else {
                                            Trace.msgSecurityPrintln(string2);
                                        }
                                        throw object3;
                                    }
                                    throw object3;
                                }
                                throw certificateException;
                            }
                            catch (IOException iOException) {
                                Trace.msgSecurityPrintln(iOException.getMessage());
                                throw iOException;
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                Trace.msgSecurityPrintln(invalidAlgorithmParameterException.getMessage());
                                throw invalidAlgorithmParameterException;
                            }
                            catch (CRLException cRLException) {
                                Trace.msgSecurityPrintln(cRLException.getMessage());
                                throw cRLException;
                            }
                            finally {
                                Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
                            }
                        }
                        if (bl4 && !bl3 && n4 > 1 && !bl9 && !bl7 && n3 == 0) {
                            if (!permanentStore.contains(certificateArray2[0])) {
                                try {
                                    object4 = TrustDecider.doOCSPEEValidation(certificateArray2[0], certificateArray2[1], linkedHashSet, ((PKIXParameters)cloneable).getDate());
                                    if (object4 != OCSP.RevocationStatus.CertStatus.GOOD) {
                                        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.bad");
                                        string = ResourceManager.getMessage("trustdecider.check.ocsp.ee.revoked");
                                        throw new CertificateException(string);
                                    }
                                    Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.good");
                                }
                                catch (IOException iOException) {
                                    Trace.msgSecurityPrintln(iOException.getMessage());
                                }
                                catch (CertPathValidatorException certPathValidatorException) {
                                    Trace.msgSecurityPrintln(certPathValidatorException.getMessage());
                                    throw new CertificateException(certPathValidatorException);
                                }
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.off");
                        }
                        if (bl7) {
                            linkedHashSet.remove(x509Certificate);
                        }
                        boolean bl13 = false;
                        if (deniedStore.contains(certificateArray2[0])) {
                            deniedURL.add(uRL);
                            bl13 = deniedStore.contains(certificateArray2[0], true) ? true : bl8;
                        }
                        if (!bl13) {
                            if (!(!permanentStore.contains(certificateArray2[0]) || bl8 && permanentStore.contains(certificateArray2[0], true))) {
                                long l4 = l2;
                                return l4;
                            }
                            if (bl9 && !permanentStore.contains(certificateArray2[0], true)) {
                                object3 = DeploySigningCertStore.getUserCertStore();
                                object3.load(true);
                                if (object3.add(certificateArray2[0], true)) {
                                    object3.save();
                                }
                                Trace.msgSecurityPrintln("trustdecider.check.trustextension.add");
                                long l5 = l2;
                                return l5;
                            }
                            if (!(!sessionStore.contains(certificateArray2[0]) || bl8 && sessionStore.contains(certificateArray2[0], true))) {
                                long l6 = 1L;
                                return l6;
                            }
                            if (browserTrustedStore != null && browserTrustedStore.contains(certificateArray2[0])) {
                                long l7 = 1L;
                                return l7;
                            }
                            if (!Config.getBooleanProperty("deployment.security.askgrantdialog.show")) {
                                string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                                throw new CertificateException(string);
                            }
                            if (bl5) {
                                deployLock.unlock();
                                bl5 = false;
                            }
                            int n6 = X509Util.showSecurityDialog(certificateArray2, codeSource.getLocation(), 0, n4, bl7, n2, date, appInfo, bl);
                            bl5 = deployLock.lock();
                            if (n6 == 0) {
                                Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                                sessionStore.add(certificateArray2[0], !bl8);
                                sessionStore.save();
                                l = 1L;
                            } else if (n6 == 2) {
                                Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                                object2 = DeploySigningCertStore.getUserCertStore();
                                object2.load(true);
                                if (object2.add(certificateArray2[0], !bl8)) {
                                    object2.save();
                                }
                                l = l2;
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.user.deny");
                                deniedStore.add(certificateArray2[0], !bl8);
                                deniedStore.save();
                                deniedURL.add(uRL);
                            }
                            if (l != 0L) {
                                long l8 = l;
                                return l8;
                            }
                        }
                        ++n;
                    }
                    break block102;
                }
                Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                if (CertValidator.validate(codeSource, appInfo, certificateArray, n, rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore)) {
                    long l = 1L;
                    return l;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            finally {
                if (bl5) {
                    deployLock.unlock();
                }
            }
        }
        return 0L;
    }

    private static boolean checkTSAPath(CertPath certPath, LinkedHashSet linkedHashSet) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        Validator validator = Validator.getInstance("PKIX", "tsa server", linkedHashSet);
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[0]);
        try {
            x509CertificateArray = validator.validate(x509CertificateArray);
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
            return false;
        }
        return true;
    }

    private static PKIXParameters doCRLValidation(PKIXParameters pKIXParameters, boolean bl) throws IOException, InvalidAlgorithmParameterException, CRLException, NoSuchAlgorithmException {
        if (crl509 != null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.on");
            System.clearProperty("com.sun.security.enableCRLDP");
            pKIXParameters.setRevocationEnabled(true);
            pKIXParameters.addCertStore(java.security.cert.CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl509))));
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.off");
            pKIXParameters.setRevocationEnabled(bl);
            System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(bl));
        }
        return pKIXParameters;
    }

    private static void doOCSPValidation(PKIXParameters pKIXParameters, LinkedHashSet linkedHashSet, X509Certificate[] x509CertificateArray, boolean bl, boolean bl2) throws IOException {
        X509Certificate x509Certificate = null;
        boolean bl3 = false;
        Security.setProperty("ocsp.enable", Boolean.toString(bl));
        if (ocspValidConfig) {
            Security.setProperty("ocsp.responderURL", ocspURL);
        }
        pKIXParameters.setRevocationEnabled(bl);
        if (ocspValidConfig) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.on");
            String string = null;
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                string = CertUtils.extractSubjectAliasName(x509Certificate);
                if (!ocspSigner.equals(string)) continue;
                bl3 = true;
                break;
            }
            if (bl3 && x509Certificate != null) {
                Security.setProperty("ocsp.responderCertSubjectName", x509Certificate.getSubjectX500Principal().getName());
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.off");
        }
        if (!bl2 && bl) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
    }

    private static OCSP.RevocationStatus.CertStatus doOCSPEEValidation(X509Certificate x509Certificate, X509Certificate x509Certificate2, LinkedHashSet linkedHashSet, Date date) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.start");
        URI uRI = null;
        X509Certificate x509Certificate3 = x509Certificate2;
        if (ocspValidConfig) {
            try {
                uRI = new URI(ocspURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
                return OCSP.RevocationStatus.CertStatus.GOOD;
            }
            object2 = linkedHashSet.iterator();
            while (object2.hasNext()) {
                object = (X509Certificate)object2.next();
                String string = CertUtils.extractSubjectAliasName((X509Certificate)object);
                if (!ocspSigner.equals(string)) continue;
                x509Certificate3 = object;
                break;
            }
        } else {
            uRI = OCSP.getResponderURI(x509Certificate);
        }
        if (uRI == null) {
            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
            return OCSP.RevocationStatus.CertStatus.GOOD;
        }
        object2 = uRI.toString();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.value", new Object[]{object2});
        object2 = OCSP.check((X509Certificate)x509Certificate, (X509Certificate)x509Certificate2, (URI)uRI, (X509Certificate)x509Certificate3, (Date)date).getCertStatus();
        object = ((Enum)object2).name();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.return.status", new Object[]{object});
        return object2;
    }

    private static boolean checkTrustedExtension(X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction");
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName();
        Iterator iterator = jurisdictionList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction.found");
            return true;
        }
        return false;
    }

    private static boolean isReplacedCA(HashMap hashMap, X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.replacedCA.start");
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        if (hashMap.containsKey(x500Principal) && TrustDecider.isSignatureValid((X509Certificate)hashMap.get(x500Principal), x509Certificate)) {
            Trace.msgSecurityPrintln("trustdecider.check.replacedCA.succeed");
            return true;
        }
        Trace.msgSecurityPrintln("trustdecider.check.replacedCA.failed");
        return false;
    }

    private static boolean isSignatureValid(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            x509Certificate2.verify(x509Certificate.getPublicKey());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRootCAValid(CodeSource codeSource) {
        Certificate[] certificateArray = codeSource.getCertificates();
        if (certificateArray == null || certificateArray.length == 0) {
            return false;
        }
        boolean bl = false;
        try {
            Iterator iterator;
            bl = deployLock.lock();
            rootStore.load();
            if (browserRootStore != null && !isBrowserRootStoreLoaded) {
                browserRootStore.load();
                isBrowserRootStoreLoaded = true;
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(rootStore.getCertificates());
            if (browserRootStore != null) {
                linkedHashSet.addAll(browserRootStore.getCertificates());
            }
            HashMap<X500Principal, Object> hashMap = new HashMap<X500Principal, Object>();
            Object object = linkedHashSet.iterator();
            while (object.hasNext()) {
                iterator = (X509Certificate)object.next();
                hashMap.put(((X509Certificate)((Object)iterator)).getSubjectX500Principal(), iterator);
            }
            object = TrustDecider.breakDownMultiSignerChains(certificateArray);
            iterator = object.iterator();
            if (iterator.hasNext()) {
                List list = (List)iterator.next();
                X509Certificate x509Certificate = (X509Certificate)list.get(list.size() - 1);
                if (linkedHashSet.contains(x509Certificate)) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (TrustDecider.isReplacedCA(hashMap, x509Certificate)) {
                    boolean bl3 = true;
                    return bl3;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
        return false;
    }

    protected static List breakDownMultiSignerChains(Certificate[] certificateArray) {
        int n = 0;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        while (n2 < certificateArray.length) {
            ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
            int n3 = n;
            while (n3 + 1 < certificateArray.length && certificateArray[n3] instanceof X509Certificate && certificateArray[n3 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n3], (X509Certificate)certificateArray[n3 + 1])) {
                ++n3;
            }
            n2 = n3 + 1;
            for (int i = n; i < n2; ++i) {
                arrayList2.add(certificateArray[i]);
            }
            arrayList.add(arrayList2);
            n = n2;
        }
        return arrayList;
    }

    static {
        deployLock = new DeployLock();
        TrustDecider.reset();
    }
}

