/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.JarSigningData;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile {
    private Reference signingDataRef;
    private final String resourceURL;
    private final File indexFile;
    private static Enumeration emptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    static /* synthetic */ Class class$java$util$jar$Manifest;

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile(new File(super.getName()), this.signingDataRef, this.resourceURL, this.indexFile);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
            throw new CloneNotSupportedException();
        }
    }

    protected CachedJarFile(CacheEntry cacheEntry) throws IOException {
        this(new File(cacheEntry.getResourceFilename()), new SoftReference<Object>(null), cacheEntry.getURL(), cacheEntry.getIndexFile());
    }

    private CachedJarFile(File file, Reference reference, String string, File file2) throws IOException {
        super(file, false);
        this.signingDataRef = reference;
        this.resourceURL = string;
        this.indexFile = file2;
        CachedJarFile.ensureAncestorKnowsAboutManifest(this);
        MemoryCache.addResourceReference(this, string);
    }

    static void ensureAncestorKnowsAboutManifest(final JarFile jarFile) throws IOException {
        if (!Config.isJavaVersionAtLeast16()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        try {
                            Field field = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedJarFile.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("manLoaded");
                            if (field != null) {
                                field.setAccessible(true);
                                field.setBoolean(jarFile, true);
                                return null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        }
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    public URL getResourceURL() {
        try {
            return new URL(this.resourceURL);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignored(malformedURLException);
            return null;
        }
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null || !this.indexFile.equals(cacheEntry.getIndexFile())) {
            String string = cacheEntry == null ? "No memory CacheEntry: " + this.resourceURL : "CachedJarFile.getCacheEntry: " + this.indexFile + " != " + cacheEntry.getIndexFile() + " for " + this.resourceURL;
            Trace.println(string, TraceLevel.CACHE);
            cacheEntry = CachedJarFile.recoverCacheEntry(this.indexFile, this.resourceURL);
            if (cacheEntry != null) {
                this.clearReferences();
            }
        }
        return cacheEntry;
    }

    static CacheEntry recoverCacheEntry(File file, String string) {
        CacheEntry cacheEntry = CachedJarFile.recoverOldCacheEntry(file, string);
        if (cacheEntry != null) {
            MemoryCache.addLoadedResource(string, cacheEntry);
            return cacheEntry;
        }
        return CachedJarFile.recoverWithLatestVersionCacheEntry(string);
    }

    private static CacheEntry recoverOldCacheEntry(File file, String string) {
        CacheEntry cacheEntry = null;
        if (file != null && file.isFile()) {
            try {
                cacheEntry = Cache.getCacheEntryFromFile(file, true);
                Trace.println("Recovered memory CacheEntry from: " + string, TraceLevel.CACHE);
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
            if (cacheEntry == null) {
                Trace.println("Failed to recover old CacheEntry for " + string + "from " + file, TraceLevel.CACHE);
            }
        }
        return cacheEntry;
    }

    private static CacheEntry recoverWithLatestVersionCacheEntry(String string) {
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = Cache.getCacheEntry(new URL(string), null, null);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        if (cacheEntry != null) {
            Trace.println("Recovered CacheEntry: " + cacheEntry, TraceLevel.CACHE);
        } else {
            Trace.println("Failed to recover with latest CacheEntry", TraceLevel.CACHE);
        }
        return cacheEntry;
    }

    synchronized JarSigningData getSigningData() {
        if (this.signingDataRef == null) {
            return null;
        }
        JarSigningData jarSigningData = (JarSigningData)this.signingDataRef.get();
        if (jarSigningData == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                jarSigningData = cacheEntry.getJarSigningData();
                this.signingDataRef = jarSigningData != null ? new SoftReference<JarSigningData>(jarSigningData) : null;
            } else {
                Trace.println("getSignerMap failed to get CacheEntry for " + this.resourceURL, TraceLevel.CACHE);
            }
        }
        return jarSigningData;
    }

    private synchronized void clearReferences() {
        CachedJarFile.clear(new Reference[]{this.signingDataRef});
    }

    static void clear(Reference[] referenceArray) {
        if (referenceArray == null) {
            return;
        }
        for (int i = 0; i < referenceArray.length; ++i) {
            if (referenceArray[i] == null) continue;
            referenceArray[i].clear();
        }
    }

    Enumeration entryNames(CodeSource[] codeSourceArray) {
        JarSigningData jarSigningData = this.getSigningData();
        if (jarSigningData != null && jarSigningData.matchStrictSingleSigning(codeSourceArray)) {
            return this.unsignedEntryNames(null);
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        if (jarSigningData != null) {
            bl = jarSigningData.collectEntryNamesBySigners(codeSourceArray, arrayList);
        }
        Map map = jarSigningData != null ? jarSigningData.getSignerMap() : null;
        final Iterator iterator = arrayList.iterator();
        final Enumeration enumeration = bl ? this.unsignedEntryNames(map) : emptyEnumeration;
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                if (iterator.hasNext()) {
                    this.name = (String)iterator.next();
                    return true;
                }
                if (enumeration.hasMoreElements()) {
                    this.name = (String)enumeration.nextElement();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration unsignedEntryNames(final Map map) {
        final Enumeration enumeration = this.entries();
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (JarUtil.canSkipEntry(zipEntry) || map != null && map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource[] getCodeSources(URL uRL) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSources(uRL) : new CodeSource[]{};
    }

    CodeSource getCodeSource(URL uRL, String string) {
        JarSigningData jarSigningData = this.getSigningData();
        return jarSigningData != null ? jarSigningData.getCodeSource(uRL, string) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile.this.getManifest();
            if (manifest != null) {
                Attributes attributes = manifest.getAttributes(this.getName());
                return attributes;
            }
            return null;
        }

        public Certificate[] getCertificates() {
            JarSigningData jarSigningData = CachedJarFile.this.getSigningData();
            if (jarSigningData != null) {
                return jarSigningData.getCertificates(this.getName());
            }
            return null;
        }

        public CodeSigner[] getCodeSigners() {
            JarSigningData jarSigningData = CachedJarFile.this.getSigningData();
            if (jarSigningData != null) {
                return jarSigningData.getCodeSigners(this.getName());
            }
            return null;
        }
    }
}

