/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.MS932DB;

public class MS932
extends Charset
implements HistoricallyNamedCharset {
    public MS932() {
        super("windows-31j", ExtendedCharsets.aliasesFor("windows-31j"));
    }

    public String historicalName() {
        return "MS932";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof MS932;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends MS932DB.Decoder
    implements DelegatableDecoder {
        JIS_X_0201.Decoder jisDec0201;

        private Decoder(Charset charset) {
            super(charset);
            this.jisDec0201 = new JIS_X_0201.Decoder(charset);
        }

        protected char decodeSingle(int n) {
            if ((n & 0xFF80) == 0) {
                return (char)n;
            }
            return this.jisDec0201.decode(n);
        }

        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return super.decodeLoop(byteBuffer, charBuffer);
        }

        public void implReset() {
            super.implReset();
        }

        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }

        protected boolean isLegalLeadingByte(int n) {
            return n >= 129 && n <= 159 || n >= 224 && n <= 252;
        }
    }

    private static class Encoder
    extends MS932DB.Encoder {
        private JIS_X_0201.Encoder jisEnc0201;

        private Encoder(Charset charset) {
            super(charset);
            this.jisEnc0201 = new JIS_X_0201.Encoder(charset);
        }

        protected int encodeSingle(char c) {
            if ((c & 0xFF80) == 0) {
                return (byte)c;
            }
            byte by = this.jisEnc0201.encode(c);
            if (by == 0) {
                return -1;
            }
            return by;
        }
    }
}

