/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    static final String OCSP_ENABLE_PROP = "ocsp.enable";
    static final String OCSP_URL_PROP = "ocsp.responderURL";
    static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;
    private boolean onlyEECert = false;

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathValidatorException {
        this(certPath, pKIXParameters, false);
    }

    OCSPChecker(CertPath certPath, PKIXParameters pKIXParameters, boolean bl) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pKIXParameters;
        this.onlyEECert = bl;
        List<? extends Certificate> list = this.cp.getCertificates();
        this.certs = list.toArray(new X509Certificate[list.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length + 1;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate certificate, Collection<String> collection) throws CertPathValidatorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        --this.remainingCerts;
        X509CertImpl x509CertImpl = null;
        try {
            x509CertImpl = X509CertImpl.toImpl((X509Certificate)certificate);
        }
        catch (CertificateException certificateException) {
            throw new CertPathValidatorException(certificateException);
        }
        if (this.onlyEECert && x509CertImpl.getBasicConstraints() != -1) {
            if (DEBUG != null) {
                DEBUG.println("Skipping revocation check, not end entity cert");
            }
            return;
        }
        String[] stringArray = OCSPChecker.getOCSPProperties();
        URI uRI = OCSPChecker.getOCSPServerURI(x509CertImpl, stringArray[0]);
        X500Principal x500Principal = null;
        X500Principal x500Principal2 = null;
        BigInteger bigInteger = null;
        if (stringArray[1] != null) {
            x500Principal = new X500Principal(stringArray[1]);
        } else if (stringArray[2] != null && stringArray[3] != null) {
            x500Principal2 = new X500Principal(stringArray[2]);
            String string = OCSPChecker.stripOutSeparators(stringArray[3]);
            bigInteger = new BigInteger(string, 16);
        } else if (stringArray[2] != null || stringArray[3] != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        boolean bl = false;
        if (x500Principal != null || x500Principal2 != null) {
            bl = true;
        }
        Object object5 = null;
        boolean bl2 = true;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        if (this.remainingCerts < this.certs.length) {
            object5 = this.certs[this.remainingCerts];
            bl2 = false;
            if (!bl) {
                arrayList.add((X509Certificate)object5);
                if (DEBUG != null) {
                    DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                }
            }
        }
        if (bl2 || bl) {
            Object object6;
            Object object7;
            Object object8;
            if (DEBUG != null && bl) {
                DEBUG.println("Searching trust anchors for issuer or responder certificate");
            }
            if (!(object4 = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                throw new CertPathValidatorException("Must specify at least one trust anchor");
            }
            object3 = x509CertImpl.getIssuerX500Principal();
            object2 = null;
            while (object4.hasNext() && (bl2 || bl)) {
                object = (TrustAnchor)object4.next();
                object8 = ((TrustAnchor)object).getTrustedCert();
                object7 = ((X509Certificate)object8).getSubjectX500Principal();
                if (bl2 && ((X500Principal)object3).equals(object7)) {
                    if (object2 == null && (object2 = (Object)x509CertImpl.getIssuerKeyIdentifier()) == null && DEBUG != null) {
                        DEBUG.println("No issuer key identifier (AKID) in the certificate being validated");
                    }
                    object6 = null;
                    if (object2 != null && (object6 = OCSPChecker.getKeyId((X509Certificate)object8)) != null) {
                        if (!Arrays.equals((byte[])object2, (byte[])object6)) continue;
                        if (DEBUG != null) {
                            DEBUG.println("Issuer certificate key ID: " + String.format("0x%0" + ((Object)object2).length * 2 + "x", new BigInteger(1, (byte[])object2)));
                        }
                    }
                    object5 = object8;
                    bl2 = false;
                    if (!bl && arrayList.isEmpty()) {
                        arrayList.add((X509Certificate)object8);
                        if (DEBUG != null) {
                            DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                        }
                    }
                }
                if (!bl || (x500Principal == null || !x500Principal.equals(object7)) && (x500Principal2 == null || bigInteger == null || !x500Principal2.equals(((X509Certificate)object8).getIssuerX500Principal()) || !bigInteger.equals(((X509Certificate)object8).getSerialNumber()))) continue;
                arrayList.add((X509Certificate)object8);
            }
            if (object5 == null) {
                throw new CertPathValidatorException("No trusted certificate for " + x509CertImpl.getIssuerDN());
            }
            if (bl) {
                if (DEBUG != null) {
                    DEBUG.println("Searching cert stores for responder's certificate");
                }
                object = null;
                if (x500Principal != null) {
                    object = new X509CertSelector();
                    ((X509CertSelector)object).setSubject(x500Principal);
                } else if (x500Principal2 != null && bigInteger != null) {
                    object = new X509CertSelector();
                    ((X509CertSelector)object).setIssuer(x500Principal2);
                    ((X509CertSelector)object).setSerialNumber(bigInteger);
                }
                if (object != null) {
                    object8 = this.pkixParams.getCertStores();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (CertStore)object7.next();
                        try {
                            arrayList.addAll(((CertStore)object6).getCertificates((CertSelector)object));
                        }
                        catch (CertStoreException certStoreException) {
                            if (DEBUG == null) continue;
                            DEBUG.println("CertStore exception:" + certStoreException);
                        }
                    }
                }
            }
        }
        if (bl && arrayList.isEmpty()) {
            throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
        }
        if (DEBUG != null) {
            DEBUG.println("Located " + arrayList.size() + " trusted responder certificate(s)");
        }
        object4 = null;
        object3 = null;
        try {
            object4 = new CertId((X509Certificate)object5, x509CertImpl.getSerialNumberObject());
            object3 = OCSP.check(Collections.singletonList(object4), uRI, arrayList, this.pkixParams.getDate());
        }
        catch (Exception exception) {
            if (exception instanceof CertPathValidatorException) {
                throw (CertPathValidatorException)exception;
            }
            throw new CertPathValidatorException(exception);
        }
        object2 = ((OCSPResponse)object3).getSingleResponse((CertId)object4);
        object = object2.getCertStatus();
        if (object == OCSP.RevocationStatus.CertStatus.REVOKED) {
            throw new CertificateRevokedException(this.cp, this.remainingCerts - 1);
        }
        if (object == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
            throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts - 1);
        }
    }

    private static URI getOCSPServerURI(X509CertImpl x509CertImpl, String string) throws CertPathValidatorException {
        if (string != null) {
            try {
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new CertPathValidatorException(uRISyntaxException);
            }
        }
        AuthorityInfoAccessExtension authorityInfoAccessExtension = x509CertImpl.getAuthorityInfoAccessExtension();
        if (authorityInfoAccessExtension == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        for (AccessDescription accessDescription : list) {
            GeneralName generalName;
            if (!accessDescription.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6) continue;
            URIName uRIName = (URIName)generalName.getName();
            return uRIName.getURI();
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] stringArray = new String[4];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                stringArray[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                stringArray[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                stringArray[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                stringArray[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return stringArray;
    }

    private static String stripOutSeparators(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < cArray.length; ++i) {
            if (HEX_DIGITS.indexOf(cArray[i]) == -1) continue;
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    static byte[] getKeyId(X509Certificate x509Certificate) {
        byte[] byArray;
        block3: {
            X509CertImpl x509CertImpl = null;
            byArray = null;
            try {
                x509CertImpl = X509CertImpl.toImpl(x509Certificate);
                byArray = x509CertImpl.getSubjectKeyIdentifier();
                if (byArray == null && DEBUG != null) {
                    DEBUG.println("No subject key identifier (SKID) in the certificate (Subject: " + x509Certificate.getSubjectX500Principal() + ")");
                }
            }
            catch (CertificateException certificateException) {
                if (DEBUG == null) break block3;
                DEBUG.println("Error parsing X.509 certificate (Subject: " + x509Certificate.getSubjectX500Principal() + ") " + certificateException);
            }
        }
        return byArray;
    }
}

