/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Random;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SourceChannelImpl;

class PipeImpl
extends Pipe {
    private static final int NUM_SECRET_BYTES = 16;
    private static final Random RANDOM_NUMBER_GENERATOR = new SecureRandom();
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;

    PipeImpl(SelectorProvider selectorProvider) throws IOException {
        try {
            AccessController.doPrivileged(new Initializer(selectorProvider));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    private class Initializer
    implements PrivilegedExceptionAction {
        private final SelectorProvider sp;

        private Initializer(SelectorProvider selectorProvider) {
            this.sp = selectorProvider;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object run() throws IOException {
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel3 = null;
            try {
                try {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(16);
                    ByteBuffer byteBuffer2 = ByteBuffer.allocate(16);
                    InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
                    assert (inetAddress.isLoopbackAddress());
                    abstractInterruptibleChannel = ServerSocketChannel.open();
                    ((ServerSocketChannel)abstractInterruptibleChannel).socket().bind(new InetSocketAddress(inetAddress, 0));
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, ((ServerSocketChannel)abstractInterruptibleChannel).socket().getLocalPort());
                    abstractInterruptibleChannel2 = SocketChannel.open(inetSocketAddress);
                    RANDOM_NUMBER_GENERATOR.nextBytes(byteBuffer.array());
                    do {
                        ((SocketChannel)abstractInterruptibleChannel2).write(byteBuffer);
                    } while (byteBuffer.hasRemaining());
                    byteBuffer.rewind();
                    while (true) {
                        abstractInterruptibleChannel3 = ((ServerSocketChannel)abstractInterruptibleChannel).accept();
                        do {
                            ((SocketChannel)abstractInterruptibleChannel3).read(byteBuffer2);
                        } while (byteBuffer2.hasRemaining());
                        byteBuffer2.rewind();
                        if (byteBuffer2.equals(byteBuffer)) {
                            PipeImpl.this.source = new SourceChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel2);
                            PipeImpl.this.sink = new SinkChannelImpl(this.sp, (SocketChannel)abstractInterruptibleChannel3);
                            break;
                        }
                        abstractInterruptibleChannel3.close();
                    }
                }
                catch (IOException iOException) {
                    try {
                        if (abstractInterruptibleChannel2 != null) {
                            abstractInterruptibleChannel2.close();
                        }
                        if (abstractInterruptibleChannel3 != null) {
                            abstractInterruptibleChannel3.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    IOException iOException3 = new IOException("Unable to establish loopback connection");
                    iOException3.initCause(iOException);
                    throw iOException3;
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (abstractInterruptibleChannel == null) throw throwable;
                    abstractInterruptibleChannel.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (abstractInterruptibleChannel == null) return null;
            abstractInterruptibleChannel.close();
            return null;
        }
    }
}

