/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.StringTokenizer;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private static final String INVALID_INSTANCE_MSG = "Trying to deserialize an invalid instance of JMXServiceURL";
    private static final Exception randomException;
    private static final BitSet alphaBitSet;
    private static final BitSet numericBitSet;
    private static final BitSet alphaNumericBitSet;
    private static final BitSet protocolBitSet;
    private static final BitSet hostNameBitSet;
    private String protocol;
    private String host;
    private int port;
    private String urlPath;
    private transient String toString;
    private static final ClassLogger logger;

    public JMXServiceURL(String string) throws MalformedURLException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            n4 = string.charAt(i);
            if (n4 >= 32 && n4 < 127) continue;
            throw new MalformedURLException("Service URL contains non-ASCII character 0x" + Integer.toHexString(n4));
        }
        n4 = "service:jmx:".length();
        if (!string.regionMatches(true, 0, "service:jmx:", 0, n4)) {
            throw new MalformedURLException("Service URL must start with service:jmx:");
        }
        int[] nArray = new int[1];
        int n6 = n4;
        int n7 = JMXServiceURL.indexOf(string, ':', n6);
        this.protocol = string.substring(n6, n7).toLowerCase();
        if (!string.regionMatches(n7, "://", 0, 3)) {
            throw new MalformedURLException("Missing \"://\" after protocol name");
        }
        int n8 = n7 + 3;
        if (n8 < n5 && string.charAt(n8) == '[') {
            n3 = string.indexOf(93, n8) + 1;
            if (n3 == 0) {
                throw new MalformedURLException("Bad host name: [ without ]");
            }
            this.host = string.substring(n8 + 1, n3 - 1);
            if (!JMXServiceURL.isNumericIPv6Address(this.host)) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
        } else {
            n3 = JMXServiceURL.indexOfFirstNotInSet(string, hostNameBitSet, n8);
            this.host = string.substring(n8, n3);
        }
        if (n3 < n5 && string.charAt(n3) == ':') {
            if (this.host.length() == 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            n2 = n3 + 1;
            n = JMXServiceURL.indexOfFirstNotInSet(string, numericBitSet, n2);
            String string2 = string.substring(n2, n);
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Bad port number: \"" + string2 + "\": " + numberFormatException);
            }
        } else {
            n = n3;
            this.port = 0;
        }
        this.urlPath = (n2 = n) < n5 ? string.substring(n2) : "";
        this.validate();
    }

    public JMXServiceURL(String string, String string2, int n) throws MalformedURLException {
        this(string, string2, n, null);
    }

    public JMXServiceURL(String string, String string2, int n, String string3) throws MalformedURLException {
        if (string == null) {
            string = "jmxmp";
        }
        if (string2 == null) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedURLException("Local host name unknown: " + unknownHostException);
            }
            string2 = inetAddress.getHostName();
            try {
                JMXServiceURL.validateHost(string2, n);
            }
            catch (MalformedURLException malformedURLException) {
                if (logger.fineOn()) {
                    logger.fine("JMXServiceURL", "Replacing illegal local host name " + string2 + " with numeric IP address " + "(see RFC 1034)", malformedURLException);
                }
                string2 = inetAddress.getHostAddress();
            }
        }
        if (string2.startsWith("[")) {
            if (!string2.endsWith("]")) {
                throw new MalformedURLException("Host starts with [ but does not end with ]");
            }
            if (!JMXServiceURL.isNumericIPv6Address(string2 = string2.substring(1, string2.length() - 1))) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
            if (string2.startsWith("[")) {
                throw new MalformedURLException("More than one [[...]]");
            }
        }
        this.protocol = string.toLowerCase();
        this.host = string2;
        this.port = n;
        if (string3 == null) {
            string3 = "";
        }
        this.urlPath = string3;
        this.validate();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("host", null);
        int n = getField.get("port", -1);
        String string2 = (String)getField.get("protocol", null);
        String string3 = (String)getField.get("urlPath", null);
        if (string2 == null || string3 == null || string == null) {
            StringBuilder stringBuilder = new StringBuilder(INVALID_INSTANCE_MSG).append('[');
            boolean bl = true;
            if (string2 == null) {
                stringBuilder.append("protocol=null");
                bl = false;
            }
            if (string == null) {
                stringBuilder.append(bl ? "" : ",").append("host=null");
                bl = false;
            }
            if (string3 == null) {
                stringBuilder.append(bl ? "" : ",").append("urlPath=null");
            }
            stringBuilder.append(']');
            throw new InvalidObjectException(stringBuilder.toString());
        }
        if (string.contains("[") || string.contains("]")) {
            throw new InvalidObjectException("Invalid host name: " + string);
        }
        try {
            this.validate(string2, string, n, string3);
            this.protocol = string2;
            this.host = string;
            this.port = n;
            this.urlPath = string3;
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidObjectException("Trying to deserialize an invalid instance of JMXServiceURL: " + malformedURLException.getMessage());
        }
    }

    private void validate(String string, String string2, int n, String string3) throws MalformedURLException {
        int n2 = JMXServiceURL.indexOfFirstNotInSet(string, protocolBitSet, 0);
        if (n2 == 0 || n2 < string.length() || !alphaBitSet.get(string.charAt(0))) {
            throw new MalformedURLException("Missing or invalid protocol name: \"" + string + "\"");
        }
        JMXServiceURL.validateHost(string2, n);
        if (n < 0) {
            throw new MalformedURLException("Bad port: " + n);
        }
        if (string3.length() > 0 && !string3.startsWith("/") && !string3.startsWith(";")) {
            throw new MalformedURLException("Bad URL path: " + string3);
        }
    }

    private void validate() throws MalformedURLException {
        this.validate(this.protocol, this.host, this.port, this.urlPath);
    }

    private static void validateHost(String string, int n) throws MalformedURLException {
        int n2;
        if (string.length() == 0) {
            if (n != 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            return;
        }
        if (JMXServiceURL.isNumericIPv6Address(string)) {
            try {
                InetAddress.getByName(string);
            }
            catch (Exception exception) {
                MalformedURLException malformedURLException = new MalformedURLException("Bad IPv6 address: " + string);
                EnvHelp.initCause(malformedURLException, exception);
                throw malformedURLException;
            }
        }
        int n3 = string.length();
        int n4 = 46;
        boolean bl = false;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            boolean bl2 = alphaNumericBitSet.get(n2);
            if (n4 == 46) {
                n5 = n2;
            }
            if (bl2) {
                n4 = 97;
                continue;
            }
            if (n2 == 45) {
                if (n4 == 46) break;
                n4 = 45;
                continue;
            }
            if (n2 == 46) {
                bl = true;
                if (n4 != 97) break;
                n4 = 46;
                continue;
            }
            n4 = 46;
            break;
        }
        try {
            if (n4 != 97) {
                throw randomException;
            }
            if (bl && !alphaBitSet.get(n5)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
                for (n2 = 0; n2 < 4; ++n2) {
                    String string2 = stringTokenizer.nextToken();
                    int n6 = Integer.parseInt(string2);
                    if (n6 < 0 || n6 > 255) {
                        throw randomException;
                    }
                    if (n2 >= 3 || stringTokenizer.nextToken().equals(".")) continue;
                    throw randomException;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    throw randomException;
                }
            }
        }
        catch (Exception exception) {
            throw new MalformedURLException("Bad host: \"" + string + "\"");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuffer stringBuffer = new StringBuffer("service:jmx:");
        stringBuffer.append(this.getProtocol()).append("://");
        String string = this.getHost();
        if (JMXServiceURL.isNumericIPv6Address(string)) {
            stringBuffer.append('[').append(string).append(']');
        } else {
            stringBuffer.append(string);
        }
        int n = this.getPort();
        if (n != 0) {
            stringBuffer.append(':').append(n);
        }
        stringBuffer.append(this.getURLPath());
        this.toString = stringBuffer.toString();
        return this.toString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JMXServiceURL)) {
            return false;
        }
        JMXServiceURL jMXServiceURL = (JMXServiceURL)object;
        return jMXServiceURL.getProtocol().equalsIgnoreCase(this.getProtocol()) && jMXServiceURL.getHost().equalsIgnoreCase(this.getHost()) && jMXServiceURL.getPort() == this.getPort() && jMXServiceURL.getURLPath().equals(this.getURLPath());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static boolean isNumericIPv6Address(String string) {
        return string.indexOf(58) >= 0;
    }

    private static int indexOf(String string, char c, int n) {
        int n2 = string.indexOf(c, n);
        if (n2 < 0) {
            return string.length();
        }
        return n2;
    }

    private static int indexOfFirstNotInSet(String string, BitSet bitSet, int n) {
        char c;
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && (c = string.charAt(n2)) < '\u0080' && bitSet.get(c); ++n2) {
        }
        return n2;
    }

    private static void addCharsToBitSet(BitSet bitSet, String string) {
        for (int i = 0; i < string.length(); ++i) {
            bitSet.set(string.charAt(i));
        }
    }

    static {
        int n;
        randomException = new Exception();
        alphaBitSet = new BitSet(128);
        numericBitSet = new BitSet(128);
        alphaNumericBitSet = new BitSet(128);
        protocolBitSet = new BitSet(128);
        hostNameBitSet = new BitSet(128);
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            numericBitSet.set(n);
        }
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            alphaBitSet.set(n);
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            alphaBitSet.set(n);
        }
        alphaNumericBitSet.or(alphaBitSet);
        alphaNumericBitSet.or(numericBitSet);
        protocolBitSet.or(alphaNumericBitSet);
        protocolBitSet.set(43);
        protocolBitSet.set(45);
        hostNameBitSet.or(alphaNumericBitSet);
        hostNameBitSet.set(45);
        hostNameBitSet.set(46);
        logger = new ClassLogger("javax.management.remote.misc", "JMXServiceURL");
    }
}

