/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private MailcapFile[] DB;
    private static final int PROG = 0;

    public MailcapCommandMap() {
        String string;
        ArrayList<MailcapFile> arrayList = new ArrayList<MailcapFile>(5);
        MailcapFile mailcapFile = null;
        arrayList.add(null);
        LogSupport.log("MailcapCommandMap: load HOME");
        try {
            String string2;
            string = System.getProperty("user.home");
            if (string != null && (mailcapFile = this.loadFile(string2 = string + File.separator + ".mailcap")) != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load SYS");
        try {
            string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            mailcapFile = this.loadFile(string);
            if (mailcapFile != null) {
                arrayList.add(mailcapFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load JAR");
        this.loadAllResources(arrayList, "META-INF/mailcap");
        LogSupport.log("MailcapCommandMap: load DEF");
        mailcapFile = this.loadResource("/META-INF/mailcap.default");
        if (mailcapFile != null) {
            arrayList.add(mailcapFile);
        }
        this.DB = new MailcapFile[arrayList.size()];
        this.DB = arrayList.toArray(this.DB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailcapFile loadResource(String string) {
        InputStream inputStream = null;
        try {
            inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                MailcapFile mailcapFile = new MailcapFile(inputStream);
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: successfully loaded mailcap file: " + string);
                }
                MailcapFile mailcapFile2 = mailcapFile;
                return mailcapFile2;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: not loading mailcap file: " + string);
            }
        }
        catch (IOException iOException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: can't load " + string, iOException);
            }
        }
        catch (SecurityException securityException) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: can't load " + string, securityException);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(List list, String string) {
        Object object;
        boolean bl;
        block26: {
            bl = false;
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                if ((object = classLoader != null ? SecuritySupport.getResources(classLoader, string) : SecuritySupport.getSystemResources(string)) == null) break block26;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: getResources");
                }
                for (int i = 0; i < ((URL[])object).length; ++i) {
                    URL uRL = object[i];
                    InputStream inputStream = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: URL " + uRL);
                    }
                    try {
                        inputStream = SecuritySupport.openStream(uRL);
                        if (inputStream != null) {
                            list.add(new MailcapFile(inputStream));
                            bl = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log("MailcapCommandMap: successfully loaded mailcap file from URL: " + uRL);
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: not loading mailcap file from URL: " + uRL);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: can't load " + uRL, iOException);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: can't load " + uRL, securityException);
                        continue;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block26;
                LogSupport.log("MailcapCommandMap: can't load " + string, exception);
            }
        }
        if (!bl) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: !anyLoaded");
            }
            if ((object = this.loadResource("/" + string)) != null) {
                list.add(object);
            }
        }
    }

    private MailcapFile loadFile(String string) {
        MailcapFile mailcapFile = null;
        try {
            mailcapFile = new MailcapFile(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mailcapFile;
    }

    public MailcapCommandMap(String string) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG from " + string);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(string);
        }
    }

    public MailcapCommandMap(InputStream inputStream) {
        this();
        LogSupport.log("MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String string) {
        Map map;
        int n;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null) continue;
            this.appendPrefCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendPrefCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            if (this.checkForVerb(list, string)) continue;
            List list2 = (List)map.get(string);
            String string2 = (String)list2.get(0);
            list.add(new CommandInfo(string, string2));
        }
    }

    private boolean checkForVerb(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = ((CommandInfo)iterator.next()).getCommandName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String string) {
        Map map;
        int n;
        ArrayList arrayList = new ArrayList();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null) continue;
            this.appendCmdsToList(map, arrayList);
        }
        CommandInfo[] commandInfoArray = new CommandInfo[arrayList.size()];
        commandInfoArray = arrayList.toArray(commandInfoArray);
        return commandInfoArray;
    }

    private void appendCmdsToList(Map map, List list) {
        for (String string : map.keySet()) {
            List list2 = (List)map.get(string);
            for (String string2 : list2) {
                list.add(new CommandInfo(string, string2));
            }
        }
    }

    public synchronized CommandInfo getCommand(String string, String string2) {
        String string3;
        List list;
        Map map;
        int n;
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null || (map = this.DB[n].getMailcapFallbackList(string)) == null || (list = (List)map.get(string2)) == null || (string3 = (String)list.get(0)) == null) continue;
            return new CommandInfo(string2, string3);
        }
        return null;
    }

    public synchronized void addMailcap(String string) {
        LogSupport.log("MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(string);
    }

    public synchronized DataContentHandler createDataContentHandler(String string) {
        String string2;
        DataContentHandler dataContentHandler;
        List list;
        Map map;
        int n;
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: createDataContentHandler for " + string);
        }
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search DB #" + n);
            }
            if ((map = this.DB[n].getMailcapList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        for (n = 0; n < this.DB.length; ++n) {
            if (this.DB[n] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search fallback DB #" + n);
            }
            if ((map = this.DB[n].getMailcapFallbackList(string)) == null || (list = (List)map.get("content-handler")) == null || (dataContentHandler = this.getDataContentHandler(string2 = (String)list.get(0))) == null) continue;
            return dataContentHandler;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String string) {
        block12: {
            if (LogSupport.isLoggable()) {
                LogSupport.log("    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("      class " + string);
            }
            try {
                ClassLoader classLoader = null;
                classLoader = SecuritySupport.getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Class<?> clazz = null;
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (Exception exception) {
                    clazz = Class.forName(string);
                }
                if (clazz != null) {
                    return (DataContentHandler)clazz.newInstance();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Can't load DCH " + string, illegalAccessException);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Can't load DCH " + string, classNotFoundException);
                }
            }
            catch (InstantiationException instantiationException) {
                if (!LogSupport.isLoggable()) break block12;
                LogSupport.log("Can't load DCH " + string, instantiationException);
            }
        }
        return null;
    }

    public synchronized String[] getMimeTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.DB.length; ++i) {
            String[] stringArray;
            if (this.DB[i] == null || (stringArray = this.DB[i].getMimeTypes()) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (arrayList.contains(stringArray[j])) continue;
                arrayList.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] getNativeCommands(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String[] stringArray;
            if (this.DB[i] == null || (stringArray = this.DB[i].getNativeCommands(string)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (arrayList.contains(stringArray[j])) continue;
                arrayList.add(stringArray[j]);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }
}

