/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;

public final class Inet4Address
extends InetAddress {
    static final int INADDRSZ = 4;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int loopback = 2130706433;

    Inet4Address() {
        this.holder().hostName = null;
        this.holder().address = 0;
        this.holder().family = 1;
    }

    Inet4Address(String string, byte[] byArray) {
        this.holder().hostName = string;
        this.holder().family = 1;
        if (byArray != null && byArray.length == 4) {
            int n = byArray[3] & 0xFF;
            n |= byArray[2] << 8 & 0xFF00;
            n |= byArray[1] << 16 & 0xFF0000;
            this.holder().address = n |= byArray[0] << 24 & 0xFF000000;
        }
        this.holder().originalHostName = string;
    }

    Inet4Address(String string, int n) {
        this.holder().hostName = string;
        this.holder().family = 1;
        this.holder().address = n;
        this.holder().originalHostName = string;
    }

    private Object writeReplace() throws ObjectStreamException {
        InetAddress inetAddress = new InetAddress();
        inetAddress.holder().hostName = this.holder().getHostName();
        inetAddress.holder().address = this.holder().getAddress();
        inetAddress.holder().family = 2;
        return inetAddress;
    }

    public boolean isMulticastAddress() {
        return (this.holder().getAddress() & 0xF0000000) == -536870912;
    }

    public boolean isAnyLocalAddress() {
        return this.holder().getAddress() == 0;
    }

    public boolean isLoopbackAddress() {
        byte[] byArray = this.getAddress();
        return byArray[0] == 127;
    }

    public boolean isLinkLocalAddress() {
        int n = this.holder().getAddress();
        return (n >>> 24 & 0xFF) == 169 && (n >>> 16 & 0xFF) == 254;
    }

    public boolean isSiteLocalAddress() {
        int n = this.holder().getAddress();
        return (n >>> 24 & 0xFF) == 10 || (n >>> 24 & 0xFF) == 172 && (n >>> 16 & 0xF0) == 16 || (n >>> 24 & 0xFF) == 192 && (n >>> 16 & 0xFF) == 168;
    }

    public boolean isMCGlobal() {
        byte[] byArray = this.getAddress();
        return (byArray[0] & 0xFF) >= 224 && (byArray[0] & 0xFF) <= 238 && ((byArray[0] & 0xFF) != 224 || byArray[1] != 0 || byArray[2] != 0);
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        int n = this.holder().getAddress();
        return (n >>> 24 & 0xFF) == 224 && (n >>> 16 & 0xFF) == 0 && (n >>> 8 & 0xFF) == 0;
    }

    public boolean isMCSiteLocal() {
        int n = this.holder().getAddress();
        return (n >>> 24 & 0xFF) == 239 && (n >>> 16 & 0xFF) == 255;
    }

    public boolean isMCOrgLocal() {
        int n = this.holder().getAddress();
        return (n >>> 24 & 0xFF) == 239 && (n >>> 16 & 0xFF) >= 192 && (n >>> 16 & 0xFF) <= 195;
    }

    public byte[] getAddress() {
        int n = this.holder().getAddress();
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public String getHostAddress() {
        return Inet4Address.numericToTextFormat(this.getAddress());
    }

    public int hashCode() {
        return this.holder().getAddress();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Inet4Address && ((InetAddress)object).holder().getAddress() == this.holder().getAddress();
    }

    static String numericToTextFormat(byte[] byArray) {
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    private static native void init();

    static {
        Inet4Address.init();
    }
}

