/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.xml.internal.stream.util.BufferAllocator;
import com.sun.xml.internal.stream.util.ThreadLocalBufferAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class Entity {
    public String name;
    public boolean inExternalSubset;

    public Entity() {
        this.clear();
    }

    public Entity(String string, boolean bl) {
        this.name = string;
        this.inExternalSubset = bl;
    }

    public boolean isEntityDeclInExternalSubset() {
        return this.inExternalSubset;
    }

    public abstract boolean isExternal();

    public abstract boolean isUnparsed();

    public void clear() {
        this.name = null;
        this.inExternalSubset = false;
    }

    public void setValues(Entity entity) {
        this.name = entity.name;
        this.inExternalSubset = entity.inExternalSubset;
    }

    public static class ExternalEntity
    extends Entity {
        public XMLResourceIdentifier entityLocation;
        public String notation;

        public ExternalEntity() {
            this.clear();
        }

        public ExternalEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, boolean bl) {
            super(string, bl);
            this.entityLocation = xMLResourceIdentifier;
            this.notation = string2;
        }

        public final boolean isExternal() {
            return true;
        }

        public final boolean isUnparsed() {
            return this.notation != null;
        }

        public void clear() {
            super.clear();
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.entityLocation = null;
            this.notation = null;
        }

        public void setValues(ExternalEntity externalEntity) {
            super.setValues(externalEntity);
            this.entityLocation = externalEntity.entityLocation;
            this.notation = externalEntity.notation;
        }
    }

    public static class InternalEntity
    extends Entity {
        public String text;

        public InternalEntity() {
            this.clear();
        }

        public InternalEntity(String string, String string2, boolean bl) {
            super(string, bl);
            this.text = string2;
        }

        public final boolean isExternal() {
            return false;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public void clear() {
            super.clear();
            this.text = null;
        }

        public void setValues(Entity entity) {
            super.setValues(entity);
            this.text = null;
        }

        public void setValues(InternalEntity internalEntity) {
            super.setValues(internalEntity);
            this.text = internalEntity.text;
        }
    }

    public static class ScannedEntity
    extends Entity {
        public static final int DEFAULT_BUFFER_SIZE = 8192;
        public int fBufferSize = 8192;
        public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 28;
        public static final int DEFAULT_INTERNAL_BUFFER_SIZE = 1024;
        public InputStream stream;
        public Reader reader;
        public XMLResourceIdentifier entityLocation;
        public String encoding;
        public boolean literal;
        public boolean isExternal;
        public String version;
        public char[] ch = null;
        public int position;
        public int count;
        public int lineNumber = 1;
        public int columnNumber = 1;
        boolean declaredEncoding = false;
        boolean externallySpecifiedEncoding = false;
        public String xmlVersion = "1.0";
        public int fTotalCountTillLastLoad;
        public int fLastCount;
        public int baseCharOffset;
        public int startPosition;
        public boolean mayReadChunks;
        public boolean xmlDeclChunkRead = false;
        public boolean isGE = false;

        public String getEncodingName() {
            return this.encoding;
        }

        public String getEntityVersion() {
            return this.version;
        }

        public void setEntityVersion(String string) {
            this.version = string;
        }

        public Reader getEntityReader() {
            return this.reader;
        }

        public InputStream getEntityInputStream() {
            return this.stream;
        }

        public ScannedEntity(boolean bl, String string, XMLResourceIdentifier xMLResourceIdentifier, InputStream inputStream, Reader reader, String string2, boolean bl2, boolean bl3, boolean bl4) {
            this.isGE = bl;
            this.name = string;
            this.entityLocation = xMLResourceIdentifier;
            this.stream = inputStream;
            this.reader = reader;
            this.encoding = string2;
            this.literal = bl2;
            this.mayReadChunks = bl3;
            this.isExternal = bl4;
            int n = bl4 ? this.fBufferSize : 1024;
            BufferAllocator bufferAllocator = ThreadLocalBufferAllocator.getBufferAllocator();
            this.ch = bufferAllocator.getCharBuffer(n);
            if (this.ch == null) {
                this.ch = new char[n];
            }
        }

        public void close() throws IOException {
            BufferAllocator bufferAllocator = ThreadLocalBufferAllocator.getBufferAllocator();
            bufferAllocator.returnCharBuffer(this.ch);
            this.ch = null;
            this.reader.close();
        }

        public boolean isEncodingExternallySpecified() {
            return this.externallySpecifiedEncoding;
        }

        public void setEncodingExternallySpecified(boolean bl) {
            this.externallySpecifiedEncoding = bl;
        }

        public boolean isDeclaredEncoding() {
            return this.declaredEncoding;
        }

        public void setDeclaredEncoding(boolean bl) {
            this.declaredEncoding = bl;
        }

        public final boolean isExternal() {
            return this.isExternal;
        }

        public final boolean isUnparsed() {
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("name=\"" + this.name + '\"');
            stringBuffer.append(",ch=" + new String(this.ch));
            stringBuffer.append(",position=" + this.position);
            stringBuffer.append(",count=" + this.count);
            return stringBuffer.toString();
        }
    }
}

