/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.implementations.XPath2NodeFilter;
import com.sun.org.apache.xml.internal.security.transforms.params.XPath2FilterContainer;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathFuncHereAPI;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2002/06/xmldsig-filter2";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, Transform transform) throws TransformationException {
        CachedXPathAPIHolder.setDoc(transform.getElement().getOwnerDocument());
        try {
            ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList2 = new ArrayList<NodeList>();
            ArrayList<NodeList> arrayList3 = new ArrayList<NodeList>();
            CachedXPathFuncHereAPI cachedXPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            Element[] elementArray = XMLUtils.selectNodes(transform.getElement().getFirstChild(), implementedTransformURI, "XPath");
            int n = elementArray.length;
            if (n == 0) {
                Object[] objectArray = new Object[]{implementedTransformURI, "XPath"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            Document document = null;
            document = xMLSignatureInput.getSubNode() != null ? XMLUtils.getOwnerDocument(xMLSignatureInput.getSubNode()) : XMLUtils.getOwnerDocument(xMLSignatureInput.getNodeSet());
            for (int i = 0; i < n; ++i) {
                Element element = XMLUtils.selectNode(transform.getElement().getFirstChild(), implementedTransformURI, "XPath", i);
                XPath2FilterContainer xPath2FilterContainer = XPath2FilterContainer.newInstance(element, xMLSignatureInput.getSourceURI());
                NodeList nodeList = cachedXPathFuncHereAPI.selectNodeList(document, xPath2FilterContainer.getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(xPath2FilterContainer.getXPathFilterTextNode()), xPath2FilterContainer.getElement());
                if (xPath2FilterContainer.isIntersect()) {
                    arrayList3.add(nodeList);
                    continue;
                }
                if (xPath2FilterContainer.isSubtract()) {
                    arrayList2.add(nodeList);
                    continue;
                }
                if (!xPath2FilterContainer.isUnion()) continue;
                arrayList.add(nodeList);
            }
            xMLSignatureInput.addNodeFilter(new XPath2NodeFilter(arrayList, arrayList2, arrayList3));
            xMLSignatureInput.setNodeSet(true);
            return xMLSignatureInput;
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (DOMException dOMException) {
            throw new TransformationException("empty", dOMException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
        catch (SAXException sAXException) {
            throw new TransformationException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new TransformationException("empty", parserConfigurationException);
        }
    }
}

