/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.xalan.internal.xsltc.compiler.AttributeSet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.DecimalFormatting;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Key;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SyntaxTreeNode;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.VariableBase;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodType;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import jdk.xml.internal.HashMap;

final class SymbolTable {
    private final Map<String, Stylesheet> _stylesheets = new HashMap<String, Stylesheet>();
    private final Map<String, Vector> _primops = new HashMap<String, Vector>();
    private Map<String, VariableBase> _variables = null;
    private Map<String, Template> _templates = null;
    private Map<String, AttributeSet> _attributeSets = null;
    private Map<String, String> _aliases = null;
    private Map<String, Integer> _excludedURI = null;
    private Map<String, DecimalFormatting> _decimalFormats = null;
    private Map<String, Key> _keys = null;
    private int _nsCounter = 0;
    private SyntaxTreeNode _current = null;

    SymbolTable() {
    }

    public DecimalFormatting getDecimalFormatting(QName qName) {
        if (this._decimalFormats == null) {
            return null;
        }
        return this._decimalFormats.get(qName.getStringRep());
    }

    public void addDecimalFormatting(QName qName, DecimalFormatting decimalFormatting) {
        if (this._decimalFormats == null) {
            this._decimalFormats = new HashMap<String, DecimalFormatting>();
        }
        this._decimalFormats.put(qName.getStringRep(), decimalFormatting);
    }

    public Key getKey(QName qName) {
        if (this._keys == null) {
            return null;
        }
        return this._keys.get(qName.getStringRep());
    }

    public void addKey(QName qName, Key key) {
        if (this._keys == null) {
            this._keys = new HashMap<String, Key>();
        }
        this._keys.put(qName.getStringRep(), key);
    }

    public Stylesheet addStylesheet(QName qName, Stylesheet stylesheet) {
        return this._stylesheets.put(qName.getStringRep(), stylesheet);
    }

    public Stylesheet lookupStylesheet(QName qName) {
        return this._stylesheets.get(qName.getStringRep());
    }

    public Template addTemplate(Template template) {
        QName qName = template.getName();
        if (this._templates == null) {
            this._templates = new HashMap<String, Template>();
        }
        return this._templates.put(qName.getStringRep(), template);
    }

    public Template lookupTemplate(QName qName) {
        if (this._templates == null) {
            return null;
        }
        return this._templates.get(qName.getStringRep());
    }

    public Variable addVariable(Variable variable) {
        if (this._variables == null) {
            this._variables = new HashMap<String, VariableBase>();
        }
        String string = variable.getName().getStringRep();
        return (Variable)this._variables.put(string, variable);
    }

    public Param addParam(Param param) {
        if (this._variables == null) {
            this._variables = new HashMap<String, VariableBase>();
        }
        String string = param.getName().getStringRep();
        return (Param)this._variables.put(string, param);
    }

    public Variable lookupVariable(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        VariableBase variableBase = this._variables.get(string);
        return variableBase instanceof Variable ? (Variable)variableBase : null;
    }

    public Param lookupParam(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        VariableBase variableBase = this._variables.get(string);
        return variableBase instanceof Param ? (Param)variableBase : null;
    }

    public SyntaxTreeNode lookupName(QName qName) {
        if (this._variables == null) {
            return null;
        }
        String string = qName.getStringRep();
        return this._variables.get(string);
    }

    public AttributeSet addAttributeSet(AttributeSet attributeSet) {
        if (this._attributeSets == null) {
            this._attributeSets = new HashMap<String, AttributeSet>();
        }
        return this._attributeSets.put(attributeSet.getName().getStringRep(), attributeSet);
    }

    public AttributeSet lookupAttributeSet(QName qName) {
        if (this._attributeSets == null) {
            return null;
        }
        return this._attributeSets.get(qName.getStringRep());
    }

    public void addPrimop(String string, MethodType methodType) {
        Vector<MethodType> vector = this._primops.get(string);
        if (vector == null) {
            vector = new Vector<MethodType>();
            this._primops.put(string, vector);
        }
        vector.addElement(methodType);
    }

    public Vector lookupPrimop(String string) {
        return this._primops.get(string);
    }

    public String generateNamespacePrefix() {
        return new String("ns" + this._nsCounter++);
    }

    public void setCurrentNode(SyntaxTreeNode syntaxTreeNode) {
        this._current = syntaxTreeNode;
    }

    public String lookupNamespace(String string) {
        if (this._current == null) {
            return "";
        }
        return this._current.lookupNamespace(string);
    }

    public void addPrefixAlias(String string, String string2) {
        if (this._aliases == null) {
            this._aliases = new HashMap<String, String>();
        }
        this._aliases.put(string, string2);
    }

    public String lookupPrefixAlias(String string) {
        if (this._aliases == null) {
            return null;
        }
        return this._aliases.get(string);
    }

    public void excludeURI(String string) {
        Integer n;
        if (string == null) {
            return;
        }
        if (this._excludedURI == null) {
            this._excludedURI = new HashMap<String, Integer>();
        }
        n = (n = this._excludedURI.get(string)) == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
        this._excludedURI.put(string, n);
    }

    public void excludeNamespaces(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(string2);
                if (string3 == null) continue;
                this.excludeURI(string3);
            }
        }
    }

    public boolean isExcludedNamespace(String string) {
        if (string != null && this._excludedURI != null) {
            Integer n = this._excludedURI.get(string);
            return n != null && n > 0;
        }
        return false;
    }

    public void unExcludeNamespaces(String string) {
        if (this._excludedURI == null) {
            return;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.equals("#default") ? this.lookupNamespace("") : this.lookupNamespace(string2);
                Integer n = this._excludedURI.get(string3);
                if (n == null) continue;
                this._excludedURI.put(string3, n - 1);
            }
        }
    }
}

