/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashMap;

public class ClassLoaderRepository
implements Repository {
    private ClassLoader loader;
    private jdk.xml.internal.HashMap<String, JavaClass> loadedClasses = new jdk.xml.internal.HashMap();
    private static final long serialVersionUID = -5917543689769325856L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("loader", ClassLoader.class), new ObjectStreamField("loadedClasses", HashMap.class)};

    public ClassLoaderRepository(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    public JavaClass findClass(String string) {
        if (this.loadedClasses.containsKey(string)) {
            return this.loadedClasses.get(string);
        }
        return null;
    }

    public JavaClass loadClass(String string) throws ClassNotFoundException {
        String string2 = string.replace('.', '/');
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            InputStream inputStream = this.loader.getResourceAsStream(string2 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string + " not found.");
            }
            ClassParser classParser = new ClassParser(inputStream, string);
            javaClass = classParser.parse();
            this.storeClass(javaClass);
            return javaClass;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    public void clear() {
        this.loadedClasses.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        HashMap<String, JavaClass> hashMap = new HashMap<String, JavaClass>(this.loadedClasses);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("loadedClasses", hashMap);
        putField.put("loader", this.loader);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        HashMap hashMap = (HashMap)getField.get("loadedClasses", null);
        if (hashMap != null) {
            this.loadedClasses = new jdk.xml.internal.HashMap(hashMap);
        }
        this.loader = (ClassLoader)getField.get("loader", null);
    }
}

