/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBufferFilter;
import com.sun.jmx.remote.security.NotificationAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanPermission;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public class ServerNotifForwarder {
    private final NotifForwarderBufferFilter bufferFilter = new NotifForwarderBufferFilter();
    private MBeanServer mbeanServer;
    private final String connectionId;
    private final long connectionTimeout;
    private static int listenerCounter = 0;
    private static final int[] listenerCounterLock = new int[0];
    private NotificationBuffer notifBuffer;
    private final Map<ObjectName, Set<IdAndFilter>> listenerMap = new HashMap<ObjectName, Set<IdAndFilter>>();
    private boolean terminated = false;
    private final int[] terminationLock = new int[0];
    static final String broadcasterClass = NotificationBroadcaster.class.getName();
    private final boolean checkNotificationEmission;
    private final NotificationAccessController notificationAccessController;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ServerNotifForwarder");

    public ServerNotifForwarder(MBeanServer mBeanServer, Map map, NotificationBuffer notificationBuffer, String string) {
        this.mbeanServer = mBeanServer;
        this.notifBuffer = notificationBuffer;
        this.connectionId = string;
        this.connectionTimeout = EnvHelp.getServerConnectionTimeout(map);
        this.checkNotificationEmission = EnvHelp.computeBooleanFromString(map, "jmx.remote.x.check.notification.emission");
        this.notificationAccessController = (NotificationAccessController)map.get("com.sun.jmx.remote.notification.access.controller");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotificationListener(final ObjectName objectName, NotificationFilter notificationFilter) throws InstanceNotFoundException, IOException {
        Comparable<Boolean> comparable;
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add a listener at " + objectName);
        }
        this.checkState();
        this.checkMBeanPermission(objectName, "addNotificationListener");
        if (this.notificationAccessController != null) {
            this.notificationAccessController.addNotificationListener(this.connectionId, objectName, Subject.getSubject(AccessController.getContext()));
        }
        try {
            comparable = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ServerNotifForwarder.this.mbeanServer.isInstanceOf(objectName, broadcasterClass));
                }
            });
            if (!comparable.booleanValue()) {
                throw new IllegalArgumentException("The specified MBean [" + objectName + "] is not a " + "NotificationBroadcaster " + "object.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)ServerNotifForwarder.extractException(privilegedActionException);
        }
        comparable = this.getListenerID();
        ObjectName objectName2 = objectName;
        if (objectName.getDomain() == null || objectName.getDomain().equals("")) {
            try {
                objectName2 = ObjectName.getInstance(this.mbeanServer.getDefaultDomain(), objectName.getKeyPropertyList());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IOException iOException = new IOException(malformedObjectNameException.getMessage());
                iOException.initCause(malformedObjectNameException);
                throw iOException;
            }
        }
        Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
        synchronized (map) {
            IdAndFilter idAndFilter = new IdAndFilter((Integer)comparable, notificationFilter);
            Set<IdAndFilter> set = this.listenerMap.get(objectName2);
            if (set == null) {
                set = Collections.singleton(idAndFilter);
            } else {
                if (set.size() == 1) {
                    set = new HashSet<IdAndFilter>(set);
                }
                set.add(idAndFilter);
            }
            this.listenerMap.put(objectName2, set);
        }
        return comparable;
    }

    public void removeNotificationListener(ObjectName objectName, Integer[] integerArray) throws Exception {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove some listeners from " + objectName);
        }
        this.checkState();
        this.checkMBeanPermission(objectName, "removeNotificationListener");
        if (this.notificationAccessController != null) {
            this.notificationAccessController.removeNotificationListener(this.connectionId, objectName, Subject.getSubject(AccessController.getContext()));
        }
        Exception exception = null;
        for (int i = 0; i < integerArray.length; ++i) {
            try {
                this.removeNotificationListener(objectName, integerArray[i]);
                continue;
            }
            catch (Exception exception2) {
                if (exception == null) continue;
                exception = exception2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName objectName, Integer n) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + n + " from " + objectName);
        }
        this.checkState();
        if (objectName != null && !objectName.isPattern() && !this.mbeanServer.isRegistered(objectName)) {
            throw new InstanceNotFoundException("The MBean " + objectName + " is not registered.");
        }
        Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
        synchronized (map) {
            Set<IdAndFilter> set = this.listenerMap.get(objectName);
            IdAndFilter idAndFilter = new IdAndFilter(n, null);
            if (set == null || !set.contains(idAndFilter)) {
                throw new ListenerNotFoundException("Listener not found");
            }
            if (set.size() == 1) {
                this.listenerMap.remove(objectName);
            } else {
                set.remove(idAndFilter);
            }
        }
    }

    public NotificationResult fetchNotifs(long l, long l2, int n) {
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Fetching notifications, the startSequenceNumber is " + l + ", the timeout is " + l2 + ", the maxNotifications is " + n);
        }
        NotificationResult notificationResult = null;
        long l3 = Math.min(this.connectionTimeout, l2);
        try {
            notificationResult = this.notifBuffer.fetchNotifications(this.bufferFilter, l, l3, n);
            this.snoopOnUnregister(notificationResult);
        }
        catch (InterruptedException interruptedException) {
            notificationResult = new NotificationResult(0L, 0L, new TargetedNotification[0]);
        }
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Forwarding the notifs: " + notificationResult);
        }
        return notificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snoopOnUnregister(NotificationResult notificationResult) {
        Set<IdAndFilter> set = this.listenerMap.get(MBeanServerDelegate.DELEGATE_NAME);
        if (set == null || set.isEmpty()) {
            return;
        }
        for (TargetedNotification targetedNotification : notificationResult.getTargetedNotifications()) {
            Integer n = targetedNotification.getListenerID();
            for (IdAndFilter idAndFilter : set) {
                Notification notification;
                if (idAndFilter.id != n || !((notification = targetedNotification.getNotification()) instanceof MBeanServerNotification) || !notification.getType().equals("JMX.mbean.unregistered")) continue;
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
                synchronized (map) {
                    this.listenerMap.remove(objectName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "Be called.");
        }
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
            synchronized (map) {
                this.listenerMap.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (logger.traceOn()) {
                logger.trace("terminate", "Terminated.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                throw new IOException("The connection has been terminated.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getListenerID() {
        int[] nArray = listenerCounterLock;
        synchronized (listenerCounterLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Integer(listenerCounter++);
        }
    }

    private final void checkMBeanPermission(ObjectName objectName, String string) throws InstanceNotFoundException, SecurityException {
        ServerNotifForwarder.checkMBeanPermission(this.mbeanServer, objectName, string);
    }

    static void checkMBeanPermission(final MBeanServer mBeanServer, final ObjectName objectName, String string) throws InstanceNotFoundException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessControlContext accessControlContext = AccessController.getContext();
            ObjectInstance objectInstance = null;
            try {
                objectInstance = (ObjectInstance)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws InstanceNotFoundException {
                        return mBeanServer.getObjectInstance(objectName);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (InstanceNotFoundException)ServerNotifForwarder.extractException(privilegedActionException);
            }
            String string2 = objectInstance.getClassName();
            MBeanPermission mBeanPermission = new MBeanPermission(string2, null, objectName, string);
            securityManager.checkPermission(mBeanPermission, accessControlContext);
        }
    }

    private boolean allowNotificationEmission(ObjectName objectName, TargetedNotification targetedNotification) {
        try {
            if (this.checkNotificationEmission) {
                this.checkMBeanPermission(objectName, "addNotificationListener");
            }
            if (this.notificationAccessController != null) {
                this.notificationAccessController.fetchNotification(this.connectionId, objectName, targetedNotification.getNotification(), Subject.getSubject(AccessController.getContext()));
            }
            return true;
        }
        catch (SecurityException securityException) {
            if (logger.debugOn()) {
                logger.debug("fetchNotifs", "Notification " + targetedNotification.getNotification() + " not forwarded: the " + "caller didn't have the required access rights");
            }
            return false;
        }
        catch (Exception exception) {
            if (logger.debugOn()) {
                logger.debug("fetchNotifs", "Notification " + targetedNotification.getNotification() + " not forwarded: " + "got an unexpected exception: " + exception);
            }
            return false;
        }
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    private static class IdAndFilter {
        private Integer id;
        private NotificationFilter filter;

        IdAndFilter(Integer n, NotificationFilter notificationFilter) {
            this.id = n;
            this.filter = notificationFilter;
        }

        Integer getId() {
            return this.id;
        }

        NotificationFilter getFilter() {
            return this.filter;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof IdAndFilter && ((IdAndFilter)object).getId().equals(this.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class NotifForwarderBufferFilter
    implements NotificationBufferFilter {
        NotifForwarderBufferFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(List<TargetedNotification> list, ObjectName objectName, Notification notification) {
            IdAndFilter[] idAndFilterArray;
            IdAndFilter[] idAndFilterArray2 = ServerNotifForwarder.this.listenerMap;
            synchronized (idAndFilterArray2) {
                Set set = (Set)ServerNotifForwarder.this.listenerMap.get(objectName);
                if (set == null) {
                    logger.debug("bufferFilter", "no listeners for this name");
                    return;
                }
                idAndFilterArray = new IdAndFilter[set.size()];
                set.toArray(idAndFilterArray);
            }
            for (IdAndFilter idAndFilter : idAndFilterArray) {
                NotificationFilter notificationFilter = idAndFilter.getFilter();
                if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
                logger.debug("bufferFilter", "filter matches");
                TargetedNotification targetedNotification = new TargetedNotification(notification, idAndFilter.getId());
                if (!ServerNotifForwarder.this.allowNotificationEmission(objectName, targetedNotification)) continue;
                list.add(targetedNotification);
            }
        }
    }
}

