/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orbutil.proxy;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.presentation.rmi.DynamicAccessPermission;
import com.sun.corba.se.spi.orbutil.proxy.CompositeInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompositeInvocationHandlerImpl
implements CompositeInvocationHandler {
    private Map classToInvocationHandler = new LinkedHashMap();
    private InvocationHandler defaultHandler = null;
    private static final DynamicAccessPermission perm = new DynamicAccessPermission("access");
    private static final long serialVersionUID = 4571178305984833743L;

    public void addInvocationHandler(Class clazz, InvocationHandler invocationHandler) {
        this.checkAccess();
        this.classToInvocationHandler.put(clazz, invocationHandler);
    }

    public void setDefaultHandler(InvocationHandler invocationHandler) {
        this.checkAccess();
        this.defaultHandler = invocationHandler;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        InvocationHandler invocationHandler = (InvocationHandler)this.classToInvocationHandler.get(clazz);
        if (invocationHandler == null) {
            if (this.defaultHandler != null) {
                invocationHandler = this.defaultHandler;
            } else {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("util");
                throw oRBUtilSystemException.noInvocationHandler("\"" + method.toString() + "\"");
            }
        }
        return invocationHandler.invoke(object, method, objectArray);
    }

    private void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(perm);
        }
    }
}

