/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.AddressingDispositionException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.IORAddressingInfo;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.TargetAddress;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.ior.iiop.RequestPartitioningComponent;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContexts;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.ReadTimeouts;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.IOP.TaggedProfile;
import sun.misc.SharedSecrets;

public abstract class MessageBase
implements Message {
    public byte[] giopHeader;
    private ByteBuffer byteBuffer;
    private int threadPoolToUse;
    byte encodingVersion = 0;
    private static ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.protocol");

    public static String typeToString(int n) {
        return MessageBase.typeToString((byte)n);
    }

    public static String typeToString(byte by) {
        String string = by + "/";
        switch (by) {
            case 0: {
                string = string + "GIOPRequest";
                break;
            }
            case 1: {
                string = string + "GIOPReply";
                break;
            }
            case 2: {
                string = string + "GIOPCancelRequest";
                break;
            }
            case 3: {
                string = string + "GIOPLocateRequest";
                break;
            }
            case 4: {
                string = string + "GIOPLocateReply";
                break;
            }
            case 5: {
                string = string + "GIOPCloseConnection";
                break;
            }
            case 6: {
                string = string + "GIOPMessageError";
                break;
            }
            case 7: {
                string = string + "GIOPFragment";
                break;
            }
            default: {
                string = string + "Unknown";
            }
        }
        return string;
    }

    public static MessageBase readGIOPMessage(ORB oRB, CorbaConnection corbaConnection) {
        MessageBase messageBase = MessageBase.readGIOPHeader(oRB, corbaConnection);
        messageBase = (MessageBase)MessageBase.readGIOPBody(oRB, corbaConnection, messageBase);
        return messageBase;
    }

    public static MessageBase readGIOPHeader(ORB oRB, CorbaConnection corbaConnection) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        MessageBase messageBase = null;
        ReadTimeouts readTimeouts = oRB.getORBData().getTransportTCPReadTimeouts();
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = corbaConnection.read(12, 0, 12, (long)readTimeouts.get_max_giop_header_time_to_wait());
        }
        catch (IOException iOException) {
            throw wrapper.ioexceptionWhenReadingConnection(iOException);
        }
        if (oRB.giopDebugFlag) {
            MessageBase.dprint(".readGIOPHeader: " + MessageBase.typeToString(byteBuffer.get(7)));
            MessageBase.dprint(".readGIOPHeader: GIOP header is: ");
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(0).limit(12);
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo((org.omg.CORBA.ORB)oRB, byteBuffer2);
            byteBufferWithInfo.buflen = 12;
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        if ((n5 = (n4 = byteBuffer.get(0) << 24 & 0xFF000000) | (n3 = byteBuffer.get(1) << 16 & 0xFF0000) | (n2 = byteBuffer.get(2) << 8 & 0xFF00) | (n = byteBuffer.get(3) << 0 & 0xFF)) != 1195986768) {
            throw wrapper.giopMagicError(CompletionStatus.COMPLETED_MAYBE);
        }
        byte by = 0;
        if (byteBuffer.get(4) == 13 && byteBuffer.get(5) <= 1 && byteBuffer.get(5) > 0 && oRB.getORBData().isJavaSerializationEnabled()) {
            by = byteBuffer.get(5);
            byteBuffer.put(4, (byte)1);
            byteBuffer.put(5, (byte)2);
        }
        GIOPVersion gIOPVersion = oRB.getORBData().getGIOPVersion();
        if (oRB.giopDebugFlag) {
            MessageBase.dprint(".readGIOPHeader: Message GIOP version: " + byteBuffer.get(4) + '.' + byteBuffer.get(5));
            MessageBase.dprint(".readGIOPHeader: ORB Max GIOP Version: " + gIOPVersion);
        }
        if ((byteBuffer.get(4) > gIOPVersion.getMajor() || byteBuffer.get(4) == gIOPVersion.getMajor() && byteBuffer.get(5) > gIOPVersion.getMinor()) && byteBuffer.get(7) != 6) {
            throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
        }
        MessageBase.AreFragmentsAllowed(byteBuffer.get(4), byteBuffer.get(5), byteBuffer.get(6), byteBuffer.get(7));
        switch (byteBuffer.get(7)) {
            case 0: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating RequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new RequestMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new RequestMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new RequestMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 3: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating LocateRequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new LocateRequestMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new LocateRequestMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new LocateRequestMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating CancelRequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new CancelRequestMessage_1_0();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new CancelRequestMessage_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new CancelRequestMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating ReplyMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new ReplyMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new ReplyMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new ReplyMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 4: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating LocateReplyMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new LocateReplyMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new LocateReplyMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new LocateReplyMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 5: 
            case 6: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating Message for CloseConnection or MessageError");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new Message_1_0();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new Message_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new Message_1_1();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 7: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: creating FragmentMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) break;
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new FragmentMessage_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new FragmentMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (oRB.giopDebugFlag) {
                    MessageBase.dprint(".readGIOPHeader: UNKNOWN MESSAGE TYPE: " + byteBuffer.get(7));
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
            object = (Message_1_0)messageBase;
            ((Message_1_0)object).magic = n5;
            ((Message_1_0)object).GIOP_version = new GIOPVersion(byteBuffer.get(4), byteBuffer.get(5));
            ((Message_1_0)object).byte_order = byteBuffer.get(6) == 1;
            messageBase.threadPoolToUse = 0;
            ((Message_1_0)object).message_type = byteBuffer.get(7);
            ((Message_1_0)object).message_size = MessageBase.readSize(byteBuffer.get(8), byteBuffer.get(9), byteBuffer.get(10), byteBuffer.get(11), ((Message_1_0)object).isLittleEndian()) + 12;
        } else {
            object = (Message_1_1)messageBase;
            ((Message_1_1)object).magic = n5;
            ((Message_1_1)object).GIOP_version = new GIOPVersion(byteBuffer.get(4), byteBuffer.get(5));
            ((Message_1_1)object).flags = (byte)(byteBuffer.get(6) & 3);
            messageBase.threadPoolToUse = byteBuffer.get(6) >>> 2 & 0x3F;
            ((Message_1_1)object).message_type = byteBuffer.get(7);
            ((Message_1_1)object).message_size = MessageBase.readSize(byteBuffer.get(8), byteBuffer.get(9), byteBuffer.get(10), byteBuffer.get(11), ((Message_1_1)object).isLittleEndian()) + 12;
        }
        if (oRB.giopDebugFlag) {
            MessageBase.dprint(".readGIOPHeader: header construction complete.");
            object = byteBuffer.asReadOnlyBuffer();
            byte[] byArray = new byte[12];
            ((Buffer)object).position(0).limit(12);
            ((ByteBuffer)object).get(byArray, 0, byArray.length);
            messageBase.giopHeader = byArray;
        }
        messageBase.setByteBuffer(byteBuffer);
        messageBase.setEncodingVersion(by);
        return messageBase;
    }

    public static Message readGIOPBody(ORB oRB, CorbaConnection corbaConnection, Message message) {
        ReadTimeouts readTimeouts = oRB.getORBData().getTransportTCPReadTimeouts();
        ByteBuffer byteBuffer = message.getByteBuffer();
        byteBuffer.position(12);
        int n = message.getSize() - 12;
        try {
            byteBuffer = corbaConnection.read(byteBuffer, 12, n, (long)readTimeouts.get_max_time_to_wait());
        }
        catch (IOException iOException) {
            throw wrapper.ioexceptionWhenReadingConnection(iOException);
        }
        message.setByteBuffer(byteBuffer);
        if (oRB.giopDebugFlag) {
            MessageBase.dprint(".readGIOPBody: received message:");
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(0).limit(message.getSize());
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo((org.omg.CORBA.ORB)oRB, byteBuffer2);
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        return message;
    }

    private static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, byte by, int n, boolean bl, byte[] byArray, String string, ServiceContexts serviceContexts, Principal principal) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new RequestMessage_1_0(oRB, serviceContexts, n, bl, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new RequestMessage_1_1(oRB, serviceContexts, n, bl, new byte[]{0, 0, 0}, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            byte by2 = 3;
            by2 = bl ? (byte)3 : 0;
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            RequestMessage_1_2 requestMessage_1_2 = new RequestMessage_1_2(oRB, n, by2, new byte[]{0, 0, 0}, targetAddress, string, serviceContexts);
            requestMessage_1_2.setEncodingVersion(by);
            return requestMessage_1_2;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, byte by, int n, boolean bl, IOR iOR, short s, String string, ServiceContexts serviceContexts, Principal principal) {
        Object object;
        Object object2;
        RequestMessage requestMessage = null;
        IIOPProfile iIOPProfile = iOR.getProfile();
        if (s == 0) {
            iIOPProfile = iOR.getProfile();
            ObjectKey objectKey = iIOPProfile.getObjectKey();
            object2 = objectKey.getBytes(oRB);
            requestMessage = MessageBase.createRequest(oRB, gIOPVersion, by, n, bl, (byte[])object2, string, serviceContexts, principal);
        } else {
            if (!gIOPVersion.equals(GIOPVersion.V1_2)) {
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            byte by2 = 3;
            by2 = bl ? (byte)3 : 0;
            object2 = new TargetAddress();
            if (s == 1) {
                iIOPProfile = iOR.getProfile();
                ((TargetAddress)object2).profile(iIOPProfile.getIOPProfile());
            } else if (s == 2) {
                object = new IORAddressingInfo(0, iOR.getIOPIOR());
                ((TargetAddress)object2).ior((IORAddressingInfo)object);
            } else {
                throw wrapper.illegalTargetAddressDisposition(CompletionStatus.COMPLETED_NO);
            }
            requestMessage = new RequestMessage_1_2(oRB, n, by2, new byte[]{0, 0, 0}, (TargetAddress)object2, string, serviceContexts);
            requestMessage.setEncodingVersion(by);
        }
        if (gIOPVersion.supportsIORIIOPProfileComponents()) {
            int n2 = 0;
            object2 = (IIOPProfileTemplate)iIOPProfile.getTaggedProfileTemplate();
            object = object2.iteratorById(1398099457);
            if (object.hasNext()) {
                n2 = ((RequestPartitioningComponent)object.next()).getRequestPartitioningId();
            }
            if (n2 < 0 || n2 > 63) {
                throw wrapper.invalidRequestPartitioningId(new Integer(n2), new Integer(0), new Integer(63));
            }
            requestMessage.setThreadPoolToUse(n2);
        }
        return requestMessage;
    }

    public static ReplyMessage createReply(ORB oRB, GIOPVersion gIOPVersion, byte by, int n, int n2, ServiceContexts serviceContexts, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new ReplyMessage_1_0(oRB, serviceContexts, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new ReplyMessage_1_1(oRB, serviceContexts, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            ReplyMessage_1_2 replyMessage_1_2 = new ReplyMessage_1_2(oRB, n, n2, serviceContexts, iOR);
            replyMessage_1_2.setEncodingVersion(by);
            return replyMessage_1_2;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateRequestMessage createLocateRequest(ORB oRB, GIOPVersion gIOPVersion, byte by, int n, byte[] byArray) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateRequestMessage_1_0(oRB, n, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateRequestMessage_1_1(oRB, n, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            LocateRequestMessage_1_2 locateRequestMessage_1_2 = new LocateRequestMessage_1_2(oRB, n, targetAddress);
            locateRequestMessage_1_2.setEncodingVersion(by);
            return locateRequestMessage_1_2;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateReplyMessage createLocateReply(ORB oRB, GIOPVersion gIOPVersion, byte by, int n, int n2, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateReplyMessage_1_0(oRB, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateReplyMessage_1_1(oRB, n, n2, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            LocateReplyMessage_1_2 locateReplyMessage_1_2 = new LocateReplyMessage_1_2(oRB, n, n2, iOR);
            locateReplyMessage_1_2.setEncodingVersion(by);
            return locateReplyMessage_1_2;
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static CancelRequestMessage createCancelRequest(GIOPVersion gIOPVersion, int n) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new CancelRequestMessage_1_0(n);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new CancelRequestMessage_1_1(n);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new CancelRequestMessage_1_2(n);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createCloseConnection(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 5, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createMessageError(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 6, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static FragmentMessage createFragmentMessage(GIOPVersion gIOPVersion) {
        return null;
    }

    public static int getRequestId(Message message) {
        switch (message.getType()) {
            case 0: {
                return ((RequestMessage)message).getRequestId();
            }
            case 1: {
                return ((ReplyMessage)message).getRequestId();
            }
            case 3: {
                return ((LocateRequestMessage)message).getRequestId();
            }
            case 4: {
                return ((LocateReplyMessage)message).getRequestId();
            }
            case 2: {
                return ((CancelRequestMessage)message).getRequestId();
            }
            case 7: {
                return ((FragmentMessage)message).getRequestId();
            }
        }
        throw wrapper.illegalGiopMsgType(CompletionStatus.COMPLETED_MAYBE);
    }

    public static void setFlag(ByteBuffer byteBuffer, int n) {
        byte by = byteBuffer.get(6);
        by = (byte)(by | n);
        byteBuffer.put(6, by);
    }

    public static void clearFlag(byte[] byArray, int n) {
        byArray[6] = (byte)(byArray[6] & (0xFF ^ n));
    }

    private static void AreFragmentsAllowed(byte by, byte by2, byte by3, byte by4) {
        if (by == 1 && by2 == 0 && by4 == 7) {
            throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
        }
        if ((by3 & 2) == 2) {
            switch (by4) {
                case 2: 
                case 5: 
                case 6: {
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
                case 3: 
                case 4: {
                    if (by != 1 || by2 != 1) break;
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
    }

    static ObjectKey extractObjectKey(byte[] byArray, ORB oRB) {
        try {
            ObjectKey objectKey;
            if (byArray != null && (objectKey = oRB.getObjectKeyFactory().create(byArray)) != null) {
                return objectKey;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw wrapper.invalidObjectKey();
    }

    static ObjectKey extractObjectKey(TargetAddress targetAddress, ORB oRB) {
        short s = oRB.getORBData().getGIOPTargetAddressPreference();
        short s2 = targetAddress.discriminator();
        switch (s) {
            case 0: {
                if (s2 == 0) break;
                throw new AddressingDispositionException(0);
            }
            case 1: {
                if (s2 == 1) break;
                throw new AddressingDispositionException(1);
            }
            case 2: {
                if (s2 == 2) break;
                throw new AddressingDispositionException(2);
            }
            case 3: {
                break;
            }
            default: {
                throw wrapper.orbTargetAddrPreferenceInExtractObjectkeyInvalid();
            }
        }
        try {
            switch (s2) {
                case 0: {
                    byte[] byArray = targetAddress.object_key();
                    if (byArray == null) break;
                    ObjectKey objectKey = oRB.getObjectKeyFactory().create(byArray);
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
                case 1: {
                    IIOPProfile iIOPProfile = null;
                    TaggedProfile taggedProfile = targetAddress.profile();
                    if (taggedProfile == null) break;
                    iIOPProfile = IIOPFactories.makeIIOPProfile(oRB, taggedProfile);
                    ObjectKey objectKey = iIOPProfile.getObjectKey();
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
                case 2: {
                    IORAddressingInfo iORAddressingInfo = targetAddress.ior();
                    if (iORAddressingInfo == null) break;
                    TaggedProfile taggedProfile = iORAddressingInfo.ior.profiles[iORAddressingInfo.selected_profile_index];
                    IIOPProfile iIOPProfile = IIOPFactories.makeIIOPProfile(oRB, taggedProfile);
                    ObjectKey objectKey = iIOPProfile.getObjectKey();
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw wrapper.invalidObjectKey();
    }

    private static int readSize(byte by, byte by2, byte by3, byte by4, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        if (!bl) {
            n4 = by << 24 & 0xFF000000;
            n3 = by2 << 16 & 0xFF0000;
            n2 = by3 << 8 & 0xFF00;
            n = by4 << 0 & 0xFF;
        } else {
            n4 = by4 << 24 & 0xFF000000;
            n3 = by3 << 16 & 0xFF0000;
            n2 = by2 << 8 & 0xFF00;
            n = by << 0 & 0xFF;
        }
        return n4 | n3 | n2 | n;
    }

    static void nullCheck(Object object) {
        if (object == null) {
            throw wrapper.nullNotAllowed();
        }
    }

    static SystemException getSystemException(String string, int n, CompletionStatus completionStatus, String string2, ORBUtilSystemException oRBUtilSystemException) {
        SystemException systemException = null;
        try {
            Class<?> clazz = SharedSecrets.getJavaCorbaAccess().loadClass(string);
            if (string2 == null) {
                systemException = (SystemException)clazz.newInstance();
            } else {
                Class[] classArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2};
                systemException = (SystemException)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw oRBUtilSystemException.badSystemExceptionInReply(CompletionStatus.COMPLETED_MAYBE, exception);
        }
        systemException.minor = n;
        systemException.completed = completionStatus;
        return systemException;
    }

    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public int getThreadPoolToUse() {
        return this.threadPoolToUse;
    }

    public byte getEncodingVersion() {
        return this.encodingVersion;
    }

    public void setEncodingVersion(byte by) {
        this.encodingVersion = by;
    }

    private static void dprint(String string) {
        ORBUtility.dprint("MessageBase", string);
    }
}

