/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.XmlRecord;
import java.io.StringReader;
import java.security.Provider;
import java.security.cert.X509Certificate;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class Response
extends XmlRecord {
    public boolean ValidateSign() throws Exception {
        return this.ValidateSign(this.getString());
    }

    public boolean ValidateSign(String xmlString) throws Exception {
        X509Certificate cert;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            return false;
        }
        Element element = (Element)nl.item(0).getParentNode();
        if (null != element) {
            element.setIdAttribute("Id", true);
        }
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        try {
            cert = AppContext.getContext().getServerCertificate("serverapp");
            if (cert == null) {
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
        DOMValidateContext valContext = new DOMValidateContext(cert.getPublicKey(), nl.item(0));
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }

    public String getErrorCode() {
        Node sifraGreske = this.getDocument().getElementsByTagName("tns:SifraGreske").item(0);
        if (sifraGreske == null) {
            return "";
        }
        return sifraGreske.getTextContent();
    }

    public String getErrorString() {
        Node porukaGreske = this.getDocument().getElementsByTagName("tns:PorukaGreske").item(0);
        if (porukaGreske == null) {
            return "";
        }
        return porukaGreske.getTextContent();
    }

    public boolean hasError() {
        if (this.getDocument() == null) {
            return false;
        }
        if (this.getDocument().getElementsByTagName("tns:ProvjeraOdgovor").item(0) != null && this.getErrorCode().equalsIgnoreCase("V100")) {
            return false;
        }
        return this.getDocument().getElementsByTagName("tns:Greska").item(0) != null;
    }

    public XmlRecord createXml(Request request) {
        Document doc = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            doc = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            return new XmlRecord();
        }
        Element nodeResponse = doc.createElement("Response");
        doc.appendChild(nodeResponse);
        if (this.hasError() && this.getDocument().getElementsByTagName("tns:ProvjeraOdgovor").item(0) == null) {
            Element nodeSifraGreske = doc.createElement("SifraGreske");
            nodeSifraGreske.setTextContent(this.getErrorCode());
            nodeResponse.appendChild(nodeSifraGreske);
            Element nodePorukaGreske = doc.createElement("PorukaGreske");
            nodePorukaGreske.setTextContent(this.getErrorString());
            nodeResponse.appendChild(nodePorukaGreske);
        }
        return new XmlRecord(doc);
    }

    public String toString() {
        String string = this.getTag() + ": ";
        try {
            string = string + this.getDocument().getElementsByTagName("tns:IdPoruke").item(0).getTextContent() + " / ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String datumVrijeme = this.getDocument().getElementsByTagName("tns:DatumVrijeme").item(0).getTextContent() + " / ";
            string = string + datumVrijeme.substring(0, 10) + " " + datumVrijeme.substring(11);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasError()) {
            string = string + " / gre\u0139\u02c7ka :" + this.getErrorCode();
        }
        return string;
    }

    public abstract XmlRecord createAnswer(Request var1);

    public abstract String getTag();
}

