/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.pdf417.decoder;

import hr.iii.fiskal.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(moduleBitCount));
        if (decodedValue != -1) {
            return decodedValue;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(moduleBitCount);
    }

    private static int[] sampleBitCounts(int[] moduleBitCount) {
        float bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        int[] result = new int[8];
        int bitCountIndex = 0;
        int sumPreviousBits = 0;
        for (int i = 0; i < 17; ++i) {
            float sampleIndex = bitCountSum / 34.0f + (float)i * bitCountSum / 17.0f;
            if ((float)(sumPreviousBits + moduleBitCount[bitCountIndex]) <= sampleIndex) {
                sumPreviousBits += moduleBitCount[bitCountIndex];
            }
            int n = ++bitCountIndex;
            result[n] = result[n] + 1;
        }
        return result;
    }

    private static int getDecodedCodewordValue(int[] moduleBitCount) {
        int decodedValue = PDF417CodewordDecoder.getBitValue(moduleBitCount);
        return PDF417Common.getCodeword(decodedValue) == -1 ? -1 : decodedValue;
    }

    private static int getBitValue(int[] moduleBitCount) {
        long result = 0L;
        for (int i = 0; i < moduleBitCount.length; ++i) {
            for (int bit = 0; bit < moduleBitCount[i]; ++bit) {
                result = result << 1 | (long)(i % 2 == 0 ? 1 : 0);
            }
        }
        return (int)result;
    }

    private static int getClosestDecodedValue(int[] moduleBitCount) {
        int bitCountSum = PDF417Common.getBitCountSum(moduleBitCount);
        float[] bitCountRatios = new float[8];
        for (int i = 0; i < bitCountRatios.length; ++i) {
            bitCountRatios[i] = (float)moduleBitCount[i] / (float)bitCountSum;
        }
        float bestMatchError = Float.MAX_VALUE;
        int bestMatch = -1;
        for (int j = 0; j < RATIOS_TABLE.length; ++j) {
            float diff;
            float error = 0.0f;
            float[] ratioTableRow = RATIOS_TABLE[j];
            for (int k = 0; k < 8 && !((error += (diff = ratioTableRow[k] - bitCountRatios[k]) * diff) >= bestMatchError); ++k) {
            }
            if (!(error < bestMatchError)) continue;
            bestMatchError = error;
            bestMatch = PDF417Common.SYMBOL_TABLE[j];
        }
        return bestMatch;
    }

    static {
        for (int i = 0; i < PDF417Common.SYMBOL_TABLE.length; ++i) {
            int currentSymbol = PDF417Common.SYMBOL_TABLE[i];
            int currentBit = currentSymbol & 1;
            for (int j = 0; j < 8; ++j) {
                float size = 0.0f;
                while ((currentSymbol & 1) == currentBit) {
                    size += 1.0f;
                    currentSymbol >>= 1;
                }
                currentBit = currentSymbol & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[i][8 - j - 1] = size / 17.0f;
            }
        }
    }
}

