/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExtendedSSLSession;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLAlgorithmConstraints;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.util.AlgorithmConstraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class X509KeyManagerImpl
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final boolean useDebug = debug != null && Debug.isOn("keymanager");
    private static Date verificationDate;
    private final List<KeyStore.Builder> builders;
    private final AtomicLong uidCounter;
    private final Map<String, Reference<KeyStore.PrivateKeyEntry>> entryCacheMap;

    X509KeyManagerImpl(KeyStore.Builder builder) {
        this(Collections.singletonList(builder));
    }

    X509KeyManagerImpl(List<KeyStore.Builder> list) {
        this.builders = list;
        this.uidCounter = new AtomicLong();
        this.entryCacheMap = Collections.synchronizedMap(new SizedMap());
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getEntry(string);
        return privateKeyEntry == null ? null : (X509Certificate[])privateKeyEntry.getCertificateChain();
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getEntry(string);
        return privateKeyEntry == null ? null : privateKeyEntry.getPrivateKey();
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(stringArray), principalArray, CheckType.CLIENT, this.getAlgorithmConstraints(socket));
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(stringArray), principalArray, CheckType.CLIENT, this.getAlgorithmConstraints(sSLEngine));
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(string), principalArray, CheckType.SERVER, this.getAlgorithmConstraints(socket));
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(X509KeyManagerImpl.getKeyTypes(string), principalArray, CheckType.SERVER, this.getAlgorithmConstraints(sSLEngine));
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray, CheckType.CLIENT, null);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray, CheckType.SERVER, null);
    }

    private AlgorithmConstraints getAlgorithmConstraints(Socket socket) {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocketImpl sSLSocketImpl = (SSLSocketImpl)socket;
            SSLSession sSLSession = sSLSocketImpl.getHandshakeSession();
            if (sSLSession != null) {
                ProtocolVersion protocolVersion = ProtocolVersion.valueOf(sSLSession.getProtocol());
                if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                    String[] stringArray = null;
                    if (sSLSession instanceof ExtendedSSLSession) {
                        ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                        stringArray = extendedSSLSession.getPeerSupportedSignatureAlgorithms();
                    }
                    return new SSLAlgorithmConstraints(sSLSocketImpl, stringArray, true);
                }
            }
            return new SSLAlgorithmConstraints(sSLSocketImpl, true);
        }
        return new SSLAlgorithmConstraints((SSLSocket)null, true);
    }

    private AlgorithmConstraints getAlgorithmConstraints(SSLEngine sSLEngine) {
        SSLSession sSLSession;
        if (sSLEngine != null && (sSLSession = ((SSLEngineImpl)sSLEngine).getHandshakeSession()) != null) {
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(sSLSession.getProtocol());
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                String[] stringArray = null;
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    stringArray = extendedSSLSession.getPeerSupportedSignatureAlgorithms();
                }
                return new SSLAlgorithmConstraints(sSLEngine, stringArray, true);
            }
        }
        return new SSLAlgorithmConstraints(sSLEngine, true);
    }

    private String makeAlias(EntryStatus entryStatus) {
        return this.uidCounter.incrementAndGet() + "." + entryStatus.builderIndex + "." + entryStatus.alias;
    }

    private KeyStore.PrivateKeyEntry getEntry(String string) {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        if (string == null) {
            return null;
        }
        Reference<KeyStore.PrivateKeyEntry> reference = this.entryCacheMap.get(string);
        KeyStore.PrivateKeyEntry privateKeyEntry2 = privateKeyEntry = reference != null ? reference.get() : null;
        if (privateKeyEntry != null) {
            return privateKeyEntry;
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(46, n + 1);
        if (n == -1 || n2 == n) {
            return null;
        }
        try {
            int n3 = Integer.parseInt(string.substring(n + 1, n2));
            String string2 = string.substring(n2 + 1);
            KeyStore.Builder builder = this.builders.get(n3);
            KeyStore keyStore = builder.getKeyStore();
            KeyStore.Entry entry = keyStore.getEntry(string2, builder.getProtectionParameter(string));
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
                return null;
            }
            privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.entryCacheMap.put(string, new SoftReference<KeyStore.PrivateKeyEntry>(privateKeyEntry));
            return privateKeyEntry;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static List<KeyType> getKeyTypes(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return null;
        }
        ArrayList<KeyType> arrayList = new ArrayList<KeyType>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(new KeyType(string));
        }
        return arrayList;
    }

    private String chooseAlias(List<KeyType> list, Principal[] principalArray, CheckType checkType, AlgorithmConstraints algorithmConstraints) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Set<Principal> set = this.getIssuerSet(principalArray);
        ArrayList<EntryStatus> arrayList = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> list2 = this.getAliases(i, list, set, false, checkType, algorithmConstraints);
                if (list2 == null) continue;
                EntryStatus entryStatus = list2.get(0);
                if (entryStatus.checkResult == CheckResult.OK) {
                    if (useDebug) {
                        debug.println("KeyMgr: choosing key: " + entryStatus);
                    }
                    return this.makeAlias(entryStatus);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<EntryStatus>();
                }
                arrayList.addAll(list2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList == null) {
            if (useDebug) {
                debug.println("KeyMgr: no matching key found");
            }
            return null;
        }
        Collections.sort(arrayList);
        if (useDebug) {
            debug.println("KeyMgr: no good matching key found, returning best match out of:");
            debug.println(((Object)arrayList).toString());
        }
        return this.makeAlias((EntryStatus)arrayList.get(0));
    }

    public String[] getAliases(String string, Principal[] principalArray, CheckType checkType, AlgorithmConstraints algorithmConstraints) {
        if (string == null) {
            return null;
        }
        Set<Principal> set = this.getIssuerSet(principalArray);
        List<KeyType> list = X509KeyManagerImpl.getKeyTypes(string);
        ArrayList<EntryStatus> arrayList = null;
        int n = this.builders.size();
        for (int i = 0; i < n; ++i) {
            try {
                List<EntryStatus> list2 = this.getAliases(i, list, set, true, checkType, algorithmConstraints);
                if (list2 == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<EntryStatus>();
                }
                arrayList.addAll(list2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            if (useDebug) {
                debug.println("KeyMgr: no matching alias found");
            }
            return null;
        }
        Collections.sort(arrayList);
        if (useDebug) {
            debug.println("KeyMgr: getting aliases: " + arrayList);
        }
        return this.toAliases((List<EntryStatus>)arrayList);
    }

    private String[] toAliases(List<EntryStatus> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (EntryStatus entryStatus : list) {
            stringArray[n++] = this.makeAlias(entryStatus);
        }
        return stringArray;
    }

    private Set<Principal> getIssuerSet(Principal[] principalArray) {
        if (principalArray != null && principalArray.length != 0) {
            return new HashSet<Principal>(Arrays.asList(principalArray));
        }
        return null;
    }

    private List<EntryStatus> getAliases(int n, List<KeyType> list, Set<Principal> set, boolean bl, CheckType checkType, AlgorithmConstraints algorithmConstraints) throws Exception {
        KeyStore.Builder builder = this.builders.get(n);
        KeyStore keyStore = builder.getKeyStore();
        ArrayList<EntryStatus> arrayList = null;
        Date date = verificationDate;
        boolean bl2 = false;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length == 0) continue;
            boolean bl3 = false;
            for (Certificate certificate : certificateArray) {
                if (certificate instanceof X509Certificate) continue;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            int n2 = -1;
            int n3 = 0;
            for (KeyType keyType : list) {
                if (keyType.matches(certificateArray)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            if (n2 == -1) {
                if (!useDebug) continue;
                debug.println("Ignoring alias " + string + ": key algorithm does not match");
                continue;
            }
            if (set != null) {
                boolean bl4 = false;
                for (Certificate certificate : certificateArray) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (!set.contains(x509Certificate.getIssuerX500Principal())) continue;
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    if (!useDebug) continue;
                    debug.println("Ignoring alias " + string + ": issuers do not match");
                    continue;
                }
            }
            if (algorithmConstraints != null && !X509KeyManagerImpl.conformsToAlgorithmConstraints(algorithmConstraints, certificateArray)) {
                if (!useDebug) continue;
                debug.println("Ignoring alias " + string + ": certificate list does not conform to " + "algorithm constraints");
                continue;
            }
            if (date == null) {
                date = new Date();
            }
            CheckResult checkResult = checkType.check((X509Certificate)certificateArray[0], date);
            EntryStatus entryStatus = new EntryStatus(n, n2, string, certificateArray, checkResult);
            if (!bl2 && checkResult == CheckResult.OK && n2 == 0) {
                bl2 = true;
            }
            if (bl2 && !bl) {
                return Collections.singletonList(entryStatus);
            }
            if (arrayList == null) {
                arrayList = new ArrayList<EntryStatus>();
            }
            arrayList.add(entryStatus);
        }
        return arrayList;
    }

    private static boolean conformsToAlgorithmConstraints(AlgorithmConstraints algorithmConstraints, Certificate[] certificateArray) {
        AlgorithmChecker algorithmChecker = new AlgorithmChecker(algorithmConstraints);
        try {
            algorithmChecker.init(false);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            return false;
        }
        for (int i = certificateArray.length - 1; i >= 0; --i) {
            Certificate certificate = certificateArray[i];
            try {
                algorithmChecker.check(certificate, Collections.<String>emptySet());
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CheckResult {
        OK,
        EXPIRED,
        EXTENSION_MISMATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CheckType {
        NONE(Collections.<String>emptySet()),
        CLIENT(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.2"))),
        SERVER(new HashSet<String>(Arrays.asList("2.5.29.37.0", "1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3")));

        final Set<String> validEku;

        private CheckType(Set<String> set) {
            this.validEku = set;
        }

        private static boolean getBit(boolean[] blArray, int n) {
            return n < blArray.length && blArray[n];
        }

        CheckResult check(X509Certificate x509Certificate, Date date) {
            if (this == NONE) {
                return CheckResult.OK;
            }
            try {
                List<String> list = x509Certificate.getExtendedKeyUsage();
                if (list != null && Collections.disjoint(this.validEku, list)) {
                    return CheckResult.EXTENSION_MISMATCH;
                }
                boolean[] blArray = x509Certificate.getKeyUsage();
                if (blArray != null) {
                    String string = x509Certificate.getPublicKey().getAlgorithm();
                    boolean bl = CheckType.getBit(blArray, 0);
                    if (string.equals("RSA")) {
                        if (!(bl || this != CLIENT && CheckType.getBit(blArray, 2))) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (string.equals("DSA")) {
                        if (!bl) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (string.equals("DH")) {
                        if (!CheckType.getBit(blArray, 4)) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    } else if (string.equals("EC")) {
                        if (!bl) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                        if (this == SERVER && !CheckType.getBit(blArray, 4)) {
                            return CheckResult.EXTENSION_MISMATCH;
                        }
                    }
                }
            }
            catch (CertificateException certificateException) {
                return CheckResult.EXTENSION_MISMATCH;
            }
            try {
                x509Certificate.checkValidity(date);
                return CheckResult.OK;
            }
            catch (CertificateException certificateException) {
                return CheckResult.EXPIRED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryStatus
    implements Comparable<EntryStatus> {
        final int builderIndex;
        final int keyIndex;
        final String alias;
        final CheckResult checkResult;

        EntryStatus(int n, int n2, String string, Certificate[] certificateArray, CheckResult checkResult) {
            this.builderIndex = n;
            this.keyIndex = n2;
            this.alias = string;
            this.checkResult = checkResult;
        }

        @Override
        public int compareTo(EntryStatus entryStatus) {
            int n = this.checkResult.compareTo(entryStatus.checkResult);
            return n == 0 ? this.keyIndex - entryStatus.keyIndex : n;
        }

        public String toString() {
            String string = this.alias + " (verified: " + (Object)((Object)this.checkResult) + ")";
            if (this.builderIndex == 0) {
                return string;
            }
            return "Builder #" + this.builderIndex + ", alias: " + string;
        }
    }

    private static class KeyType {
        final String keyAlgorithm;
        final String sigKeyAlgorithm;

        KeyType(String string) {
            int n = string.indexOf("_");
            if (n == -1) {
                this.keyAlgorithm = string;
                this.sigKeyAlgorithm = null;
            } else {
                this.keyAlgorithm = string.substring(0, n);
                this.sigKeyAlgorithm = string.substring(n + 1);
            }
        }

        boolean matches(Certificate[] certificateArray) {
            if (!certificateArray[0].getPublicKey().getAlgorithm().equals(this.keyAlgorithm)) {
                return false;
            }
            if (this.sigKeyAlgorithm == null) {
                return true;
            }
            if (certificateArray.length > 1) {
                return this.sigKeyAlgorithm.equals(certificateArray[1].getPublicKey().getAlgorithm());
            }
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            String string = x509Certificate.getSigAlgName().toUpperCase(Locale.ENGLISH);
            String string2 = "WITH" + this.sigKeyAlgorithm.toUpperCase(Locale.ENGLISH);
            return string.contains(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SizedMap<K, V>
    extends LinkedHashMap<K, V> {
        private SizedMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > 10;
        }
    }
}

