/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ExtendedSSLParameters;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import sun.security.util.AlgorithmConstraints;

final class SSLServerSocketImpl
extends SSLServerSocket {
    private SSLContextImpl sslContext;
    private byte doClientAuth = 0;
    private boolean useServerMode = true;
    private boolean enableSessionCreation = true;
    private CipherSuiteList enabledCipherSuites = null;
    private ProtocolList enabledProtocols = null;
    private boolean checkedEnabled = false;
    private String identificationProtocol = null;
    private AlgorithmConstraints algorithmConstraints = null;

    SSLServerSocketImpl(int n, int n2, SSLContextImpl sSLContextImpl) throws IOException, SSLException {
        super(n, n2);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(int n, int n2, InetAddress inetAddress, SSLContextImpl sSLContextImpl) throws IOException {
        super(n, n2, inetAddress);
        this.initServer(sSLContextImpl);
    }

    SSLServerSocketImpl(SSLContextImpl sSLContextImpl) throws IOException {
        this.initServer(sSLContextImpl);
    }

    private void initServer(SSLContextImpl sSLContextImpl) throws SSLException {
        if (sSLContextImpl == null) {
            throw new SSLException("No Authentication context given");
        }
        this.sslContext = sSLContextImpl;
        this.enabledCipherSuites = this.sslContext.getDefaultCipherSuiteList(true);
        this.enabledProtocols = this.sslContext.getDefaultProtocolList(true);
    }

    public String[] getSupportedCipherSuites() {
        return this.sslContext.getSupportedCipherSuiteList().toStringArray();
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        this.checkedEnabled = false;
    }

    public String[] getSupportedProtocols() {
        return this.sslContext.getSupportedProtocolList().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
    }

    public boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public void setWantClientAuth(boolean bl) {
        this.doClientAuth = bl ? (byte)1 : 0;
    }

    public boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public void setUseClientMode(boolean bl) {
        if (this.useServerMode != !bl && this.sslContext.isDefaultProtocolList(this.enabledProtocols)) {
            this.enabledProtocols = this.sslContext.getDefaultProtocolList(!bl);
        }
        this.useServerMode = !bl;
    }

    public boolean getUseClientMode() {
        return !this.useServerMode;
    }

    public void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLParameters getSSLParameters() {
        ExtendedSSLParameters extendedSSLParameters = new ExtendedSSLParameters();
        extendedSSLParameters.setCipherSuites(this.getEnabledCipherSuites());
        extendedSSLParameters.setProtocols(this.getEnabledProtocols());
        if (this.getNeedClientAuth()) {
            extendedSSLParameters.setNeedClientAuth(true);
        } else if (this.getWantClientAuth()) {
            extendedSSLParameters.setWantClientAuth(true);
        }
        extendedSSLParameters.setEndpointIdentificationAlgorithm(this.identificationProtocol);
        extendedSSLParameters.setAlgorithmConstraints(this.algorithmConstraints);
        return extendedSSLParameters;
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        String[] stringArray = sSLParameters.getCipherSuites();
        if (stringArray != null) {
            this.setEnabledCipherSuites(stringArray);
        }
        if ((stringArray = sSLParameters.getProtocols()) != null) {
            this.setEnabledProtocols(stringArray);
        }
        if (sSLParameters.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
        if (sSLParameters instanceof ExtendedSSLParameters) {
            ExtendedSSLParameters extendedSSLParameters = (ExtendedSSLParameters)sSLParameters;
            this.identificationProtocol = extendedSSLParameters.getEndpointIdentificationAlgorithm();
            this.algorithmConstraints = extendedSSLParameters.getAlgorithmConstraints();
        }
    }

    public Socket accept() throws IOException {
        SSLSocketImpl sSLSocketImpl = new SSLSocketImpl(this.sslContext, this.useServerMode, this.enabledCipherSuites, this.doClientAuth, this.enableSessionCreation, this.enabledProtocols, this.identificationProtocol, this.algorithmConstraints);
        this.implAccept(sSLSocketImpl);
        sSLSocketImpl.doneConnect();
        return sSLSocketImpl;
    }

    public String toString() {
        return "[SSL: " + super.toString() + "]";
    }
}

