/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.util.KeyUtil;

final class RSAClientKeyExchange
extends HandshakeMessage {
    private ProtocolVersion protocolVersion;
    SecretKey preMaster;
    private byte[] encrypted;

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, PublicKey publicKey) throws IOException {
        if (!publicKey.getAlgorithm().equals("RSA")) {
            throw new SSLKeyException("Public key not of type RSA");
        }
        this.protocolVersion = protocolVersion;
        try {
            String string = protocolVersion.v >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(protocolVersion2.v, protocolVersion.v), secureRandom);
            this.preMaster = keyGenerator.generateKey();
            Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
            cipher.init(3, (Key)publicKey, secureRandom);
            this.encrypted = cipher.wrap(this.preMaster);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLKeyException)new SSLKeyException("RSA premaster secret error").initCause(generalSecurityException);
        }
    }

    RSAClientKeyExchange(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2, SecureRandom secureRandom, HandshakeInStream handshakeInStream, int n, PrivateKey privateKey) throws IOException {
        block16: {
            if (!privateKey.getAlgorithm().equals("RSA")) {
                throw new SSLKeyException("Private key not of type RSA");
            }
            if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
                this.encrypted = handshakeInStream.getBytes16();
            } else {
                this.encrypted = new byte[n];
                if (handshakeInStream.read(this.encrypted) != n) {
                    throw new SSLProtocolException("SSL: read PreMasterSecret: short read");
                }
            }
            byte[] byArray = null;
            try {
                boolean bl = false;
                Cipher cipher = JsseJce.getCipher("RSA/ECB/PKCS1Padding");
                try {
                    cipher.init(4, (Key)privateKey, new TlsRsaPremasterSecretParameterSpec(protocolVersion2.v, protocolVersion.v), secureRandom);
                    bl = !KeyUtil.isOracleJCEProvider(cipher.getProvider().getName());
                }
                catch (InvalidKeyException invalidKeyException) {
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("The Cipher provider " + cipher.getProvider().getName() + " caused exception: " + invalidKeyException.getMessage());
                    }
                    bl = true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("The Cipher provider " + cipher.getProvider().getName() + " caused exception: " + unsupportedOperationException.getMessage());
                    }
                    bl = true;
                }
                if (bl) {
                    cipher.init(2, privateKey);
                    boolean bl2 = false;
                    try {
                        byArray = cipher.doFinal(this.encrypted);
                    }
                    catch (BadPaddingException badPaddingException) {
                        bl2 = true;
                    }
                    byArray = KeyUtil.checkTlsPreMasterSecretKey(protocolVersion2.v, protocolVersion.v, secureRandom, byArray, bl2);
                    this.preMaster = RSAClientKeyExchange.generatePreMasterSecret(protocolVersion2.v, protocolVersion.v, byArray, secureRandom);
                    break block16;
                }
                this.preMaster = (SecretKey)cipher.unwrap(this.encrypted, "TlsRsaPremasterSecret", 3);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SSLProtocolException("Unable to process PreMasterSecret, may be too big");
            }
            catch (Exception exception) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("RSA premaster secret decryption error:");
                    exception.printStackTrace(System.out);
                }
                throw new RuntimeException("Could not generate dummy secret", exception);
            }
        }
    }

    private static SecretKey generatePreMasterSecret(int n, int n2, byte[] byArray, SecureRandom secureRandom) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Generating a premaster secret");
        }
        try {
            String string = n >= ProtocolVersion.TLS12.v ? "SunTls12RsaPremasterSecret" : "SunTlsRsaPremasterSecret";
            KeyGenerator keyGenerator = JsseJce.getKeyGenerator(string);
            keyGenerator.init(new TlsRsaPremasterSecretParameterSpec(n, n2, byArray), secureRandom);
            return keyGenerator.generateKey();
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA premaster secret generation error:");
                invalidAlgorithmParameterException.printStackTrace(System.out);
            }
            throw new RuntimeException("Could not generate premaster secret", invalidAlgorithmParameterException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA premaster secret generation error:");
                noSuchAlgorithmException.printStackTrace(System.out);
            }
            throw new RuntimeException("Could not generate premaster secret", noSuchAlgorithmException);
        }
    }

    int messageType() {
        return 16;
    }

    int messageLength() {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            return this.encrypted.length + 2;
        }
        return this.encrypted.length;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
            handshakeOutStream.putBytes16(this.encrypted);
        } else {
            handshakeOutStream.write(this.encrypted);
        }
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, RSA PreMasterSecret, " + this.protocolVersion);
    }
}

