/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.ssl.SSLAlgorithmConstraints;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.CryptoPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProtocolVersion
implements Comparable<ProtocolVersion> {
    static final int LIMIT_MAX_VALUE = 65535;
    static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion NONE = new ProtocolVersion(-1, "NONE");
    static final ProtocolVersion SSL20Hello = new ProtocolVersion(2, "SSLv2Hello");
    static final ProtocolVersion SSL30 = new ProtocolVersion(768, "SSLv3");
    static final ProtocolVersion TLS10 = new ProtocolVersion(769, "TLSv1");
    static final ProtocolVersion TLS11 = new ProtocolVersion(770, "TLSv1.1");
    static final ProtocolVersion TLS12 = new ProtocolVersion(771, "TLSv1.2");
    private static final boolean FIPS = Provider.isFIPS();
    static final ProtocolVersion MIN = FIPS ? TLS10 : SSL30;
    static final ProtocolVersion MAX = TLS12;
    static final ProtocolVersion DEFAULT = TLS10;
    static final ProtocolVersion DEFAULT_HELLO = FIPS ? TLS10 : SSL30;
    static final Set<ProtocolVersion> availableProtocols;
    final int v;
    final byte major;
    final byte minor;
    final String name;

    @Override
    public int compareTo(ProtocolVersion protocolVersion) {
        return this.v - protocolVersion.v;
    }

    private ProtocolVersion(int n, String string) {
        this.v = n;
        this.name = string;
        this.major = (byte)(n >>> 8);
        this.minor = (byte)(n & 0xFF);
    }

    private static ProtocolVersion valueOf(int n) {
        if (n == ProtocolVersion.SSL30.v) {
            return SSL30;
        }
        if (n == ProtocolVersion.TLS10.v) {
            return TLS10;
        }
        if (n == ProtocolVersion.TLS11.v) {
            return TLS11;
        }
        if (n == ProtocolVersion.TLS12.v) {
            return TLS12;
        }
        if (n == ProtocolVersion.SSL20Hello.v) {
            return SSL20Hello;
        }
        int n2 = n >>> 8 & 0xFF;
        int n3 = n & 0xFF;
        return new ProtocolVersion(n, "Unknown-" + n2 + "." + n3);
    }

    static ProtocolVersion valueOf(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        return ProtocolVersion.valueOf(n3);
    }

    static ProtocolVersion valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Protocol cannot be null");
        }
        if (FIPS && (string.equals(ProtocolVersion.SSL30.name) || string.equals(ProtocolVersion.SSL20Hello.name))) {
            throw new IllegalArgumentException("Only TLS 1.0 or later allowed in FIPS mode");
        }
        if (string.equals(ProtocolVersion.SSL30.name)) {
            return SSL30;
        }
        if (string.equals(ProtocolVersion.TLS10.name)) {
            return TLS10;
        }
        if (string.equals(ProtocolVersion.TLS11.name)) {
            return TLS11;
        }
        if (string.equals(ProtocolVersion.TLS12.name)) {
            return TLS12;
        }
        if (string.equals(ProtocolVersion.SSL20Hello.name)) {
            return SSL20Hello;
        }
        throw new IllegalArgumentException(string);
    }

    public String toString() {
        return this.name;
    }

    static {
        HashSet<ProtocolVersion> hashSet = new HashSet<ProtocolVersion>(5);
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[]{SSL20Hello, SSL30, TLS10, TLS11, TLS12};
        EnumSet<CryptoPrimitive> enumSet = EnumSet.of(CryptoPrimitive.KEY_AGREEMENT);
        for (ProtocolVersion protocolVersion : protocolVersionArray) {
            if (!SSLAlgorithmConstraints.DEFAULT_SSL_ONLY.permits(enumSet, protocolVersion.name, null)) continue;
            hashSet.add(protocolVersion);
        }
        availableProtocols = Collections.unmodifiableSet(hashSet);
    }
}

