/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import sun.security.provider.ParameterCache;

public final class DHKeyPairGenerator
extends KeyPairGeneratorSpi {
    private DHParameterSpec params;
    private int pSize;
    private int lSize;
    private SecureRandom random;

    public DHKeyPairGenerator() {
        this.initialize(1024, null);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        if (n != 2048 && (n < 512 || n > 1024 || n % 64 != 0)) {
            throw new InvalidParameterException("Keysize must be multiple of 64 ranging from 512 to 1024 (inclusive), or 2048");
        }
        this.pSize = n;
        this.lSize = 0;
        this.random = secureRandom;
        this.params = null;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        this.params = (DHParameterSpec)algorithmParameterSpec;
        this.pSize = this.params.getP().bitLength();
        if (this.pSize != 2048 && (this.pSize < 512 || this.pSize > 1024 || this.pSize % 64 != 0)) {
            throw new InvalidAlgorithmParameterException("Prime size must be multiple of 64, and can only range from 512 to 1024 (inclusive), or 2048");
        }
        this.lSize = this.params.getL();
        if (this.lSize != 0 && this.lSize > this.pSize) {
            throw new InvalidAlgorithmParameterException("Exponent size must not be larger than modulus size");
        }
        this.random = secureRandom;
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        if (this.random == null) {
            this.random = SunJCE.RANDOM;
        }
        if (this.params == null) {
            try {
                this.params = ParameterCache.getDHParameterSpec(this.pSize, this.random);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException);
            }
        }
        BigInteger bigInteger2 = this.params.getP();
        BigInteger bigInteger3 = this.params.getG();
        if (this.lSize <= 0) {
            this.lSize = this.pSize >> 1;
            if (this.lSize < 384) {
                this.lSize = 384;
            }
        }
        BigInteger bigInteger4 = bigInteger2.subtract(BigInteger.valueOf(2L));
        while ((bigInteger = new BigInteger(this.lSize, this.random)).compareTo(BigInteger.ONE) < 0 || bigInteger.compareTo(bigInteger4) > 0) {
        }
        BigInteger bigInteger5 = bigInteger3.modPow(bigInteger, bigInteger2);
        DHPublicKey dHPublicKey = new DHPublicKey(bigInteger5, bigInteger2, bigInteger3, this.lSize);
        DHPrivateKey dHPrivateKey = new DHPrivateKey(bigInteger, bigInteger2, bigInteger3, this.lSize);
        return new KeyPair(dHPublicKey, dHPrivateKey);
    }
}

