/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.crypto.CryptoAllPermission;
import javax.crypto.CryptoPermissions;
import javax.crypto.JarVerifier;
import sun.security.jca.GetInstance;
import sun.security.validator.Validator;

final class JceSecurity {
    static final boolean debug = false;
    static final SecureRandom RANDOM = new SecureRandom();
    private static CryptoPermissions defaultPolicy = null;
    private static CryptoPermissions exemptPolicy = null;
    private static final Map verificationResults = new IdentityHashMap();
    private static final Map verifyingProviders = new IdentityHashMap();
    private static final boolean isRestricted;
    private static CertificateFactory certificateFactory;
    private static X509Certificate jceCertificate;
    private static X509Certificate jceCertificate2;
    private static Validator providerValidator;
    private static Validator exemptValidator;
    private static final Object PROVIDER_VERIFIED;
    private static final URL NULL_URL;
    private static final Map codeBaseCacheRef;

    private JceSecurity() {
    }

    private static X509Certificate parseCertificate(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
        return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service service = GetInstance.getService(string, string2, string3);
        Exception exception = JceSecurity.getVerificationResult(service.getProvider());
        if (exception != null) {
            String string4 = "JCE cannot authenticate the provider " + string3;
            throw (NoSuchProviderException)new NoSuchProviderException(string4).initCause(exception);
        }
        return GetInstance.getInstance(service, clazz);
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service service = GetInstance.getService(string, string2, provider);
        Exception exception = JceSecurity.getVerificationResult(provider);
        if (exception != null) {
            String string3 = "JCE cannot authenticate the provider " + provider.getName();
            throw new SecurityException(string3, exception);
        }
        return GetInstance.getInstance(service, clazz);
    }

    static GetInstance.Instance getInstance(String string, Class clazz, String string2) throws NoSuchAlgorithmException {
        List<Provider.Service> list = GetInstance.getServices(string, string2);
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        for (Provider.Service service : list) {
            if (!JceSecurity.canUseProvider(service.getProvider())) continue;
            try {
                GetInstance.Instance instance = GetInstance.getInstance(service, clazz);
                return instance;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        throw new NoSuchAlgorithmException("Algorithm " + string2 + " not available", noSuchAlgorithmException);
    }

    static CryptoPermissions verifyExemptJar(URL uRL) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(uRL, exemptValidator, true);
        jarVerifier.verify();
        return jarVerifier.getPermissions();
    }

    static void verifyProviderJar(URL uRL) throws Exception {
        JarVerifier jarVerifier = new JarVerifier(uRL, providerValidator, false);
        jarVerifier.verify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized Exception getVerificationResult(Provider provider) {
        Object v = verificationResults.get(provider);
        if (v == PROVIDER_VERIFIED) {
            return null;
        }
        if (v != null) {
            return (Exception)v;
        }
        if (verifyingProviders.get(provider) != null) {
            return new NoSuchProviderException("Recursion during verification");
        }
        try {
            verifyingProviders.put(provider, Boolean.FALSE);
            URL uRL = JceSecurity.getCodeBase(provider.getClass());
            JceSecurity.verifyProviderJar(uRL);
            verificationResults.put(provider, PROVIDER_VERIFIED);
            Exception exception = null;
            return exception;
        }
        catch (Exception exception) {
            verificationResults.put(provider, exception);
            Exception exception2 = exception;
            return exception2;
        }
        finally {
            verifyingProviders.remove(provider);
        }
    }

    static boolean canUseProvider(Provider provider) {
        return JceSecurity.getVerificationResult(provider) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL getCodeBase(final Class clazz) {
        Map map = codeBaseCacheRef;
        synchronized (map) {
            URL uRL = (URL)codeBaseCacheRef.get(clazz);
            if (uRL == null) {
                uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        CodeSource codeSource;
                        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                        if (protectionDomain != null && (codeSource = protectionDomain.getCodeSource()) != null) {
                            return codeSource.getLocation();
                        }
                        return NULL_URL;
                    }
                });
                codeBaseCacheRef.put(clazz, uRL);
            }
            return uRL == NULL_URL ? null : uRL;
        }
    }

    private static void setupJurisdictionPolicies() throws Exception {
        Object object2;
        String string = System.getProperty("java.home");
        String string2 = File.separator;
        String string3 = string + string2 + "lib" + string2 + "security" + string2;
        File file = new File(string3, "US_export_policy.jar");
        File file2 = new File(string3, "local_policy.jar");
        URL uRL = ClassLoader.getSystemResource("javax/crypto/Cipher.class");
        if (uRL == null || !file.exists() || !file2.exists()) {
            throw new SecurityException("Cannot locate policy or framework files!");
        }
        List list = JarVerifier.getSignersOfJarEntry(uRL);
        for (Object object2 : list) {
            if (!object2[0].equals(jceCertificate)) continue;
            list = null;
            break;
        }
        if (list != null) {
            throw new SecurityException("Jurisdiction policy files are not signed by trusted signers!");
        }
        CryptoPermissions cryptoPermissions = new CryptoPermissions();
        object2 = new CryptoPermissions();
        JceSecurity.loadPolicies(file, cryptoPermissions, (CryptoPermissions)object2);
        CryptoPermissions cryptoPermissions2 = new CryptoPermissions();
        CryptoPermissions cryptoPermissions3 = new CryptoPermissions();
        JceSecurity.loadPolicies(file2, cryptoPermissions2, cryptoPermissions3);
        if (cryptoPermissions.isEmpty() || cryptoPermissions2.isEmpty()) {
            throw new SecurityException("Missing mandatory jurisdiction policy files");
        }
        defaultPolicy = cryptoPermissions.getMinimum(cryptoPermissions2);
        exemptPolicy = ((CryptoPermissions)object2).isEmpty() ? (cryptoPermissions3.isEmpty() ? null : cryptoPermissions3) : ((CryptoPermissions)object2).getMinimum(cryptoPermissions3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPolicies(File file, CryptoPermissions cryptoPermissions, CryptoPermissions cryptoPermissions2) throws Exception {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                if (jarEntry.getName().startsWith("default_")) {
                    inputStream = jarFile.getInputStream(jarEntry);
                    cryptoPermissions.load(inputStream);
                } else {
                    if (!jarEntry.getName().startsWith("exempt_")) continue;
                    inputStream = jarFile.getInputStream(jarEntry);
                    cryptoPermissions2.load(inputStream);
                }
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
                continue;
            }
            Certificate[] certificateArray = jarEntry.getCertificates();
            List list = JarVerifier.convertCertsToChains(certificateArray);
            boolean bl = false;
            for (X509Certificate[] x509CertificateArray : list) {
                X509Certificate x509Certificate = x509CertificateArray[0];
                if (!x509Certificate.equals(jceCertificate) && !x509Certificate.equals(jceCertificate2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new SecurityException("Jurisdiction policy files are not signed by trusted signers!");
        }
        jarFile.close();
        jarFile = null;
    }

    static CryptoPermissions getDefaultPolicy() {
        return defaultPolicy;
    }

    static CryptoPermissions getExemptPolicy() {
        return exemptPolicy;
    }

    static boolean isRestricted() {
        return isRestricted;
    }

    private static byte[] getSystemEntropy() {
        Object object;
        Object object2;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        try {
            object2 = System.getProperties();
            Enumeration<?> enumeration = ((Properties)object2).propertyNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                messageDigest.update(((String)object).getBytes());
                messageDigest.update(((Properties)object2).getProperty((String)object).getBytes());
            }
            messageDigest.update(InetAddress.getLocalHost().toString().getBytes());
            File file = new File(((Properties)object2).getProperty("java.io.tmpdir"));
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                messageDigest.update(stringArray[i].getBytes());
            }
        }
        catch (Exception exception) {
            messageDigest.update((byte)exception.hashCode());
        }
        object = Runtime.getRuntime();
        object2 = JceSecurity.longToByteArray(((Runtime)object).totalMemory());
        messageDigest.update((byte[])object2, 0, ((Object)object2).length);
        object2 = JceSecurity.longToByteArray(((Runtime)object).freeMemory());
        messageDigest.update((byte[])object2, 0, ((Object)object2).length);
        return messageDigest.digest();
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    private static void testSignatures(X509Certificate x509Certificate) throws Exception {
        PublicKey[] publicKeyArray;
        String string = "-----BEGIN CERTIFICATE-----\nMIIDLDCCAukCBDf5OeUwCwYHKoZIzjgEAwUAMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwHhcNOTkxMDA0MjMzNjA1WhcNMDAxMDAzMjMzNjA1WjB7MQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCUN1cGVydGlubzEZMBcGA1UEChMQU3VuIE1pY3Jvc3lzdGVtczEWMBQGA1UECxMNSmF2YSBTb2Z0d2FyZTEYMBYGA1UEAxMPSkNFIERldmVsb3BtZW50MIIBuDCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYUAAoGBAOGsR8waR5aiuOk1yBLemRlVCY+APJv3xqmPRxWAF6nwV2xrFUB8ghSEMFcHywoe4vBDvkGSoAFzeB5jy5wjDiFsN5AFPEVRfveS4NNZ1dgRdHbbh3h5O1dZE4MAKQwQfUoh9Oa3aahlB+orRzKOHLlGDpbNRQLST5BClvohramCMAsGByqGSM44BAMFAAMwADAtAhRF46T3nS+inP9TA1pLd3LIV0NNDQIVAIafi+1/+JKxu0rcoXWMFSxNaRb3\n-----END CERTIFICATE-----";
        byte[] byArray = JceSecurity.getSystemEntropy();
        int n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
        X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate, JceSecurity.parseCertificate(string), JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIB4DCCAYoCAQEwDQYJKoZIhvcNAQEEBQAwezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlDdXBlcnRpbm8xGTAXBgNVBAoTEFN1biBNaWNyb3N5c3RlbXMxFjAUBgNVBAsTDUphdmEgU29mdHdhcmUxGDAWBgNVBAMTD0pDRSBEZXZlbG9wbWVudDAeFw0wMjEwMzExNTI3NDRaFw0wNzEwMzExNTI3NDRaMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAo/4CddEOa3M6v9JFAhnBYgTq54Y30++F8yzCK9EeYaG3AzvzZqNshDy579647p0cOM/4VO6rU2PgbzgKXPcs8wIDAQABMA0GCSqGSIb3DQEBBAUAA0EACqPlFmVdKdYSCTNltXKQnBqss9GNjbnB+CitvWrwN+oOK8qQpvV+5LB6LruvRy6zCedCV95Z2kXKg/Fnj0gvsg==\n-----END CERTIFICATE-----"), JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIB4DCCAYoCAQIwDQYJKoZIhvcNAQEEBQAwezELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlDdXBlcnRpbm8xGTAXBgNVBAoTEFN1biBNaWNyb3N5c3RlbXMxFjAUBgNVBAsTDUphdmEgU29mdHdhcmUxGDAWBgNVBAMTD0pDRSBEZXZlbG9wbWVudDAeFw0wMjEwMzExNTI3NDRaFw0wNzEwMzExNTI3NDRaMHsxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJQ3VwZXJ0aW5vMRkwFwYDVQQKExBTdW4gTWljcm9zeXN0ZW1zMRYwFAYDVQQLEw1KYXZhIFNvZnR3YXJlMRgwFgYDVQQDEw9KQ0UgRGV2ZWxvcG1lbnQwXDANBgkqhkiG9w0BAQEFAANLADBIAkEAr1OSXaOzpnVoqL2LqS5+HLy1kVvBwiM/E5iYT9eZaghE8qvF+4fETipWUNTWCQzHR4cDJGJOl9Nm77tELhES4QIDAQABMA0GCSqGSIb3DQEBBAUAA0EAL+WcVFyj+iXlEVNVQbNOOUlWmlmXGiNKKXnIdNcc1ZUyi+JW0zmlfZ7iU/eRYhEEJBwdrUoyiGOGLo7pi6JzAA==\n-----END CERTIFICATE-----")};
        publicKeyArray = new PublicKey[]{x509Certificate.getPublicKey(), publicKeyArray[0], x509CertificateArray[2].getPublicKey(), publicKeyArray[2]};
        boolean[] blArray = new boolean[]{true, false, true, false};
        for (int i = 0; i < 12; ++i) {
            boolean bl;
            int n2 = n & 3;
            n >>= 2;
            try {
                x509CertificateArray[n2].verify(publicKeyArray[n2]);
                bl = true;
            }
            catch (SignatureException signatureException) {
                bl = false;
            }
            catch (InvalidKeyException invalidKeyException) {
                bl = false;
            }
            if (bl == blArray[n2]) continue;
            throw new SecurityException("Signature classes have been tampered with");
        }
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JceSecurity.certificateFactory = CertificateFactory.getInstance("X.509");
                    jceCertificate = JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIICnTCCAlugAwIBAgICAh8wCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTA1MTEyMzIyNDk0MVoXDTEwMTEyNzIyNDk0MVowYzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMR0wGwYDVQQDExRTdW4gTWljcm9zeXN0ZW1zIEluYzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA16bKo6tC3OHFDNfPXLKXMCMtIyeubNnsEtlvrH34HhfF+ZmpSliLCvQ15ms705vy4XgZUbZ3mgSOlLRMAGRo6596ePhc+0Z6yeKhbb3LZ8iz97ZIptkHGOshj9cfcSRPYmorUug9OsybMdIfQXazxT9mZJ9Yx5IDw6xak7kVbpUCAwEAAaOBiDCBhTARBglghkgBhvhCAQEEBAMCBBAwDgYDVR0PAQH/BAQDAgXgMB0GA1UdDgQWBBRI319jCbhc9DWJVltXgfrMybHNjzAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAgBgNVHREEGTAXgRV5dS1jaGluZy5wZW5nQHN1bi5jb20wCwYHKoZIzjgEAwUAAy8AMCwCFFBFmED9s3OoN9rbXfQV3+brJPW/AhQr+Wq1MlubAvnfjrlqeksh0QaDAQ==\n-----END CERTIFICATE-----");
                    jceCertificate2 = JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIICnjCCAlugAwIBAgICAV0wCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTAyMTAyNTE5MDUxMFoXDTA3MTAyOTE5MDUxMFowYzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMR0wGwYDVQQDExRTdW4gTWljcm9zeXN0ZW1zIEluYzCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA16bKo6tC3OHFDNfPXLKXMCMtIyeubNnsEtlvrH34HhfF+ZmpSliLCvQ15ms705vy4XgZUbZ3mgSOlLRMAGRo6596ePhc+0Z6yeKhbb3LZ8iz97ZIptkHGOshj9cfcSRPYmorUug9OsybMdIfQXazxT9mZJ9Yx5IDw6xak7kVbpUCAwEAAaOBiDCBhTARBglghkgBhvhCAQEEBAMCBBAwDgYDVR0PAQH/BAQDAgXgMB0GA1UdDgQWBBRI319jCbhc9DWJVltXgfrMybHNjzAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAgBgNVHREEGTAXgRV5dS1jaGluZy5wZW5nQHN1bi5jb20wCwYHKoZIzjgEAwUAAzAAMC0CFFmXXV97KWezNwPFiAJt5IWpPGVqAhUAggVpunP/Bo8BOcwIoUpgYYQ7ruY=\n-----END CERTIFICATE-----");
                    X509Certificate[] x509CertificateArray = new X509Certificate[]{JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIDwDCCA36gAwIBAgIBEDALBgcqhkjOOAQDBQAwgZAxCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTESMBAGA1UEBxMJUGFsbyBBbHRvMR0wGwYDVQQKExRTdW4gTWljcm9zeXN0ZW1zIEluYzEjMCEGA1UECxMaSmF2YSBTb2Z0d2FyZSBDb2RlIFNpZ25pbmcxHDAaBgNVBAMTE0pDRSBDb2RlIFNpZ25pbmcgQ0EwHhcNMDEwNDI1MDcwMDAwWhcNMjAwNDI1MDcwMDAwWjCBkDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRIwEAYDVQQHEwlQYWxvIEFsdG8xHTAbBgNVBAoTFFN1biBNaWNyb3N5c3RlbXMgSW5jMSMwIQYDVQQLExpKYXZhIFNvZnR3YXJlIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTCCAbcwggEsBgcqhkjOOAQBMIIBHwKBgQDrrzcEHspRHmldsPKP9rVJH8akmQXXKb90t2r1Gdge5Bv4CgGamP9wq+JKVoZsU7P84ciBjDHwxPOwi+ZwBuz3aWjbg0xyKYkpNhdcO0oHoCACKkaXUR1wyAgYC84Mbpt29wXj5/vTYXnhYJokjQaVgzxRIOEwzzhXgqYacg3O0wIVAIQlReG6ualiq3noWzC4iWsb/3t1AoGBAKvJdHt07+5CtWpTTTvdkAZyaJEPC6Qpdi5VO9WuTWVcfio6BKZnptBxqqXXt+LBcg2k0aoeklRMIAAJorAJQRkzALLDXK5C+LGLynyW2BB/N0Rbqsx4yNdydjdrQJmoVWb6qAMei0oRAmnLTLglBhygd9LJrNI96QoQ+nZwt/vcA4GEAAKBgC0JmFysuJzHmX7uIBkqNJD516urrt1rcpUNZvjvJ49Esu0oRMf+r7CmJ28AZ0WCWweoVlY70ilRYV5pOdcudHcSzxlK9S3Iy3JhxE5v+kdDPxS7+rwYZijC2WaLei0vwmCSSxT+WD4hf2hivmxISfmgS16FnRkQ+RVFURtx1PcLo2YwZDARBglghkgBhvhCAQEEBAMCAAcwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBRl4vSGydNO8JFOWKJq9dh4WprBpjAdBgNVHQ4EFgQUZeL0hsnTTvCRTliiavXYeFqawaYwCwYHKoZIzjgEAwUAAy8AMCwCFCr3zzyXXfl4tgjXQbTZDUVM5LScAhRFzXVpDiH6HdazKbLp9zMdM/38SQ==\n-----END CERTIFICATE-----"), JceSecurity.parseCertificate("-----BEGIN CERTIFICATE-----\nMIIDUTCCAw2gAwIBAgIEQCFoETALBgcqhkjOOAQDBQAwYDELMAkGA1UEBhMCVVMxGDAWBgNVBAoTD0lCTSBDb3Jwb3JhdGlvbjEZMBcGA1UECxMQSUJNIENvZGUgU2lnbmluZzEcMBoGA1UEAxMTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0wNDAyMDQyMTQ1NTNaFw0yMDA1MjYyMDQ1NTNaMGAxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9JQk0gQ29ycG9yYXRpb24xGTAXBgNVBAsTEElCTSBDb2RlIFNpZ25pbmcxHDAaBgNVBAMTE0pDRSBDb2RlIFNpZ25pbmcgQ0EwggG4MIIBLAYHKoZIzjgEATCCAR8CgYEA/X9TgR11EilS30qcLuzk5/YRt1I870QAwx4/gLZRJmlFXUAiUftZPY1Y+r/F9bow9subVWzXgTuAHTRv8mZgt2uZUKWkn5/oBHsQIsJPu6nX/rfGG/g7V+fGqKYVDwT7g/bTxR7DAjVUE1oWkTL2dfOuK2HXKu/yIgMZndFIAccCFQCXYFCPFSMLzLKSuYKi64QL8Fgc9QKBgQD34aCF1ps93su8q1w2uFe5eZSvu/o66oL5V0wLPQeCZ1FZV4661FlP5nEHEIGAtEkWcSPoTCgWE7fPCTKMyKbhPBZ6i1R8jSjgo64eK7OmdZFuo38L+iE1YvH7YnoBJDvMpPG+qFGQiaiD3+Fa5Z8GkotmXoB7VSVkAUw7/s9JKgOBhQACgYEA6msAx98QO7l0NafhbWaCTfdbVnHCJkUncj1REGL/s9wQyftRE9Sti6glbl3JeNJbJ9MTQUcUBnzLgjhexgthoEyDLZTMjC6EkDqPQgppUtN0JnekFH0qcUGIiXemLWKaoViYbWzPzqjqut3ooRBEjIRCwbgfK7S8s110YICNQlSjUzBRMB0GA1UdDgQWBBR+PU1NzBBZuvmuQj3lyVdaUgt+hzAfBgNVHSMEGDAWgBR+PU1NzBBZuvmuQj3lyVdaUgt+hzAPBgNVHRMBAf8EBTADAQH/MAsGByqGSM44BAMFAAMxADAuAhUAi5ncRzk0NqFYt4yWsnlcVBPt+zsCFQCM9M0mv0t9iodsOOHJhqUrW1QjAA==\n-----END CERTIFICATE-----"), jceCertificate, jceCertificate2};
                    providerValidator = Validator.getInstance("Simple", "jce signing", Arrays.asList(x509CertificateArray));
                    exemptValidator = providerValidator;
                    JceSecurity.testSignatures(x509CertificateArray[0]);
                    JceSecurity.setupJurisdictionPolicies();
                    JceSecurity.certificateFactory = null;
                    return null;
                }
            });
            isRestricted = !defaultPolicy.implies(CryptoAllPermission.INSTANCE);
        }
        catch (Exception exception) {
            SecurityException securityException = new SecurityException("Cannot set up certs for trusted CAs");
            securityException.initCause(exception);
            throw securityException;
        }
        PROVIDER_VERIFIED = Boolean.TRUE;
        try {
            NULL_URL = new URL("http://null.sun.com/");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        codeBaseCacheRef = new WeakHashMap();
    }
}

