/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.BrowserSupport;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.BasicService;
import sun.awt.DesktopBrowse;

public final class BasicServiceImpl
implements BasicService {
    private URL _codebase = null;
    private String _codebaseProtocol = null;
    private boolean _isWebBrowserSupported;
    private static BasicServiceImpl _sharedInstance = null;

    private BasicServiceImpl(URL uRL, boolean bl, String string) {
        this._codebaseProtocol = string;
        this._codebase = uRL;
        this._isWebBrowserSupported = bl;
        if (Config.isJavaVersionAtLeast16() && DesktopBrowse.getInstance() == null) {
            try {
                DesktopBrowse.setInstance((DesktopBrowse)new BasicServiceBrowser());
            }
            catch (Throwable throwable) {
                Trace.ignored((Throwable)throwable);
            }
        }
    }

    public static BasicServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static void initialize(URL uRL, boolean bl, String string) {
        if (_sharedInstance == null) {
            _sharedInstance = new BasicServiceImpl(uRL, bl, string);
        }
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public boolean isOffline() {
        return DeployOfflineManager.isGlobalOffline();
    }

    private boolean isFileProtocolCodebase() {
        return this._codebaseProtocol != null && this._codebaseProtocol.equalsIgnoreCase("file");
    }

    static boolean isArgumentOkay(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        return true;
    }

    private boolean isValidURL(URL uRL) {
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        URL uRL2 = launchDesc.getMainJarURL();
        return uRL2 == null || URLUtil.checkDocumentURL((URL)uRL2, (URL)uRL);
    }

    public boolean showDocument(URL uRL) {
        DesktopBrowse desktopBrowse;
        if (uRL == null) {
            return false;
        }
        try {
            uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return false;
        }
        if (!URLUtil.checkDocumentURL((URL)this._codebase, (URL)uRL)) {
            return false;
        }
        if (Config.isJavaVersionAtLeast16() && (desktopBrowse = DesktopBrowse.getInstance()) != null && !(desktopBrowse instanceof BasicServiceBrowser)) {
            if (!this.isWebBrowserSupported()) {
                return false;
            }
            try {
                uRL = new URL(this._codebase, uRL.toString());
                if (!BasicServiceImpl.isArgumentOkay(uRL.toString())) {
                    return false;
                }
                if (!this.isValidURL(uRL)) {
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            desktopBrowse.browse(uRL);
            return true;
        }
        return this.showDocumentHelper(uRL);
    }

    private boolean showDocumentHelper(final URL uRL) {
        Comparable<File> comparable;
        boolean bl = uRL.toString().toLowerCase().endsWith(".jnlp");
        boolean bl2 = false;
        try {
            comparable = DownloadEngine.getCachedFile((URL)uRL);
            bl2 = comparable != null;
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
        if ((bl || bl2) && (comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (DownloadEngine.isJnlpURL((URL)uRL)) {
                    try {
                        String string = DownloadEngine.getCachedResourceFilePath((URL)uRL, null);
                        if (string != null && BasicServiceImpl.isArgumentOkay(string)) {
                            String[] stringArray = new String[]{Config.getJavawsCommand(), "-Xnosplash", string};
                            Runtime.getRuntime().exec(stringArray);
                            return new Boolean(true);
                        }
                    }
                    catch (Exception exception) {
                        Trace.ignored((Throwable)exception);
                        return new Boolean(false);
                    }
                }
                return new Boolean(false);
            }
        })) != null && ((Boolean)comparable).booleanValue()) {
            return true;
        }
        if (!this.isWebBrowserSupported()) {
            return false;
        }
        comparable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL3 = uRL;
                try {
                    URL uRL2 = new URL(BasicServiceImpl.this._codebase, uRL3.toString());
                    if (!BasicServiceImpl.isArgumentOkay(uRL2.toString())) {
                        return new Boolean(false);
                    }
                    if (!BasicServiceImpl.this.isValidURL(uRL2)) {
                        return new Boolean(false);
                    }
                    uRL3 = uRL2;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return new Boolean(BrowserSupport.showDocument(uRL3));
            }
        });
        return comparable == null ? false : (Boolean)comparable;
    }

    public boolean isWebBrowserSupported() {
        PerfLogger.setEndTime((String)"BasicService.isWebBrowserSupported called");
        PerfLogger.outputLog();
        return this._isWebBrowserSupported;
    }

    private class BasicServiceBrowser
    extends DesktopBrowse {
        private BasicServiceBrowser() {
        }

        public void browse(URL uRL) {
            BasicServiceImpl.this.showDocument(uRL);
        }
    }
}

