/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CredentialManager;
import com.sun.deploy.util.Trace;

public final class MSCredentialManager
extends CredentialManager {
    private static boolean isEncryptionSupported = false;
    private static long sessionId = -1L;

    MSCredentialManager() {
    }

    public static synchronized CredentialManager getInstance() {
        if (instance == null) {
            instance = new MSCredentialManager();
        }
        return instance;
    }

    protected boolean isPasswordEncryptionSupported() {
        return isEncryptionSupported;
    }

    protected byte[] encryptPassword(char[] cArray) {
        byte[] byArray = new byte[]{};
        try {
            if (cArray.length > 0) {
                byArray = MSCredentialManager.encryptMSPassword(cArray);
            }
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
        return byArray;
    }

    protected long getLoginSessionId() {
        return sessionId;
    }

    protected char[] decryptPassword(byte[] byArray) {
        char[] cArray = null;
        try {
            cArray = MSCredentialManager.decryptMSPassword(byArray);
        }
        catch (Exception exception) {
            Trace.securityPrintException(exception);
        }
        return cArray;
    }

    private static native byte[] encryptMSPassword(char[] var0);

    private static native char[] decryptMSPassword(byte[] var0);

    private static native boolean isEncryptionAvailable();

    private static native long getLoginUID();

    static {
        String string = System.getProperty("os.name").toLowerCase();
        if ((string.indexOf("windows") == -1 || string.indexOf("98") == -1) && string.indexOf("me") == -1 && string.indexOf("nt") == -1) {
            isEncryptionSupported = MSCredentialManager.isEncryptionAvailable();
            sessionId = MSCredentialManager.getLoginUID();
        }
    }
}

