/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.util.http.server.forms;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import hr.iii.util.http.server.forms.FilePart;
import hr.iii.util.http.server.forms.ParamPart;
import hr.iii.util.http.server.forms.Part;
import hr.iii.util.http.server.forms.ServerInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class HttpFormParser {
    private ServerInputStream in;
    private String boundary;
    private int maxsize;
    private FilePart lastFilePart;
    private static String DEFAULT_ENCODING = "UTF-8";
    private String encoding = DEFAULT_ENCODING;
    private byte[] buf = new byte[8192];

    public HttpFormParser(HttpExchange req, int maxSize) throws IOException {
        this(req, maxSize, null);
    }

    public HttpFormParser(HttpExchange req, int maxSize, String encoding) throws IOException {
        String line;
        Headers header;
        String contentType;
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        if ((contentType = (header = req.getRequestHeaders()).getFirst("Content-type")) == null || !contentType.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        this.maxsize = maxSize;
        this.boundary = this.extractBoundary(contentType);
        if (this.boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        try {
            this.in = new ServerInputStream(req.getRequestBody());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        do {
            if ((line = this.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!line.startsWith(this.boundary));
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        Vector<String> headers = new Vector<String>();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        while (line != null && line.length() > 0) {
            String nextLine = null;
            boolean getNextLine = true;
            while (getNextLine) {
                nextLine = this.readLine();
                if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    line = line + nextLine;
                    continue;
                }
                getNextLine = false;
            }
            headers.addElement(line);
            line = nextLine;
        }
        if (line == null) {
            return null;
        }
        String name = null;
        String filename = null;
        String origname = null;
        String contentType = "text/plain";
        Enumeration elements = headers.elements();
        while (elements.hasMoreElements()) {
            String type;
            String headerline = (String)elements.nextElement();
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                String[] dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2];
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = this.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        if (filename == null) {
            return new ParamPart(name, this.in, this.boundary, this.encoding);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.lastFilePart = new FilePart(name, this.in, this.boundary, contentType, filename, origname);
        return this.lastFilePart;
    }

    private String extractContentType(String line) {
        int end = (line = line.toLowerCase()).indexOf(";");
        if (end == -1) {
            end = line.length();
        }
        return line.substring(13, end).trim();
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[4];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        int startOffset = 6;
        if (start == -1 || end == -1) {
            start = line.indexOf("name=", end);
            end = line.indexOf(";", start + 6);
            if (start == -1) {
                throw new IOException("Content disposition corrupt: " + origline);
            }
            if (end == -1) {
                end = line.length();
            }
            startOffset = 5;
        }
        String name = origline.substring(start + startOffset, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }
}

