/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.xml;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.XmlRecord;
import java.io.ByteArrayOutputStream;
import java.util.EnumMap;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RacunResponse
extends Response {
    public static final String TAG = "tns:RacunOdgovor";

    @Override
    public String getTag() {
        return TAG;
    }

    public String getJir() {
        Node jir = this.getDocument().getElementsByTagName("tns:Jir").item(0);
        if (jir == null) {
            return "";
        }
        return jir.getTextContent();
    }

    @Override
    public XmlRecord createAnswer(Request request) {
        Element element;
        String content;
        XmlRecord xml = this.createXml(request);
        Node nodeResponse = xml.getDocument().getElementsByTagName("Response").item(0);
        Node node = request.getDocument().getElementsByTagName("tns:ZastKod").item(0);
        if (node != null && !(content = node.getTextContent()).isEmpty()) {
            element = xml.getDocument().createElement("ZastitniKod");
            element.setTextContent(content);
            nodeResponse.appendChild(element);
            Element QRTextelement = xml.getDocument().createElement("QRCodeText");
            QRTextelement.setTextContent(RacunResponse.getQrText(request));
            nodeResponse.appendChild(QRTextelement);
            Element QRelement = xml.getDocument().createElement("QRCode");
            String base64 = RacunResponse.getQrCode(request);
            QRelement.setTextContent(base64);
            nodeResponse.appendChild(QRelement);
        }
        if ((node = request.getDocument().getElementsByTagName("tns:IdPoruke").item(0)) != null && !(content = node.getTextContent()).isEmpty()) {
            element = xml.getDocument().createElement("IdPoruke");
            element.setTextContent(content);
            nodeResponse.appendChild(element);
        }
        if (!this.getJir().isEmpty()) {
            Element element2 = xml.getDocument().createElement("Jir");
            element2.setTextContent(this.getJir());
            nodeResponse.appendChild(element2);
        }
        return xml;
    }

    @Override
    public String toString() {
        String string = this.getTag() + ": ";
        try {
            string = string + this.getDocument().getElementsByTagName("tns:IdPoruke").item(0).getTextContent() + " / ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String datumVrijeme = this.getDocument().getElementsByTagName("tns:DatumVrijeme").item(0).getTextContent() + " / ";
            string = string + datumVrijeme.substring(0, 10) + " " + datumVrijeme.substring(11);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = string + this.getDocument().getElementsByTagName("tns:Jir").item(0).getTextContent() + " / ";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasError()) {
            string = string + " / gre\u0139\u02c7ka :" + this.getErrorCode();
        }
        return string;
    }

    public static String getQrText(Request request) {
        String zki = "";
        String dateTime = "";
        String iznos = "";
        Node node = request.getDocument().getElementsByTagName("tns:ZastKod").item(0);
        if (node != null) {
            zki = node.getTextContent();
        }
        if ((node = request.getDocument().getElementsByTagName("tns:DatVrijeme").item(0)) != null) {
            String value = node.getTextContent();
            dateTime = value.substring(6, 10) + value.substring(3, 5) + value.substring(0, 2) + "_" + value.substring(11, 13) + value.substring(14, 16);
        }
        if ((node = request.getDocument().getElementsByTagName("tns:IznosUkupno").item(0)) != null) {
            iznos = node.getTextContent();
        }
        return AppContext.getContext().getQrCodeURL() + "?zki=" + zki + "&datv=" + dateTime + "&izn=" + iznos.replace(".", "").replace(",", "");
    }

    public static String getQrCode(Request request) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String qrString = RacunResponse.getQrText(request);
        try {
            EnumMap<EncodeHintType, Integer> hints = null;
            hints = new EnumMap<EncodeHintType, Integer>(EncodeHintType.class);
            hints.put(EncodeHintType.MARGIN, 2);
            BitMatrix bitMatrix = new QRCodeWriter().encode(qrString, BarcodeFormat.QR_CODE, 125, 125, hints);
            MatrixToImageWriter.writeToStream(bitMatrix, "gif", out);
        }
        catch (Exception e) {
            return "";
        }
        return new String(Base64.encodeBase64(out.toByteArray()));
    }
}

