/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal.ui;

import hr.iii.fiskal.AppContext;
import hr.iii.util.http.server.AbstractHttpHandler;
import hr.iii.util.http.server.forms.HttpFormParser;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class LogsHandler
extends AbstractHttpHandler {
    @Override
    protected byte[] createPostResponse(String uri, HttpFormParser parser) throws IOException {
        return null;
    }

    @Override
    protected byte[] prepareResponse(byte[] response) {
        return response;
    }

    @Override
    protected byte[] createResponse(String uri) throws IOException {
        if (uri.toLowerCase().indexOf("dir") >= 0) {
            return this.getLogFiles().getBytes();
        }
        if (uri.toLowerCase().indexOf("read") >= 0) {
            String emptyFile = "<FILE></FILE>";
            if (this.parameters != null) {
                String fileName = (String)this.parameters.get("file");
                String strFPos = (String)this.parameters.get("fpos");
                String strLines = (String)this.parameters.get("lines");
                if (fileName == null) {
                    return emptyFile.getBytes();
                }
                int lines = 0;
                long fpos = -1L;
                if (strLines != null) {
                    lines = Integer.parseInt(strLines);
                }
                if (lines <= 0) {
                    return emptyFile.getBytes();
                }
                if (strFPos != null) {
                    fpos = Long.parseLong(strFPos);
                }
                return this.getFileLines(fileName, fpos, lines).getBytes();
            }
            return emptyFile.getBytes();
        }
        return this.createResponseFromFile("logs.html");
    }

    private String getLogFiles() {
        String newHtml = "<DIR>";
        try {
            File folder = new File(AppContext.getLogDir() + ".");
            Object[] listOfFiles = folder.listFiles();
            Arrays.sort(listOfFiles);
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fname;
                if (!((File)listOfFiles[i]).isFile() || (fname = ((File)listOfFiles[i]).getName()).indexOf(".log") <= 0 || fname.indexOf(".lck") >= 0 || fname.indexOf("proxy") < 0 && fname.indexOf("request") < 0) continue;
                newHtml = newHtml + "<FILE>" + fname + "</FILE>";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        newHtml = newHtml + "</DIR>";
        return newHtml;
    }

    private String getFileLines(String fileName, long fpos, int lines) {
        String newHtml = "<FILE>";
        long flen = 0L;
        try {
            RandomAccessFile file = new RandomAccessFile(AppContext.getLogDir() + fileName, "r");
            flen = file.length();
            if (fpos == -1L) {
                fpos = flen - 1L;
                file.seek(fpos);
                int lineOffset = -1 * lines;
                while (lineOffset < 0 && fpos > 0L) {
                    byte readByte;
                    try {
                        readByte = file.readByte();
                        file.seek(--fpos);
                    }
                    catch (IOException e) {
                        break;
                    }
                    if (readByte != 10) continue;
                    ++lineOffset;
                }
            } else {
                file.seek(fpos);
            }
            for (int lastLine = 0; lastLine < lines; ++lastLine) {
                String line;
                try {
                    line = file.readLine();
                    if (line == null) {
                    }
                }
                catch (IOException e) {}
                break;
                newHtml = newHtml + "<LINE>" + LogsHandler.escape(line) + "</LINE>";
            }
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        newHtml = newHtml + "<POS>" + flen + "</POS>";
        newHtml = newHtml + "</FILE>";
        return newHtml;
    }

    private static String escape(String s) {
        String retVal = s;
        retVal = retVal.replace("<", "%3C");
        retVal = retVal.replace(">", "%3E");
        retVal = retVal.replace("\"", "%22");
        return retVal;
    }
}

