/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import hr.iii.fiskal.AppContext;
import hr.iii.fiskal.AppKeyStoreException;
import hr.iii.fiskal.soapssl.SSLClient;
import hr.iii.fiskal.soapssl.SSLSoapException;
import hr.iii.fiskal.soapssl.SoapMessage;
import hr.iii.fiskal.xml.PDF417CodeResponse;
import hr.iii.fiskal.xml.QRCodeResponse;
import hr.iii.fiskal.xml.RacunPDResponse;
import hr.iii.fiskal.xml.RacunResponse;
import hr.iii.fiskal.xml.Request;
import hr.iii.fiskal.xml.RequestFactory;
import hr.iii.fiskal.xml.Response;
import hr.iii.fiskal.xml.XmLRecordUnknowException;
import hr.iii.fiskal.xml.XmlRecord;
import hr.iii.fiskal.xml.XmlRecordException;
import hr.iii.fiskal.xml.XmlRecordIOException;
import hr.iii.fiskal.xml.XmlRecordParseException;
import hr.iii.fiskal.xml.XmlRecordSignException;
import hr.iii.fiskal.xml.ZastKodPDResponse;
import hr.iii.fiskal.xml.ZastKodResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RequestHandler
implements HttpHandler {
    private Logger reqLogger = null;
    private Logger appLogger = null;
    private String clientName = "";

    RequestHandler() {
    }

    @Override
    public void handle(HttpExchange t) {
        block6: {
            boolean bDec = false;
            this.clientName = t.getRemoteAddress().getAddress().getHostAddress().toString() + ":" + t.getRemoteAddress().getPort();
            this.reqLogger = Logger.getLogger("hr.iii.fiskal.request");
            this.appLogger = Logger.getLogger("hr.iii.fiskal.proxy");
            this.appLogger.fine("Connected: " + this.clientName);
            try {
                if (t.getRequestMethod().compareToIgnoreCase("POST") == 0) {
                    AppContext.getContext().getStatistics().incConnectedClients();
                    bDec = true;
                    this.handlePost(t);
                    AppContext.getContext().getStatistics().decConnectedClients();
                } else if (t.getRequestMethod().compareToIgnoreCase("GET") == 0) {
                    this.handleGet(t);
                } else {
                    t.sendResponseHeaders(404, 0L);
                }
            }
            catch (IOException e) {
                if (!bDec) break block6;
                AppContext.getContext().getStatistics().decConnectedClients();
            }
        }
        t.close();
        this.appLogger.fine("Disconnected: " + this.clientName);
    }

    private void handlePost(HttpExchange t) throws IOException {
        String encoding = "UTF-8";
        String answer = "";
        String requestString = "";
        XmlRecord request = null;
        Response response = null;
        long startComm = System.currentTimeMillis();
        Long rx = 0L;
        Long prep = 0L;
        Long creat = 0L;
        Long ssl = 0L;
        AppContext.getContext().getStatistics().setLastClient(t.getRemoteAddress());
        this.appLogger.fine("Checking header");
        try {
            String line;
            int charsetOff;
            Headers reqHeaders = t.getRequestHeaders();
            String contentType = reqHeaders.getFirst("Content-Type");
            if (contentType != null && (charsetOff = contentType.indexOf("charset")) >= 0 && (charsetOff = contentType.indexOf("=", charsetOff + 7)) >= 0) {
                encoding = contentType.substring(charsetOff + 1).trim();
            }
            RequestFactory requestFactory = new RequestFactory();
            BufferedReader br = new BufferedReader(new InputStreamReader(t.getRequestBody(), Charset.forName(encoding)));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            this.appLogger.fine("Receive " + sb.length() + " bytes");
            requestString = sb.toString();
            rx = System.currentTimeMillis() - startComm;
            long startReq = System.currentTimeMillis();
            request = requestFactory.createRequest(requestString);
            creat = System.currentTimeMillis() - startReq;
            startReq = System.currentTimeMillis();
            ((Request)request).prepareRequest();
            this.appLogger.fine("Prepare " + ((Request)request).toString());
            prep = System.currentTimeMillis() - startReq;
            if (request.getDocument().getElementsByTagName("tns:ZastKodZahtjev").item(0) != null) {
                response = new ZastKodResponse();
            } else if (request.getDocument().getElementsByTagName("tns:ZastKodPDZahtjev").item(0) != null) {
                response = new ZastKodPDResponse();
            } else if (request.getDocument().getElementsByTagName("tns:QRCodeRequest").item(0) != null) {
                response = new QRCodeResponse();
            } else if (request.getDocument().getElementsByTagName("tns:PDF417CodeRequest").item(0) != null) {
                response = new PDF417CodeResponse();
            } else {
                startReq = System.currentTimeMillis();
                SoapMessage soapMessage = new SoapMessage((Request)request);
                SSLClient sslClient = new SSLClient(AppContext.getContext().getServerURL());
                sslClient.post(soapMessage);
                response = sslClient.getResponse();
                ssl = System.currentTimeMillis() - startReq;
                if (response.getDocument().getElementsByTagName("tns:Jir").item(0) != null) {
                    AppContext.getContext().getStatistics().incJirCount();
                }
            }
            if (response.hasError()) {
                AppContext.getContext().getStatistics().incErrorCode(response.getErrorCode());
            }
            XmlRecord xmlAnswer = response.createAnswer((Request)request);
            answer = xmlAnswer.getString();
        }
        catch (XmlRecordException e) {
            answer = this.createAnswer(e.getErrorCode(), e, (Request)request);
            AppContext.getContext().getStatistics().incErrorCode(e.getErrorCode());
        }
        catch (SSLSoapException e) {
            this.appLogger.warning("Post error: " + e.getMessage());
            answer = this.createAnswer(XmlRecordException.NEUSPJELO_SLANJE_ZAHTJEVA, e, (Request)request);
            AppContext.getContext().getStatistics().incErrorCode(XmlRecordException.NEUSPJELO_SLANJE_ZAHTJEVA);
        }
        catch (AppKeyStoreException e) {
            answer = this.createAnswer(XmlRecordException.INTERNA_GRESKA, e, (Request)request);
            AppContext.getContext().getStatistics().incErrorCode(XmlRecordException.INTERNA_GRESKA);
        }
        long startAnsw = System.currentTimeMillis();
        byte[] bAnswer = answer.getBytes();
        t.sendResponseHeaders(200, bAnswer.length);
        OutputStream os = t.getResponseBody();
        os.write(bAnswer);
        os.close();
        this.appLogger.fine("Return " + bAnswer.length + " bytes");
        Long ans = System.currentTimeMillis() - startAnsw;
        if (request == null) {
            this.writeCommChain(t.getRemoteAddress(), requestString, response, answer);
        } else if (request.getDocument().getElementsByTagName("tns:EchoRequest").item(0) == null) {
            this.writeCommChain(t.getRemoteAddress(), request.getString(), response, answer);
        }
        AppContext.getContext().getStatistics().setAverageCommElapsed(System.currentTimeMillis() - startComm);
        Long elapsed = System.currentTimeMillis() - startComm;
        this.appLogger.fine("Stats: RX=" + rx.toString() + " CREATE=" + creat.toString() + " PREP=" + prep.toString() + " SSL=" + ssl.toString() + " RET=" + ans.toString() + " TOT=" + elapsed.toString() + " ms");
    }

    private void handleGet(HttpExchange t) throws IOException {
        String answer = "";
        String echoStr = "<tns:EchoRequest xmlns:tns=\"http://www.apis-it.hr/fin/2012/types/f73\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.apis-it.hr/fin/2012/types/f73 FiskalizacijaSchema.xsd \">Provjera</tns:EchoRequest>";
        try {
            RequestFactory requestFactory = new RequestFactory();
            Request echo = requestFactory.createRequest(echoStr);
            echo.prepareRequest();
            SoapMessage soapMessage = new SoapMessage(echo);
            SSLClient sslClient = new SSLClient(AppContext.getContext().getServerURL());
            sslClient.post(soapMessage);
            answer = "I3Fiskal Service\tOK\rI3Fiskal Server\tOK";
        }
        catch (XmlRecordSignException e1) {
            answer = "I3Fiskal Service\tERR\rI3Fiskal Server\t???";
        }
        catch (XmlRecordParseException e) {
            answer = "I3Fiskal Service\tERR\rI3Fiskal Server\t???";
        }
        catch (XmlRecordIOException e) {
        }
        catch (SSLSoapException e) {
            answer = "I3Fiskal Service\tOK\rI3Fiskal Server\tERR";
        }
        catch (AppKeyStoreException e) {
            answer = "I3Fiskal Service\tERR\rI3Fiskal Server\t???";
        }
        catch (XmLRecordUnknowException e) {
            // empty catch block
        }
        t.sendResponseHeaders(200, answer.length());
        OutputStream os = t.getResponseBody();
        os.write(answer.getBytes());
        os.close();
    }

    private String createAnswer(String sifraGreske, Exception exception, Request request) {
        Document doc = null;
        Element nodeResponse = null;
        Element nodeSifraGreske = null;
        Element nodePorukaGreske = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            doc = dbf.newDocumentBuilder().newDocument();
            nodeResponse = doc.createElement("Response");
            doc.appendChild(nodeResponse);
            nodeSifraGreske = doc.createElement("SifraGreske");
            nodeSifraGreske.setTextContent(sifraGreske);
            nodeResponse.appendChild(nodeSifraGreske);
            nodePorukaGreske = doc.createElement("PorukaGreske");
            nodePorukaGreske.setTextContent(exception.getMessage());
            nodeResponse.appendChild(nodePorukaGreske);
        }
        catch (ParserConfigurationException e) {
            return "";
        }
        if (request != null) {
            Element element;
            String content;
            Node node = request.getDocument().getElementsByTagName("tns:ZastKod").item(0);
            if (node != null) {
                content = node.getTextContent();
                if (!content.isEmpty()) {
                    element = doc.createElement("ZastitniKod");
                    element.setTextContent(content);
                    nodeResponse.appendChild(element);
                    Element QRTextelement = doc.createElement("QRCodeText");
                    QRTextelement.setTextContent(RacunResponse.getQrText(request));
                    nodeResponse.appendChild(QRTextelement);
                    Element QRelement = doc.createElement("QRCode");
                    String base64 = RacunResponse.getQrCode(request);
                    QRelement.setTextContent(base64);
                    nodeResponse.appendChild(QRelement);
                }
            } else if ((request.getTag().equals("tns:ZastKodPDZahtjev") || request.getTag().equals("tns:PrateciDokumentiZahtjev")) && (node = request.getDocument().getElementsByTagName("tns:ZastKodPD").item(0)) != null && !(content = node.getTextContent()).isEmpty()) {
                element = doc.createElement("ZastitniKodPD");
                element.setTextContent(content);
                nodeResponse.appendChild(element);
                Element QRTextelement = doc.createElement("QRCodeText");
                QRTextelement.setTextContent(RacunPDResponse.getQrText(request));
                nodeResponse.appendChild(QRTextelement);
                Element QRelement = doc.createElement("QRCode");
                String base64 = RacunPDResponse.getQrCode(request);
                QRelement.setTextContent(base64);
                nodeResponse.appendChild(QRelement);
            }
            node = request.getDocument().getElementsByTagName("tns:IdPoruke").item(0);
            if (node != null && !(content = node.getTextContent()).isEmpty()) {
                element = doc.createElement("IdPoruke");
                element.setTextContent(content);
                nodeResponse.appendChild(element);
            }
        }
        XmlRecord xml = new XmlRecord(doc);
        return xml.getString();
    }

    private void writeCommChain(InetSocketAddress client, String request, Response response, String answer) {
        if (request != null) {
            this.reqLogger.fine(" " + this.clientName + " - POSLANO:\r\n--------------------------\r\n" + this.prettyPrintXml(request) + "\r\n--------------------------\r\n");
        }
        if (response != null) {
            this.reqLogger.fine(" " + this.clientName + " - PRIMLJENO:\r\n--------------------------\r\n" + this.prettyPrintXml(response.getString()) + "\r\n--------------------------\r\n");
        }
        if (answer != null) {
            this.reqLogger.fine(" " + this.clientName + " - ODGOVOR:\r\n--------------------------\r\n" + this.prettyPrintXml(answer) + "\r\n--------------------------\r\n");
        }
    }

    private String prettyPrintXml(String sourceXml) {
        if (sourceXml.isEmpty()) {
            return sourceXml;
        }
        StreamSource xmlInput = new StreamSource(new StringReader(sourceXml), "UTF-8");
        StreamResult xmlOutput = new StreamResult(new StringWriter());
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setAttribute("indent-number", new Integer(2));
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.transform(xmlInput, xmlOutput);
        }
        catch (Exception e) {
            return sourceXml;
        }
        return xmlOutput.getWriter().toString();
    }
}

