/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ProxyThreadExecutor
extends ThreadPoolExecutor {
    long elapsed = 0L;
    long start = System.currentTimeMillis();
    int threads = 0;

    public ProxyThreadExecutor(int nThreads) {
        super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public synchronized void setCost(long duration) {
        long stop = System.currentTimeMillis();
        this.elapsed += duration;
        if (stop - this.start > 2000L) {
            long average = this.elapsed / (long)this.threads;
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.S ");
            String strDate = formatter.format(new Date());
            System.out.println("\n********\nDate: " + strDate + "\nPool size=" + this.getCorePoolSize() + " Threads=" + this.threads + " Active threads" + this.getActiveCount() + " Waiting threads" + this.getQueue().size() + " Elapsed=" + this.elapsed + " Average=" + average + " ms\n*******\n");
            this.elapsed = 0L;
            this.start = stop;
            this.threads = 0;
        } else {
            ++this.threads;
        }
    }

    @Override
    protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
        super.beforeExecute(paramThread, paramRunnable);
    }

    @Override
    protected void afterExecute(Runnable paramRunnable, Throwable paramThrowable) {
        super.afterExecute(paramRunnable, paramThrowable);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.S ");
        String strDate = formatter.format(new Date());
        System.out.println(strDate + " Waiting threads=" + this.getQueue().size() + " Active threads=" + this.getActiveCount());
    }
}

