/*
 * Decompiled with CFR 0.152.
 */
package hr.iii.fiskal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateFileHandler
extends StreamHandler {
    private MeteredStream meter;
    private static final String PROPERTY_PREFIX = "hr.iii.fiskal.DateFileHandler";
    private static final String PATTERN_KEY = "hr.iii.fiskal.DateFileHandler.pattern";
    private static final String DEFAULT_PATTERN = "%h/java%u.log";
    private static final String DAYS_KEY = "hr.iii.fiskal.DateFileHandler.days";
    private static final int DEFAULT_DAYS = 7;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    private int days = 7;
    private String pattern = "%h/java%u.log";
    private LinkedList logFiles;
    volatile File handler;
    volatile long startDate = System.currentTimeMillis();
    volatile long endDate;
    volatile String currentDate = null;
    private String lockFileName;
    private FileOutputStream lockStream;
    private static final int MAX_LOCKS = 100;
    private static HashMap<String, String> locks = new HashMap();
    long written;

    public DateFileHandler() throws IOException, SecurityException {
        this(LogManager.getLogManager().getProperty(PATTERN_KEY), Integer.parseInt(LogManager.getLogManager().getProperty(DAYS_KEY)));
    }

    public DateFileHandler(String pattern, int days) {
        this.configure();
        this.pattern = pattern == null ? DEFAULT_PATTERN : pattern;
        this.days = days == 0 ? 7 : days;
        this.written = 0L;
        this.logFiles = new LinkedList();
        this.findPreviousDates();
        this.rotate();
    }

    @Override
    public void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
    }

    @Override
    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
    }

    private void configure() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String pattern = manager.getProperty((cname = this.getClass().getName()) + ".pattern");
        this.pattern = pattern == null ? DEFAULT_PATTERN : pattern;
        String days = manager.getProperty(cname + ".days");
        this.days = days == null ? 7 : Integer.parseInt(days);
        String level = manager.getProperty(cname + ".level");
        if (level == null) {
            this.setLevel(Level.ALL);
        } else {
            this.setLevel(Level.parse(level));
        }
        String filter = manager.getProperty(cname + ".filter");
        if (filter == null) {
            this.setFilter(null);
        } else {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clz.newInstance());
            }
            catch (Exception e) {
                this.setFilter(null);
            }
        }
        String formatter = manager.getProperty(cname + ".formatter");
        if (formatter == null) {
            this.setFormatter(new XMLFormatter());
        } else {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(formatter);
                this.setFormatter((Formatter)clz.newInstance());
            }
            catch (Exception e) {
                this.setFormatter(null);
            }
        }
        try {
            String encoding = manager.getProperty(cname + ".encoding");
            this.setEncoding(encoding);
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.endDate < record.getMillis()) {
            this.rotate();
        }
        if (System.currentTimeMillis() - this.startDate > 90000000L) {
            String msg = record.getMessage();
            record.setMessage("missed file rolling at: " + new Date(this.endDate) + "\n" + msg);
        }
        super.publish(record);
        this.flush();
    }

    private synchronized void rotate() {
        String path;
        String pattern;
        this.close();
        this.startDate = System.currentTimeMillis();
        if (this.currentDate != null) {
            pattern = this.pattern.replace("%d", this.currentDate);
            path = DateFileHandler.replaceFileNameEscapes(pattern);
            File fNew = new File(path);
            this.logFiles.addLast(this.currentDate);
        }
        this.cleanupDates();
        this.currentDate = this.format.format(new Date());
        pattern = this.pattern.replace("%d", this.currentDate);
        path = DateFileHandler.replaceFileNameEscapes(pattern);
        File dd = new File(path);
        if (dd.getParentFile() != null && !dd.getParentFile().exists()) {
            dd.getParentFile().mkdirs();
        }
        Calendar next = Calendar.getInstance();
        next.set(11, 0);
        next.set(12, 0);
        next.set(13, 0);
        next.set(14, 0);
        next.add(5, 1);
        this.endDate = next.getTimeInMillis();
        this.setOutputStream(this.createFileStream(pattern));
        this.written = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutputStream createFileStream(String pattern) {
        LogManager.getLogManager().checkAccess();
        if (pattern == null) {
            pattern = LogManager.getLogManager().getProperty(PATTERN_KEY);
        }
        if (pattern == null) {
            pattern = DEFAULT_PATTERN;
        }
        String path = DateFileHandler.replaceFileNameEscapes(pattern);
        int unique = -1;
        while (true) {
            if (++unique > 100) {
                return null;
            }
            this.lockFileName = path + ".lck";
            HashMap<String, String> hashMap = locks;
            synchronized (hashMap) {
                boolean available;
                FileChannel fc;
                if (locks.get(this.lockFileName) != null) {
                    continue;
                }
                try {
                    this.lockStream = new FileOutputStream(this.lockFileName);
                    fc = this.lockStream.getChannel();
                }
                catch (IOException ix) {
                    continue;
                }
                try {
                    available = fc.tryLock() != null;
                }
                catch (IOException ix) {
                    available = true;
                }
                if (available) {
                    locks.put(this.lockFileName, this.lockFileName);
                    break;
                }
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            File file = new File(path);
            int len = (int)file.length();
            FileOutputStream fout = new FileOutputStream(file.toString(), true);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            this.meter = new MeteredStream(bout, len);
            return this.meter;
        }
        catch (Exception ex) {
            this.reportError(null, ex, 4);
            return null;
        }
    }

    private void cleanupDates() {
        if (this.days >= 0) {
            while (this.logFiles.size() >= this.days) {
                String toCleanup = (String)this.logFiles.removeFirst();
                this.cleanupDate(toCleanup);
            }
        }
    }

    private void cleanupDate(String date) {
        String path = DateFileHandler.replaceFileNameEscapes(this.pattern.replace("%d", date));
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
        if ((f = new File(path + ".lck")).exists()) {
            f.delete();
        }
    }

    private void findPreviousDates() {
        File[] fileList;
        if (this.days < 0) {
            return;
        }
        String today = this.format.format(new Date());
        String filter = DateFileHandler.getFilterFromPattern(this.pattern, "%d");
        String patternExt = filter.substring(filter.lastIndexOf("."));
        File dir = new File(filter);
        String filePath = dir.getParent();
        if (filePath == null) {
            filePath = ".";
        }
        for (File f : fileList = new File(filePath).listFiles(new WildCardFileFilter(filter))) {
            String fileExt;
            if (DateFileHandler.getDateFromFile(this.pattern, f.getAbsolutePath()).compareTo(today) == 0 || !f.exists() || !(fileExt = f.getName().substring(f.getName().lastIndexOf("."))).contentEquals(patternExt)) continue;
            this.logFiles.addFirst(DateFileHandler.getDateFromFile(this.pattern, f.getAbsolutePath()));
        }
    }

    private static String getDateFromFile(String pattern, String filePath) {
        String regex = pattern.replaceAll("\\\\", "/").replaceAll("%d", "(.*)");
        filePath = filePath.replaceAll("\\\\", "/");
        Matcher m = Pattern.compile(regex).matcher(filePath);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private static String getFilterFromPattern(String pattern, String dateEsc) {
        String filter = DateFileHandler.replaceFileNameEscapes(pattern);
        return filter.replaceAll("%d", "*");
    }

    private static String replaceFileNameEscapes(String pattern) {
        StringBuffer buf = new StringBuffer(pattern);
        int pos = 0;
        block5: do {
            String replaceWith;
            if (buf.charAt(pos) == '/') {
                replaceWith = System.getProperty("file.separator");
                buf.replace(pos, pos + 1, replaceWith);
                pos = pos + replaceWith.length() - 1;
                continue;
            }
            if (buf.charAt(pos) != '%') continue;
            switch (buf.charAt(pos + 1)) {
                case 't': {
                    replaceWith = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    replaceWith = System.getProperty("user.home");
                    break;
                }
                case '%': {
                    replaceWith = "%";
                    break;
                }
                default: {
                    continue block5;
                }
            }
            buf.replace(pos, pos + 2, replaceWith);
            pos = pos + replaceWith.length() - 1;
        } while (++pos < buf.length() - 1);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        new File(this.lockFileName).delete();
        this.lockFileName = null;
        this.lockStream = null;
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private final class WildCardFileFilter
    implements FileFilter {
        private String _pattern;

        public WildCardFileFilter(String pattern) {
            this._pattern = pattern.replace("*", ".*").replace("?", ".").replaceAll("\\\\", "/");
        }

        @Override
        public boolean accept(File file) {
            String fileName = file.getAbsolutePath().replaceAll("\\\\", "/");
            return Pattern.compile(this._pattern).matcher(fileName).find();
        }
    }
}

