/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.util.Locale;

public final class CommandLineEncoder {
    private static final BarcodeFormat DEFAULT_BARCODE_FORMAT = BarcodeFormat.QR_CODE;
    private static final String DEFAULT_IMAGE_FORMAT = "PNG";
    private static final String DEFAULT_OUTPUT_FILE = "out";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;

    private CommandLineEncoder() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            CommandLineEncoder.printUsage();
            return;
        }
        BarcodeFormat barcodeFormat = DEFAULT_BARCODE_FORMAT;
        String imageFormat = DEFAULT_IMAGE_FORMAT;
        String outFileString = DEFAULT_OUTPUT_FILE;
        int width = 300;
        int height = 300;
        String contents = null;
        for (String arg : args) {
            String[] argValue = arg.split("=");
            String av = argValue[0];
            if ("--barcode_format".equals(av)) {
                barcodeFormat = BarcodeFormat.valueOf(argValue[1]);
                continue;
            }
            if ("--image_format".equals(av)) {
                imageFormat = argValue[1];
                continue;
            }
            if ("--output".equals(av)) {
                outFileString = argValue[1];
                continue;
            }
            if ("--width".equals(av)) {
                width = Integer.parseInt(argValue[1]);
                continue;
            }
            if ("--height".equals(av)) {
                height = Integer.parseInt(argValue[1]);
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("Unknown command line option " + arg);
                CommandLineEncoder.printUsage();
                return;
            }
            contents = arg;
        }
        if (contents == null) {
            CommandLineEncoder.printUsage();
            return;
        }
        if (DEFAULT_OUTPUT_FILE.equals(outFileString)) {
            outFileString = outFileString + '.' + imageFormat.toLowerCase(Locale.ENGLISH);
        }
        BitMatrix matrix = new MultiFormatWriter().encode(contents, barcodeFormat, width, height);
        MatrixToImageWriter.writeToPath(matrix, imageFormat, new File(outFileString));
    }

    private static void printUsage() {
        System.err.println("Encodes barcode images using the ZXing library\n");
        System.err.println("usage: CommandLineEncoder [ options ] content_to_encode");
        System.err.println("  --barcode_format=format: Format to encode, from BarcodeFormat class. Not all formats are supported. Defaults to QR_CODE.");
        System.err.println("  --image_format=format: image output format, such as PNG, JPG, GIF. Defaults to PNG");
        System.err.println("  --output=filename: File to write to. Defaults to out.png");
        System.err.println("  --width=pixels: Image width. Defaults to 300");
        System.err.println("  --height=pixels: Image height. Defaults to 300");
    }
}

