/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CurrencyNameProvider;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;

public final class Currency
implements Serializable {
    private static final long serialVersionUID = -158308464356906721L;
    private final String currencyCode;
    private final transient int defaultFractionDigits;
    private final transient int numericCode;
    private static ConcurrentMap<String, Currency> instances = new ConcurrentHashMap<String, Currency>(7);
    private static HashSet<Currency> available;
    static int formatVersion;
    static int dataVersion;
    static int[] mainTable;
    static long[] scCutOverTimes;
    static String[] scOldCurrencies;
    static String[] scNewCurrencies;
    static int[] scOldCurrenciesDFD;
    static int[] scNewCurrenciesDFD;
    static int[] scOldCurrenciesNumericCode;
    static int[] scNewCurrenciesNumericCode;
    static String otherCurrencies;
    static int[] otherCurrenciesDFD;
    static int[] otherCurrenciesNumericCode;
    private static final int A_TO_Z = 26;
    private static final int INVALID_COUNTRY_ENTRY = 127;
    private static final int COUNTRY_WITHOUT_CURRENCY_ENTRY = 512;
    private static final int SIMPLE_CASE_COUNTRY_MASK = 0;
    private static final int SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK = 31;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK = 480;
    private static final int SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT = 5;
    private static final int SIMPLE_CASE_COUNTRY_MAX_DEFAULT_DIGITS = 9;
    private static final int SPECIAL_CASE_COUNTRY_MASK = 512;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_MASK = 31;
    private static final int SPECIAL_CASE_COUNTRY_INDEX_DELTA = 1;
    private static final int COUNTRY_TYPE_MASK = 512;
    private static final int NUMERIC_CODE_MASK = 1047552;
    private static final int NUMERIC_CODE_SHIFT = 10;
    private static final int VALID_FORMAT_VERSION = 2;
    private static final int SYMBOL = 0;

    private Currency(String string, int n, int n2) {
        this.currencyCode = string;
        this.defaultFractionDigits = n;
        this.numericCode = n2;
    }

    public static Currency getInstance(String string) {
        return Currency.getInstance(string, Integer.MIN_VALUE, 0);
    }

    private static Currency getInstance(String string, int n, int n2) {
        Currency currency;
        Currency currency2 = (Currency)instances.get(string);
        if (currency2 != null) {
            return currency2;
        }
        if (n == Integer.MIN_VALUE) {
            char c;
            if (string.length() != 3) {
                throw new IllegalArgumentException();
            }
            char c2 = string.charAt(0);
            int n3 = Currency.getMainTableEntry(c2, c = string.charAt(1));
            if ((n3 & 0x200) == 0 && n3 != 127 && string.charAt(2) - 65 == (n3 & 0x1F)) {
                n = (n3 & 0x1E0) >> 5;
                n2 = (n3 & 0xFFC00) >> 10;
            } else {
                if (string.charAt(2) == '-') {
                    throw new IllegalArgumentException();
                }
                int n4 = otherCurrencies.indexOf(string);
                if (n4 == -1) {
                    throw new IllegalArgumentException();
                }
                n = otherCurrenciesDFD[n4 / 4];
                n2 = otherCurrenciesNumericCode[n4 / 4];
            }
        }
        return (currency2 = instances.putIfAbsent(string, currency = new Currency(string, n, n2))) != null ? currency2 : currency;
    }

    public static Currency getInstance(Locale locale) {
        char c;
        String string = locale.getCountry();
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() != 2) {
            throw new IllegalArgumentException();
        }
        char c2 = string.charAt(0);
        int n = Currency.getMainTableEntry(c2, c = string.charAt(1));
        if ((n & 0x200) == 0 && n != 127) {
            char c3 = (char)((n & 0x1F) + 65);
            int n2 = (n & 0x1E0) >> 5;
            int n3 = (n & 0xFFC00) >> 10;
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(c3);
            return Currency.getInstance(stringBuffer.toString(), n2, n3);
        }
        if (n == 127) {
            throw new IllegalArgumentException();
        }
        if (n == 512) {
            return null;
        }
        int n4 = (n & 0x1F) - 1;
        if (scCutOverTimes[n4] == Long.MAX_VALUE || System.currentTimeMillis() < scCutOverTimes[n4]) {
            return Currency.getInstance(scOldCurrencies[n4], scOldCurrenciesDFD[n4], scOldCurrenciesNumericCode[n4]);
        }
        return Currency.getInstance(scNewCurrencies[n4], scNewCurrenciesDFD[n4], scNewCurrenciesNumericCode[n4]);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getSymbol() {
        return this.getSymbol(Locale.getDefault());
    }

    public String getSymbol(Locale locale) {
        try {
            Object object;
            LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CurrencyNameProvider.class);
            if (localeServiceProviderPool.hasProviders() && (object = localeServiceProviderPool.getLocalizedObject(CurrencyNameGetter.INSTANCE, locale, null, this.currencyCode, 0)) != null) {
                return object;
            }
            object = LocaleData.getCurrencyNames(locale);
            return ((ResourceBundle)object).getString(this.currencyCode);
        }
        catch (MissingResourceException missingResourceException) {
            return this.currencyCode;
        }
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public String toString() {
        return this.currencyCode;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    private static int getMainTableEntry(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'A' || c2 > 'Z') {
            throw new IllegalArgumentException();
        }
        return mainTable[(c - 65) * 26 + (c2 - 65)];
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.util.CurrencyData");
                    formatVersion = (Integer)clazz.getDeclaredField("formatVersion").get(clazz);
                    dataVersion = (Integer)clazz.getDeclaredField("dataVersion").get(clazz);
                    mainTable = (int[])clazz.getDeclaredField("mainTable").get(clazz);
                    scCutOverTimes = (long[])clazz.getDeclaredField("scCutOverTimes").get(clazz);
                    scOldCurrencies = (String[])clazz.getDeclaredField("scOldCurrencies").get(clazz);
                    scNewCurrencies = (String[])clazz.getDeclaredField("scNewCurrencies").get(clazz);
                    scOldCurrenciesDFD = (int[])clazz.getDeclaredField("scOldCurrenciesDFD").get(clazz);
                    scNewCurrenciesDFD = (int[])clazz.getDeclaredField("scNewCurrenciesDFD").get(clazz);
                    scOldCurrenciesNumericCode = (int[])clazz.getDeclaredField("scOldCurrenciesNumericCode").get(clazz);
                    scNewCurrenciesNumericCode = (int[])clazz.getDeclaredField("scNewCurrenciesNumericCode").get(clazz);
                    otherCurrencies = (String)clazz.getDeclaredField("otherCurrencies").get(clazz);
                    otherCurrenciesDFD = (int[])clazz.getDeclaredField("otherCurrenciesDFD").get(clazz);
                    otherCurrenciesNumericCode = (int[])clazz.getDeclaredField("otherCurrenciesNumericCode").get(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new InternalError();
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CurrencyNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CurrencyNameProvider, String> {
        private static final CurrencyNameGetter INSTANCE = new CurrencyNameGetter();

        private CurrencyNameGetter() {
        }

        @Override
        public String getObject(CurrencyNameProvider currencyNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 1);
            int n = (Integer)objectArray[0];
            switch (n) {
                case 0: {
                    return currencyNameProvider.getSymbol(string, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

