/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.events;

import com.sun.xml.internal.stream.events.DummyEvent;
import com.sun.xml.internal.stream.util.ReadOnlyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import jdk.xml.internal.HashMap;

public class StartElementEvent
extends DummyEvent
implements StartElement {
    private Map fAttributes;
    private List fNamespaces;
    private NamespaceContext fNamespaceContext = null;
    private QName fQName;

    public StartElementEvent(String string, String string2, String string3) {
        this(new QName(string2, string3, string));
    }

    public StartElementEvent(QName qName) {
        this.fQName = qName;
        this.init();
    }

    public StartElementEvent(StartElement startElement) {
        this(startElement.getName());
        this.addAttributes(startElement.getAttributes());
        this.addNamespaceAttributes(startElement.getNamespaces());
    }

    protected void init() {
        this.setEventType(1);
        this.fAttributes = new HashMap();
        this.fNamespaces = new ArrayList();
    }

    public QName getName() {
        return this.fQName;
    }

    public void setName(QName qName) {
        this.fQName = qName;
    }

    public Iterator getAttributes() {
        if (this.fAttributes != null) {
            Collection collection = this.fAttributes.values();
            return new ReadOnlyIterator(collection.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Iterator getNamespaces() {
        if (this.fNamespaces != null) {
            return new ReadOnlyIterator(this.fNamespaces.iterator());
        }
        return new ReadOnlyIterator();
    }

    public Attribute getAttributeByName(QName qName) {
        if (qName == null) {
            return null;
        }
        return (Attribute)this.fAttributes.get(qName);
    }

    public String getNamespace() {
        return this.fQName.getNamespaceURI();
    }

    public String getNamespaceURI(String string) {
        if (this.getNamespace() != null && this.fQName.getPrefix().equals(string)) {
            return this.getNamespace();
        }
        if (this.fNamespaceContext != null) {
            return this.fNamespaceContext.getNamespaceURI(string);
        }
        return null;
    }

    public String toString() {
        Attribute attribute;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<");
        stringBuffer.append(this.nameAsString());
        if (this.fAttributes != null) {
            iterator = this.getAttributes();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Attribute)iterator.next();
                stringBuffer.append(" ");
                stringBuffer.append(attribute.toString());
            }
        }
        if (this.fNamespaces != null) {
            iterator = this.fNamespaces.iterator();
            attribute = null;
            while (iterator.hasNext()) {
                attribute = (Namespace)iterator.next();
                stringBuffer.append(" ");
                stringBuffer.append(attribute.toString());
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String nameAsString() {
        if ("".equals(this.fQName.getNamespaceURI())) {
            return this.fQName.getLocalPart();
        }
        if (this.fQName.getPrefix() != null) {
            return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getPrefix() + ":" + this.fQName.getLocalPart();
        }
        return "['" + this.fQName.getNamespaceURI() + "']:" + this.fQName.getLocalPart();
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.fNamespaceContext = namespaceContext;
    }

    protected void writeAsEncodedUnicodeEx(Writer writer) throws IOException {
        writer.write(this.toString());
    }

    void addAttribute(Attribute attribute) {
        if (attribute.isNamespace()) {
            this.fNamespaces.add(attribute);
        } else {
            this.fAttributes.put(attribute.getName(), attribute);
        }
    }

    void addAttributes(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.fAttributes.put(attribute.getName(), attribute);
        }
    }

    void addNamespaceAttribute(Namespace namespace) {
        if (namespace == null) {
            return;
        }
        this.fNamespaces.add(namespace);
    }

    void addNamespaceAttributes(Iterator iterator) {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Namespace namespace = (Namespace)iterator.next();
            this.fNamespaces.add(namespace);
        }
    }
}

