/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer;

import com.sun.xml.internal.stream.buffer.ContextClassloaderLocal;
import com.sun.xml.internal.stream.buffer.FragmentedArray;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferException;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferSource;
import com.sun.xml.internal.stream.buffer.sax.SAXBufferProcessor;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferProcessor;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLStreamBuffer {
    protected Map<String, String> _inscopeNamespaces = Collections.emptyMap();
    protected boolean _hasInternedStrings;
    protected FragmentedArray<byte[]> _structure;
    protected int _structurePtr;
    protected FragmentedArray<String[]> _structureStrings;
    protected int _structureStringsPtr;
    protected FragmentedArray<char[]> _contentCharactersBuffer;
    protected int _contentCharactersBufferPtr;
    protected FragmentedArray<Object[]> _contentObjects;
    protected int _contentObjectsPtr;
    protected int treeCount;
    protected String systemId;
    private static final ContextClassloaderLocal<TransformerFactory> trnsformerFactory = new ContextClassloaderLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() throws Exception {
            return TransformerFactory.newInstance();
        }
    };

    public final boolean isCreated() {
        return this._structure.getArray()[0] != 0;
    }

    public final boolean isFragment() {
        return this.isCreated() && (this._structure.getArray()[this._structurePtr] & 0xF0) != 16;
    }

    public final boolean isElementFragment() {
        return this.isCreated() && (this._structure.getArray()[this._structurePtr] & 0xF0) == 32;
    }

    public final boolean isForest() {
        return this.isCreated() && this.treeCount > 1;
    }

    public final String getSystemId() {
        return this.systemId;
    }

    public final Map<String, String> getInscopeNamespaces() {
        return this._inscopeNamespaces;
    }

    public final boolean hasInternedStrings() {
        return this._hasInternedStrings;
    }

    public final StreamReaderBufferProcessor readAsXMLStreamReader() throws XMLStreamException {
        return new StreamReaderBufferProcessor(this);
    }

    public final void writeToXMLStreamWriter(XMLStreamWriter xMLStreamWriter, boolean bl) throws XMLStreamException {
        StreamWriterBufferProcessor streamWriterBufferProcessor = new StreamWriterBufferProcessor(this, bl);
        streamWriterBufferProcessor.process(xMLStreamWriter);
    }

    public final void writeToXMLStreamWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.writeToXMLStreamWriter(xMLStreamWriter, this.isFragment());
    }

    public final SAXBufferProcessor readAsXMLReader() {
        return new SAXBufferProcessor(this, this.isFragment());
    }

    public final SAXBufferProcessor readAsXMLReader(boolean bl) {
        return new SAXBufferProcessor(this, bl);
    }

    public final void writeTo(ContentHandler contentHandler, boolean bl) throws SAXException {
        SAXBufferProcessor sAXBufferProcessor = this.readAsXMLReader(bl);
        sAXBufferProcessor.setContentHandler(contentHandler);
        if (sAXBufferProcessor instanceof LexicalHandler) {
            sAXBufferProcessor.setLexicalHandler((LexicalHandler)((Object)contentHandler));
        }
        if (sAXBufferProcessor instanceof DTDHandler) {
            sAXBufferProcessor.setDTDHandler((DTDHandler)((Object)contentHandler));
        }
        if (sAXBufferProcessor instanceof ErrorHandler) {
            sAXBufferProcessor.setErrorHandler((ErrorHandler)((Object)contentHandler));
        }
        sAXBufferProcessor.process();
    }

    public final void writeTo(ContentHandler contentHandler) throws SAXException {
        this.writeTo(contentHandler, this.isFragment());
    }

    public final void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        SAXBufferProcessor sAXBufferProcessor = this.readAsXMLReader(bl);
        sAXBufferProcessor.setContentHandler(contentHandler);
        if (sAXBufferProcessor instanceof LexicalHandler) {
            sAXBufferProcessor.setLexicalHandler((LexicalHandler)((Object)contentHandler));
        }
        if (sAXBufferProcessor instanceof DTDHandler) {
            sAXBufferProcessor.setDTDHandler((DTDHandler)((Object)contentHandler));
        }
        sAXBufferProcessor.setErrorHandler(errorHandler);
        sAXBufferProcessor.process();
    }

    public final void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.writeTo(contentHandler, errorHandler, this.isFragment());
    }

    public final Node writeTo(Node node) throws XMLStreamBufferException {
        try {
            Transformer transformer = trnsformerFactory.get().newTransformer();
            transformer.transform(new XMLStreamBufferSource(this), new DOMResult(node));
            return node.getLastChild();
        }
        catch (TransformerException transformerException) {
            throw new XMLStreamBufferException(transformerException);
        }
    }

    public static XMLStreamBuffer createNewBufferFromXMLStreamReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.createFromXMLStreamReader(xMLStreamReader);
        return mutableXMLStreamBuffer;
    }

    public static XMLStreamBuffer createNewBufferFromXMLReader(XMLReader xMLReader, InputStream inputStream) throws SAXException, IOException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.createFromXMLReader(xMLReader, inputStream);
        return mutableXMLStreamBuffer;
    }

    public static XMLStreamBuffer createNewBufferFromXMLReader(XMLReader xMLReader, InputStream inputStream, String string) throws SAXException, IOException {
        MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
        mutableXMLStreamBuffer.createFromXMLReader(xMLReader, inputStream, string);
        return mutableXMLStreamBuffer;
    }

    protected final FragmentedArray<byte[]> getStructure() {
        return this._structure;
    }

    protected final int getStructurePtr() {
        return this._structurePtr;
    }

    protected final FragmentedArray<String[]> getStructureStrings() {
        return this._structureStrings;
    }

    protected final int getStructureStringsPtr() {
        return this._structureStringsPtr;
    }

    protected final FragmentedArray<char[]> getContentCharactersBuffer() {
        return this._contentCharactersBuffer;
    }

    protected final int getContentCharactersBufferPtr() {
        return this._contentCharactersBufferPtr;
    }

    protected final FragmentedArray<Object[]> getContentObjects() {
        return this._contentObjects;
    }

    protected final int getContentObjectsPtr() {
        return this._contentObjectsPtr;
    }
}

