/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.impl.XML11NSDocumentScannerImpl;
import com.sun.org.apache.xerces.internal.impl.XMLDTDScannerImpl;
import com.sun.org.apache.xerces.internal.impl.XMLDocumentScannerImpl;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLEntityScanner;
import com.sun.org.apache.xerces.internal.impl.XMLNSDocumentScannerImpl;
import com.sun.org.apache.xerces.internal.util.NamespaceContextWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLAttributesIteratorImpl;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.util.XMLStringBuffer;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.xml.internal.stream.Entity;
import com.sun.xml.internal.stream.StaxErrorReporter;
import com.sun.xml.internal.stream.XMLEntityStorage;
import com.sun.xml.internal.stream.dtd.nonvalidating.DTDGrammar;
import com.sun.xml.internal.stream.dtd.nonvalidating.XMLNotationDecl;
import com.sun.xml.internal.stream.events.EntityDeclarationImpl;
import com.sun.xml.internal.stream.events.NotationDeclarationImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamReaderImpl
implements XMLStreamReader {
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String READER_IN_DEFINED_STATE = "http://java.sun.com/xml/stream/properties/reader-in-defined-state";
    private SymbolTable fSymbolTable = new SymbolTable();
    protected XMLDocumentScannerImpl fScanner = new XMLNSDocumentScannerImpl();
    protected NamespaceContextWrapper fNamespaceContextWrapper = new NamespaceContextWrapper((NamespaceSupport)this.fScanner.getNamespaceContext());
    protected XMLEntityManager fEntityManager = new XMLEntityManager();
    protected StaxErrorReporter fErrorReporter = new StaxErrorReporter();
    protected XMLEntityScanner fEntityScanner = null;
    protected XMLInputSource fInputSource = null;
    protected PropertyManager fPropertyManager = null;
    private int fEventType;
    static final boolean DEBUG = false;
    private boolean fReuse = true;
    private boolean fReaderInDefinedState = true;
    private boolean fBindNamespaces = true;
    private String fDTDDecl = null;
    private String versionStr = null;

    public XMLStreamReaderImpl(InputStream inputStream, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, inputStream, null);
        this.setInputSource(xMLInputSource);
    }

    public XMLDocumentScannerImpl getScanner() {
        System.out.println("returning scanner");
        return this.fScanner;
    }

    public XMLStreamReaderImpl(String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        this.setInputSource(xMLInputSource);
    }

    public XMLStreamReaderImpl(InputStream inputStream, String string, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedInputStream(inputStream), string);
        this.setInputSource(xMLInputSource);
    }

    public XMLStreamReaderImpl(Reader reader, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        XMLInputSource xMLInputSource = new XMLInputSource(null, null, null, new BufferedReader(reader), null);
        this.setInputSource(xMLInputSource);
    }

    public XMLStreamReaderImpl(XMLInputSource xMLInputSource, PropertyManager propertyManager) throws XMLStreamException {
        this.init(propertyManager);
        this.setInputSource(xMLInputSource);
    }

    public void setInputSource(XMLInputSource xMLInputSource) throws XMLStreamException {
        this.fReuse = false;
        try {
            this.fScanner.setInputSource(xMLInputSource);
            if (this.fReaderInDefinedState) {
                this.fEventType = this.fScanner.next();
                if (this.versionStr == null) {
                    this.versionStr = this.getVersion();
                }
                if (this.fEventType == 7 && this.versionStr != null && this.versionStr.equals("1.1")) {
                    this.switchToXML11Scanner();
                }
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (XNIException xNIException) {
            throw new XMLStreamException(xNIException.getMessage(), this.getLocation(), xNIException.getException());
        }
    }

    void init(PropertyManager propertyManager) throws XMLStreamException {
        this.fPropertyManager = propertyManager;
        propertyManager.setProperty(SYMBOL_TABLE, this.fSymbolTable);
        propertyManager.setProperty(ERROR_REPORTER, this.fErrorReporter);
        propertyManager.setProperty(ENTITY_MANAGER, this.fEntityManager);
        this.reset();
    }

    public boolean canReuse() {
        return this.fReuse;
    }

    public void reset() {
        this.fReuse = true;
        this.fEventType = 0;
        this.fEntityManager.reset(this.fPropertyManager);
        this.fScanner.reset(this.fPropertyManager);
        this.fDTDDecl = null;
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
        this.fReaderInDefinedState = (Boolean)this.fPropertyManager.getProperty(READER_IN_DEFINED_STATE);
        this.fBindNamespaces = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isNamespaceAware");
        this.versionStr = null;
    }

    public void close() throws XMLStreamException {
        this.fReuse = true;
    }

    public String getCharacterEncodingScheme() {
        return this.fScanner.getCharacterEncodingScheme();
    }

    public int getColumnNumber() {
        return this.fEntityScanner.getColumnNumber();
    }

    public String getEncoding() {
        return this.fEntityScanner.getEncoding();
    }

    public int getEventType() {
        return this.fEventType;
    }

    public int getLineNumber() {
        return this.fEntityScanner.getLineNumber();
    }

    public String getLocalName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 9) {
            return this.fScanner.getEntityName();
        }
        throw new IllegalStateException("Method getLocalName() cannot be called for " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " event.");
    }

    public String getNamespaceURI() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().uri;
        }
        return null;
    }

    public String getPIData() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " But Expected state is " + 3);
    }

    public String getPITarget() {
        if (this.fEventType == 3) {
            return this.fScanner.getPITarget();
        }
        throw new IllegalStateException("Current state of the parser is " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " But Expected state is " + 3);
    }

    public String getPrefix() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            String string = this.fScanner.getElementQName().prefix;
            return string == null ? "" : string;
        }
        return null;
    }

    public char[] getTextCharacters() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().ch;
        }
        throw new IllegalStateException("Current state = " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(4) + " , " + XMLStreamReaderImpl.getEventTypeString(5) + " , " + XMLStreamReaderImpl.getEventTypeString(12) + " , " + XMLStreamReaderImpl.getEventTypeString(6) + " valid for getTextCharacters() ");
    }

    public int getTextLength() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().length;
        }
        throw new IllegalStateException("Current state = " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(4) + " , " + XMLStreamReaderImpl.getEventTypeString(5) + " , " + XMLStreamReaderImpl.getEventTypeString(12) + " , " + XMLStreamReaderImpl.getEventTypeString(6) + " valid for getTextLength() ");
    }

    public int getTextStart() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().offset;
        }
        throw new IllegalStateException("Current state = " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(4) + " , " + XMLStreamReaderImpl.getEventTypeString(5) + " , " + XMLStreamReaderImpl.getEventTypeString(12) + " , " + XMLStreamReaderImpl.getEventTypeString(6) + " valid for getTextStart() ");
    }

    public String getValue() {
        if (this.fEventType == 3) {
            return this.fScanner.getPIData().toString();
        }
        if (this.fEventType == 5) {
            return this.fScanner.getComment();
        }
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.fScanner.getElementQName().localpart;
        }
        if (this.fEventType == 4) {
            return this.fScanner.getCharacterData().toString();
        }
        return null;
    }

    public String getVersion() {
        return this.fEntityScanner.getXMLVersion();
    }

    public boolean hasAttributes() {
        return this.fScanner.getAttributeIterator().getLength() > 0;
    }

    public boolean hasName() {
        return this.fEventType == 1 || this.fEventType == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.fEventType == -1) {
            return false;
        }
        return this.fEventType != 8;
    }

    public boolean hasValue() {
        return this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 9 || this.fEventType == 3 || this.fEventType == 5 || this.fEventType == 4;
    }

    public boolean isEndElement() {
        return this.fEventType == 2;
    }

    public boolean isStandalone() {
        return this.fScanner.isStandAlone();
    }

    public boolean isStartElement() {
        return this.fEventType == 1;
    }

    public boolean isWhiteSpace() {
        if (this.isCharacters() || this.fEventType == 12) {
            char[] cArray = this.getTextCharacters();
            int n = this.getTextStart();
            int n2 = n + this.getTextLength();
            for (int i = n; i < n2; ++i) {
                if (XMLChar.isSpace(cArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int next() throws XMLStreamException {
        if (!this.hasNext()) {
            if (this.fEventType != -1) {
                throw new NoSuchElementException("END_DOCUMENT reached: no more elements on the stream.");
            }
            throw new XMLStreamException("Error processing input source. The input stream is not complete.");
        }
        try {
            this.fEventType = this.fScanner.next();
            if (this.versionStr == null) {
                this.versionStr = this.getVersion();
            }
            if (this.fEventType == 7 && this.versionStr != null && this.versionStr.equals("1.1")) {
                this.switchToXML11Scanner();
            }
            return this.fEventType;
        }
        catch (IOException iOException) {
            Boolean bl;
            if (this.fScanner.fScannerState == 46 && (bl = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isValidating")) != null && !bl.booleanValue()) {
                this.fEventType = 11;
                this.fScanner.setScannerState(43);
                this.fScanner.setDriver(this.fScanner.fPrologDriver);
                if (this.fDTDDecl == null || this.fDTDDecl.length() == 0) {
                    this.fDTDDecl = "<!-- Exception scanning External DTD Subset.  True contents of DTD cannot be determined.  Processing will continue as XMLInputFactory.IS_VALIDATING == false. -->";
                }
                return 11;
            }
            throw new XMLStreamException(iOException.getMessage(), this.getLocation(), iOException);
        }
        catch (XNIException xNIException) {
            throw new XMLStreamException(xNIException.getMessage(), this.getLocation(), xNIException.getException());
        }
    }

    private void switchToXML11Scanner() throws IOException {
        int n = this.fScanner.fEntityDepth;
        NamespaceContext namespaceContext = this.fScanner.fNamespaceContext;
        this.fScanner = new XML11NSDocumentScannerImpl();
        this.fScanner.reset(this.fPropertyManager);
        this.fScanner.setPropertyManager(this.fPropertyManager);
        this.fEntityScanner = this.fEntityManager.getEntityScanner();
        this.fEntityManager.fCurrentEntity.mayReadChunks = true;
        this.fScanner.setScannerState(7);
        this.fScanner.fEntityDepth = n;
        this.fScanner.fNamespaceContext = namespaceContext;
        this.fEventType = this.fScanner.next();
    }

    static final String getEventTypeString(int n) {
        switch (n) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE, " + String.valueOf(n);
    }

    public int getAttributeCount() {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLength();
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeCount()");
    }

    public javax.xml.namespace.QName getAttributeName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getAttributeIterator().getQualifiedName(n));
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeName()");
    }

    public String getAttributeLocalName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getLocalName(n);
        }
        throw new IllegalStateException();
    }

    public String getAttributeNamespace(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getURI(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeNamespace()");
    }

    public String getAttributePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getPrefix(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributePrefix()");
    }

    public javax.xml.namespace.QName getAttributeQName(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            String string = this.fScanner.getAttributeIterator().getLocalName(n);
            String string2 = this.fScanner.getAttributeIterator().getURI(n);
            return new javax.xml.namespace.QName(string2, string);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeQName()");
    }

    public String getAttributeType(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getType(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeType()");
    }

    public String getAttributeValue(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().getValue(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getAttributeValue(String string, String string2) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            XMLAttributesIteratorImpl xMLAttributesIteratorImpl = this.fScanner.getAttributeIterator();
            if (string == null) {
                return xMLAttributesIteratorImpl.getValue(xMLAttributesIteratorImpl.getIndexByLocalName(string2));
            }
            return this.fScanner.getAttributeIterator().getValue(string.length() == 0 ? null : string, string2);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for getAttributeValue()");
    }

    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int n = this.next();
        StringBuffer stringBuffer = new StringBuffer();
        while (n != 2) {
            if (n == 4 || n == 12 || n == 6 || n == 9) {
                stringBuffer.append(this.getText());
            } else if (n != 3 && n != 5) {
                if (n == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (n == 1) {
                    throw new XMLStreamException("elementGetText() function expects text only elment but START_ELEMENT was encountered.", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + n, this.getLocation());
            }
            n = this.next();
        }
        return stringBuffer.toString();
    }

    public Location getLocation() {
        return new Location(){
            String _systemId;
            String _publicId;
            int _offset;
            int _columnNumber;
            int _lineNumber;
            {
                this._systemId = XMLStreamReaderImpl.this.fEntityScanner.getExpandedSystemId();
                this._publicId = XMLStreamReaderImpl.this.fEntityScanner.getPublicId();
                this._offset = XMLStreamReaderImpl.this.fEntityScanner.getCharacterOffset();
                this._columnNumber = XMLStreamReaderImpl.this.fEntityScanner.getColumnNumber();
                this._lineNumber = XMLStreamReaderImpl.this.fEntityScanner.getLineNumber();
            }

            public String getLocationURI() {
                return this._systemId;
            }

            public int getCharacterOffset() {
                return this._offset;
            }

            public int getColumnNumber() {
                return this._columnNumber;
            }

            public int getLineNumber() {
                return this._lineNumber;
            }

            public String getPublicId() {
                return this._publicId;
            }

            public String getSystemId() {
                return this._systemId;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Line number = " + this.getLineNumber());
                stringBuffer.append("\n");
                stringBuffer.append("Column number = " + this.getColumnNumber());
                stringBuffer.append("\n");
                stringBuffer.append("System Id = " + this.getSystemId());
                stringBuffer.append("\n");
                stringBuffer.append("Public Id = " + this.getPublicId());
                stringBuffer.append("\n");
                stringBuffer.append("Location Uri= " + this.getLocationURI());
                stringBuffer.append("\n");
                stringBuffer.append("CharacterOffset = " + this.getCharacterOffset());
                stringBuffer.append("\n");
                return stringBuffer.toString();
            }
        };
    }

    public javax.xml.namespace.QName getName() {
        if (this.fEventType == 1 || this.fEventType == 2) {
            return this.convertXNIQNametoJavaxQName(this.fScanner.getElementQName());
        }
        throw new IllegalStateException("Illegal to call getName() when event type is " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + "." + " Valid states are " + XMLStreamReaderImpl.getEventTypeString(1) + ", " + XMLStreamReaderImpl.getEventTypeString(2));
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return this.fNamespaceContextWrapper;
    }

    public int getNamespaceCount() {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getDeclaredPrefixCount();
        }
        throw new IllegalStateException("Current event state is " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + ", " + XMLStreamReaderImpl.getEventTypeString(2) + ", " + XMLStreamReaderImpl.getEventTypeString(13) + " valid for getNamespaceCount().");
    }

    public String getNamespacePrefix(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            String string = this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n);
            return string.equals("") ? null : string;
        }
        throw new IllegalStateException("Current state " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + ", " + XMLStreamReaderImpl.getEventTypeString(2) + ", " + XMLStreamReaderImpl.getEventTypeString(13) + " valid for getNamespacePrefix().");
    }

    public String getNamespaceURI(int n) {
        if (this.fEventType == 1 || this.fEventType == 2 || this.fEventType == 13) {
            return this.fScanner.getNamespaceContext().getURI(this.fScanner.getNamespaceContext().getDeclaredPrefixAt(n));
        }
        throw new IllegalStateException("Current state " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + ", " + XMLStreamReaderImpl.getEventTypeString(2) + ", " + XMLStreamReaderImpl.getEventTypeString(13) + " valid for getNamespaceURI().");
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (this.fPropertyManager != null) {
            if (string.equals("javax.xml.stream.notations")) {
                return this.getNotationDecls();
            }
            if (string.equals("javax.xml.stream.entities")) {
                return this.getEntityDecls();
            }
            return this.fPropertyManager.getProperty(string);
        }
        return null;
    }

    public String getText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12 || this.fEventType == 6) {
            return this.fScanner.getCharacterData().toString();
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return this.fScanner.getCharacterData().toString();
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Map<String, Entity> map = xMLEntityStorage.getDeclaredEntities();
                Entity entity = map.get(string);
                if (entity == null) {
                    return null;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId();
                }
                return ((Entity.InternalEntity)entity).text;
            }
            return null;
        }
        if (this.fEventType == 11) {
            if (this.fDTDDecl != null) {
                return this.fDTDDecl;
            }
            XMLStringBuffer xMLStringBuffer = this.fScanner.getDTDDecl();
            this.fDTDDecl = xMLStringBuffer.toString();
            return this.fDTDDecl;
        }
        throw new IllegalStateException("Current state " + XMLStreamReaderImpl.getEventTypeString(this.fEventType) + " is not among the states" + XMLStreamReaderImpl.getEventTypeString(4) + ", " + XMLStreamReaderImpl.getEventTypeString(5) + ", " + XMLStreamReaderImpl.getEventTypeString(12) + ", " + XMLStreamReaderImpl.getEventTypeString(6) + ", " + XMLStreamReaderImpl.getEventTypeString(9) + ", " + XMLStreamReaderImpl.getEventTypeString(11) + " valid for getText() ");
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this.fEventType) {
            throw new XMLStreamException("Event type " + XMLStreamReaderImpl.getEventTypeString(n) + " specified did " + "not match with current parser event " + XMLStreamReaderImpl.getEventTypeString(this.fEventType));
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Namespace URI " + string + " specified did not match " + "with current namespace URI");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("LocalName " + string2 + " specified did not match with " + "current local name");
        }
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        if (cArray == null) {
            throw new NullPointerException("target char array can't be null");
        }
        if (n2 < 0 || n3 < 0 || n < 0 || n2 >= cArray.length || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = this.getTextLength() - n;
        if (n5 < 0) {
            throw new IndexOutOfBoundsException("sourceStart is greater thannumber of characters associated with this event");
        }
        n4 = n5 < n3 ? n5 : n3;
        System.arraycopy(this.getTextCharacters(), this.getTextStart() + n, cArray, n2, n4);
        return n4;
    }

    public boolean hasText() {
        if (this.fEventType == 4 || this.fEventType == 5 || this.fEventType == 12) {
            return this.fScanner.getCharacterData().length > 0;
        }
        if (this.fEventType == 9) {
            String string = this.fScanner.getEntityName();
            if (string != null) {
                if (this.fScanner.foundBuiltInRefs) {
                    return true;
                }
                XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
                Map<String, Entity> map = xMLEntityStorage.getDeclaredEntities();
                Entity entity = map.get(string);
                if (entity == null) {
                    return false;
                }
                if (entity.isExternal()) {
                    return ((Entity.ExternalEntity)entity).entityLocation.getExpandedSystemId() != null;
                }
                return ((Entity.InternalEntity)entity).text != null;
            }
            return false;
        }
        if (this.fEventType == 11) {
            return this.fScanner.fSeenDoctypeDecl;
        }
        return false;
    }

    public boolean isAttributeSpecified(int n) {
        if (this.fEventType == 1 || this.fEventType == 10) {
            return this.fScanner.getAttributeIterator().isSpecified(n);
        }
        throw new IllegalStateException("Current state is not among the states " + XMLStreamReaderImpl.getEventTypeString(1) + " , " + XMLStreamReaderImpl.getEventTypeString(10) + "valid for isAttributeSpecified()");
    }

    public boolean isCharacters() {
        return this.fEventType == 4;
    }

    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("found: " + XMLStreamReaderImpl.getEventTypeString(n) + ", expected " + XMLStreamReaderImpl.getEventTypeString(1) + " or " + XMLStreamReaderImpl.getEventTypeString(2), this.getLocation());
        }
        return n;
    }

    public boolean standaloneSet() {
        return this.fScanner.standaloneSet();
    }

    public javax.xml.namespace.QName convertXNIQNametoJavaxQName(QName qName) {
        if (qName == null) {
            return null;
        }
        if (qName.prefix == null) {
            return new javax.xml.namespace.QName(qName.uri, qName.localpart);
        }
        return new javax.xml.namespace.QName(qName.uri, qName.localpart, qName.prefix);
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix cannot be null.");
        }
        return this.fScanner.getNamespaceContext().getURI(this.fSymbolTable.addSymbol(string));
    }

    protected void setPropertyManager(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
        this.fScanner.setProperty("stax-properties", propertyManager);
        this.fScanner.setPropertyManager(propertyManager);
    }

    protected PropertyManager getPropertyManager() {
        return this.fPropertyManager;
    }

    static void pr(String string) {
        System.out.println(string);
    }

    protected List getEntityDecls() {
        if (this.fEventType == 11) {
            XMLEntityStorage xMLEntityStorage = this.fEntityManager.getEntityStore();
            Map<String, Entity> map = xMLEntityStorage.getDeclaredEntities();
            ArrayList<EntityDeclarationImpl> arrayList = null;
            if (map != null) {
                EntityDeclarationImpl entityDeclarationImpl = null;
                arrayList = new ArrayList<EntityDeclarationImpl>(map.size());
                for (Map.Entry<String, Entity> entry : map.entrySet()) {
                    String string = entry.getKey();
                    Entity entity = entry.getValue();
                    entityDeclarationImpl = new EntityDeclarationImpl();
                    entityDeclarationImpl.setEntityName(string);
                    if (entity.isExternal()) {
                        entityDeclarationImpl.setXMLResourceIdentifier(((Entity.ExternalEntity)entity).entityLocation);
                        entityDeclarationImpl.setNotationName(((Entity.ExternalEntity)entity).notation);
                    } else {
                        entityDeclarationImpl.setEntityReplacementText(((Entity.InternalEntity)entity).text);
                    }
                    arrayList.add(entityDeclarationImpl);
                }
            }
            return arrayList;
        }
        return null;
    }

    protected List getNotationDecls() {
        if (this.fEventType == 11) {
            if (this.fScanner.fDTDScanner == null) {
                return null;
            }
            DTDGrammar dTDGrammar = ((XMLDTDScannerImpl)this.fScanner.fDTDScanner).getGrammar();
            if (dTDGrammar == null) {
                return null;
            }
            List list = dTDGrammar.getNotationDecls();
            Iterator iterator = list.iterator();
            ArrayList<NotationDeclarationImpl> arrayList = new ArrayList<NotationDeclarationImpl>();
            while (iterator.hasNext()) {
                XMLNotationDecl xMLNotationDecl = (XMLNotationDecl)iterator.next();
                if (xMLNotationDecl == null) continue;
                arrayList.add(new NotationDeclarationImpl(xMLNotationDecl));
            }
            return arrayList;
        }
        return null;
    }
}

