/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.AttrImpl;
import com.sun.org.apache.xerces.internal.dom.AttrNSImpl;
import com.sun.org.apache.xerces.internal.dom.CDATASectionImpl;
import com.sun.org.apache.xerces.internal.dom.ChildNode;
import com.sun.org.apache.xerces.internal.dom.CommentImpl;
import com.sun.org.apache.xerces.internal.dom.CoreDOMImplementationImpl;
import com.sun.org.apache.xerces.internal.dom.DOMConfigurationImpl;
import com.sun.org.apache.xerces.internal.dom.DOMImplementationImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DOMNormalizer;
import com.sun.org.apache.xerces.internal.dom.DeepNodeListImpl;
import com.sun.org.apache.xerces.internal.dom.DeferredDOMImplementationImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentFragmentImpl;
import com.sun.org.apache.xerces.internal.dom.DocumentTypeImpl;
import com.sun.org.apache.xerces.internal.dom.ElementDefinitionImpl;
import com.sun.org.apache.xerces.internal.dom.ElementImpl;
import com.sun.org.apache.xerces.internal.dom.ElementNSImpl;
import com.sun.org.apache.xerces.internal.dom.EntityImpl;
import com.sun.org.apache.xerces.internal.dom.EntityReferenceImpl;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import com.sun.org.apache.xerces.internal.dom.NodeListCache;
import com.sun.org.apache.xerces.internal.dom.NotationImpl;
import com.sun.org.apache.xerces.internal.dom.ParentNode;
import com.sun.org.apache.xerces.internal.dom.ProcessingInstructionImpl;
import com.sun.org.apache.xerces.internal.dom.TextImpl;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.util.XML11Char;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import com.sun.org.apache.xerces.internal.utils.ObjectFactory;
import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import jdk.xml.internal.HashMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreDocumentImpl
extends ParentNode
implements Document {
    static final long serialVersionUID = 0L;
    protected DocumentTypeImpl docType;
    protected ElementImpl docElement;
    transient NodeListCache fFreeNLCache;
    protected String encoding;
    protected String actualEncoding;
    protected String version;
    protected boolean standalone;
    protected String fDocumentURI;
    private Map<Node, Map<String, ParentNode.UserDataRecord>> nodeUserData;
    protected Map<String, Node> identifiers;
    transient DOMNormalizer domNormalizer = null;
    transient DOMConfigurationImpl fConfiguration = null;
    transient Object fXPathEvaluator = null;
    private static final int[] kidOK = new int[13];
    protected int changes = 0;
    protected boolean allowGrammarAccess;
    protected boolean errorChecking = true;
    protected boolean ancestorChecking = true;
    protected boolean xmlVersionChanged = false;
    private int documentNumber = 0;
    private int nodeCounter = 0;
    private Map<Node, Integer> nodeTable;
    private boolean xml11Version = false;
    private static final ObjectStreamField[] serialPersistentFields;

    public CoreDocumentImpl() {
        this(false);
    }

    public CoreDocumentImpl(boolean bl) {
        super(null);
        this.ownerDocument = this;
        this.allowGrammarAccess = bl;
        String string = SecuritySupport.getSystemProperty("http://java.sun.com/xml/dom/properties/ancestor-check");
        if (string != null && string.equalsIgnoreCase("false")) {
            this.ancestorChecking = false;
        }
    }

    public CoreDocumentImpl(DocumentType documentType) {
        this(documentType, false);
    }

    public CoreDocumentImpl(DocumentType documentType, boolean bl) {
        this(bl);
        if (documentType != null) {
            try {
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)documentType;
            }
            catch (ClassCastException classCastException) {
                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, string);
            }
            documentTypeImpl.ownerDocument = this;
            this.appendChild(documentType);
        }
    }

    @Override
    public final Document getOwnerDocument() {
        return null;
    }

    @Override
    public short getNodeType() {
        return 9;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public Node cloneNode(boolean bl) {
        CoreDocumentImpl coreDocumentImpl = new CoreDocumentImpl();
        this.callUserDataHandlers(this, coreDocumentImpl, (short)1);
        this.cloneNode(coreDocumentImpl, bl);
        return coreDocumentImpl;
    }

    protected void cloneNode(CoreDocumentImpl coreDocumentImpl, boolean bl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            HashMap<Node, String> hashMap = null;
            if (this.identifiers != null) {
                hashMap = new HashMap<Node, String>(this.identifiers.size());
                for (String string : this.identifiers.keySet()) {
                    hashMap.put(this.identifiers.get(string), string);
                }
            }
            Object object = this.firstChild;
            while (object != null) {
                coreDocumentImpl.appendChild(coreDocumentImpl.importNode((Node)object, true, true, hashMap));
                object = ((ChildNode)object).nextSibling;
            }
        }
        coreDocumentImpl.allowGrammarAccess = this.allowGrammarAccess;
        coreDocumentImpl.errorChecking = this.errorChecking;
    }

    @Override
    public Node insertBefore(Node node, Node node2) throws DOMException {
        short s = node.getNodeType();
        if (this.errorChecking && (s == 1 && this.docElement != null || s == 10 && this.docType != null)) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
            throw new DOMException(3, string);
        }
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        super.insertBefore(node, node2);
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        super.removeChild(node);
        short s = node.getNodeType();
        if (s == 1) {
            this.docElement = null;
        } else if (s == 10) {
            this.docType = null;
        }
        return node;
    }

    @Override
    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (node.getOwnerDocument() == null && node instanceof DocumentTypeImpl) {
            ((DocumentTypeImpl)node).ownerDocument = this;
        }
        if (this.errorChecking && (this.docType != null && node2.getNodeType() != 10 && node.getNodeType() == 10 || this.docElement != null && node2.getNodeType() != 1 && node.getNodeType() == 1)) {
            throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
        }
        super.replaceChild(node, node2);
        short s = node2.getNodeType();
        if (s == 1) {
            this.docElement = (ElementImpl)node;
        } else if (s == 10) {
            this.docType = (DocumentTypeImpl)node;
        }
        return node2;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String string) throws DOMException {
    }

    @Override
    public Object getFeature(String string, String string2) {
        boolean bl;
        boolean bl2 = bl = string2 == null || string2.length() == 0;
        if (string.equalsIgnoreCase("+XPath") && (bl || string2.equals("3.0"))) {
            if (this.fXPathEvaluator != null) {
                return this.fXPathEvaluator;
            }
            try {
                Class clazz = ObjectFactory.findProviderClass("com.sun.org.apache.xpath.internal.domapi.XPathEvaluatorImpl", true);
                Constructor constructor = clazz.getConstructor(Document.class);
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!classArray[i].getName().equals("org.w3c.dom.xpath.XPathEvaluator")) continue;
                    this.fXPathEvaluator = constructor.newInstance(this);
                    return this.fXPathEvaluator;
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return super.getFeature(string, string2);
    }

    @Override
    public Attr createAttribute(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new AttrImpl(this, string);
    }

    @Override
    public CDATASection createCDATASection(String string) throws DOMException {
        return new CDATASectionImpl(this, string);
    }

    @Override
    public Comment createComment(String string) {
        return new CommentImpl(this, string);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl(this);
    }

    @Override
    public Element createElement(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new ElementImpl(this, string);
    }

    @Override
    public EntityReference createEntityReference(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new EntityReferenceImpl(this, string);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string3);
        }
        return new ProcessingInstructionImpl(this, string, string2);
    }

    @Override
    public Text createTextNode(String string) {
        return new TextImpl(this, string);
    }

    @Override
    public DocumentType getDoctype() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docType;
    }

    @Override
    public Element getDocumentElement() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.docElement;
    }

    @Override
    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    @Override
    public DOMImplementation getImplementation() {
        return CoreDOMImplementationImpl.getDOMImplementation();
    }

    public void setErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    @Override
    public void setStrictErrorChecking(boolean bl) {
        this.errorChecking = bl;
    }

    public boolean getErrorChecking() {
        return this.errorChecking;
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.errorChecking;
    }

    @Override
    public String getInputEncoding() {
        return this.actualEncoding;
    }

    public void setInputEncoding(String string) {
        this.actualEncoding = string;
    }

    public void setXmlEncoding(String string) {
        this.encoding = string;
    }

    public void setEncoding(String string) {
        this.setXmlEncoding(string);
    }

    @Override
    public String getXmlEncoding() {
        return this.encoding;
    }

    public String getEncoding() {
        return this.getXmlEncoding();
    }

    @Override
    public void setXmlVersion(String string) {
        if (string.equals("1.0") || string.equals("1.1")) {
            if (!this.getXmlVersion().equals(string)) {
                this.xmlVersionChanged = true;
                this.isNormalized(false);
                this.version = string;
            }
        } else {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string2);
        }
        this.xml11Version = this.getXmlVersion().equals("1.1");
    }

    public void setVersion(String string) {
        this.setXmlVersion(string);
    }

    @Override
    public String getXmlVersion() {
        return this.version == null ? "1.0" : this.version;
    }

    public String getVersion() {
        return this.getXmlVersion();
    }

    @Override
    public void setXmlStandalone(boolean bl) throws DOMException {
        this.standalone = bl;
    }

    public void setStandalone(boolean bl) {
        this.setXmlStandalone(bl);
    }

    @Override
    public boolean getXmlStandalone() {
        return this.standalone;
    }

    public boolean getStandalone() {
        return this.getXmlStandalone();
    }

    @Override
    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    @Override
    public Node renameNode(Node node, String string, String string2) throws DOMException {
        if (this.errorChecking && node.getOwnerDocument() != this && node != this) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string3);
        }
        switch (node.getNodeType()) {
            case 1: {
                ElementImpl elementImpl = (ElementImpl)node;
                if (elementImpl instanceof ElementNSImpl) {
                    ((ElementNSImpl)elementImpl).rename(string, string2);
                    this.callUserDataHandlers(elementImpl, null, (short)4);
                } else if (string == null) {
                    if (this.errorChecking) {
                        int n = string2.indexOf(58);
                        if (n != -1) {
                            String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                            throw new DOMException(14, string4);
                        }
                        if (!CoreDocumentImpl.isXMLName(string2, this.xml11Version)) {
                            String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                            throw new DOMException(5, string5);
                        }
                    }
                    elementImpl.rename(string2);
                    this.callUserDataHandlers(elementImpl, null, (short)4);
                } else {
                    ElementNSImpl elementNSImpl = new ElementNSImpl(this, string, string2);
                    this.copyEventListeners(elementImpl, elementNSImpl);
                    Map<String, ParentNode.UserDataRecord> map = this.removeUserDataTable(elementImpl);
                    Node node2 = elementImpl.getParentNode();
                    Node node3 = elementImpl.getNextSibling();
                    if (node2 != null) {
                        node2.removeChild(elementImpl);
                    }
                    Node node4 = elementImpl.getFirstChild();
                    while (node4 != null) {
                        elementImpl.removeChild(node4);
                        elementNSImpl.appendChild(node4);
                        node4 = elementImpl.getFirstChild();
                    }
                    elementNSImpl.moveSpecifiedAttributes(elementImpl);
                    this.setUserDataTable(elementNSImpl, map);
                    this.callUserDataHandlers(elementImpl, elementNSImpl, (short)4);
                    if (node2 != null) {
                        node2.insertBefore(elementNSImpl, node3);
                    }
                    elementImpl = elementNSImpl;
                }
                this.renamedElement((Element)node, elementImpl);
                return elementImpl;
            }
            case 2: {
                AttrImpl attrImpl = (AttrImpl)node;
                Element element = attrImpl.getOwnerElement();
                if (element != null) {
                    element.removeAttributeNode(attrImpl);
                }
                if (node instanceof AttrNSImpl) {
                    ((AttrNSImpl)attrImpl).rename(string, string2);
                    if (element != null) {
                        element.setAttributeNodeNS(attrImpl);
                    }
                    this.callUserDataHandlers(attrImpl, null, (short)4);
                } else if (string == null) {
                    attrImpl.rename(string2);
                    if (element != null) {
                        element.setAttributeNode(attrImpl);
                    }
                    this.callUserDataHandlers(attrImpl, null, (short)4);
                } else {
                    AttrNSImpl attrNSImpl = new AttrNSImpl(this, string, string2);
                    this.copyEventListeners(attrImpl, attrNSImpl);
                    Map<String, ParentNode.UserDataRecord> map = this.removeUserDataTable(attrImpl);
                    Node node5 = attrImpl.getFirstChild();
                    while (node5 != null) {
                        attrImpl.removeChild(node5);
                        attrNSImpl.appendChild(node5);
                        node5 = attrImpl.getFirstChild();
                    }
                    this.setUserDataTable(attrNSImpl, map);
                    this.callUserDataHandlers(attrImpl, attrNSImpl, (short)4);
                    if (element != null) {
                        element.setAttributeNode(attrNSImpl);
                    }
                    attrImpl = attrNSImpl;
                }
                this.renamedAttrNode((Attr)node, attrImpl);
                return attrImpl;
            }
        }
        String string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
        throw new DOMException(9, string6);
    }

    @Override
    public void normalizeDocument() {
        if (this.isNormalized() && !this.isNormalizeDocRequired()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.domNormalizer == null) {
            this.domNormalizer = new DOMNormalizer();
        }
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        } else {
            this.fConfiguration.reset();
        }
        this.domNormalizer.normalizeDocument(this, this.fConfiguration);
        this.isNormalized(true);
        this.xmlVersionChanged = false;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        if (this.fConfiguration == null) {
            this.fConfiguration = new DOMConfigurationImpl();
        }
        return this.fConfiguration;
    }

    @Override
    public String getBaseURI() {
        if (this.fDocumentURI != null && this.fDocumentURI.length() != 0) {
            try {
                return new URI(this.fDocumentURI).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
        }
        return this.fDocumentURI;
    }

    @Override
    public void setDocumentURI(String string) {
        this.fDocumentURI = string;
    }

    public boolean getAsync() {
        return false;
    }

    public void setAsync(boolean bl) {
        if (bl) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
            throw new DOMException(9, string);
        }
    }

    public void abort() {
    }

    public boolean load(String string) {
        return false;
    }

    public boolean loadXML(String string) {
        return false;
    }

    public String saveXML(Node node) throws DOMException {
        if (this.errorChecking && node != null && this != node.getOwnerDocument()) {
            String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
            throw new DOMException(4, string);
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)DOMImplementationImpl.getDOMImplementation());
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        if (node == null) {
            node = this;
        }
        return lSSerializer.writeToString(node);
    }

    void setMutationEvents(boolean bl) {
    }

    boolean getMutationEvents() {
        return false;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        return new DocumentTypeImpl(this, string, string2, string3);
    }

    public Entity createEntity(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new EntityImpl(this, string);
    }

    public Notation createNotation(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new NotationImpl(this, string);
    }

    public ElementDefinitionImpl createElementDefinition(String string) throws DOMException {
        if (this.errorChecking && !CoreDocumentImpl.isXMLName(string, this.xml11Version)) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string2);
        }
        return new ElementDefinitionImpl(this, string);
    }

    @Override
    protected int getNodeNumber() {
        if (this.documentNumber == 0) {
            CoreDOMImplementationImpl coreDOMImplementationImpl = (CoreDOMImplementationImpl)CoreDOMImplementationImpl.getDOMImplementation();
            this.documentNumber = coreDOMImplementationImpl.assignDocumentNumber();
        }
        return this.documentNumber;
    }

    protected int getNodeNumber(Node node) {
        int n;
        if (this.nodeTable == null) {
            this.nodeTable = new HashMap<Node, Integer>();
            n = --this.nodeCounter;
            this.nodeTable.put(node, n);
        } else {
            Integer n2 = this.nodeTable.get(node);
            if (n2 == null) {
                n = --this.nodeCounter;
                this.nodeTable.put(node, n);
            } else {
                n = n2;
            }
        }
        return n;
    }

    @Override
    public Node importNode(Node node, boolean bl) throws DOMException {
        return this.importNode(node, bl, false, null);
    }

    private Node importNode(Node node, boolean bl, boolean bl2, Map<Node, String> map) throws DOMException {
        Node node2;
        Node node3 = null;
        Map<String, ParentNode.UserDataRecord> map2 = null;
        if (node instanceof NodeImpl) {
            map2 = ((NodeImpl)node).getUserDataRecord();
        }
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                String string;
                int n;
                boolean bl3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0");
                node2 = !bl3 || node.getLocalName() == null ? this.createElement(node.getNodeName()) : this.createElementNS(node.getNamespaceURI(), node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n2 = namedNodeMap.getLength();
                    for (n = 0; n < n2; ++n) {
                        Attr attr = (Attr)namedNodeMap.item(n);
                        if (!attr.getSpecified() && !bl2) continue;
                        Attr attr2 = (Attr)this.importNode(attr, true, bl2, map);
                        if (!bl3 || attr.getLocalName() == null) {
                            node2.setAttributeNode(attr2);
                            continue;
                        }
                        node2.setAttributeNodeNS(attr2);
                    }
                }
                if (map != null && (string = map.get(node)) != null) {
                    if (this.identifiers == null) {
                        this.identifiers = new HashMap<String, Node>();
                    }
                    this.identifiers.put(string, node2);
                }
                node3 = node2;
                break;
            }
            case 2: {
                node3 = node.getOwnerDocument().getImplementation().hasFeature("XML", "2.0") ? (node.getLocalName() == null ? this.createAttribute(node.getNodeName()) : this.createAttributeNS(node.getNamespaceURI(), node.getNodeName())) : this.createAttribute(node.getNodeName());
                if (node instanceof AttrImpl) {
                    node2 = (AttrImpl)node;
                    if (((NodeImpl)node2).hasStringValue()) {
                        AttrImpl attrImpl = (AttrImpl)node3;
                        attrImpl.setValue(((AttrImpl)node2).getValue());
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (node.getFirstChild() == null) {
                    node3.setNodeValue(node.getNodeValue());
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                node3 = this.createTextNode(node.getNodeValue());
                break;
            }
            case 4: {
                node3 = this.createCDATASection(node.getNodeValue());
                break;
            }
            case 5: {
                node3 = this.createEntityReference(node.getNodeName());
                bl = false;
                break;
            }
            case 6: {
                node2 = (Entity)node;
                EntityImpl entityImpl = (EntityImpl)this.createEntity(node.getNodeName());
                entityImpl.setPublicId(node2.getPublicId());
                entityImpl.setSystemId(node2.getSystemId());
                entityImpl.setNotationName(node2.getNotationName());
                entityImpl.isReadOnly(false);
                node3 = entityImpl;
                break;
            }
            case 7: {
                node3 = this.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 8: {
                node3 = this.createComment(node.getNodeValue());
                break;
            }
            case 10: {
                int n;
                if (!bl2) {
                    String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                    throw new DOMException(9, string);
                }
                node2 = (DocumentType)node;
                DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.createDocumentType(node2.getNodeName(), node2.getPublicId(), node2.getSystemId());
                NamedNodeMap namedNodeMap = node2.getEntities();
                NamedNodeMap namedNodeMap2 = documentTypeImpl.getEntities();
                if (namedNodeMap != null) {
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, true, map));
                    }
                }
                namedNodeMap = node2.getNotations();
                namedNodeMap2 = documentTypeImpl.getNotations();
                if (namedNodeMap != null) {
                    for (n = 0; n < namedNodeMap.getLength(); ++n) {
                        namedNodeMap2.setNamedItem(this.importNode(namedNodeMap.item(n), true, true, map));
                    }
                }
                node3 = documentTypeImpl;
                break;
            }
            case 11: {
                node3 = this.createDocumentFragment();
                break;
            }
            case 12: {
                node2 = (Notation)node;
                NotationImpl notationImpl = (NotationImpl)this.createNotation(node.getNodeName());
                notationImpl.setPublicId(node2.getPublicId());
                notationImpl.setSystemId(node2.getSystemId());
                node3 = notationImpl;
                break;
            }
            default: {
                String string = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, string);
            }
        }
        if (map2 != null) {
            this.callUserDataHandlers(node, node3, (short)2, map2);
        }
        if (bl) {
            for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                node3.appendChild(this.importNode(node2, true, bl2, map));
            }
        }
        if (node3.getNodeType() == 6) {
            ((NodeImpl)node3).setReadOnly(true, true);
        }
        return node3;
    }

    @Override
    public Node adoptNode(Node node) {
        Map<String, ParentNode.UserDataRecord> map;
        Object object;
        Object object2;
        NodeImpl nodeImpl;
        try {
            nodeImpl = (NodeImpl)node;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (node == null) {
            return null;
        }
        if (node.getOwnerDocument() != null && (object2 = this.getImplementation()) != (object = node.getOwnerDocument().getImplementation())) {
            if (object2 instanceof DOMImplementationImpl && object instanceof DeferredDOMImplementationImpl) {
                this.undeferChildren(nodeImpl);
            } else if (!(object2 instanceof DeferredDOMImplementationImpl) || !(object instanceof DOMImplementationImpl)) {
                return null;
            }
        }
        switch (nodeImpl.getNodeType()) {
            case 2: {
                object2 = (AttrImpl)nodeImpl;
                if (((AttrImpl)object2).getOwnerElement() != null) {
                    ((AttrImpl)object2).getOwnerElement().removeAttributeNode((Attr)object2);
                }
                ((NodeImpl)object2).isSpecified(true);
                map = nodeImpl.getUserDataRecord();
                ((AttrImpl)object2).setOwnerDocument(this);
                if (map == null) break;
                this.setUserDataTable(nodeImpl, map);
                break;
            }
            case 6: 
            case 12: {
                object2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, (String)object2);
            }
            case 9: 
            case 10: {
                object2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_SUPPORTED_ERR", null);
                throw new DOMException(9, (String)object2);
            }
            case 5: {
                NamedNodeMap namedNodeMap;
                Node node2;
                map = nodeImpl.getUserDataRecord();
                object2 = nodeImpl.getParentNode();
                if (object2 != null) {
                    object2.removeChild(node);
                }
                while ((object = nodeImpl.getFirstChild()) != null) {
                    nodeImpl.removeChild((Node)object);
                }
                nodeImpl.setOwnerDocument(this);
                if (map != null) {
                    this.setUserDataTable(nodeImpl, map);
                }
                if (this.docType == null || (node2 = (namedNodeMap = this.docType.getEntities()).getNamedItem(nodeImpl.getNodeName())) == null) break;
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    Node node3 = object.cloneNode(true);
                    nodeImpl.appendChild(node3);
                }
                break;
            }
            case 1: {
                map = nodeImpl.getUserDataRecord();
                object2 = nodeImpl.getParentNode();
                if (object2 != null) {
                    object2.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
                if (map != null) {
                    this.setUserDataTable(nodeImpl, map);
                }
                ((ElementImpl)nodeImpl).reconcileDefaultAttributes();
                break;
            }
            default: {
                map = nodeImpl.getUserDataRecord();
                object2 = nodeImpl.getParentNode();
                if (object2 != null) {
                    object2.removeChild(node);
                }
                nodeImpl.setOwnerDocument(this);
                if (map == null) break;
                this.setUserDataTable(nodeImpl, map);
            }
        }
        if (map != null) {
            this.callUserDataHandlers(node, null, (short)5, map);
        }
        return nodeImpl;
    }

    protected void undeferChildren(Node node) {
        Node node2 = node;
        while (null != node) {
            NamedNodeMap namedNodeMap;
            if (((NodeImpl)node).needsSyncData()) {
                ((NodeImpl)node).synchronizeData();
            }
            if ((namedNodeMap = node.getAttributes()) != null) {
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    this.undeferChildren(namedNodeMap.item(i));
                }
            }
            Node node3 = null;
            node3 = node.getFirstChild();
            while (null == node3 && !node2.equals(node)) {
                node3 = node.getNextSibling();
                if (null != node3 || null != (node = node.getParentNode()) && !node2.equals(node)) continue;
                node3 = null;
                break;
            }
            node = node3;
        }
    }

    @Override
    public Element getElementById(String string) {
        return this.getIdentifier(string);
    }

    protected final void clearIdentifiers() {
        if (this.identifiers != null) {
            this.identifiers.clear();
        }
    }

    public void putIdentifier(String string, Element element) {
        if (element == null) {
            this.removeIdentifier(string);
            return;
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            this.identifiers = new HashMap<String, Node>();
        }
        this.identifiers.put(string, element);
    }

    public Element getIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return null;
        }
        Element element = (Element)this.identifiers.get(string);
        if (element != null) {
            for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
                if (node != this) continue;
                return element;
            }
        }
        return null;
    }

    public void removeIdentifier(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.identifiers == null) {
            return;
        }
        this.identifiers.remove(string);
    }

    @Override
    public Element createElementNS(String string, String string2) throws DOMException {
        return new ElementNSImpl(this, string, string2);
    }

    public Element createElementNS(String string, String string2, String string3) throws DOMException {
        return new ElementNSImpl(this, string, string2, string3);
    }

    @Override
    public Attr createAttributeNS(String string, String string2) throws DOMException {
        return new AttrNSImpl(this, string, string2);
    }

    public Attr createAttributeNS(String string, String string2, String string3) throws DOMException {
        return new AttrNSImpl(this, string, string2, string3);
    }

    @Override
    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public Object clone() throws CloneNotSupportedException {
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)super.clone();
        coreDocumentImpl.docType = null;
        coreDocumentImpl.docElement = null;
        return coreDocumentImpl;
    }

    public static final boolean isXMLName(String string, boolean bl) {
        if (string == null) {
            return false;
        }
        if (!bl) {
            return XMLChar.isValidName(string);
        }
        return XML11Char.isXML11ValidName(string);
    }

    public static final boolean isValidQName(String string, String string2, boolean bl) {
        if (string2 == null) {
            return false;
        }
        boolean bl2 = false;
        bl2 = !bl ? (string == null || XMLChar.isValidNCName(string)) && XMLChar.isValidNCName(string2) : (string == null || XML11Char.isXML11ValidNCName(string)) && XML11Char.isXML11ValidNCName(string2);
        return bl2;
    }

    protected boolean isKidOK(Node node, Node node2) {
        if (this.allowGrammarAccess && node.getNodeType() == 10) {
            return node2.getNodeType() == 1;
        }
        return 0 != (kidOK[node.getNodeType()] & 1 << node2.getNodeType());
    }

    @Override
    protected void changed() {
        ++this.changes;
    }

    @Override
    protected int changes() {
        return this.changes;
    }

    NodeListCache getNodeListCache(ParentNode parentNode) {
        if (this.fFreeNLCache == null) {
            return new NodeListCache(parentNode);
        }
        NodeListCache nodeListCache = this.fFreeNLCache;
        this.fFreeNLCache = this.fFreeNLCache.next;
        nodeListCache.fChild = null;
        nodeListCache.fChildIndex = -1;
        nodeListCache.fLength = -1;
        if (nodeListCache.fOwner != null) {
            nodeListCache.fOwner.fNodeListCache = null;
        }
        nodeListCache.fOwner = parentNode;
        return nodeListCache;
    }

    void freeNodeListCache(NodeListCache nodeListCache) {
        nodeListCache.next = this.fFreeNLCache;
        this.fFreeNLCache = nodeListCache;
    }

    public Object setUserData(Node node, String string, Object object, UserDataHandler userDataHandler) {
        Map<String, ParentNode.UserDataRecord> map;
        if (object == null) {
            ParentNode.UserDataRecord userDataRecord;
            Map<String, ParentNode.UserDataRecord> map2;
            if (this.nodeUserData != null && (map2 = this.nodeUserData.get(node)) != null && (userDataRecord = map2.remove(string)) != null) {
                return userDataRecord.fData;
            }
            return null;
        }
        if (this.nodeUserData == null) {
            this.nodeUserData = new HashMap<Node, Map<String, ParentNode.UserDataRecord>>();
            map = new HashMap<String, ParentNode.UserDataRecord>();
            this.nodeUserData.put(node, map);
        } else {
            map = this.nodeUserData.get(node);
            if (map == null) {
                map = new HashMap<String, ParentNode.UserDataRecord>();
                this.nodeUserData.put(node, map);
            }
        }
        ParentNode.UserDataRecord userDataRecord = map.put(string, new ParentNode.UserDataRecord(this, object, userDataHandler));
        if (userDataRecord != null) {
            return userDataRecord.fData;
        }
        return null;
    }

    public Object getUserData(Node node, String string) {
        if (this.nodeUserData == null) {
            return null;
        }
        Map<String, ParentNode.UserDataRecord> map = this.nodeUserData.get(node);
        if (map == null) {
            return null;
        }
        ParentNode.UserDataRecord userDataRecord = map.get(string);
        if (userDataRecord != null) {
            return userDataRecord.fData;
        }
        return null;
    }

    protected Map<String, ParentNode.UserDataRecord> getUserDataRecord(Node node) {
        if (this.nodeUserData == null) {
            return null;
        }
        Map<String, ParentNode.UserDataRecord> map = this.nodeUserData.get(node);
        if (map == null) {
            return null;
        }
        return map;
    }

    Map<String, ParentNode.UserDataRecord> removeUserDataTable(Node node) {
        if (this.nodeUserData == null) {
            return null;
        }
        return this.nodeUserData.get(node);
    }

    void setUserDataTable(Node node, Map<String, ParentNode.UserDataRecord> map) {
        if (this.nodeUserData == null) {
            this.nodeUserData = new HashMap<Node, Map<String, ParentNode.UserDataRecord>>();
        }
        if (map != null) {
            this.nodeUserData.put(node, map);
        }
    }

    void callUserDataHandlers(Node node, Node node2, short s) {
        if (this.nodeUserData == null) {
            return;
        }
        if (node instanceof NodeImpl) {
            Map<String, ParentNode.UserDataRecord> map = ((NodeImpl)node).getUserDataRecord();
            if (map == null || map.isEmpty()) {
                return;
            }
            this.callUserDataHandlers(node, node2, s, map);
        }
    }

    void callUserDataHandlers(Node node, Node node2, short s, Map<String, ParentNode.UserDataRecord> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            ParentNode.UserDataRecord userDataRecord = map.get(string);
            if (userDataRecord.fHandler == null) continue;
            userDataRecord.fHandler.handle(s, string, userDataRecord.fData, node, node2);
        }
    }

    protected final void checkNamespaceWF(String string, int n, int n2) {
        if (!this.errorChecking) {
            return;
        }
        if (n == 0 || n == string.length() - 1 || n2 != n) {
            String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
            throw new DOMException(14, string2);
        }
    }

    protected final void checkDOMNSErr(String string, String string2) {
        if (this.errorChecking) {
            if (string2 == null) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, string3);
            }
            if (string.equals("xml") && !string2.equals(NamespaceContext.XML_URI)) {
                String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, string4);
            }
            if (string.equals("xmlns") && !string2.equals(NamespaceContext.XMLNS_URI) || !string.equals("xmlns") && string2.equals(NamespaceContext.XMLNS_URI)) {
                String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, string5);
            }
        }
    }

    protected final void checkQName(String string, String string2) {
        if (!this.errorChecking) {
            return;
        }
        boolean bl = false;
        if (!this.xml11Version) {
            bl = (string == null || XMLChar.isValidNCName(string)) && XMLChar.isValidNCName(string2);
        } else {
            boolean bl2 = bl = (string == null || XML11Char.isXML11ValidNCName(string)) && XML11Char.isXML11ValidNCName(string2);
        }
        if (!bl) {
            String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
            throw new DOMException(5, string3);
        }
    }

    boolean isXML11Version() {
        return this.xml11Version;
    }

    boolean isNormalizeDocRequired() {
        return true;
    }

    boolean isXMLVersionChanged() {
        return this.xmlVersionChanged;
    }

    protected void setUserData(NodeImpl nodeImpl, Object object) {
        this.setUserData(nodeImpl, "XERCES1DOMUSERDATA", object, null);
    }

    protected Object getUserData(NodeImpl nodeImpl) {
        return this.getUserData(nodeImpl, "XERCES1DOMUSERDATA");
    }

    protected void addEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    protected void removeEventListener(NodeImpl nodeImpl, String string, EventListener eventListener, boolean bl) {
    }

    protected void copyEventListeners(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
    }

    protected boolean dispatchEvent(NodeImpl nodeImpl, Event event) {
        return false;
    }

    void replacedText(NodeImpl nodeImpl) {
    }

    void deletedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void insertedText(NodeImpl nodeImpl, int n, int n2) {
    }

    void modifyingCharacterData(NodeImpl nodeImpl, boolean bl) {
    }

    void modifiedCharacterData(NodeImpl nodeImpl, String string, String string2, boolean bl) {
    }

    void insertingNode(NodeImpl nodeImpl, boolean bl) {
    }

    void insertedNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void removingNode(NodeImpl nodeImpl, NodeImpl nodeImpl2, boolean bl) {
    }

    void removedNode(NodeImpl nodeImpl, boolean bl) {
    }

    void replacingNode(NodeImpl nodeImpl) {
    }

    void replacedNode(NodeImpl nodeImpl) {
    }

    void replacingData(NodeImpl nodeImpl) {
    }

    void replacedCharacterData(NodeImpl nodeImpl, String string, String string2) {
    }

    void modifiedAttrValue(AttrImpl attrImpl, String string) {
    }

    void setAttrNode(AttrImpl attrImpl, AttrImpl attrImpl2) {
    }

    void removedAttrNode(AttrImpl attrImpl, NodeImpl nodeImpl, String string) {
    }

    void renamedAttrNode(Attr attr, Attr attr2) {
    }

    void renamedElement(Element element, Element element2) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = null;
        if (this.nodeUserData != null) {
            hashtable = new Hashtable();
            for (Map.Entry object2 : this.nodeUserData.entrySet()) {
                hashtable.put(object2.getKey(), new Hashtable((Map)object2.getValue()));
            }
        }
        Hashtable<String, Node> hashtable2 = this.identifiers == null ? null : new Hashtable<String, Node>(this.identifiers);
        Hashtable<Node, Integer> hashtable3 = this.nodeTable == null ? null : new Hashtable<Node, Integer>(this.nodeTable);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("docType", this.docType);
        putField.put("docElement", this.docElement);
        putField.put("fFreeNLCache", this.fFreeNLCache);
        putField.put("encoding", this.encoding);
        putField.put("actualEncoding", this.actualEncoding);
        putField.put("version", this.version);
        putField.put("standalone", this.standalone);
        putField.put("fDocumentURI", this.fDocumentURI);
        putField.put("userData", hashtable);
        putField.put("identifiers", hashtable2);
        putField.put("changes", this.changes);
        putField.put("allowGrammarAccess", this.allowGrammarAccess);
        putField.put("errorChecking", this.errorChecking);
        putField.put("ancestorChecking", this.ancestorChecking);
        putField.put("xmlVersionChanged", this.xmlVersionChanged);
        putField.put("documentNumber", this.documentNumber);
        putField.put("nodeCounter", this.nodeCounter);
        putField.put("nodeTable", hashtable3);
        putField.put("xml11Version", this.xml11Version);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.docType = (DocumentTypeImpl)getField.get("docType", null);
        this.docElement = (ElementImpl)getField.get("docElement", null);
        this.fFreeNLCache = (NodeListCache)getField.get("fFreeNLCache", null);
        this.encoding = (String)getField.get("encoding", null);
        this.actualEncoding = (String)getField.get("actualEncoding", null);
        this.version = (String)getField.get("version", null);
        this.standalone = getField.get("standalone", false);
        this.fDocumentURI = (String)getField.get("fDocumentURI", null);
        Hashtable hashtable = (Hashtable)getField.get("userData", null);
        Hashtable hashtable2 = (Hashtable)getField.get("identifiers", null);
        this.changes = getField.get("changes", 0);
        this.allowGrammarAccess = getField.get("allowGrammarAccess", false);
        this.errorChecking = getField.get("errorChecking", true);
        this.ancestorChecking = getField.get("ancestorChecking", true);
        this.xmlVersionChanged = getField.get("xmlVersionChanged", false);
        this.documentNumber = getField.get("documentNumber", 0);
        this.nodeCounter = getField.get("nodeCounter", 0);
        Hashtable hashtable3 = (Hashtable)getField.get("nodeTable", null);
        this.xml11Version = getField.get("xml11Version", false);
        if (hashtable != null) {
            this.nodeUserData = new HashMap<Node, Map<String, ParentNode.UserDataRecord>>();
            for (Map.Entry entry : hashtable.entrySet()) {
                this.nodeUserData.put((Node)entry.getKey(), new HashMap((Map)entry.getValue()));
            }
        }
        if (hashtable2 != null) {
            this.identifiers = new HashMap<String, Node>(hashtable2);
        }
        if (hashtable3 != null) {
            this.nodeTable = new HashMap<Node, Integer>(hashtable3);
        }
    }

    static {
        CoreDocumentImpl.kidOK[9] = 1410;
        CoreDocumentImpl.kidOK[1] = 442;
        CoreDocumentImpl.kidOK[5] = 442;
        CoreDocumentImpl.kidOK[6] = 442;
        CoreDocumentImpl.kidOK[11] = 442;
        CoreDocumentImpl.kidOK[2] = 40;
        CoreDocumentImpl.kidOK[12] = 0;
        CoreDocumentImpl.kidOK[4] = 0;
        CoreDocumentImpl.kidOK[3] = 0;
        CoreDocumentImpl.kidOK[8] = 0;
        CoreDocumentImpl.kidOK[7] = 0;
        CoreDocumentImpl.kidOK[10] = 0;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("docType", DocumentTypeImpl.class), new ObjectStreamField("docElement", ElementImpl.class), new ObjectStreamField("fFreeNLCache", NodeListCache.class), new ObjectStreamField("encoding", String.class), new ObjectStreamField("actualEncoding", String.class), new ObjectStreamField("version", String.class), new ObjectStreamField("standalone", Boolean.TYPE), new ObjectStreamField("fDocumentURI", String.class), new ObjectStreamField("userData", Hashtable.class), new ObjectStreamField("identifiers", Hashtable.class), new ObjectStreamField("changes", Integer.TYPE), new ObjectStreamField("allowGrammarAccess", Boolean.TYPE), new ObjectStreamField("errorChecking", Boolean.TYPE), new ObjectStreamField("ancestorChecking", Boolean.TYPE), new ObjectStreamField("xmlVersionChanged", Boolean.TYPE), new ObjectStreamField("documentNumber", Integer.TYPE), new ObjectStreamField("nodeCounter", Integer.TYPE), new ObjectStreamField("nodeTable", Hashtable.class), new ObjectStreamField("xml11Version", Boolean.TYPE)};
    }
}

