/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.util.ClassPath;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashMap;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static jdk.xml.internal.HashMap _instances = new jdk.xml.internal.HashMap();
    private ClassPath _path = null;
    private jdk.xml.internal.HashMap<String, JavaClass> _loadedClasses = new jdk.xml.internal.HashMap();
    private static final long serialVersionUID = 4274520361292963981L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("_path", ClassPath.class), new ObjectStreamField("_loadedClasses", HashMap.class)};

    private SyntheticRepository(ClassPath classPath) {
        this._path = classPath;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository syntheticRepository = (SyntheticRepository)_instances.get(classPath);
        if (syntheticRepository == null) {
            syntheticRepository = new SyntheticRepository(classPath);
            _instances.put(classPath, syntheticRepository);
        }
        return syntheticRepository;
    }

    public void storeClass(JavaClass javaClass) {
        this._loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    public void removeClass(JavaClass javaClass) {
        this._loadedClasses.remove(javaClass.getClassName());
    }

    public JavaClass findClass(String string) {
        return this._loadedClasses.get(string);
    }

    public JavaClass loadClass(String string) throws ClassNotFoundException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + string);
        }
        string = string.replace('/', '.');
        try {
            return this.loadClass(this._path.getInputStream(string), string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String string = clazz.getName();
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(string2 + ".class"), string);
    }

    private JavaClass loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string);
                javaClass = classParser.parse();
                this.storeClass(javaClass);
                return javaClass;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + string);
    }

    public void clear() {
        this._loadedClasses.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        HashMap<String, JavaClass> hashMap = new HashMap<String, JavaClass>(this._loadedClasses);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("_loadedClasses", hashMap);
        putField.put("_path", this._path);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        HashMap hashMap = (HashMap)getField.get("_loadedClasses", null);
        if (hashMap != null) {
            this._loadedClasses = new jdk.xml.internal.HashMap(hashMap);
        }
        this._path = (ClassPath)getField.get("_path", null);
    }
}

