/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.DLSInfo;
import com.sun.media.sound.DLSSampleOptions;
import com.sun.media.sound.ModelByteBuffer;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public final class DLSSample
extends SoundbankResource {
    byte[] guid = null;
    DLSInfo info = new DLSInfo();
    DLSSampleOptions sampleoptions;
    ModelByteBuffer data;
    AudioFormat format;

    public DLSSample(Soundbank soundbank) {
        super(soundbank, null, AudioInputStream.class);
    }

    public DLSSample() {
        super(null, null, AudioInputStream.class);
    }

    public DLSInfo getInfo() {
        return this.info;
    }

    public Object getData() {
        AudioFormat audioFormat = this.getFormat();
        InputStream inputStream = this.data.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return new AudioInputStream(inputStream, audioFormat, this.data.capacity());
    }

    public ModelByteBuffer getDataBuffer() {
        return this.data;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat audioFormat) {
        this.format = audioFormat;
    }

    public void setData(ModelByteBuffer modelByteBuffer) {
        this.data = modelByteBuffer;
    }

    public void setData(byte[] byArray) {
        this.data = new ModelByteBuffer(byArray);
    }

    public void setData(byte[] byArray, int n, int n2) {
        this.data = new ModelByteBuffer(byArray, n, n2);
    }

    public String getName() {
        return this.info.name;
    }

    public void setName(String string) {
        this.info.name = string;
    }

    public DLSSampleOptions getSampleoptions() {
        return this.sampleoptions;
    }

    public void setSampleoptions(DLSSampleOptions dLSSampleOptions) {
        this.sampleoptions = dLSSampleOptions;
    }

    public String toString() {
        return "Sample: " + this.info.name;
    }

    public byte[] getGuid() {
        return this.guid == null ? null : Arrays.copyOf(this.guid, this.guid.length);
    }

    public void setGuid(byte[] byArray) {
        this.guid = byArray == null ? null : Arrays.copyOf(byArray, byArray.length);
    }
}

