/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.ListenerThreadImpl;
import com.sun.corba.se.impl.transport.ReaderThreadImpl;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.ListenerThread;
import com.sun.corba.se.pept.transport.ReaderThread;
import com.sun.corba.se.pept.transport.Selector;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SelectorImpl
extends Thread
implements Selector {
    private ORB orb;
    private java.nio.channels.Selector selector;
    private long timeout;
    private List deferredRegistrations;
    private List interestOpsList;
    private HashMap listenerThreads;
    private Map readerThreads;
    private boolean selectorStarted;
    private volatile boolean closed;
    private ORBUtilSystemException wrapper;

    public SelectorImpl(ORB oRB) {
        this.orb = oRB;
        this.selector = null;
        this.selectorStarted = false;
        this.timeout = 60000L;
        this.deferredRegistrations = new ArrayList();
        this.interestOpsList = new ArrayList();
        this.listenerThreads = new HashMap();
        this.readerThreads = Collections.synchronizedMap(new HashMap());
        this.closed = false;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterestOps(EventHandler eventHandler) {
        SelectionKey selectionKey;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerInterestOps:-> " + eventHandler);
        }
        if ((selectionKey = eventHandler.getSelectionKey()).isValid()) {
            int n = eventHandler.getInterestOps();
            SelectionKeyAndOp selectionKeyAndOp = new SelectionKeyAndOp(selectionKey, n);
            List list = this.interestOpsList;
            synchronized (list) {
                this.interestOpsList.add(selectionKeyAndOp);
            }
            this.selector.wakeup();
        } else {
            this.wrapper.selectionKeyInvalid(eventHandler.toString());
            if (this.orb.transportDebugFlag) {
                this.dprint(".registerInterestOps: EventHandler SelectionKey not valid " + eventHandler);
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerInterestOps:<- ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForEvent(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerForEvent: " + eventHandler);
        }
        if (this.isClosed()) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".registerForEvent: closed: " + eventHandler);
            }
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            List list = this.deferredRegistrations;
            synchronized (list) {
                this.deferredRegistrations.add(eventHandler);
            }
            if (!this.selectorStarted) {
                this.startSelector();
            }
            this.selector.wakeup();
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.createListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.createReaderThread(eventHandler);
                break;
            }
            default: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".registerForEvent: default: " + eventHandler);
                }
                throw new RuntimeException("SelectorImpl.registerForEvent: unknown interest ops");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForEvent(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterForEvent: " + eventHandler);
        }
        if (this.isClosed()) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".unregisterForEvent: closed: " + eventHandler);
            }
            return;
        }
        if (eventHandler.shouldUseSelectThreadToWait()) {
            SelectionKey selectionKey;
            List list = this.deferredRegistrations;
            synchronized (list) {
                selectionKey = eventHandler.getSelectionKey();
            }
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.selector.wakeup();
            return;
        }
        switch (eventHandler.getInterestOps()) {
            case 16: {
                this.destroyListenerThread(eventHandler);
                break;
            }
            case 1: {
                this.destroyReaderThread(eventHandler);
                break;
            }
            default: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".unregisterForEvent: default: " + eventHandler);
                }
                throw new RuntimeException("SelectorImpl.uregisterForEvent: unknown interest ops");
            }
        }
    }

    public void close() {
        block8: {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close");
            }
            if (this.isClosed()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".close: already closed");
                }
                return;
            }
            this.setClosed(true);
            for (Object object : this.listenerThreads.values()) {
                object.close();
            }
            for (Object object : this.readerThreads.values()) {
                object.close();
            }
            try {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            catch (Throwable throwable) {
                if (!this.orb.transportDebugFlag) break block8;
                this.dprint(".close: selector.close: " + throwable);
            }
        }
    }

    public void run() {
        this.setName("SelectorThread");
        while (!this.closed) {
            try {
                int n;
                block12: {
                    n = 0;
                    if (this.timeout == 0L && this.orb.transportDebugFlag) {
                        this.dprint(".run: Beginning of selection cycle");
                    }
                    this.handleDeferredRegistrations();
                    this.enableInterestOps();
                    try {
                        n = this.selector.select(this.timeout);
                    }
                    catch (IOException iOException) {
                        if (!this.orb.transportDebugFlag) break block12;
                        this.dprint(".run: selector.select: " + iOException);
                    }
                }
                if (this.closed) {
                    this.selector.close();
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".run: closed - .run return");
                    }
                    return;
                }
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                if (this.orb.transportDebugFlag && iterator.hasNext()) {
                    this.dprint(".run: n = " + n);
                }
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    EventHandler eventHandler = (EventHandler)selectionKey.attachment();
                    try {
                        eventHandler.handleEvent();
                    }
                    catch (Throwable throwable) {
                        if (!this.orb.transportDebugFlag) continue;
                        this.dprint(".run: eventHandler.handleEvent", throwable);
                    }
                }
                if (this.timeout != 0L || !this.orb.transportDebugFlag) continue;
                this.dprint(".run: End of selection cycle");
            }
            catch (Throwable throwable) {
                if (!this.orb.transportDebugFlag) continue;
                this.dprint(".run: ignoring", throwable);
            }
        }
    }

    private synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized void setClosed(boolean bl) {
        this.closed = bl;
    }

    private void startSelector() {
        try {
            this.selector = java.nio.channels.Selector.open();
        }
        catch (IOException iOException) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".startSelector: Selector.open: IOException: " + iOException);
            }
            RuntimeException runtimeException = new RuntimeException(".startSelector: Selector.open exception");
            runtimeException.initCause(iOException);
            throw runtimeException;
        }
        this.setDaemon(true);
        this.start();
        this.selectorStarted = true;
        if (this.orb.transportDebugFlag) {
            this.dprint(".startSelector: selector.start completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeferredRegistrations() {
        List list = this.deferredRegistrations;
        synchronized (list) {
            int n = this.deferredRegistrations.size();
            for (int i = 0; i < n; ++i) {
                SelectionKey selectionKey;
                EventHandler eventHandler;
                block7: {
                    eventHandler = (EventHandler)this.deferredRegistrations.get(i);
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".handleDeferredRegistrations: " + eventHandler);
                    }
                    SelectableChannel selectableChannel = eventHandler.getChannel();
                    selectionKey = null;
                    try {
                        selectionKey = selectableChannel.register(this.selector, eventHandler.getInterestOps(), eventHandler);
                    }
                    catch (ClosedChannelException closedChannelException) {
                        if (!this.orb.transportDebugFlag) break block7;
                        this.dprint(".handleDeferredRegistrations: " + closedChannelException);
                    }
                }
                eventHandler.setSelectionKey(selectionKey);
            }
            this.deferredRegistrations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableInterestOps() {
        List list = this.interestOpsList;
        synchronized (list) {
            int n = this.interestOpsList.size();
            if (n > 0) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".enableInterestOps:->");
                }
                SelectionKey selectionKey = null;
                SelectionKeyAndOp selectionKeyAndOp = null;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    selectionKeyAndOp = (SelectionKeyAndOp)this.interestOpsList.get(i);
                    selectionKey = selectionKeyAndOp.selectionKey;
                    if (!selectionKey.isValid()) continue;
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".enableInterestOps: " + selectionKeyAndOp);
                    }
                    int n3 = selectionKeyAndOp.keyOp;
                    n2 = selectionKey.interestOps();
                    selectionKey.interestOps(n2 | n3);
                }
                this.interestOpsList.clear();
                if (this.orb.transportDebugFlag) {
                    this.dprint(".enableInterestOps:<-");
                }
            }
        }
    }

    private void createListenerThread(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".createListenerThread: " + eventHandler);
        }
        Acceptor acceptor = eventHandler.getAcceptor();
        ListenerThreadImpl listenerThreadImpl = new ListenerThreadImpl(this.orb, acceptor, this);
        this.listenerThreads.put(eventHandler, listenerThreadImpl);
        Exception exception = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(listenerThreadImpl);
        }
        catch (NoSuchThreadPoolException noSuchThreadPoolException) {
            exception = noSuchThreadPoolException;
        }
        catch (NoSuchWorkQueueException noSuchWorkQueueException) {
            exception = noSuchWorkQueueException;
        }
        if (exception != null) {
            RuntimeException runtimeException = new RuntimeException(exception.toString());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    private void destroyListenerThread(EventHandler eventHandler) {
        ListenerThread listenerThread;
        if (this.orb.transportDebugFlag) {
            this.dprint(".destroyListenerThread: " + eventHandler);
        }
        if ((listenerThread = (ListenerThread)this.listenerThreads.get(eventHandler)) == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".destroyListenerThread: cannot find ListenerThread - ignoring.");
            }
            return;
        }
        this.listenerThreads.remove(eventHandler);
        listenerThread.close();
    }

    private void createReaderThread(EventHandler eventHandler) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".createReaderThread: " + eventHandler);
        }
        Connection connection = eventHandler.getConnection();
        ReaderThreadImpl readerThreadImpl = new ReaderThreadImpl(this.orb, connection, this);
        this.readerThreads.put(eventHandler, readerThreadImpl);
        Exception exception = null;
        try {
            this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(readerThreadImpl);
        }
        catch (NoSuchThreadPoolException noSuchThreadPoolException) {
            exception = noSuchThreadPoolException;
        }
        catch (NoSuchWorkQueueException noSuchWorkQueueException) {
            exception = noSuchWorkQueueException;
        }
        if (exception != null) {
            RuntimeException runtimeException = new RuntimeException(exception.toString());
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    private void destroyReaderThread(EventHandler eventHandler) {
        ReaderThread readerThread;
        if (this.orb.transportDebugFlag) {
            this.dprint(".destroyReaderThread: " + eventHandler);
        }
        if ((readerThread = (ReaderThread)this.readerThreads.get(eventHandler)) == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".destroyReaderThread: cannot find ReaderThread - ignoring.");
            }
            return;
        }
        this.readerThreads.remove(eventHandler);
        readerThread.close();
    }

    private void dprint(String string) {
        ORBUtility.dprint("SelectorImpl", string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }

    private class SelectionKeyAndOp {
        public int keyOp;
        public SelectionKey selectionKey;

        public SelectionKeyAndOp(SelectionKey selectionKey, int n) {
            this.selectionKey = selectionKey;
            this.keyOp = n;
        }
    }
}

