/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static Method hasStaticInitializerMethod = null;

    public static long computeSerialVersionUID(Class clazz) {
        long l = com.sun.corba.se.impl.io.ObjectStreamClass.getSerialVersionUID(clazz);
        if (l == 0L) {
            return l;
        }
        l = ObjectStreamClassUtil_1_3.getSerialVersion(l, clazz);
        return l;
    }

    private static Long getSerialVersion(final long l, final Class clazz) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                long l2;
                try {
                    Field field = clazz.getDeclaredField("serialVersionUID");
                    int n = field.getModifiers();
                    l2 = Modifier.isStatic(n) && Modifier.isFinal(n) && Modifier.isPrivate(n) ? l : ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    l2 = ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                return new Long(l2);
            }
        });
    }

    public static long computeStructuralUID(boolean bl, Class<?> clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            int n2;
            AccessibleObject accessibleObject;
            if (!Serializable.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != Object.class) {
                boolean bl2 = false;
                Class[] classArray = new Class[]{ObjectOutputStream.class};
                accessibleObject = ObjectStreamClassUtil_1_3.getDeclaredMethod(clazz2, "writeObject", classArray, 2, 8);
                if (accessibleObject != null) {
                    bl2 = true;
                }
                dataOutputStream.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(bl2, clazz2));
            }
            if (bl) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Field[] fieldArray = ObjectStreamClassUtil_1_3.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            for (int i = 0; i < fieldArray.length; ++i) {
                accessibleObject = fieldArray[i];
                n2 = ((Field)accessibleObject).getModifiers();
                if (Modifier.isTransient(n2) || Modifier.isStatic(n2)) continue;
                dataOutputStream.writeUTF(((Field)accessibleObject).getName());
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)accessibleObject).getType()));
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (n2 = n = Math.min(8, byArray.length); n2 > 0; --n2) {
                l += (long)(byArray[n2] & 0xFF) << n2 * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            String string;
            Object object;
            int n;
            AnnotatedElement[] annotatedElementArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n2 &= 0x611) & 0x200) != 0) {
                n2 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n2 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n2);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                Arrays.sort(annotatedElementArray, compareClassByName);
                for (n = 0; n < annotatedElementArray.length; ++n) {
                    dataOutputStream.writeUTF(((Class)annotatedElementArray[n]).getName());
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            Arrays.sort(annotatedElementArray, compareMemberByName);
            for (n = 0; n < annotatedElementArray.length; ++n) {
                AnnotatedElement annotatedElement = annotatedElementArray[n];
                int n3 = ((Field)annotatedElement).getModifiers();
                if (Modifier.isPrivate(n3) && (Modifier.isTransient(n3) || Modifier.isStatic(n3))) continue;
                dataOutputStream.writeUTF(((Field)annotatedElement).getName());
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)annotatedElement).getType()));
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            for (int i = 0; i < methodSignatureArray.length; ++i) {
                MethodSignature methodSignature = methodSignatureArray[i];
                object = "<init>";
                string = methodSignature.signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeInt(methodSignature.member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i = 0; i < methodSignatureArray2.length; ++i) {
                object = methodSignatureArray2[i];
                string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < Math.min(8, byArray.length); ++i) {
                l += (long)(byArray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n = 0;
            while (clazz2.isArray()) {
                ++n;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Object object;
        if (hasStaticInitializerMethod == null) {
            object = null;
            try {
                if (object == null) {
                    object = ObjectStreamClass.class;
                }
                hasStaticInitializerMethod = ((Class)object).getDeclaredMethod("hasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + ((Class)object).getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            object = (Boolean)hasStaticInitializerMethod.invoke(null, clazz);
            return (Boolean)object;
        }
        catch (Exception exception) {
            throw new InternalError("Error invoking hasStaticInitializer: " + exception);
        }
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray, final int n, final int n2) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                    int n3 = method.getModifiers();
                    if ((n3 & n2) != 0 || (n3 & n) != n) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Method)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                ++n;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n];
            int n2 = 0;
            for (int i = 0; i < memberArray.length; ++i) {
                if (Modifier.isPrivate(memberArray[i].getModifiers())) continue;
                methodSignatureArray[n2] = new MethodSignature(memberArray[i]);
                ++n2;
            }
            if (n2 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n == 0) {
                    n = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.getSignature((Constructor)member) : ObjectStreamClassUtil_1_3.getSignature((Method)member);
        }
    }
}

