/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.crypto.CryptoPermissions;
import javax.crypto.CryptoPolicyParser;
import sun.security.validator.Validator;

final class JarVerifier {
    private static final boolean debug = false;
    private static final String PLUGIN_IMPL_NAME = "sun.plugin.net.protocol.jar.CachedJarURLConnection";
    private Vector verifiedSignerCache = null;
    private URL jarURL;
    private boolean savePerms = false;
    private CryptoPermissions appPerms = null;
    private Validator validator;

    JarVerifier(URL uRL, Validator validator, boolean bl) {
        this.jarURL = uRL;
        this.validator = validator;
        this.savePerms = bl;
        this.verifiedSignerCache = new Vector(2);
    }

    void verify() throws JarException, IOException {
        if (this.jarURL == null) {
            throw new JarException("Class is on the bootclasspath");
        }
        try {
            this.verifyJars(this.jarURL, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CertificateException certificateException) {
            throw new JarException("Cannot verify " + this.jarURL.toString());
        }
        catch (CryptoPolicyParser.ParsingException parsingException) {
            throw new JarException("Cannot parse " + this.jarURL.toString());
        }
        finally {
            if (this.verifiedSignerCache != null) {
                this.verifiedSignerCache.clear();
            }
        }
    }

    CryptoPermissions getPermissions() {
        return this.appPerms;
    }

    private void verifyJars(URL uRL, Vector vector) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        String string = uRL.toString();
        if (vector == null || !vector.contains(string)) {
            String string2 = this.verifySingleJar(uRL);
            if (vector != null) {
                vector.addElement(string);
            }
            if (string2 != null) {
                if (vector == null) {
                    vector = new Vector<String>();
                    vector.addElement(string);
                }
                this.verifyManifestClassPathJars(uRL, string2, vector);
            }
        }
    }

    private void verifyManifestClassPathJars(URL uRL, String string, Vector vector) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        String[] stringArray = JarVerifier.parseAttrClasspath(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                URL uRL2 = new URL(uRL, stringArray[i]);
                this.verifyJars(uRL2, vector);
            }
        }
        catch (MalformedURLException malformedURLException) {
            MalformedURLException malformedURLException2 = new MalformedURLException("The JAR file " + uRL.toString() + " contains invalid URLs in its Class-Path attribute");
            malformedURLException2.initCause(malformedURLException);
            throw malformedURLException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String verifySingleJar(URL uRL) throws NoSuchProviderException, CertificateException, IOException, CryptoPolicyParser.ParsingException {
        final URL uRL2 = uRL.getProtocol().equalsIgnoreCase("jar") ? uRL : new URL("jar:" + uRL.toString() + "!/");
        JarHolder jarHolder = null;
        try {
            try {
                jarHolder = (JarHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        boolean bl = false;
                        JarURLConnection jarURLConnection = (JarURLConnection)uRL2.openConnection();
                        if (jarURLConnection.getClass().getName().equals(JarVerifier.PLUGIN_IMPL_NAME)) {
                            bl = true;
                        }
                        jarURLConnection.setUseCaches(bl);
                        JarFile jarFile = jarURLConnection.getJarFile();
                        if (jarFile != null) {
                            return new JarHolder(jarFile, bl);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Cannot verify " + uRL2.toString());
                securityException.initCause(privilegedActionException);
                throw securityException;
            }
            if (jarHolder != null) {
                Object object;
                Object object2;
                Cloneable cloneable;
                JarFile jarFile = jarHolder.file;
                byte[] byArray = new byte[8192];
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    cloneable = enumeration.nextElement();
                    object2 = new BufferedInputStream(jarFile.getInputStream((ZipEntry)cloneable));
                    try {
                        while (((BufferedInputStream)object2).read(byArray, 0, byArray.length) != -1) {
                        }
                    }
                    finally {
                        ((BufferedInputStream)object2).close();
                    }
                }
                cloneable = jarFile.getManifest();
                if (cloneable == null) {
                    throw new JarException(uRL.toString() + " is not signed.");
                }
                object2 = jarFile.entries();
                while (object2.hasMoreElements()) {
                    X509Certificate[] x509CertificateArray;
                    object = (JarEntry)object2.nextElement();
                    if (((ZipEntry)object).isDirectory()) continue;
                    Certificate[] certificateArray = ((JarEntry)object).getCertificates();
                    if (certificateArray == null || certificateArray.length == 0) {
                        if (((ZipEntry)object).getName().startsWith("META-INF")) continue;
                        throw new JarException(uRL.toString() + " has unsigned entries - " + ((ZipEntry)object).getName());
                    }
                    int n = 0;
                    boolean bl = false;
                    while ((x509CertificateArray = JarVerifier.getAChain(certificateArray, n)) != null) {
                        if (this.verifiedSignerCache.contains(x509CertificateArray[0])) {
                            bl = true;
                            break;
                        }
                        if (this.isTrusted(x509CertificateArray)) {
                            bl = true;
                            this.verifiedSignerCache.addElement(x509CertificateArray[0]);
                            break;
                        }
                        n += x509CertificateArray.length;
                    }
                    if (bl) continue;
                    throw new JarException(uRL.toString() + " is not signed by a" + " trusted signer.");
                }
                if (this.jarURL.equals(uRL) && this.savePerms) {
                    object = jarHolder.file.getJarEntry("cryptoPerms");
                    this.appPerms = new CryptoPermissions();
                    this.appPerms.load(jarHolder.file.getInputStream((ZipEntry)object));
                }
                object = ((Manifest)cloneable).getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                return object;
            }
            String string = null;
            return string;
        }
        finally {
            if (jarHolder != null && !jarHolder.useCaches) {
                jarHolder.file.close();
            }
        }
    }

    private static String[] parseAttrClasspath(String string) throws JarException {
        string = string.trim();
        int n = string.indexOf(32);
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        do {
            if (n > 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1).trim();
                n = string.indexOf(32);
            } else {
                string2 = string;
                bl = true;
            }
            if (!string2.endsWith(".jar")) {
                throw new JarException("The provider contains un-verifiable components");
            }
            vector.addElement(string2);
        } while (!bl);
        return vector.toArray(new String[0]);
    }

    private boolean isTrusted(X509Certificate[] x509CertificateArray) {
        try {
            this.validator.validate(x509CertificateArray);
            return true;
        }
        catch (CertificateException certificateException) {
            return false;
        }
    }

    private static X509Certificate[] getAChain(Certificate[] certificateArray, int n) {
        int n2;
        if (n > certificateArray.length - 1) {
            return null;
        }
        for (n2 = n; n2 < certificateArray.length - 1 && ((Object)((X509Certificate)certificateArray[n2 + 1]).getSubjectDN()).equals(((X509Certificate)certificateArray[n2]).getIssuerDN()); ++n2) {
        }
        int n3 = n2 - n + 1;
        X509Certificate[] x509CertificateArray = new X509Certificate[n3];
        for (int i = 0; i < n3; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[n + i];
        }
        return x509CertificateArray;
    }

    static List convertCertsToChains(Certificate[] certificateArray) throws CertificateException {
        if (certificateArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<X509Certificate[]> arrayList = new ArrayList<X509Certificate[]>();
        X509Certificate[] x509CertificateArray = null;
        int n = 0;
        while ((x509CertificateArray = JarVerifier.getAChain(certificateArray, n)) != null) {
            arrayList.add(x509CertificateArray);
            n += x509CertificateArray.length;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List getSignersOfJarEntry(URL uRL) throws Exception {
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        jarURLConnection.setUseCaches(false);
        byte[] byArray = new byte[8192];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(jarURLConnection.getInputStream());
        try {
            while (bufferedInputStream.read(byArray, 0, byArray.length) != -1) {
            }
        }
        finally {
            bufferedInputStream.close();
        }
        return JarVerifier.convertCertsToChains(jarURLConnection.getCertificates());
    }

    private static class JarHolder {
        JarFile file;
        boolean useCaches;

        JarHolder(JarFile jarFile, boolean bl) {
            this.file = jarFile;
            this.useCaches = bl;
        }
    }
}

