/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarUtil {
    private static final String META_FILE_DIR = "META-INF/";

    public static boolean isSigningRelated(String string) {
        if (string == null) {
            return false;
        }
        if (!(string = string.toUpperCase(Locale.ENGLISH)).startsWith(META_FILE_DIR)) {
            return false;
        }
        if ((string = string.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if (string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF") || string.endsWith(".EC") || string.equals("MANIFEST.MF")) {
            return true;
        }
        if (string.startsWith("SIG-")) {
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string2 = string.substring(n + 1);
                if (string2.length() > 3 || string2.length() < 1) {
                    return false;
                }
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isDirectory(ZipEntry zipEntry) {
        return zipEntry.isDirectory() && zipEntry.getSize() == 0L && zipEntry.getCrc() == 0L;
    }

    public static boolean canSkipEntry(ZipEntry zipEntry) {
        return JarUtil.isSigningRelated(zipEntry.getName()) || JarUtil.isDirectory(zipEntry);
    }

    public static boolean allJarEntriesSigned(JarFile jarFile) throws IOException {
        if (jarFile == null || jarFile.getManifest() == null) {
            return false;
        }
        Set<String> set = jarFile.getManifest().getEntries().keySet();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            if (JarUtil.canSkipEntry(jarEntry) || set.contains(string)) continue;
            return false;
        }
        return true;
    }
}

