/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.util.OrderedHashSet;
import com.sun.deploy.util.Property;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class JVMParameters {
    private static final boolean DEBUG = false;
    private List internalArguments = new ArrayList();
    private ArgumentSet trustedArguments = new ArgumentSet();
    private ArgumentSet arguments = new ArgumentSet();
    private long maxHeap = 0L;
    private boolean isDefault;
    private static final long DEFAULT_HEAP = 0x4000000L;
    private static final String INTERNAL_SEPARATOR_ARG = "---";
    private static final String TRUSTED_SEPARATOR_ARG = "--";
    private static JVMParameters runningJVMParameters = null;
    private static final String[] PLUGIN_DEPENDENT_JARS = new String[]{"deploy.jar", "javaws.jar", "plugin.jar", "SharedWindow.jar"};

    public JVMParameters() {
        this.clear();
    }

    public void clear() {
        this.internalArguments.clear();
        this.clearUserArguments();
    }

    public void clearUserArguments() {
        this.trustedArguments.clear();
        this.arguments.clear();
        this.maxHeap = 0L;
        this.isDefault = true;
    }

    public JVMParameters copy() {
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.addArguments(this);
        return jVMParameters;
    }

    public String[][] copyToStringArrays() {
        String[][] stringArray = new String[8][];
        stringArray[0] = this.internalArguments.toArray(new String[0]);
        this.trustedArguments.copyToStringArrays(stringArray, 1);
        String[] stringArray2 = new String[]{this.getXmx()};
        stringArray[4] = stringArray2;
        this.arguments.copyToStringArrays(stringArray, 5);
        return stringArray;
    }

    public void getFromStringArrays(String[][] stringArray) {
        for (int i = 0; i < stringArray[0].length; ++i) {
            this.internalArguments.add(stringArray[0][i]);
        }
        this.trustedArguments.getFromStringArrays(stringArray, 1);
        String string = stringArray[4][0];
        if (string != null) {
            this.addArgument(string);
        }
        this.arguments.getFromStringArrays(stringArray, 5);
        this.recomputeIsDefault();
    }

    public void parse(String string) {
        this.parseImpl(string, false, false);
    }

    public void parse(String string, boolean bl) {
        this.parseImpl(string, false, bl);
    }

    public void parseTrustedOptions(String string) {
        this.parseImpl(string, true, false);
    }

    private void parseImpl(String string, boolean bl, boolean bl2) {
        List list;
        if (string == null) {
            return;
        }
        try {
            list = StringQuoteUtil.parseCommandLine(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            return;
        }
        boolean bl3 = true;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            bl3 = this.addArgumentImpl(string2, bl3, bl, bl2);
        }
    }

    public void addProperties(Properties properties) {
        this.arguments.addAll(properties);
        this.recomputeIsDefault();
    }

    public void addProperties(List list) {
        this.arguments.addAll(list);
        this.recomputeIsDefault();
    }

    public void addArgument(String string) {
        this.addArgument(string, true);
    }

    public void addArgument(String string, boolean bl) {
        this.addArgumentImpl(StringQuoteUtil.unquoteIfNeeded(string), bl, false, false);
    }

    public void addInternalArgument(String string) {
        this.internalArguments.add(string);
    }

    public void addArguments(JVMParameters jVMParameters) {
        this.internalArguments.addAll(jVMParameters.internalArguments);
        this.trustedArguments.addAll(jVMParameters.trustedArguments);
        this.arguments.addAll(jVMParameters.arguments);
        if (!jVMParameters.isDefault && jVMParameters.maxHeap > 0L) {
            this.maxHeap = jVMParameters.maxHeap;
        } else if (this.isDefault && jVMParameters.isDefault) {
            this.maxHeap = this.maxHeap != 0L || jVMParameters.maxHeap != 0L ? Math.max(this.getMaxHeapSize(), jVMParameters.getMaxHeapSize()) : 0L;
        }
        this.isDefault = this.isDefault && jVMParameters.isDefault;
    }

    public void removeArgument(String string) {
        if (string.startsWith("-Xmx")) {
            this.maxHeap = 0L;
        } else if (!this.trustedArguments.removeArgument(string)) {
            this.arguments.removeArgument(string);
        }
        this.recomputeIsDefault();
    }

    public void parseBootClassPath(String[] stringArray) {
        this.parseBootClassPath(Config.getSystemProperty("sun.boot.class.path"), stringArray);
    }

    public void parseBootClassPath(String string, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = null;
            String string2 = null;
            try {
                stringArray2 = string.split(File.pathSeparator);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                stringArray2 = JVMParameters.splitString(string, File.pathSeparator);
            }
            block2: for (int i = 0; i < stringArray2.length; ++i) {
                String string3 = stringArray2[i];
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!string3.endsWith(stringArray[j])) continue;
                    if (string2 == null) {
                        string2 = string3;
                        continue block2;
                    }
                    string2 = string2 + File.pathSeparator + string3;
                    continue block2;
                }
            }
            if (string2 != null) {
                this.addInternalArgument("-Xbootclasspath/a:" + string2);
            }
        }
    }

    public static String[] getPlugInDependentJars() {
        return (String[])PLUGIN_DEPENDENT_JARS.clone();
    }

    public List getCommandLineArguments(boolean bl, boolean bl2) {
        return this.getCommandLineArguments(bl, true, true, bl2, true, false, -1);
    }

    public List getCommandLineArguments(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n) {
        int n2;
        Object object;
        Object object2;
        int n3 = 0;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl2) {
            object2 = this.internalArguments.iterator();
            while (n3 < n && object2.hasNext()) {
                object = (String)object2.next();
                if (bl6 && (((String)object).startsWith("-Xbootclasspath/a") || ((String)object).startsWith("-Djava.class.path")) || n3 + (n2 = ((String)object).length() + 1) >= n) continue;
                arrayList.add(object);
                n3 += n2;
            }
        }
        if (bl) {
            arrayList.add(INTERNAL_SEPARATOR_ARG);
        }
        if (bl3 && n3 < n) {
            n3 += this.trustedArguments.addTo(arrayList, bl4, bl5, n - n3);
        }
        if (bl) {
            arrayList.add(TRUSTED_SEPARATOR_ARG);
        }
        if ((object2 = this.getXmx()) != null && n3 + (n2 = ((String)object2).length() + 1) < n) {
            arrayList.add(object2);
            n3 += n2;
        }
        if (n3 < n) {
            n3 += this.arguments.addTo(arrayList, bl4, bl5, n - n3);
        }
        if (n3 >= n) {
            object = new Exception("Internal Error: JVMParameters.getCommandLineArguments: string size: " + n3 + " >= " + n);
            ((Throwable)object).printStackTrace();
        }
        this.ensureNoDuplicates(arrayList);
        return arrayList;
    }

    private void ensureNoDuplicates(List list) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashSet.contains(string)) {
                iterator.remove();
                continue;
            }
            hashSet.add(string);
        }
    }

    public String getCommandLineArgumentsAsString(boolean bl, boolean bl2) {
        return StringQuoteUtil.getStringByCommandList(this.getCommandLineArguments(false, bl, bl2, false, true, false, -1));
    }

    public String getCommandLineArgumentsAsString(boolean bl) {
        return this.getCommandLineArgumentsAsString(bl, true);
    }

    public void addTo(Properties properties) {
        this.trustedArguments.addTo(properties);
        this.arguments.addTo(properties);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.addTo(properties);
        return properties;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean satisfies(JVMParameters jVMParameters) {
        if (jVMParameters == null) {
            return false;
        }
        if (this.getMaxHeapSize() < jVMParameters.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && jVMParameters.isDefault) {
            return true;
        }
        if (this.isSecure() != jVMParameters.isSecure()) {
            return false;
        }
        if (!this.isDefault && jVMParameters.isDefault) {
            return false;
        }
        int n = jVMParameters.size();
        for (int i = 0; i < n; ++i) {
            String string = jVMParameters.get(i);
            if (this.isExcluded(string) || this.contains(string)) continue;
            return false;
        }
        return true;
    }

    public boolean satisfiesSecure(JVMParameters jVMParameters) {
        if (jVMParameters == null) {
            return false;
        }
        if (this.getMaxHeapSize() < jVMParameters.getMaxHeapSize()) {
            return false;
        }
        if (this.isDefault && jVMParameters.isDefault) {
            return true;
        }
        if (!this.isDefault && jVMParameters.isDefault) {
            return false;
        }
        int n = jVMParameters.size();
        for (int i = 0; i < n; ++i) {
            String string = jVMParameters.get(i);
            if (!JVMParameters.isSecureArgument(string) || this.isExcluded(string) || this.contains(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSecureArgument(String string) {
        Property property = Property.createProperty(string);
        if (property != null) {
            return property.isSecure();
        }
        return Config.isSecureVmArg(string);
    }

    public static boolean isJVMCommandLineArgument(String string) {
        if (string == null) {
            return false;
        }
        return (string = StringQuoteUtil.unquoteIfNeeded(string)).charAt(0) == '-';
    }

    public long getMaxHeapSize() {
        return this.maxHeap > 0L ? this.maxHeap : 0x4000000L;
    }

    public void setMaxHeapSize(long l) {
        this.maxHeap = l > 0L ? l : 0L;
    }

    public static final long getDefaultHeapSize() {
        return 0x4000000L;
    }

    public static JVMParameters getRunningJVMParameters() {
        return runningJVMParameters;
    }

    public static void setRunningJVMParameters(JVMParameters jVMParameters) {
        runningJVMParameters = new JVMParameters();
        Properties properties = new Properties();
        Config.addSecureSystemPropertiesTo(properties);
        runningJVMParameters.addProperties(properties);
        runningJVMParameters.addArguments(jVMParameters);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[JVMParameters: isSecure: " + this.isSecure() + ", args: ");
        stringBuffer.append(this.getCommandLineArgumentsAsString(true));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean contains(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isExcluded(String string) {
        if (string.startsWith("-Djnlp.") || string.startsWith("-Djavaws.")) {
            if (Environment.isJavaWebStart()) {
                return true;
            }
            if (string.startsWith("-Djnlp.packEnabled") || string.startsWith("-Djnlp.versionEnabled") || string.startsWith("-Djnlp.concurrentDownloads")) {
                return true;
            }
        }
        return false;
    }

    public boolean containsPrefix(String string) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!this.get(i).startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecure() {
        return this.arguments.isSecure();
    }

    public static long parseMemorySpec(String string) throws IllegalArgumentException {
        char c = '\u0000';
        String string2 = string;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            if (i != string.length() - 1) {
                throw new IllegalArgumentException("Too many characters after heap size specifier");
            }
            c = string.charAt(i);
            string = string.substring(0, string.length() - 1);
            break;
        }
        try {
            long l = Long.parseLong(string);
            if (c != '\u0000') {
                switch (c) {
                    case 'T': 
                    case 't': {
                        l *= 0L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        l *= 0x40000000L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        l *= 0x100000L;
                        break;
                    }
                    case 'K': 
                    case 'k': {
                        l *= 1024L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal heap size specifier " + c + " in " + string2);
                    }
                }
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(numberFormatException);
        }
    }

    public static String unparseMemorySpec(long l) {
        if (l % 0x40000000L == 0L) {
            return "" + l / 0x40000000L + "g";
        }
        if (l % 0x100000L == 0L) {
            return "" + l / 0x100000L + "m";
        }
        if (l % 1024L == 0L) {
            return "" + l / 1024L + "k";
        }
        return "" + l;
    }

    private static String tail(String string, String string2) {
        return string.substring(string2.length());
    }

    private boolean addArgumentImpl(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        if (bl && string.startsWith("-Xmx")) {
            try {
                this.maxHeap = JVMParameters.parseMemorySpec(JVMParameters.tail(string, "-Xmx"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            bl4 = true;
        } else {
            bl4 = bl2 ? this.trustedArguments.addArgument(string, bl) : (bl3 ? (Config.isSecureVmArg(string) || Config.isSecureSystemProperty(string) ? this.arguments.addArgument(string, bl) : true) : this.arguments.addArgument(string, bl));
        }
        this.recomputeIsDefault();
        return bl4;
    }

    private String getXmx() {
        if (this.getMaxHeapSize() != 0x4000000L) {
            return "-Xmx" + JVMParameters.unparseMemorySpec(this.maxHeap);
        }
        return null;
    }

    private void recomputeIsDefault() {
        this.isDefault = this.getMaxHeapSize() == 0x4000000L && this.trustedArguments.isDefault() && this.arguments.isDefault();
    }

    private int size() {
        return this.trustedArguments.size() + this.arguments.size();
    }

    private String get(int n) {
        if (n < this.trustedArguments.size()) {
            return this.trustedArguments.get(n);
        }
        return this.arguments.get(n -= this.trustedArguments.size());
    }

    private static String[] splitString(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        if (!StringQuoteUtil.test()) {
            System.exit(1);
        }
        System.exit(JVMParameters.test(stringArray) ? 0 : 2);
    }

    protected static boolean test(String[] stringArray) {
        Property property;
        String string;
        boolean bl = true;
        JVMParameters jVMParameters = new JVMParameters();
        jVMParameters.parseBootClassPath(System.getProperty("sun.boot.class.path"), new String[]{"deploy.jar"});
        List list = jVMParameters.getCommandLineArguments(false, false);
        System.out.println("Subordinate JVM Arguments:");
        Object object = list.iterator();
        while (object.hasNext()) {
            System.out.println("  " + (String)object.next());
        }
        object = "-DwinPath=" + StringQuoteUtil._testPropVal[2];
        String string2 = Property.getQuotesWholePropertySpec() ? StringQuoteUtil.quoteIfNeeded((String)object) : "-DwinPath=" + StringQuoteUtil.quoteIfNeeded(StringQuoteUtil._testPropVal[2]);
        if (string2.equals(string = (property = new Property("winPath", StringQuoteUtil._testPropVal[2])).toString())) {
            System.out.println("Test 0.0 passed");
        } else {
            System.out.println("Test 0.0 FAILED");
            bl = false;
            System.out.println("\t orig     : <winPath>,<" + StringQuoteUtil._testPropVal[2] + ">");
            System.out.println("\t expected : <" + string2 + ">");
            System.out.println("\t result   : <" + string + ">");
        }
        String string3 = "-Djnlpx.vmargs=-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"";
        String string4 = Property.getQuotesWholePropertySpec() ? StringQuoteUtil.quoteIfNeeded(string3) : "-Djnlpx.vmargs=" + StringQuoteUtil.quoteIfNeeded("-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"");
        property = new Property("jnlpx.vmargs", "-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"");
        string = property.toString();
        if (string4.equals(string)) {
            System.out.println("Test 0.1 passed");
        } else {
            System.out.println("Test 0.1 FAILED");
            bl = false;
            System.out.println("\t orig     : <jnlpx.vmargs>,<-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t expected : <" + string4 + ">");
            System.out.println("\t parsed   : <" + string + ">");
        }
        property = Property.createProperty(string4);
        if (property != null && property.getKey().equals("jnlpx.vmargs") && property.getValue().equals("-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\"")) {
            System.out.println("Test 0.2 passed");
        } else {
            System.out.println("Test 0.2 FAILED");
            bl = false;
            System.out.println("\t orig           : <" + string3 + ">");
            System.out.println("\t expected       : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat \"-DexecString=/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE \"-DwaitString.0=[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes \"-DwinPath=c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t parsed         : <" + property.toString() + ">");
        }
        string4 = "-Djnlpx.vmargs=\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\"";
        property = Property.createProperty(string4);
        if (property != null && property.getKey().equals("jnlpx.vmargs") && property.getValue().equals("-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\"")) {
            System.out.println("Test 0.3 passed");
        } else {
            System.out.println("Test 0.3 FAILED");
            bl = false;
            System.out.println("\t orig           : <" + string3 + ">");
            System.out.println("\t expected       : <-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\"/bin/sh {1} {0} {2}\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\"[yes or no]\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\"c:\\windows\\Documents, and Stuff\\java.exe\">");
            System.out.println("\t parsed         : <" + property.toString() + ">");
        }
        JVMParameters jVMParameters2 = new JVMParameters();
        JVMParameters jVMParameters3 = new JVMParameters();
        jVMParameters3.clear();
        jVMParameters3.parse(StringQuoteUtil.unquoteIfNeeded("\"-DplatformVersion=1.5 -DresponseString.0=yes -Dverbose=true -DinstallerEntry=jre.dat -DexecString=\\\"/bin/sh {1} {0} {2}\\\" -DjavaPath=jre1.5.0_11/bin/java -DlicenseEntry=LICENSE -DwaitString.0=\\\"[yes or no]\\\" -DinstallerLocation=javaws-1_0_1-j2re-1_5_0_11-data-linux-i586.jar -DjavaVersion=1.5.0_11 -DisSolarisInstall=yes -DwinPath=\\\"c:\\windows\\Documents, and Stuff\\java.exe\\\"\""));
        System.out.println("Test 0.4 result: " + jVMParameters3);
        jVMParameters2.clear();
        jVMParameters3.clear();
        jVMParameters2.parse("-Xmx128m");
        jVMParameters3.parse("-Xmx256m");
        jVMParameters2.setDefault(true);
        jVMParameters3.setDefault(true);
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("Test 1 passed");
        } else {
            System.out.println("TEST 1 FAILED");
            bl = false;
        }
        if (jVMParameters2.satisfies(jVMParameters3)) {
            System.out.println("TEST 2 FAILED");
            bl = false;
        } else {
            System.out.println("Test 2 passed");
        }
        jVMParameters2.addArgument("-Dsun.java2d.opengl=true");
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("TEST 3 FAILED");
            bl = false;
        } else {
            System.out.println("Test 3 passed");
        }
        jVMParameters2.removeArgument("-Dsun.java2d.opengl=true");
        jVMParameters3.addArgument("-Dsun.java2d.noddraw=true");
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("Test 4 passed");
        } else {
            System.out.println("TEST 4 FAILED");
            bl = false;
        }
        jVMParameters2.removeArgument("-Xmx");
        if (jVMParameters2.isDefault()) {
            System.out.println("Test 5 passed");
        } else {
            System.out.println("TEST 5 FAILED");
            bl = false;
        }
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("TEST 6 FAILED");
            bl = false;
        } else {
            System.out.println("Test 6 passed");
        }
        jVMParameters3.setDefault(true);
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("Test 7 passed");
        } else {
            System.out.println("TEST 7 FAILED !(p2>=p1)");
            System.out.println("p2: " + jVMParameters3);
            System.out.println("p1: " + jVMParameters2);
            bl = false;
        }
        jVMParameters3.addArgument("-Djava.security.policy=c:/insecurepolicy");
        if (jVMParameters3.isSecure()) {
            System.out.println("Test 8 FAILED");
            bl = false;
        } else {
            System.out.println("Test 8 passed");
        }
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("Test 9 FAILED");
            bl = false;
        } else {
            System.out.println("Test 9 passed");
        }
        jVMParameters3.addArgument("-Djava.security.manager=null");
        jVMParameters2.addArgument("-Djava.security.manager=null");
        if (jVMParameters3.satisfies(jVMParameters2)) {
            System.out.println("Test 10 passed");
        } else {
            System.out.println("Test 10 FAILED");
            bl = false;
        }
        jVMParameters3.removeArgument("-Djava.security.manager=null");
        jVMParameters3.removeArgument("-Djava.security.policy=c:/insecurepolicy");
        if (jVMParameters3.isSecure()) {
            System.out.println("Test 11 passed");
        } else {
            System.out.println("Test 11 FAILED");
            bl = false;
        }
        jVMParameters2.clear();
        jVMParameters2.parse("-Dwhy=????");
        jVMParameters2.parse("-Dabcde=\"1111 and one\"");
        jVMParameters2.parse(StringQuoteUtil.quoteIfNeeded((String)object));
        jVMParameters2.parse("-Djust.a.key");
        jVMParameters2.parse("-Dababa=2222");
        jVMParameters2.parse("-Djust.a.key.2");
        jVMParameters2.parse("-Dlala=33333");
        jVMParameters2.parse("-Djust.a.key");
        jVMParameters2.parse("-Dsoso=55555");
        jVMParameters2.parse("-Djust.a.key.2=6666");
        jVMParameters2.parse("-Dwhy=\"LAST ELEMENT\"");
        JVMParameters.setRunningJVMParameters(jVMParameters2);
        System.out.println("Running JVMParams: " + jVMParameters2 + "\n\t-> " + JVMParameters.getRunningJVMParameters());
        jVMParameters3.clear();
        Properties properties = new Properties();
        properties.setProperty("abcde", "1111 and one");
        properties.setProperty("winPath", StringQuoteUtil._testPropVal[2]);
        jVMParameters3.addProperties(properties);
        jVMParameters3.parse("-Dababa=2222 -Dlala=33333 -Djust.a.key -Dsoso=55555 -Djust.a.key.2=6666 -Dwhy=\"LAST ELEMENT\"");
        if (JVMParameters.getRunningJVMParameters().satisfies(jVMParameters3)) {
            System.out.println("Test 12.1 passed");
            System.out.println("\t running JVMParam: " + JVMParameters.getRunningJVMParameters());
            System.out.println("\t does contain: " + jVMParameters3);
        } else {
            System.out.println("Test 12.1 FAILED");
            bl = false;
            System.out.println("\t running JVMParam: " + JVMParameters.getRunningJVMParameters());
            System.out.println("\t does not contain: " + jVMParameters3);
        }
        jVMParameters3.clear();
        jVMParameters3.parse("-Dabcde=1111 -Dababa=2222 -Dlala=33333 -Djust.a.key -Dsoso=55555 -Djust.a.key.2");
        if (!JVMParameters.getRunningJVMParameters().satisfies(jVMParameters3)) {
            System.out.println("Test 12.2 passed");
        } else {
            System.out.println("Test 12.2 FAILED");
            bl = false;
            System.out.println("\t running JVMParam: " + JVMParameters.getRunningJVMParameters());
            System.out.println("\t     does contain: " + jVMParameters3);
        }
        JVMParameters jVMParameters4 = new JVMParameters();
        jVMParameters4.addArgument("-Djavapi.onething=an\"oth\"er");
        jVMParameters4.addArgument("-Djavapi.flub=hallo\\");
        jVMParameters4.addArgument("-Djavapi.hello=\"value\\\"");
        jVMParameters4.addArgument("-Djavapi.other=\"something\"");
        jVMParameters4.addArgument("-verbose:\"jni\"");
        jVMParameters4.addArgument("-verbose:class\\");
        jVMParameters4.addArgument("\"-verbose:jni\\\"");
        jVMParameters4.addArgument("\"-verbose:gc\"");
        jVMParameters4.addArgument("-Xms\"128M");
        jVMParameters4.addArgument("-Xmn256\\");
        jVMParameters4.addArgument("-Xss\"100\\\"");
        jVMParameters4.addArgument("\"-Xrs\"");
        if (jVMParameters4.containsPrefix("-Djavapi.other")) {
            System.out.println("Test 13 Passed");
        } else {
            System.out.println("Test 13 Failed");
        }
        jVMParameters4.removeArgument("-Djavapi.other");
        if (jVMParameters4.contains("-verbose:gc")) {
            System.out.println("Test 14 Passed");
        } else {
            System.out.println("Test 14 Failed");
        }
        jVMParameters4.removeArgument("-verbose");
        if (jVMParameters4.containsPrefix("-Xrs")) {
            System.out.println("Test 15 Passed");
        } else {
            System.out.println("Test 15 Failed");
        }
        jVMParameters4.removeArgument("-Xrs");
        if (jVMParameters4.isDefault()) {
            System.out.println("Test 16 Passed");
        } else {
            System.out.println("Test 16 Failed");
        }
        return bl;
    }

    static class ArgumentSet {
        private OrderedHashSet dashXOptions = new OrderedHashSet();
        private OrderedHashSet systemProperties = new OrderedHashSet();
        private OrderedHashSet otherArguments = new OrderedHashSet();
        public static final int NUM_ARGUMENT_LISTS = 3;

        ArgumentSet() {
        }

        public void clear() {
            this.dashXOptions.clear();
            this.systemProperties.clear();
            this.otherArguments.clear();
        }

        private String[] systemProperties2StringArray() {
            String[] stringArray = new String[this.systemProperties.size()];
            int n = 0;
            Iterator iterator = this.systemProperties.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((Property)iterator.next()).toString();
            }
            return stringArray;
        }

        public void copyToStringArrays(String[][] stringArray, int n) {
            stringArray[n + 0] = (String[])this.dashXOptions.toArray(new String[0]);
            stringArray[n + 1] = this.systemProperties2StringArray();
            stringArray[n + 2] = (String[])this.otherArguments.toArray(new String[0]);
        }

        public void getFromStringArrays(String[][] stringArray, int n) {
            int n2;
            for (n2 = 0; n2 < stringArray[n + 0].length; ++n2) {
                this.dashXOptions.add(stringArray[n + 0][n2]);
            }
            for (n2 = 0; n2 < stringArray[n + 1].length; ++n2) {
                this.systemProperties.add(new Property(stringArray[n + 1][n2]));
            }
            for (n2 = 0; n2 < stringArray[n + 2].length; ++n2) {
                this.otherArguments.add(stringArray[n + 2][n2]);
            }
        }

        public void addAll(ArgumentSet argumentSet) {
            this.dashXOptions.addAll((Collection)argumentSet.dashXOptions);
            this.systemProperties.addAll((Collection)argumentSet.systemProperties);
            this.otherArguments.addAll((Collection)argumentSet.otherArguments);
        }

        public void addAll(Properties properties) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                this.systemProperties.add(new Property(string, string2));
            }
        }

        public void addAll(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Property)) continue;
                this.systemProperties.add(e);
            }
        }

        public int addTo(List list, boolean bl, boolean bl2, int n) {
            int n2;
            String string;
            int n3 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.otherArguments.iterator();
            while (n3 < n && iterator.hasNext()) {
                string = (String)iterator.next();
                n2 = string.length() + 1;
                if (!bl2 && !Config.isSecureVmArg(string) || n3 + n2 >= n) continue;
                arrayList.add(string);
                n3 += n2;
            }
            iterator = this.dashXOptions.iterator();
            while (n3 < n && iterator.hasNext()) {
                string = (String)iterator.next();
                n2 = string.length() + 1;
                if (!bl2 && !Config.isSecureVmArg(string) || n3 + n2 >= n) continue;
                list.add(string);
                n3 += n2;
            }
            iterator = this.systemProperties.iterator();
            while (n3 < n && iterator.hasNext()) {
                Property property = (Property)iterator.next();
                string = property.toString(bl);
                n2 = string.length() + 1;
                if (!bl2 && !property.isSecure() || n3 + n2 >= n) continue;
                list.add(string);
                n3 += n2;
            }
            list.addAll(arrayList);
            return n3;
        }

        public void addTo(Properties properties) {
            Iterator iterator = this.systemProperties.iterator();
            while (iterator.hasNext()) {
                ((Property)iterator.next()).addTo(properties);
            }
        }

        public boolean addArgument(String string, boolean bl) {
            if (string.startsWith("-Dsun.plugin2.jvm.args")) {
                throw new IllegalArgumentException("May not specify the sun.plugin2.jvm.args system property");
            }
            if (bl) {
                Property property = Property.createProperty(string);
                if (property != null) {
                    if (!Config.isLegalProperty(property.getKey(), property.getValue())) {
                        Trace.println("Rejecting property with illegal chars: " + string, TraceLevel.SECURITY);
                        return false;
                    }
                    this.systemProperties.add(property);
                    return true;
                }
                if (string.startsWith("-X")) {
                    if (string.startsWith("-Xbootclasspath:") || string.startsWith("-Xbootclasspath/p:")) {
                        return true;
                    }
                    if (!Config.isLegalArgument(string)) {
                        Trace.println("Rejecting argument with illegal chars: " + string, TraceLevel.SECURITY);
                        return false;
                    }
                    this.dashXOptions.add(string);
                    return true;
                }
            }
            if (!Config.isLegalArgument(string)) {
                Trace.println("Rejecting argument with illegal chars: " + string, TraceLevel.SECURITY);
                return false;
            }
            this.otherArguments.add(string);
            return string.startsWith("-");
        }

        public boolean removeArgument(String string) {
            if (string.startsWith("-X")) {
                return this.removeArgumentHelper(this.dashXOptions, string);
            }
            if (string.startsWith("-D")) {
                return this.removeArgumentHelper(this.systemProperties, new Property(string));
            }
            return this.removeArgumentHelper(this.otherArguments, string);
        }

        private boolean removeArgumentHelper(OrderedHashSet orderedHashSet, Property property) {
            return orderedHashSet.remove(property);
        }

        private boolean removeArgumentHelper(OrderedHashSet orderedHashSet, String string) {
            Iterator iterator = orderedHashSet.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith(string)) continue;
                orderedHashSet.remove(string2);
                return true;
            }
            return false;
        }

        public boolean isDefault() {
            return this.dashXOptions.isEmpty() && this.systemProperties.isEmpty() && this.otherArguments.isEmpty();
        }

        public boolean isSecure() {
            Iterator iterator = this.dashXOptions.iterator();
            while (iterator.hasNext()) {
                if (Config.isSecureVmArg((String)iterator.next())) continue;
                return false;
            }
            iterator = this.otherArguments.iterator();
            while (iterator.hasNext()) {
                if (Config.isSecureVmArg((String)iterator.next())) continue;
                return false;
            }
            iterator = this.systemProperties.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (property.isSecure()) continue;
                return false;
            }
            return true;
        }

        public int size() {
            return this.dashXOptions.size() + this.systemProperties.size() + this.otherArguments.size();
        }

        public String get(int n) {
            if (n < this.dashXOptions.size()) {
                return (String)this.dashXOptions.get(n);
            }
            if ((n -= this.dashXOptions.size()) < this.systemProperties.size()) {
                return ((Property)this.systemProperties.get(n)).toString();
            }
            return (String)this.otherArguments.get(n -= this.systemProperties.size());
        }
    }
}

